/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg.css;

import com.renderx.svg.css.CSSParseException;
import com.renderx.svg.css.Lexer;
import com.renderx.util.List;
import java.util.Enumeration;

public class Selector {
    private static final String FIRST_LETER = "first-letter";
    private static final String FIRST_LINE = "first-line";
    private static final String LINK = "link";
    private static final String VISITED = "visited";
    private static final String ACTIVE = "active";
    private final Lexer lexer;
    private int current;
    private short cntId = 0;
    private short cntCl = 0;
    private short cntEl = 0;
    public List nodelist = new List();

    public Selector(Lexer lexer) throws CSSParseException {
        this.lexer = lexer;
        this.current = this.lexer.getType();
        this.parse();
    }

    public Selector(String string) throws CSSParseException {
        this.lexer = new Lexer(string);
        this.current = this.lexer.nextIgnoreSpaces();
        this.parse();
    }

    public int getSpecificity() {
        int n = Math.max(Integer.toString(this.cntId).length(), Math.max(Integer.toString(this.cntCl).length(), Integer.toString(this.cntEl).length()));
        return this.cntId * (int)Math.pow(10.0, 2 * n) + this.cntCl * (int)Math.pow(10.0, n) + this.cntEl;
    }

    private void parse() throws CSSParseException {
        int n = 60;
        Node node = null;
        do {
            block0 : switch (n) {
                case 60: {
                    if (node != null) {
                        this.nodelist.cons(node);
                    }
                    node = new Node();
                    switch (this.current) {
                        case 20: {
                            n = 58;
                            node.elementName = this.lexer.getStringValue();
                            this.cntEl = (short)(this.cntEl + 1);
                            break;
                        }
                        case 27: {
                            n = 27;
                            break;
                        }
                        case 7: {
                            n = 7;
                            break;
                        }
                        case 16: {
                            n = 16;
                            break;
                        }
                        default: {
                            throw new CSSParseException("Expected selector");
                        }
                    }
                    this.current = this.lexer.nextToken();
                    break;
                }
                case 27: {
                    if (this.current == 20) {
                        n = 57;
                        node.elementID = this.lexer.getStringValue();
                        this.current = this.lexer.nextToken();
                        this.cntId = (short)(this.cntId + 1);
                        break;
                    }
                    throw new CSSParseException("Invalid HASH ident");
                }
                case 7: {
                    if (this.current == 20) {
                        n = 56;
                        node.className = this.lexer.getStringValue();
                        this.current = this.lexer.nextToken();
                        this.cntCl = (short)(this.cntCl + 1);
                        break;
                    }
                    throw new CSSParseException("Invalid CLASS ident");
                }
                case 16: {
                    if (this.current == 20 && this.isPseudoClass(this.lexer.getStringValue())) {
                        n = 59;
                        node.pseudoClassName = this.lexer.getStringValue();
                        this.cntCl = (short)(this.cntCl + 1);
                    } else if (this.current == 20 && this.isPseudoElement(this.lexer.getStringValue())) {
                        n = 54;
                        node.pseudoElementName = this.lexer.getStringValue();
                        this.cntEl = (short)(this.cntEl + 1);
                    } else {
                        throw new CSSParseException("Invalid pseudo-class/pseudo-element ident");
                    }
                    this.current = this.lexer.nextIgnoreSpaces();
                    break;
                }
                case 58: {
                    if (this.current == 27) {
                        n = 27;
                        this.current = this.lexer.nextToken();
                        break;
                    }
                }
                case 57: {
                    if (this.current == 7) {
                        n = 7;
                        this.current = this.lexer.nextToken();
                        break;
                    }
                }
                case 56: {
                    switch (this.current) {
                        case 16: {
                            n = 16;
                            this.current = this.lexer.nextToken();
                            break block0;
                        }
                        case 17: 
                        case 18: {
                            n = 59;
                            this.current = this.lexer.nextToken();
                            break block0;
                        }
                        case 0: 
                        case 1: 
                        case 6: {
                            n = 53;
                            break block0;
                        }
                    }
                    throw new CSSParseException("Invalid selector name");
                }
                case 59: {
                    switch (this.current) {
                        case 0: 
                        case 1: 
                        case 6: {
                            n = 53;
                            break block0;
                        }
                    }
                    n = 60;
                    this.current = this.lexer.skipSpaces();
                    break;
                }
                case 54: {
                    this.current = this.lexer.skipSpaces();
                    switch (this.current) {
                        case 0: 
                        case 1: 
                        case 6: {
                            n = 53;
                            break block0;
                        }
                    }
                    throw new CSSParseException("Expected end of selector");
                }
            }
        } while (n != 53);
        this.nodelist.cons(node);
    }

    public boolean equals(Selector selector) {
        if (selector.nodelist.length() != this.nodelist.length()) {
            return false;
        }
        Enumeration enumeration = this.nodelist.elements();
        Enumeration enumeration2 = selector.nodelist.elements();
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            if (((Node)enumeration.nextElement()).equals((Node)enumeration2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.nodelist.reverse().toString();
    }

    private boolean isPseudoElement(String string) {
        return string.equalsIgnoreCase(FIRST_LETER) || string.equalsIgnoreCase(FIRST_LINE);
    }

    private boolean isPseudoClass(String string) {
        return string.equalsIgnoreCase(LINK) || string.equalsIgnoreCase(VISITED) || string.equalsIgnoreCase(ACTIVE);
    }

    public class Node {
        public String elementName = null;
        public String className = null;
        public String pseudoClassName = null;
        public String pseudoElementName = null;
        public String elementID = null;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Node node) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            if (node == null) return false;
            if (this.elementName == null) {
                if (this.elementName != node.elementName) return false;
                bl4 = true;
            } else {
                bl4 = this.elementName.equals(node.elementName);
            }
            if (!bl4) return false;
            if (this.elementID == null) {
                if (this.elementID != node.elementID) return false;
                bl3 = true;
            } else {
                bl3 = this.elementID.equals(node.elementID);
            }
            if (!bl3) return false;
            if (this.className == null) {
                if (this.className != node.className) return false;
                bl2 = true;
            } else {
                bl2 = this.className.equals(node.className);
            }
            if (!bl2) return false;
            if (this.pseudoClassName == null) {
                if (this.pseudoClassName != node.pseudoClassName) return false;
                bl = true;
            } else {
                bl = this.pseudoClassName.equals(node.pseudoClassName);
            }
            if (!bl) return false;
            if (this.pseudoElementName == null) {
                if (this.pseudoElementName != node.pseudoElementName) return false;
                return true;
            }
            boolean bl5 = this.pseudoElementName.equals(node.pseudoElementName);
            if (!bl5) return false;
            return true;
        }

        public String toString() {
            return (this.elementName == null ? "" : this.elementName) + (this.elementID == null ? "" : '#' + this.elementID) + (this.className == null ? "" : '.' + this.className) + (this.pseudoClassName == null ? "" : ':' + this.pseudoClassName) + (this.pseudoElementName == null ? "" : ':' + this.pseudoElementName);
        }
    }
}

