/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.Media;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.Hashtable;
import com.renderx.util.SeekableInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class QuickMP4
extends Media {
    private static final Hashtable boxTypes = new Hashtable();
    private static final Hashtable boxTypesAudio;
    private static final Hashtable atomTypes;

    public QuickMP4() {
        this.mimetype = "video/mp4";
    }

    public void parse() throws IOException, ImageFormatException {
        this.canCopyData = true;
        SeekableInput seekableInput = this.openSeekableImageStream();
        long l = 0L;
        try {
            try {
                int n = seekableInput.readInt();
                byte[] byArray = new byte[4];
                seekableInput.readFully(byArray);
                String string = new String(byArray);
                if (atomTypes.containsKey(string.toLowerCase())) {
                    this.mimetype = "video/quicktime";
                } else {
                    byArray = new byte[4];
                    seekableInput.readFully(byArray);
                    string = new String(byArray);
                    if (boxTypes.containsKey(string.toLowerCase())) {
                        this.mimetype = "video/mp4";
                    } else if (boxTypesAudio.containsKey(string.toLowerCase())) {
                        this.mimetype = "audio/mp4";
                    } else {
                        throw new ImageFormatException("Invalid MP4/Quicktime signature in file '" + this.toDisplayString() + "'");
                    }
                }
                if (this.mimetype.endsWith("mp4")) {
                    seekableInput.seek(0L);
                    seekableInput.skipBytes(n);
                    n = seekableInput.readInt();
                    byArray = new byte[4];
                    seekableInput.readFully(byArray);
                    string = new String(byArray);
                }
                if (!string.equals("moov")) {
                    n = this.goToAtom(seekableInput, n, "moov");
                }
                l = seekableInput.getFilePointer() - 8L + (long)n;
                while (seekableInput.getFilePointer() < l) {
                    n = seekableInput.readInt();
                    byArray = new byte[4];
                    seekableInput.readFully(byArray);
                    string = new String(byArray);
                    if (string.equals("trak")) {
                        float f = 0.0f;
                        float f2 = 0.0f;
                        float f3 = 1.0f;
                        float f4 = 0.0f;
                        float f5 = 0.0f;
                        float f6 = 1.0f;
                        float f7 = 0.0f;
                        float f8 = 0.0f;
                        int n2 = 0;
                        int n3 = 0;
                        int n4 = 1;
                        long l2 = seekableInput.getFilePointer() - 8L + (long)n;
                        while (seekableInput.getFilePointer() < l2 && this.pxWidth == 0L && this.pxHeight == 0L) {
                            n = seekableInput.readInt();
                            byArray = new byte[4];
                            seekableInput.readFully(byArray);
                            string = new String(byArray);
                            if (string.equals("tkhd")) {
                                seekableInput.skipBytes(40);
                                f3 = this.readFixed16_16(seekableInput);
                                f4 = this.readFixed16_16(seekableInput);
                                n2 = seekableInput.readInt();
                                f5 = this.readFixed16_16(seekableInput);
                                f6 = this.readFixed16_16(seekableInput);
                                n3 = seekableInput.readInt();
                                f7 = this.readFixed16_16(seekableInput);
                                f8 = this.readFixed16_16(seekableInput);
                                n4 = seekableInput.readInt();
                                f = this.readFixed16_16(seekableInput);
                                f2 = this.readFixed16_16(seekableInput);
                                this.pxWidth = Math.round(Math.abs(f * f3) + Math.abs(f2 * f5));
                                this.pxHeight = Math.round(Math.abs(f * f4) + Math.abs(f2 * f6));
                                continue;
                            }
                            seekableInput.skipBytes(n - 8);
                        }
                        continue;
                    }
                    seekableInput.skipBytes(n - 8);
                }
            }
            catch (EOFException eOFException) {
                throw new ImageFormatException("Premature end of file or corrupt data in MP4/Quicktime media " + this.toDisplayString(), this.mimetype);
            }
            Object var21_19 = null;
        }
        catch (Throwable throwable) {
            Object var21_20 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
        this.setDimensions();
    }

    int goToAtom(SeekableInput seekableInput, int n, String string) throws IOException {
        String string2 = "";
        while (!string2.equals(string)) {
            seekableInput.skipBytes(n - 8);
            n = seekableInput.readInt();
            byte[] byArray = new byte[4];
            seekableInput.readFully(byArray);
            string2 = new String(byArray);
        }
        return n;
    }

    public float readFixed16_16(SeekableInput seekableInput) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = seekableInput.read();
        if ((n4 | (n3 = seekableInput.read()) | (n2 = seekableInput.read()) | (n = seekableInput.read())) < 0) {
            throw new EOFException();
        }
        int n5 = (n4 << 8) + n3;
        if (n5 >> 15 != 0) {
            n5 = -((~n5 & Short.MAX_VALUE) + 1);
        }
        float f = n5;
        float f2 = (float)((n2 << 8) + n) / 65536.0f;
        return f + f2;
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException, ImageFormatException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    static {
        boxTypes.put("avc1", "avc1");
        boxTypes.put("f4v ", "F4V ");
        boxTypes.put("f4p ", "F4P ");
        boxTypes.put("iso2", "iso2");
        boxTypes.put("isom", "isom");
        boxTypes.put("m4v ", "M4V ");
        boxTypes.put("m4vh", "M4VH");
        boxTypes.put("mmp4", "mmp4");
        boxTypes.put("m4vp", "M4VP");
        boxTypes.put("mp41", "mp41");
        boxTypes.put("mp42", "mp42");
        boxTypes.put("ndsc", "NDSC");
        boxTypes.put("ndsh", "NDSH");
        boxTypes.put("ndsm", "NDSM");
        boxTypes.put("ndsp", "NDSP");
        boxTypes.put("ndss", "NDSS");
        boxTypes.put("ndxc", "NDXC");
        boxTypes.put("ndxh", "NDXH");
        boxTypes.put("ndxm", "NDXM");
        boxTypes.put("ndxp", "NDXP");
        boxTypes.put("ndxs", "NDXS");
        boxTypes.put("3g2a", "3g2a");
        boxTypes.put("3g2b", "3g2b");
        boxTypes.put("3g2c", "3g2c");
        boxTypes.put("3ge6", "3ge6");
        boxTypes.put("3ge7", "3ge7");
        boxTypes.put("3gg6", "3gg6");
        boxTypes.put("3gp1", "3gp1");
        boxTypes.put("3gp2", "3gp2");
        boxTypes.put("3gp3", "3gp3");
        boxTypes.put("3gp4", "3gp4");
        boxTypes.put("3gp5", "3gp5");
        boxTypes.put("3gp6", "3gp6");
        boxTypes.put("3gs7", "3gs7");
        boxTypes.put("caep", "CAEP");
        boxTypes.put("caqv", "caqv");
        boxTypes.put("cdes", "CDes");
        boxTypes.put("da0a", "da0a");
        boxTypes.put("da0b", "da0b");
        boxTypes.put("da1a", "da1a");
        boxTypes.put("da1b", "da1b");
        boxTypes.put("da2a", "da2a");
        boxTypes.put("da2b", "da2b");
        boxTypes.put("da3a", "da3a");
        boxTypes.put("da3b", "da3b");
        boxTypes.put("dmb1", "dmb1");
        boxTypes.put("dmpf", "dmpf");
        boxTypes.put("drc1", "drc1");
        boxTypes.put("dv1a", "dv1a");
        boxTypes.put("dv1b", "dv1b");
        boxTypes.put("dv2a", "dv2a");
        boxTypes.put("dv2b", "dv2b");
        boxTypes.put("dv3a", "dv3a");
        boxTypes.put("dv3b", "dv3b");
        boxTypes.put("dvr1", "dvr1");
        boxTypes.put("dvt1", "dvt1");
        boxTypes.put("isc2", "isc2");
        boxTypes.put("jp2 ", "jp2 ");
        boxTypes.put("jp20", "jp20");
        boxTypes.put("jpm ", "jpm ");
        boxTypes.put("jpx ", "jpx ");
        boxTypes.put("kddi", "KDDI");
        boxTypes.put("mj2s", "mj2s");
        boxTypes.put("mjp2", "mjp2");
        boxTypes.put("mp21", "mp21");
        boxTypes.put("mp71", "mp71");
        boxTypes.put("mppi", "mppi");
        boxTypes.put("mqt ", "mqt ");
        boxTypes.put("odcf", "odcf");
        boxTypes.put("opf2", "opf2");
        boxTypes.put("opx2", "opx2");
        boxTypes.put("pana", "pana");
        boxTypes.put("qt  ", "qt  ");
        boxTypes.put("ross", "ROSS");
        boxTypes.put("sdv ", "sdv ");
        boxTypes.put("ssc1", "ssc1");
        boxTypes.put("ssc2", "ssc2");
        boxTypesAudio = new Hashtable();
        boxTypesAudio.put("f4a ", "F4A ");
        boxTypesAudio.put("f4b ", "F4B ");
        boxTypesAudio.put("m4a ", "M4A ");
        boxTypesAudio.put("m4b ", "M4B ");
        boxTypesAudio.put("m4p ", "M4P ");
        boxTypesAudio.put("msnv", "MSNV");
        boxTypesAudio.put("ndas", "NDAS");
        atomTypes = new Hashtable();
        atomTypes.put("mdat", "mdat");
        atomTypes.put("moov", "moov");
        atomTypes.put("free", "free");
        atomTypes.put("skip", "skip");
        atomTypes.put("pnot", "pnot");
    }
}

