package com.renderx.xepx.x4u.ct.nodedscpanel.transformpanel;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;

import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import com.renderx.xepx.x4u.ct.FontsPanel;

/**
 * @author AlexanderR
 *
 */
public class SlantPanel extends JPanel
{
    private static final long serialVersionUID = 1680357055776126236L;

    private FontsPanel parentPanel;
    
    private JTextField slantTextField = new JTextField();
    private JCheckBox slantCheckBox = new JCheckBox();
    
    public SlantPanel(FontsPanel _parentPanel)
    {
	this.parentPanel = _parentPanel;
	
	slantTextField.setEnabled(false);
	slantTextField.setPreferredSize(new Dimension(40, 19));
	slantTextField.setText("15");
	
	slantTextField.addFocusListener(
        	new java.awt.event.FocusAdapter()
        	{
        	    public void focusLost(FocusEvent e)
        	    {
        		parentPanel.textField_focusLost(e, (Element) parentPanel.getFontNode());
        	    }
        
        	    public void focusGained(FocusEvent e)
        	    {
        		parentPanel.textField_focusGained(e, (Element) parentPanel.getFontNode());
        	    }
        	});

	slantTextField.setName("slant");
	slantCheckBox.setText("Slanting");
	
	slantCheckBox.addActionListener(
        	new java.awt.event.ActionListener()
        	{
        	    public void actionPerformed(ActionEvent e)
        	    {
        		slantCheckBox_actionPerformed(e, (Element) parentPanel.getFontNode());
        	    }
        	});
	    
	add(slantCheckBox, null);
	add(slantTextField, null);	
    }
    
    /**
     * FontPanel service commands
     * 
     * @params e Action or Focus Event node DOM element to be managed
     */
    void slantCheckBox_actionPerformed(ActionEvent e, Element node)
    {
	boolean state = slantCheckBox.isSelected();
	if (node == null)
	    return;
	Element transform;
	NodeList children = node.getElementsByTagName("transform");
	if (children.getLength() == 0)
	{
	    transform = node.getOwnerDocument().createElement("transform");
	    node.appendChild(transform);
	} else
	{
	    transform = (Element) children.item(0);
	}

	if (state && slantTextField.getText().trim().length() > 0
		&& Integer.parseInt(slantTextField.getText().trim()) != 15)
	    transform.setAttribute("slant-angle", slantTextField.getText());

	if (!state)
	{
	    transform.removeAttribute("slant-angle");
	    if (transform.getAttributes().getLength() == 0)
		node.removeChild(transform);
	}

	slantTextField.setEnabled(state);
    }
    
    public String getText()
    {
	return slantTextField.getText();
    }
    
    public void setText(String text)
    {
	slantTextField.setText(text);
    }
    
    public void setSelected(boolean value)
    {
	slantCheckBox.setSelected(value);
    }
    
    public void setEnabled(boolean value)
    {
	slantTextField.setEnabled(value);
    }
    
    public boolean isSelected()
    {
	return slantCheckBox.isSelected();
    }     
}
