/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.helpers;

import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.CompilerException;
import com.renderx.xep.pre.Elem;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.PIHandler;
import com.renderx.xep.pre.helpers.PrintStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class ElementHandlerSerializer
extends PrintStream
implements ElementHandler,
PIHandler {
    private int level = 0;
    private boolean opentag = false;

    public ElementHandlerSerializer(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public void startElement(short s, AttList attList) throws CompilerException {
        try {
            if (this.opentag) {
                this.print(">");
            }
            this.printIndent();
            this.print("<");
            this.printQuoted(Elem.getName(s));
            this.opentag = true;
            int n = attList.size();
            if (n > 0) {
                Attn[] attnArray = new Attn[n];
                Enumeration enumeration = attList.keys();
                int n2 = 0;
                while (enumeration.hasMoreElements()) {
                    Attn attn = (Attn)enumeration.nextElement();
                    int n3 = 0;
                    while (n3 < n2 && attnArray[n3].name.compareTo(attn.name) < 0) {
                        ++n3;
                    }
                    int n4 = n2;
                    while (n4 > n3) {
                        attnArray[n4] = attnArray[n4 - 1];
                        --n4;
                    }
                    ++n2;
                    attnArray[n3] = attn;
                }
                int n5 = 0;
                while (n5 < n) {
                    Attn attn = attnArray[n5];
                    this.print(" ");
                    this.printQuoted(attn.name);
                    this.print("=\"");
                    this.printQuoted(attList.get(attn).toString());
                    this.print("\"");
                    ++n5;
                }
            }
        }
        catch (IOException iOException) {
            throw new CompilerException("Serializer error: " + iOException.getMessage());
        }
        ++this.level;
    }

    public void endElement(short s) throws CompilerException {
        --this.level;
        try {
            if (this.opentag) {
                this.print("/>");
                this.opentag = false;
            } else {
                this.printIndent();
                this.print("</");
                this.printQuoted(Elem.getName(s));
                this.print(">");
            }
        }
        catch (IOException iOException) {
            throw new CompilerException("Serializer error: " + iOException.getMessage());
        }
    }

    public void processingInstruction(String string, String string2) throws CompilerException {
        try {
            if (this.opentag) {
                this.print(">");
                this.opentag = false;
            }
            this.printIndent();
            this.print("<?" + string + ' ' + string2 + "?>");
        }
        catch (IOException iOException) {
            throw new CompilerException("Serializer error: " + iOException.getMessage());
        }
    }

    private void printIndent() throws IOException {
        this.println();
        int n = 0;
        while (n < this.level) {
            this.print("  ");
            ++n;
        }
    }

    private void printQuoted(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                this.print("&lt;");
            } else if (c == '>') {
                this.print("&gt;");
            } else if (c == '&') {
                this.print("&amp;");
            } else if (c == '\'') {
                this.print("&apos;");
            } else if (c == '\"') {
                this.print("&quot;");
            } else if (c < ' ') {
                this.print("&#x" + Integer.toHexString(c) + ";");
            } else {
                this.print(c);
            }
            ++n;
        }
    }
}

