/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.Metric;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Array;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class H4HTML
extends H4base {
    private static final String XEPURI = "http://www.renderx.com/XEP/xep";
    private static final String XHTMLURI = "http://www.w3.org/1999/xhtml";
    private static final String SVGURI = "http://www.w3.org/2000/svg";
    private static final String XFORMSURI = "http://www.w3.org/2002/xforms";
    private static final String XLINK = "http://www.w3.org/1999/xlink";
    private static final String SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String EVENTS = "http://www.w3.org/2001/xml-events";
    private static final short O_EMBED_IMAGES = 0;
    private static final short O_GENERATE_FIRST_N_PAGES = 1;
    private static final short O_BREAK_PAGES = 2;
    private static final short O_PAGE_REORDERING = 3;
    private static final short O_XFORMS = 4;
    private static final short O_HTMLFORMS = 5;
    private static final Hashtable optab = new Hashtable();
    private boolean EMBED_IMAGES;
    private int GENERATE_FIRST_N_PAGES;
    private boolean BREAK_PAGES;
    private boolean PAGE_REORDERING;
    private boolean XFORMS;
    private boolean HTMLFORMS;
    private boolean EI;
    private int GFNP;
    private boolean BP;
    private boolean PR;
    private boolean XF;
    private boolean F;
    private final ImageFactory imageFactory;
    private final Hashtable imageIndex = new Hashtable();
    private boolean imageOK = true;
    protected float totalH = 0.0f;
    protected float currentH = 0.0f;
    protected String font_weight = "400";
    protected String font_family = "Helvetica";
    protected String font_variant = "normal";
    protected String font_style = "normal";
    protected String font_stretch = "normal";
    protected float font_size = 0.0f;
    protected String word_spacing = "0";
    protected String letter_spacing = "0";
    protected String color = "000000";
    protected float translateX = 0.0f;
    protected float translateY = 0.0f;
    protected float scaleX = 1.0f;
    protected float scaleY = 1.0f;
    private String debugcss = "";
    protected float clipX = 0.0f;
    protected float clipY = 0.0f;
    protected Stack clipStack = new Stack();
    private int maxP;
    private int countPage;
    protected float xepoutX = 0.0f;
    protected float xepoutY = 0.0f;
    protected float xepoutScaleX = 1.0f;
    protected float xepoutScaleY = 1.0f;
    protected Stack xepoutScaleXs = new Stack();
    protected Stack xepoutScaleYs = new Stack();
    protected float svgH = 0.0f;
    protected float svgW = 0.0f;
    protected float svgScaleX = 1.0f;
    protected float svgScaleY = 1.0f;
    protected java.util.Hashtable SVGimage = new java.util.Hashtable();
    private File TMPDIR;
    private boolean USE_TEMP_FILE;
    private String currentPageID;
    private FileOutputStream fosTmp;
    private ByteArrayOutputStream baosTmp;
    private java.util.Hashtable tmpFiles = new java.util.Hashtable();
    private java.util.Hashtable tmpStreams = new java.util.Hashtable();
    private TreeSet page = new TreeSet();
    protected Stack stack = new Stack();
    protected Serializer handler;
    protected static java.util.Hashtable dims;
    protected static java.util.Hashtable fontStretchAlias;
    private double[] alN = new double[]{482.0, 579.0, 694.0, 833.0, 1000.0, 1200.0, 1440.0, 1728.0, 2074.0};
    private double[] alP = new double[]{83.3, 120.0};
    private ZipOutputStream XHTMLStream;
    private Hashtable model;
    private boolean isPDFField = false;
    private Field field;
    private String sharedcss = " position: absolute; margin: 0pt 0pt 0pt 0pt; padding: 0pt 0pt 0pt 0pt; overflow: hidden; clip: auto;";

    protected void resetDefaultOptions() {
        this.EI = false;
        this.GFNP = 0;
        this.BP = false;
        this.PR = true;
        this.XF = false;
    }

    protected void setOption(String string, String string2) {
        Object object = optab.get(string);
        if (object == null) {
            this.session.warning("Unrecognized XHTML option " + string + ": setting ignored");
            return;
        }
        switch ((Short)object) {
            case 0: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.EI = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.EI = false;
                    break;
                }
                this.session.warning("Invalid EMBED_IMAGES value: " + string2 + "; setting ignored");
                break;
            }
            case 1: {
                string2 = string2.trim().toLowerCase();
                try {
                    this.GFNP = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.session.warning("Invalid GENERATE_FIRST_N_PAGES value: " + string2 + "; setting ignored");
                }
                if (this.GFNP >= 0) break;
                this.GFNP = 0;
                this.session.warning("GENERATE_FIRST_N_PAGES value cannot be negative: " + string2 + "; setting ignored");
                break;
            }
            case 2: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.BP = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.BP = false;
                    break;
                }
                this.session.warning("Invalid BREAK_PAGES value: " + string2 + "; setting ignored");
                break;
            }
            case 3: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.PR = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.PR = false;
                    break;
                }
                this.session.warning("Invalid PAGE_REORDERING value: " + string2 + "; setting ignored");
                break;
            }
            case 4: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.XF = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.XF = false;
                    break;
                }
                this.session.warning("Invalid XFORMS value: " + string2 + "; setting ignored");
                break;
            }
            case 5: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.F = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.F = false;
                    break;
                }
                this.session.warning("Invalid HTML FORMS value: " + string2 + "; setting ignored");
            }
        }
    }

    protected void initDocument() throws LicenseException {
        this.EMBED_IMAGES = this.EI;
        this.GENERATE_FIRST_N_PAGES = this.GFNP;
        this.BREAK_PAGES = this.BP;
        this.PAGE_REORDERING = this.PR;
        this.XFORMS = this.XF;
        this.HTMLFORMS = this.F;
        if (this.XFORMS && !this.session.config.XForms && !this.session.config.XFormsTrial) {
            this.session.warning("XForms support is not licensed for this installation.");
            this.XFORMS = false;
        }
        this.countPage = 0;
        if (this.BREAK_PAGES) {
            this.XHTMLStream = new ZipOutputStream(this.outstream);
            this.addCSSFile("index.css");
        }
        this.model = new Hashtable();
    }

    public void resetPageSettings() {
        this.translateX = 0.0f;
        this.translateY = 0.0f;
        this.scaleX = 1.0f;
        this.scaleY = 1.0f;
        this.clipX = 0.0f;
        this.clipY = 0.0f;
        this.color = "000000";
        this.word_spacing = "0";
        this.letter_spacing = "0";
        this.font_stretch = "normal";
        this.font_weight = "400";
        this.font_family = "Helvetica";
        this.font_variant = "normal";
        this.font_style = "normal";
        this.font_size = 0.0f;
    }

    public H4HTML(OutputStream outputStream, Session session, Properties properties) throws IOException, LicenseException {
        super(outputStream, session, properties);
        if (!session.config.XHTML && !session.config.XHTMLTrial) {
            session.error("XHTML support is not licensed for this installation.");
            throw new LicenseException("XHTML support is not licensed for this installation.");
        }
        this.setTMPDIR(session.config.TMPDIR);
        this.imageFactory = session.config.imageFactory;
    }

    private void setTMPDIR(File file) {
        if (file != null) {
            if (!file.exists()) {
                this.session.error("Directory " + file + " does not exist; disk caching in XHTML generator disabled.");
                file = null;
            } else if (!file.isDirectory()) {
                this.session.error("File " + file + " is not a directory; disk caching in XHTML generator disabled.");
                file = null;
            } else if (!file.canWrite()) {
                this.session.error("Directory " + file + " is not writable; disk caching in XHTML generator disabled.");
                file = null;
            }
        }
        this.TMPDIR = file;
        this.USE_TEMP_FILE = file != null;
    }

    private void setTmpFile(String string) {
        if (this.USE_TEMP_FILE) {
            try {
                File file = this.getTempFile(string);
                this.fosTmp = new FileOutputStream(file);
                this.tmpFiles.put(string, file.toString());
            }
            catch (IOException iOException) {
                this.session.exception("Cannot create temporary file ", iOException);
                this.USE_TEMP_FILE = false;
            }
        }
        if (!this.USE_TEMP_FILE) {
            this.baosTmp = new ByteArrayOutputStream();
            this.tmpStreams.put(string, this.baosTmp);
        }
    }

    private synchronized File getTempFile(String string) {
        String string2;
        File file;
        while ((file = new File(this.TMPDIR, string2 = "xhtmlgen_" + Integer.toHexString((int)System.currentTimeMillis()) + "_" + string + ".tmp")).exists()) {
        }
        return file;
    }

    public String outFormat() {
        return "html";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4HTML.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-html-";
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (!XEPURI.equals(string)) {
            return;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        String string4 = "";
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    this.initDocument();
                    break;
                }
                case 1: {
                    ++this.countPage;
                    this.resetPageSettings();
                    int n = this.parseInteger(attributes.getValue("page-number"));
                    if (this.PAGE_REORDERING) {
                        if (n > this.maxP) {
                            this.maxP = n;
                        }
                    } else {
                        this.maxP = this.countPage;
                    }
                    if (this.session.config.XHTMLTrial && this.countPage > 10 && this.countPage % 2 == 1 || this.session.config.XFormsTrial && this.countPage > 10 && this.countPage % 2 == 1 || this.countPage > this.GENERATE_FIRST_N_PAGES && this.GENERATE_FIRST_N_PAGES != 0) {
                        this.handler = null;
                    } else {
                        this.currentPageID = this.PAGE_REORDERING ? "" + n : "" + this.countPage;
                        if (!this.page.contains(new Integer(this.currentPageID))) {
                            if (this.BREAK_PAGES) {
                                this.handler = new Serializer(this.XHTMLStream, this.BREAK_PAGES, false);
                                this.addXHTMLFile("page" + this.currentPageID + ".html");
                            } else {
                                this.setTmpFile(this.currentPageID);
                                this.handler = this.USE_TEMP_FILE ? new Serializer(this.fosTmp, false, false) : new Serializer(this.baosTmp, false, false);
                            }
                            this.page.add(new Integer(this.currentPageID));
                        } else {
                            this.session.warning("Ignoring duplicate page " + this.currentPageID);
                            this.handler = null;
                        }
                    }
                    if (this.handler == null) {
                        return;
                    }
                    this.handler.startDocument();
                    attributesImpl.clear();
                    f = this.parseLength(attributes.getValue("width"));
                    f2 = this.parseLength(attributes.getValue("height"));
                    string4 = "border: solid 2pt silver; left: 0pt; top: ";
                    string4 = string4 + this.totalH + "pt; width: " + f + "pt; height: " + f2 + "pt;" + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    this.stack.push("div");
                    attributesImpl.clear();
                    this.totalH = this.BREAK_PAGES ? 0.0f : (this.totalH += f2);
                    this.currentH = f2;
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (this.handler == null) {
                        return;
                    }
                    this.translateX += this.scaleX * this.parseLength(attributes.getValue("x"));
                    this.translateY += this.scaleY * this.parseLength(attributes.getValue("y"));
                    break;
                }
                case 4: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField && !this.XFORMS && !this.HTMLFORMS) {
                        return;
                    }
                    this.translateX += this.scaleX * this.parseFloat(attributes.getValue("e"));
                    this.translateY += this.scaleY * this.parseFloat(attributes.getValue("f"));
                    this.scaleX *= this.parseFloat(attributes.getValue("a"));
                    this.scaleY *= this.parseFloat(attributes.getValue("d"));
                    break;
                }
                case 5: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    f5 = this.scaleX * this.parseLength(attributes.getValue("x-till"));
                    f6 = this.scaleY * this.parseLength(attributes.getValue("y-till"));
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    if (f5 < f7) {
                        f3 = f7;
                        f7 = f5;
                        f5 = f3;
                    }
                    if (f6 < f8) {
                        f4 = f8;
                        f8 = f6;
                        f6 = f4;
                    }
                    f4 = this.currentH - (f6 + this.translateY) - this.clipY;
                    string4 = "left: " + (f7 + this.translateX - this.clipX) + "pt; top: " + f4 + "pt; width: " + (f5 - f7) + "pt; ";
                    string4 = string4 + "height: " + (f6 - f8) + "pt; ";
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    attributesImpl.clear();
                    this.clipStack.push(new String[]{"" + this.clipX, "" + this.clipY});
                    this.clipX = this.translateX + f7;
                    this.clipY += f4;
                    break;
                }
                case 6: {
                    if (this.handler == null) {
                        return;
                    }
                    this.word_spacing = "" + this.scaleX * this.parseLength(attributes.getValue("value"));
                    break;
                }
                case 7: {
                    if (this.handler == null) {
                        return;
                    }
                    this.letter_spacing = "" + this.scaleX * this.parseLength(attributes.getValue("value"));
                    break;
                }
                case 8: {
                    if (this.handler == null) {
                        return;
                    }
                    Lexer lexer = new Lexer();
                    Token token = lexer.getSingleToken(attributes.getValue("value"));
                    String string5 = "";
                    if (token.type == 15) {
                        if (token.stringValue != null) {
                            if (token.stringValue.equals("%")) {
                                token.numValue *= (double)this.scaleX;
                                int n = 0;
                                while (n <= 1) {
                                    if (token.numValue >= this.alP[n]) {
                                        string5 = "" + fontStretchAlias.get("" + this.alP[n]);
                                    }
                                    ++n;
                                }
                                if (token.numValue <= this.alP[0]) {
                                    string5 = "" + fontStretchAlias.get("" + this.alP[0]);
                                }
                                if (string5.equals("")) {
                                    string5 = "normal";
                                }
                            } else {
                                this.session.warning("Data type mismatch: 'normal' value  of 'font-stretch' element will be used instead.");
                                string5 = "normal";
                            }
                        } else {
                            token.numValue *= (double)this.scaleX;
                            token.numValue *= 1000.0;
                            int n = 0;
                            while (n <= 8) {
                                if (token.numValue >= this.alN[n]) {
                                    string5 = "" + fontStretchAlias.get("" + this.alN[n]);
                                }
                                ++n;
                            }
                            if (token.numValue <= this.alN[0]) {
                                string5 = "" + fontStretchAlias.get("" + this.alN[0]);
                            }
                            if (string5.equals("")) {
                                string5 = "normal";
                            }
                        }
                    } else {
                        this.session.warning("Data type mismatch: a 'normal' value  of 'font-stretch' element will be used instead.");
                        string5 = "normal";
                    }
                    this.font_stretch = string5;
                    break;
                }
                case 9: {
                    if (this.handler == null) {
                        return;
                    }
                    this.font_family = attributes.getValue("family");
                    this.font_variant = attributes.getValue("variant");
                    this.font_style = attributes.getValue("style");
                    if (!(this.font_style.equalsIgnoreCase("normal") || this.font_style.equalsIgnoreCase("oblique") || this.font_style.equalsIgnoreCase("italic"))) {
                        this.session.warning("Font style '" + this.font_style + "' is not supported. Font style 'normal' will be used instead.");
                        this.font_style = "normal";
                    }
                    this.font_weight = attributes.getValue("weight");
                    this.font_size = this.parseLength(attributes.getValue("size"));
                    break;
                }
                case 10: 
                case 45: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    if (this.font_size == 0.0f) {
                        this.session.warning("Font size is null. Text will not be rendered.");
                        return;
                    }
                    FontCatalog fontCatalog = this.session.config.fontCatalog;
                    FontRecord fontRecord = fontCatalog.getFontRecord(this.font_family, this.parseInteger(this.font_weight), this.font_style, this.font_variant);
                    Metric metric = fontRecord.getMetric();
                    float f9 = metric.descender;
                    f3 = this.scaleX * this.parseLength(attributes.getValue("x"));
                    f4 = this.scaleY * (this.parseLength(attributes.getValue("y")) + this.font_size * f9 / 1000.0f) + Math.min(this.scaleX, this.scaleY) * this.font_size;
                    string4 = "left: " + (f3 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f4 + this.translateY) - this.clipY) + "pt; ";
                    string4 = string4 + "font-family: " + this.font_family + "; font-style: " + this.font_style + "; ";
                    string4 = string4 + "font-weight: " + this.font_weight + "; font-size: " + Math.min(this.scaleX, this.scaleY) * this.font_size + "pt; ";
                    string4 = string4 + "font-stretch: " + this.font_stretch + "; font-variant: " + this.font_variant + "; ";
                    string4 = string4 + "letter-spacing: " + this.letter_spacing + "pt; word-spacing: " + this.word_spacing + "pt; ";
                    string4 = string4 + "color: #" + this.color + ";" + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    attributesImpl.clear();
                    char[] cArray = attributes.getValue("value").toCharArray();
                    this.handler.characters(cArray, 0, cArray.length);
                    this.clipStack.push(new String[]{"" + this.clipX, "" + this.clipY});
                    this.clipX = this.translateX + f7;
                    this.clipY = this.currentH - (f4 + this.translateY);
                    break;
                }
                case 11: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField && !this.XFORMS && !this.HTMLFORMS) {
                        return;
                    }
                    f5 = this.scaleX * this.parseLength(attributes.getValue("x-till"));
                    f6 = this.scaleY * this.parseLength(attributes.getValue("y-till"));
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    String string6 = attributes.getValue("style").trim();
                    float f10 = this.parseLength(attributes.getValue("thickness"));
                    string4 = "";
                    if (f5 == f7) {
                        if (f6 < f8) {
                            f4 = f8;
                            f8 = f6;
                            f6 = f4;
                        }
                        string4 = "border-left-style: " + string6 + "; border-left-width: " + (f10 *= this.scaleX) + "pt; color: #" + this.color + "; ";
                        string4 = string4 + "top: " + (this.currentH - (f6 + this.translateY) - this.clipY) + "pt; left: " + (f7 + this.translateX - this.clipX - f10 / 2.0f) + "pt; width: 0pt; ";
                        string4 = string4 + "height: " + (f6 - f8) + "pt; ";
                    }
                    if (f6 == f8) {
                        if (f5 < f7) {
                            f3 = f7;
                            f7 = f5;
                            f5 = f3;
                        }
                        string4 = "border-top-style: " + string6 + "; border-top-width: " + (f10 *= this.scaleY) + "pt; color: #" + this.color + "; ";
                        string4 = string4 + "top: " + (this.currentH - (f6 + this.translateY) - this.clipY - f10 / 2.0f) + "pt; left: " + (f7 + this.translateX - this.clipX) + "pt; ";
                        string4 = string4 + "width: " + (f5 - f7) + "pt; height: 0pt; ";
                    }
                    if (!string4.equals("")) {
                        if (this.isPDFField && this.XFORMS || this.isPDFField && this.HTMLFORMS) {
                            this.field.setProperty("border-color", "#" + this.color);
                            this.field.setProperty("border-style", string6);
                            this.field.setProperty("border-width", f10 + "pt");
                            return;
                        }
                        attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                        attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                        this.handler.startElement("", "div", "div", attributesImpl);
                        this.handler.endElement("", "div", "div");
                        attributesImpl.clear();
                    }
                    break;
                }
                case 12: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField && !this.XFORMS && !this.HTMLFORMS) {
                        return;
                    }
                    if (this.isPDFField && this.XFORMS || this.isPDFField && this.HTMLFORMS) {
                        this.field.setProperty("background-color", "#" + this.color);
                        return;
                    }
                    f5 = this.scaleX * this.parseLength(attributes.getValue("x-till"));
                    f6 = this.scaleY * this.parseLength(attributes.getValue("y-till"));
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    if (f5 < f7) {
                        f3 = f7;
                        f7 = f5;
                        f5 = f3;
                    }
                    if (f6 < f8) {
                        f4 = f8;
                        f8 = f6;
                        f6 = f4;
                    }
                    string4 = "left: " + (f7 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f6 + this.translateY) - this.clipY) + "pt; ";
                    string4 = string4 + "width: " + (f5 - f7) + "pt; height: " + (f6 - f8) + "pt; ";
                    string4 = string4 + "background-color: #" + this.color + ";" + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    try {
                        attributes = this.putImage(attributes);
                    }
                    catch (IOException iOException) {
                        this.imageOK = false;
                        this.session.exception("Error processing image", iOException);
                    }
                    String string7 = attributes.getValue("type");
                    if (string7.equals("image/svg")) {
                        string7 = "image/svg+xml";
                    }
                    if (string7.equals("application/xepout") || !this.imageOK) {
                        return;
                    }
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    float f11 = this.scaleX * this.parseFloat(attributes.getValue("scale-x"));
                    float f12 = this.scaleY * this.parseFloat(attributes.getValue("scale-y"));
                    f2 = 0.0f;
                    f = 0.0f;
                    if (attributes.getValue("height") != null) {
                        f2 = this.parseLength(attributes.getValue("height"));
                    }
                    if (attributes.getValue("width") != null) {
                        f = this.parseLength(attributes.getValue("width"));
                    }
                    f6 = f8 + f2 * f12;
                    f5 = f7 + f * f11;
                    String string8 = "pt";
                    String string9 = "pt";
                    if (attributes.getValue("wunit") != null) {
                        string8 = attributes.getValue("wunit");
                    }
                    if (attributes.getValue("hunit") != null) {
                        string9 = attributes.getValue("hunit");
                    }
                    string4 = "left: " + (f7 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f8 + this.translateY) - this.clipY) + "pt; ";
                    string4 = string4 + "width: " + f * f11 + string8 + "; height: " + f2 * f12 + string9 + "; ";
                    string4 = string4 + "position: absolute; margin: 0pt 0pt 0pt 0pt; padding: 0pt 0pt 0pt 0pt; overflow: visible;";
                    string4 = string4 + this.debugcss;
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    attributesImpl.clear();
                    string4 = "left: 0pt; top: -" + f2 * f12 + string9 + "; ";
                    string4 = string4 + "width: " + f * f11 + string8 + "; height: " + f2 * f12 + string9 + "; ";
                    string4 = string4 + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "alt", "alt", "CDATA", "none");
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "width", "width", "CDATA", "100%");
                    attributesImpl.addAttribute("", "height", "height", "CDATA", "100%");
                    if (this.EMBED_IMAGES || string7.equals("image/svg+xml")) {
                        if (string7.equals("image/svg+xml")) {
                            String string10 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
                            string10 = string10 + "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:svg=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" ";
                            string10 = string10 + "width=\"100%\" height=\"100%\">\n";
                            string10 = string10 + "<g transform=\"scale(" + f11 + ", " + f12 + ")\">";
                            string10 = string10 + attributes.getValue("src");
                            string10 = string10 + "</g></svg>";
                            StringWriter stringWriter = new StringWriter();
                            Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string10.getBytes());
                            try {
                                byte[] byArray = new byte[8192];
                                int n = 0;
                                while ((n = byteArrayInputStream.read(byArray)) != -1) {
                                    base64OutputStream.write(byArray, 0, n);
                                }
                                ((OutputStream)base64OutputStream).close();
                                Object var39_48 = null;
                            }
                            catch (Throwable throwable) {
                                Object var39_49 = null;
                                ((InputStream)byteArrayInputStream).close();
                                throw throwable;
                            }
                            ((InputStream)byteArrayInputStream).close();
                            this.handler.startComment("[if IE]");
                            attributesImpl.addAttribute("", "src", "src", "CDATA", "data:;base64," + stringWriter.toString());
                            attributesImpl.addAttribute("", "type", "type", "CDATA", string7);
                            this.handler.startElement("", "embed", "embed", attributesImpl);
                            this.handler.endElement("", "embed", "embed");
                            this.handler.endComment("![endif]");
                            attributesImpl.removeAttribute(attributesImpl.getIndex("type"));
                            attributesImpl.removeAttribute(attributesImpl.getIndex("src"));
                            attributesImpl.removeAttribute(attributesImpl.getIndex("alt"));
                            attributesImpl.addAttribute("", "data", "data", "CDATA", "data:" + string7 + ";base64," + stringWriter.toString());
                            this.handler.startElement("", "object", "object", attributesImpl);
                            this.handler.endElement("", "object", "object");
                        } else {
                            attributesImpl.addAttribute("", "src", "src", "CDATA", "data:" + string7 + ";base64," + attributes.getValue("src"));
                            this.handler.startElement("", "img", "img", attributesImpl);
                            this.handler.endElement("", "img", "img");
                        }
                    } else {
                        attributesImpl.addAttribute("", "src", "src", "CDATA", attributes.getValue("src"));
                        this.handler.startElement("", "img", "img", attributesImpl);
                        this.handler.endElement("", "img", "img");
                    }
                    attributesImpl.clear();
                    this.handler.endElement("", "div", "div");
                    this.handler.endElement("", "div", "div");
                    break;
                }
                case 16: {
                    if (this.handler == null) {
                        return;
                    }
                    this.color = this.RGB2RGB(this.parseFloat(attributes.getValue("red")), this.parseFloat(attributes.getValue("green")), this.parseFloat(attributes.getValue("blue")));
                    break;
                }
                case 17: {
                    if (this.handler == null) {
                        return;
                    }
                    this.color = this.Grey2RGB(this.parseFloat(attributes.getValue("gray")));
                    break;
                }
                case 18: {
                    if (this.handler == null) {
                        return;
                    }
                    this.color = this.CMYK2RGB(this.parseFloat(attributes.getValue("black")), this.parseFloat(attributes.getValue("cyan")), this.parseFloat(attributes.getValue("magenta")), this.parseFloat(attributes.getValue("yellow")));
                    break;
                }
                case 19: {
                    if (this.handler == null) {
                        return;
                    }
                    float f13 = this.parseFloat(attributes.getValue("tint"));
                    if (attributes.getValue("alt-gray") != null) {
                        f13 = 1.0f - f13;
                        this.color = this.Grey2RGB(f13 * this.parseFloat(attributes.getValue("alt-gray")));
                        break;
                    }
                    if (attributes.getValue("alt-red") != null) {
                        f13 = 1.0f - f13;
                        this.color = this.RGB2RGB(f13 * this.parseFloat(attributes.getValue("alt-red")), f13 * this.parseFloat(attributes.getValue("alt-green")), f13 * this.parseFloat(attributes.getValue("alt-blue")));
                        break;
                    }
                    if (attributes.getValue("alt-cyan") != null) {
                        this.color = this.CMYK2RGB(f13 * this.parseFloat(attributes.getValue("alt-black")), f13 * this.parseFloat(attributes.getValue("alt-cyan")), f13 * this.parseFloat(attributes.getValue("alt-magenta")), f13 * this.parseFloat(attributes.getValue("alt-yellow")));
                    }
                    break;
                }
                case 20: {
                    if (this.handler == null) {
                        return;
                    }
                    this.color = Integer.toHexString((int)Math.round(255.0 * (1.0 - (double)this.parseFloat(attributes.getValue("tint")))));
                    if (this.color.length() < 2) {
                        this.color = "0" + this.color;
                    }
                    this.color = this.color + this.color + this.color;
                    break;
                }
                case 21: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    f3 = this.scaleX * this.parseLength(attributes.getValue("x"));
                    f4 = this.scaleY * this.parseLength(attributes.getValue("y"));
                    string4 = "left: " + (f3 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f4 + this.translateY) - this.clipY) + "pt; ";
                    string4 = string4 + "width: 1pt; height: 1pt; " + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    attributesImpl.addAttribute("", "name", "name", "CDATA", attributes.getValue("name"));
                    this.handler.startElement("", "a", "a", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 22: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    f5 = this.scaleX * this.parseLength(attributes.getValue("x-till"));
                    f6 = this.scaleY * this.parseLength(attributes.getValue("y-till"));
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    if (f5 < f7) {
                        f3 = f7;
                        f7 = f5;
                        f5 = f3;
                    }
                    if (f6 < f8) {
                        f4 = f8;
                        f8 = f6;
                        f6 = f4;
                    }
                    string4 = "left: " + (f7 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f6 + this.translateY) - this.clipY) + "pt; ";
                    string4 = string4 + "width: " + (f5 - f7) + "pt; height: " + (f6 - f8) + "pt; " + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    if (this.BREAK_PAGES) {
                        attributesImpl.addAttribute("", "href", "href", "CDATA", "page" + attributes.getValue("destination") + ".html#" + attributes.getValue("destination-id"));
                    } else {
                        attributesImpl.addAttribute("", "href", "href", "CDATA", "#" + attributes.getValue("destination-id"));
                    }
                    this.handler.startElement("", "a", "a", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 23: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    f5 = this.scaleX * this.parseLength(attributes.getValue("x-till"));
                    f6 = this.scaleY * this.parseLength(attributes.getValue("y-till"));
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    if (f5 < f7) {
                        f3 = f7;
                        f7 = f5;
                        f5 = f3;
                    }
                    if (f6 < f8) {
                        f4 = f8;
                        f8 = f6;
                        f6 = f4;
                    }
                    string4 = "left: " + (f7 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f6 + this.translateY) - this.clipY) + "pt; ";
                    string4 = string4 + "width: " + (f5 - f7) + "pt; height: " + (f6 - f8) + "pt; " + this.debugcss;
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    attributesImpl.addAttribute("", "href", "href", "CDATA", attributes.getValue("destination"));
                    String string11 = attributes.getValue("show-destination");
                    if (string11.equalsIgnoreCase("new")) {
                        attributesImpl.addAttribute("", "target", "target", "CDATA", "_blank");
                    }
                    this.handler.startElement("", "a", "a", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    if (this.handler == null) {
                        return;
                    }
                    this.isPDFField = true;
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    this.field = new Field(attributes.getValue("name"), "true".equals(attributes.getValue("readonly").trim().toLowerCase()) || "yes".equals(attributes.getValue("readonly").trim().toLowerCase()), "true".equals(attributes.getValue("required").trim().toLowerCase()) || "yes".equals(attributes.getValue("required").trim().toLowerCase()), "true".equals(attributes.getValue("hidden").trim().toLowerCase()) || "yes".equals(attributes.getValue("hidden").trim().toLowerCase()), "true".equals(attributes.getValue("noexport").trim().toLowerCase()) || "yes".equals(attributes.getValue("noexport").trim().toLowerCase()), "true".equals(attributes.getValue("printable").trim().toLowerCase()) || "yes".equals(attributes.getValue("printable").trim().toLowerCase()));
                    if (attributes.getValue("js-calculate") != null) {
                        this.field.setCalculation(attributes.getValue("js-calculate"));
                    }
                    if (attributes.getValue("js-format") != null) {
                        this.field.setFormat(attributes.getValue("js-format"));
                    }
                    if (attributes.getValue("js-keystroke") != null) {
                        this.field.setKeystroke(attributes.getValue("js-keystroke"));
                    }
                    if (attributes.getValue("js-validate") != null) {
                        this.field.addConstraint(attributes.getValue("js-validate"));
                    }
                    f5 = this.scaleX * this.parseLength(attributes.getValue("x-till"));
                    f6 = this.scaleY * this.parseLength(attributes.getValue("y-till"));
                    f7 = this.scaleX * this.parseLength(attributes.getValue("x-from"));
                    f8 = this.scaleY * this.parseLength(attributes.getValue("y-from"));
                    if (f5 < f7) {
                        f3 = f7;
                        f7 = f5;
                        f5 = f3;
                    }
                    if (f6 < f8) {
                        f4 = f8;
                        f8 = f6;
                        f6 = f4;
                    }
                    string4 = "left: " + (f7 + this.translateX - this.clipX) + "pt; top: " + (this.currentH - (f6 + this.translateY) - this.clipY) + "pt; " + this.debugcss;
                    this.field.setProperty("width", f5 - f7 + "pt");
                    this.field.setProperty("height", f6 - f8 + "pt");
                    attributesImpl.addAttribute("", "class", "class", "CDATA", "shared");
                    attributesImpl.addAttribute("", "style", "style", "CDATA", string4);
                    this.handler.startElement("", "div", "div", attributesImpl);
                    attributesImpl.clear();
                    break;
                }
                case 28: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    String string12 = attributes.getValue("multiline").trim().toLowerCase();
                    String string13 = attributes.getValue("password").trim().toLowerCase();
                    int n = this.parseInteger(attributes.getValue("maxlen"));
                    if (this.XFORMS) {
                        if (n >= 0) {
                            this.field.addConstraint("string-length(.) &lt;=" + attributes.getValue("maxlen"));
                        }
                        if (!this.field.hidden) {
                            attributesImpl.addAttribute("", "bind", "bind", "CDATA", "" + this.field.name);
                            attributesImpl.addAttribute("", "class", "class", "CDATA", "" + this.field.name);
                            if (this.field.keystroke != null) {
                                attributesImpl.addAttribute("", "incremental", "incremental", "CDATA", "true");
                            }
                        }
                        if ("true".equals(string13) || "yes".equals(string13)) {
                            if (!this.field.hidden) {
                                this.handler.startElement(XFORMSURI, "secret", "xf:secret", attributesImpl);
                                this.handler.endElement(XFORMSURI, "secret", "xf:secret");
                            }
                            this.field.setType("secret");
                        } else if ("true".equals(string12) || "yes".equals(string12)) {
                            if (!this.field.hidden) {
                                this.handler.startElement(XFORMSURI, "textarea", "xf:textarea", attributesImpl);
                                this.handler.endElement(XFORMSURI, "textarea", "xf:textarea");
                            }
                            this.field.setType("textarea");
                        } else {
                            if (!this.field.hidden) {
                                this.handler.startElement(XFORMSURI, "input", "xf:input", attributesImpl);
                                this.handler.endElement(XFORMSURI, "input", "xf:input");
                            }
                            this.field.setType("input");
                        }
                    } else {
                        if (n >= 0 && ("false".equals(string12) || "no".equals(string12))) {
                            attributesImpl.addAttribute("", "maxlength", "maxlength", "CDATA", "" + n);
                        }
                        boolean bl = false;
                        if ("true".equals(string13) || "yes".equals(string13)) {
                            bl = true;
                        }
                        attributesImpl.addAttribute("", "name", "name", "CDATA", "" + this.field.name);
                        attributesImpl.addAttribute("", "value", "value", "CDATA", attributes.getValue("text"));
                        attributesImpl.addAttribute("", "class", "class", "CDATA", "" + this.field.name);
                        String string14 = "input";
                        if (this.field.hidden) {
                            attributesImpl.addAttribute("", "type", "type", "CDATA", "hidden");
                        } else if (bl) {
                            if (!this.field.hidden) {
                                attributesImpl.addAttribute("", "type", "type", "CDATA", "password");
                            }
                        } else if ("true".equals(string12) || "yes".equals(string12)) {
                            if (!this.field.hidden || !bl) {
                                string14 = "textarea";
                            }
                        } else {
                            attributesImpl.addAttribute("", "type", "type", "CDATA", "text");
                        }
                        this.handler.startElement("", string14, string14, attributesImpl);
                        this.handler.endElement("", string14, string14);
                        this.field.setType(string14);
                    }
                    attributesImpl.clear();
                    break;
                }
                case 29: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    this.field.setValue(attributes.getValue("group-name"));
                    this.field.setType("radio");
                    break;
                }
                case 30: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (this.XFORMS && !this.field.hidden) {
                        attributesImpl.addAttribute("", "bind", "bind", "CDATA", "" + this.field.name);
                        if (this.field.keystroke != null) {
                            attributesImpl.addAttribute("", "incremental", "incremental", "CDATA", "true");
                        }
                        this.handler.startElement(XFORMSURI, "input", "xf:input", attributesImpl);
                        this.handler.endElement(XFORMSURI, "input", "xf:input");
                    }
                    this.field.setType("checkbox");
                    attributesImpl.clear();
                    break;
                }
                case 31: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (attributes.getValue("multiselect") != null) {
                        this.field.setSelection(attributes.getValue("multiselect").trim().toLowerCase());
                    }
                    if (this.field.multiselect) {
                        this.field.setType("select");
                        break;
                    }
                    this.field.setType("select1");
                    break;
                }
                case 32: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (attributes.getValue("multiselect") != null) {
                        this.field.setSelection(attributes.getValue("multiselect").trim().toLowerCase());
                    }
                    if (this.field.multiselect) {
                        this.field.setType("select");
                        break;
                    }
                    this.field.setType("select1");
                    break;
                }
                case 33: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (attributes.getValue("fields") != null) {
                        this.field.setFields(attributes.getValue("fields"));
                    }
                    this.field.setType("trigger");
                    break;
                }
                case 34: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (attributes.getValue("fields") != null) {
                        this.field.setFields(attributes.getValue("fields"));
                    }
                    this.field.setType("submit");
                    String string15 = attributes.getValue("url");
                    String string16 = "fdf";
                    if (attributes.getValue("submit-format") != null) {
                        string16 = attributes.getValue("submit-format");
                    }
                    String string17 = "";
                    if (attributes.getValue("method") != null) {
                        string17 = attributes.getValue("method").toLowerCase();
                    }
                    if (attributes.getValue("method") == null && string16.equalsIgnoreCase("HTML")) {
                        string17 = "post";
                    }
                    this.field.createSubmissionProp(string15, string17);
                    break;
                }
                case 35: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    String string18 = "false";
                    if (attributes.getValue("initially-selected") != null) {
                        string18 = attributes.getValue("initially-selected").trim().toLowerCase();
                    }
                    this.field.addOption(attributes.getValue("text"), string18);
                    if (this.field.type == null) {
                        this.field.setType("option");
                    }
                    if (this.HTMLFORMS && this.field.type.equals("checkbox")) {
                        this.field.setValue(attributes.getValue("text"));
                    }
                    break;
                }
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!XEPURI.equals(string)) {
            return;
        }
        if (this.handler == null) {
            return;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.handler == null) {
                        return;
                    }
                    this.resetPageSettings();
                    if (this.session.config.CUSTOM_STAMP == null & this.session.config.XHTMLTrial || this.session.config.CUSTOM_STAMP == null & this.session.config.XFormsTrial) {
                        Stamp.put(this, this.session);
                    }
                    if (this.session.config.CUSTOM_STAMP != null) {
                        this.putCustomStamp();
                    }
                    while (this.stack.length() != 0) {
                        String string4 = this.stack.pop().toString();
                        this.handler.endElement("", string4, string4);
                    }
                    this.handler.endDocument();
                    if (this.USE_TEMP_FILE && !this.BREAK_PAGES) {
                        this.fosTmp.close();
                    }
                    if (this.BREAK_PAGES) {
                        this.endXHTMLFile();
                    }
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    this.handler.endElement("", "div", "div");
                    String[] stringArray = (String[])this.clipStack.pop();
                    this.clipX = this.parseFloat(stringArray[0]);
                    this.clipY = this.parseFloat(stringArray[1]);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                case 10: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    this.handler.endElement("", "div", "div");
                    String[] stringArray = (String[])this.clipStack.pop();
                    this.clipX = this.parseFloat(stringArray[0]);
                    this.clipY = this.parseFloat(stringArray[1]);
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    this.handler.endElement("", "div", "div");
                    break;
                }
                case 13: {
                    break;
                }
                case 14: {
                    break;
                }
                case 15: {
                    if (this.isPDFField) {
                        return;
                    }
                    this.imageOK = true;
                    break;
                }
                case 16: {
                    break;
                }
                case 17: {
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    break;
                }
                case 20: {
                    break;
                }
                case 21: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    this.handler.endElement("", "a", "a");
                    break;
                }
                case 22: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    this.handler.endElement("", "a", "a");
                    break;
                }
                case 23: {
                    if (this.handler == null) {
                        return;
                    }
                    if (this.isPDFField) {
                        return;
                    }
                    this.handler.endElement("", "a", "a");
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 26: {
                    break;
                }
                case 27: {
                    if (this.handler == null) {
                        return;
                    }
                    this.isPDFField = false;
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    this.handler.endElement("", "div", "div");
                    this.field.setProperty("color", "#" + this.color);
                    this.field.setProperty("word-spacing", this.word_spacing + "pt");
                    this.field.setProperty("letter-spacing", this.letter_spacing + "pt");
                    this.field.setProperty("font-stretch", this.font_stretch);
                    this.field.setProperty("font-family", this.font_family);
                    this.field.setProperty("font-variant", this.font_variant);
                    this.field.setProperty("font-style", this.font_style);
                    this.field.setProperty("font-weight", this.font_weight);
                    this.field.setProperty("font-size", Math.min(this.scaleX, this.scaleY) * this.font_size + "pt");
                    this.model.put(this.field.name, this.field);
                    break;
                }
                case 28: {
                    break;
                }
                case 29: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (!this.field.hidden) {
                        Object object;
                        this.field.setProperty("color", "#" + this.color);
                        this.field.setProperty("word-spacing", this.word_spacing + "pt");
                        this.field.setProperty("letter-spacing", this.letter_spacing + "pt");
                        this.field.setProperty("font-stretch", this.font_stretch);
                        this.field.setProperty("font-family", this.font_family);
                        this.field.setProperty("font-variant", this.font_variant);
                        this.field.setProperty("font-style", this.font_style);
                        this.field.setProperty("font-weight", this.font_weight);
                        this.field.setProperty("font-size", Math.min(this.scaleX, this.scaleY) * this.font_size + "pt");
                        String string5 = "";
                        Enumeration enumeration = this.field.style.keys();
                        while (enumeration.hasMoreElements()) {
                            object = (String)enumeration.nextElement();
                            string5 = string5 + (String)object + ": " + this.field.style.get(object) + "; ";
                        }
                        attributesImpl.addAttribute("", "style", "style", "CDATA", string5);
                        this.handler.startElement("", "div", "div", attributesImpl);
                        attributesImpl.clear();
                        if (this.XFORMS) {
                            attributesImpl.addAttribute("", "appearance", "appearance", "CDATA", "full");
                            attributesImpl.addAttribute("", "bind", "bind", "CDATA", this.field.value);
                            if (this.field.keystroke != null) {
                                attributesImpl.addAttribute("", "incremental", "incremental", "CDATA", "true");
                            }
                            this.handler.startElement(XFORMSURI, "select1", "xf:select1", attributesImpl);
                            attributesImpl.clear();
                            this.handler.startElement(XFORMSURI, "item", "xf:item", attributesImpl);
                            this.handler.startElement(XFORMSURI, "value", "xf:value", attributesImpl);
                            object = this.field.name.toCharArray();
                            this.handler.characters((char[])object, 0, ((Object)object).length);
                            this.handler.endElement(XFORMSURI, "value", "xf:value");
                            this.handler.endElement(XFORMSURI, "item", "xf:item");
                            this.handler.endElement(XFORMSURI, "select1", "xf:select1");
                        } else {
                            this.field.setType("input");
                            attributesImpl.addAttribute("", "name", "name", "CDATA", this.field.value);
                            attributesImpl.addAttribute("", "value", "value", "CDATA", this.field.name);
                            attributesImpl.addAttribute("", "type", "type", "CDATA", "radio");
                            attributesImpl.addAttribute("", "class", "class", "CDATA", "" + this.field.name);
                            this.handler.startElement("", "input", "input", attributesImpl);
                            this.handler.endElement("", "input", "input");
                        }
                        this.handler.endElement("", "div", "div");
                        attributesImpl.clear();
                    }
                    break;
                }
                case 30: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.HTMLFORMS && !this.XFORMS || this.BREAK_PAGES) {
                        return;
                    }
                    if (this.HTMLFORMS && !this.field.hidden) {
                        attributesImpl.addAttribute("", "name", "name", "CDATA", this.field.name);
                        String[] stringArray = (String[])this.field.option.get(0);
                        attributesImpl.addAttribute("", "value", "value", "CDATA", stringArray[0]);
                        attributesImpl.addAttribute("", "type", "type", "CDATA", "checkbox");
                        attributesImpl.addAttribute("", "class", "class", "CDATA", "" + this.field.name);
                        this.handler.startElement("", "input", "input", attributesImpl);
                        this.handler.endElement("", "input", "input");
                        attributesImpl.clear();
                    }
                    break;
                }
                case 31: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES || this.HTMLFORMS) {
                        return;
                    }
                    if (!this.field.hidden) {
                        attributesImpl.addAttribute("", "bind", "bind", "CDATA", "" + this.field.name);
                        attributesImpl.addAttribute("", "class", "class", "CDATA", "" + this.field.name);
                        if (this.field.keystroke != null) {
                            attributesImpl.addAttribute("", "incremental", "incremental", "CDATA", "true");
                        }
                        if (this.field.multiselect) {
                            this.handler.startElement(XFORMSURI, "select", "xf:select", attributesImpl);
                        } else {
                            this.handler.startElement(XFORMSURI, "select1", "xf:select1", attributesImpl);
                        }
                        attributesImpl.clear();
                        int n = 0;
                        while (n < this.field.option.length()) {
                            String[] stringArray = (String[])this.field.option.get(n);
                            char[] cArray = stringArray[0].toCharArray();
                            this.handler.startElement(XFORMSURI, "item", "xf:item", attributesImpl);
                            this.handler.startElement(XFORMSURI, "label", "xf:label", attributesImpl);
                            this.handler.characters(cArray, 0, cArray.length);
                            this.handler.endElement(XFORMSURI, "label", "xf:label");
                            this.handler.startElement(XFORMSURI, "value", "xf:value", attributesImpl);
                            this.handler.characters(cArray, 0, cArray.length);
                            this.handler.endElement(XFORMSURI, "value", "xf:value");
                            this.handler.endElement(XFORMSURI, "item", "xf:item");
                            ++n;
                        }
                        if (this.field.multiselect) {
                            this.handler.endElement(XFORMSURI, "select", "xf:select");
                        } else {
                            this.handler.endElement(XFORMSURI, "select1", "xf:select1");
                        }
                    }
                    attributesImpl.clear();
                    break;
                }
                case 32: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES || this.HTMLFORMS) {
                        return;
                    }
                    if (!this.field.hidden) {
                        attributesImpl.addAttribute("", "bind", "bind", "CDATA", "" + this.field.name);
                        attributesImpl.addAttribute("", "class", "class", "CDATA", "" + this.field.name);
                        if (this.field.keystroke != null) {
                            attributesImpl.addAttribute("", "incremental", "incremental", "CDATA", "true");
                        }
                        if (this.field.multiselect) {
                            this.handler.startElement(XFORMSURI, "select", "xf:select", attributesImpl);
                        } else {
                            this.handler.startElement(XFORMSURI, "select1", "xf:select1", attributesImpl);
                        }
                        attributesImpl.clear();
                        int n = 0;
                        while (n < this.field.option.length()) {
                            String[] stringArray = (String[])this.field.option.get(n);
                            char[] cArray = stringArray[0].toCharArray();
                            this.handler.startElement(XFORMSURI, "item", "xf:item", attributesImpl);
                            this.handler.startElement(XFORMSURI, "label", "xf:label", attributesImpl);
                            this.handler.characters(cArray, 0, cArray.length);
                            this.handler.endElement(XFORMSURI, "label", "xf:label");
                            this.handler.startElement(XFORMSURI, "value", "xf:value", attributesImpl);
                            this.handler.characters(cArray, 0, cArray.length);
                            this.handler.endElement(XFORMSURI, "value", "xf:value");
                            this.handler.endElement(XFORMSURI, "item", "xf:item");
                            ++n;
                        }
                        if (this.field.multiselect) {
                            this.handler.endElement(XFORMSURI, "select", "xf:select");
                        } else {
                            this.handler.endElement(XFORMSURI, "select1", "xf:select1");
                        }
                    }
                    attributesImpl.clear();
                    break;
                }
                case 33: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES || this.HTMLFORMS) {
                        return;
                    }
                    if (!this.field.hidden) {
                        String[] stringArray;
                        this.field.setProperty("color", "#" + this.color);
                        this.field.setProperty("word-spacing", this.word_spacing + "pt");
                        this.field.setProperty("letter-spacing", this.letter_spacing + "pt");
                        this.field.setProperty("font-stretch", this.font_stretch);
                        this.field.setProperty("font-family", this.font_family);
                        this.field.setProperty("font-variant", this.font_variant);
                        this.field.setProperty("font-style", this.font_style);
                        this.field.setProperty("font-weight", this.font_weight);
                        this.field.setProperty("font-size", Math.min(this.scaleX, this.scaleY) * this.font_size + "pt");
                        String string6 = "";
                        Enumeration enumeration = this.field.style.keys();
                        while (enumeration.hasMoreElements()) {
                            stringArray = (String[])enumeration.nextElement();
                            string6 = string6 + (String)stringArray + ": " + this.field.style.get(stringArray) + "; ";
                        }
                        attributesImpl.addAttribute("", "style", "style", "CDATA", string6);
                        this.handler.startElement("", "div", "div", attributesImpl);
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "appearance", "appearance", "CDATA", "minimal");
                        this.handler.startElement(XFORMSURI, "trigger", "xf:trigger", attributesImpl);
                        attributesImpl.clear();
                        this.handler.startElement(XFORMSURI, "label", "xf:label", attributesImpl);
                        stringArray = (String[])this.field.option.get(0);
                        char[] cArray = stringArray[0].toCharArray();
                        this.handler.characters(cArray, 0, cArray.length);
                        this.handler.endElement(XFORMSURI, "label", "xf:label");
                        if (!this.field.fields.isEmpty()) {
                            attributesImpl.addAttribute(EVENTS, "event", "ev:event", "CDATA", "DOMActivate");
                            this.handler.startElement(XFORMSURI, "action", "xf:action", attributesImpl);
                            attributesImpl.clear();
                            while (!this.field.fields.isEmpty()) {
                                String string7 = "" + this.field.fields.pop();
                                attributesImpl.addAttribute("", "ref", "ref", "CDATA", "" + string7);
                                this.handler.startElement(XFORMSURI, "setvalue", "xf:setvalue", attributesImpl);
                                this.handler.endElement(XFORMSURI, "setvalue", "xf:setvalue");
                                attributesImpl.clear();
                            }
                            this.handler.endElement(XFORMSURI, "action", "xf:action");
                        } else {
                            attributesImpl.addAttribute(EVENTS, "event", "ev:event", "CDATA", "DOMActivate");
                            this.handler.startElement(XFORMSURI, "reset", "xf:reset", attributesImpl);
                            this.handler.endElement(XFORMSURI, "reset", "xf:reset");
                            attributesImpl.clear();
                        }
                        this.handler.endElement(XFORMSURI, "trigger", "xf:trigger");
                        this.handler.endElement("", "div", "div");
                    }
                    break;
                }
                case 34: {
                    if (this.handler == null) {
                        return;
                    }
                    if (!this.XFORMS || this.BREAK_PAGES || this.HTMLFORMS) {
                        return;
                    }
                    if (!this.field.hidden) {
                        String[] stringArray;
                        this.field.setProperty("color", "#" + this.color);
                        this.field.setProperty("word-spacing", this.word_spacing + "pt");
                        this.field.setProperty("letter-spacing", this.letter_spacing + "pt");
                        this.field.setProperty("font-stretch", this.font_stretch);
                        this.field.setProperty("font-family", this.font_family);
                        this.field.setProperty("font-variant", this.font_variant);
                        this.field.setProperty("font-style", this.font_style);
                        this.field.setProperty("font-weight", this.font_weight);
                        this.field.setProperty("font-size", Math.min(this.scaleX, this.scaleY) * this.font_size + "pt");
                        String string8 = "";
                        Enumeration enumeration = this.field.style.keys();
                        while (enumeration.hasMoreElements()) {
                            stringArray = (String[])enumeration.nextElement();
                            string8 = string8 + (String)stringArray + ": " + this.field.style.get(stringArray) + "; ";
                        }
                        attributesImpl.addAttribute("", "style", "style", "CDATA", string8);
                        this.handler.startElement("", "div", "div", attributesImpl);
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "appearance", "appearance", "CDATA", "minimal");
                        attributesImpl.addAttribute("", "submission", "submission", "CDATA", "" + this.field.id);
                        this.handler.startElement(XFORMSURI, "submit", "xf:submit", attributesImpl);
                        attributesImpl.clear();
                        this.handler.startElement(XFORMSURI, "label", "xf:label", attributesImpl);
                        stringArray = (String[])this.field.option.get(0);
                        char[] cArray = stringArray[0].toCharArray();
                        this.handler.characters(cArray, 0, cArray.length);
                        this.handler.endElement(XFORMSURI, "label", "xf:label");
                        this.handler.endElement(XFORMSURI, "submit", "xf:submit");
                        this.handler.endElement("", "div", "div");
                    }
                    break;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    public void endDocument() throws SAXException {
        if (!this.BREAK_PAGES) {
            int n;
            Object object;
            Object object2;
            Object object3;
            OutputStreamWriter outputStreamWriter;
            try {
                outputStreamWriter = new OutputStreamWriter(this.outstream, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(this.outstream);
            }
            try {
                Object object4;
                Object object5;
                Enumeration enumeration;
                if (!this.HTMLFORMS) {
                    outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    outputStreamWriter.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
                    outputStreamWriter.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" ");
                } else {
                    outputStreamWriter.write("<html ");
                }
                if (this.XFORMS) {
                    outputStreamWriter.write("xmlns:xf=\"http://www.w3.org/2002/xforms\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:ev=\"http://www.w3.org/2001/xml-events\" ");
                }
                outputStreamWriter.write("xml:lang=\"en\" lang=\"en\">\n");
                outputStreamWriter.write("\t<head>\n");
                outputStreamWriter.write("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                outputStreamWriter.write("\t\t<style type=\"text/css\">\n");
                outputStreamWriter.write("\t\t\tdiv.shared { " + this.sharedcss + " }\n");
                outputStreamWriter.write("\t\t\ta.shared { " + this.sharedcss + " }\n");
                outputStreamWriter.write("\t\t\tembed.shared { " + this.sharedcss + " }\n");
                outputStreamWriter.write("\t\t\timg.shared { " + this.sharedcss + " }\n");
                outputStreamWriter.write("\t\t\tobject.shared { " + this.sharedcss + " }\n");
                if (this.XFORMS || this.HTMLFORMS) {
                    if (this.XFORMS) {
                        outputStreamWriter.write("\n\t\t\t@namespace xf url(http://www.w3.org/2002/xforms)\n");
                    }
                    enumeration = this.model.keys();
                    object3 = new Stack();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        object = (Field)this.model.get(object2);
                        if (!(((List)object3).contains(((Field)object).type) || ((Field)object).type.equals("checkbox") || ((Field)object).type.equals("option") || ((Field)object).type.equals("trigger") || ((Field)object).type.equals("submit") || ((Field)object).type.equals("radio"))) {
                            ((Stack)object3).push(((Field)object).type);
                            if (this.XFORMS) {
                                outputStreamWriter.write("\nxf|" + ((Field)object).type + "{ display: table-row; }\n");
                            }
                        }
                        if (((Field)object).hidden || ((Field)object).type.equals("trigger") || ((Field)object).type.equals("option") || ((Field)object).type.equals("submit") || ((Field)object).type.equals("radio")) continue;
                        if (this.XFORMS) {
                            outputStreamWriter.write("\n." + object2 + " " + ((Field)object).type + " {");
                        } else {
                            outputStreamWriter.write("\n." + object2 + " {");
                        }
                        object5 = ((Field)object).style.keys();
                        while (object5.hasMoreElements()) {
                            object4 = (String)object5.nextElement();
                            outputStreamWriter.write("\n\t" + (String)object4 + ": " + ((Field)object).style.get(object4) + ";");
                        }
                        outputStreamWriter.write("}\n");
                    }
                    if (this.XFORMS) {
                        outputStreamWriter.write("*::value:invalid { background-color: red; }\n");
                        outputStreamWriter.write("*:required::after { content: \"*\"; color: red; }\n");
                    }
                }
                outputStreamWriter.write("\n\t\t</style>\n");
                if (this.XFORMS) {
                    outputStreamWriter.write("\n\t<xf:model>\n\t\t<xf:instance>\n\t\t\t<fields xmlns=\"\">");
                    enumeration = this.model.keys();
                    object3 = new Hashtable();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        object = (Field)this.model.get(object2);
                        if (!((Field)object).type.equals("radio") || !(object5 = (String[])((Field)object).option.get(0))[1].equalsIgnoreCase("true") && !object5[1].equalsIgnoreCase("yes")) continue;
                        ((Hashtable)object3).put(((Field)object).value, object);
                    }
                    enumeration = this.model.keys();
                    while (enumeration.hasMoreElements()) {
                        object2 = enumeration.nextElement();
                        object = (Field)this.model.get(object2);
                        if (!((Field)object).type.equals("radio") || ((Hashtable)object3).containsKey(((Field)object).value)) continue;
                        ((Hashtable)object3).put(((Field)object).value, object);
                    }
                    object2 = "";
                    enumeration = this.model.keys();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        object5 = (Field)this.model.get(object);
                        object4 = (String[])((Field)object5).option.get(0);
                        if (!(((Field)object5).type.equals("trigger") || ((Field)object5).type.equals("submit") || ((Field)object5).type.equals("radio"))) {
                            outputStreamWriter.write("\n\t\t\t\t");
                            if (((Field)object5).hidden) {
                                outputStreamWriter.write("<q/>");
                            }
                            if (object4[1].equalsIgnoreCase("true") || object4[1].equalsIgnoreCase("yes")) {
                                if (((Field)object5).type.equals("checkbox")) {
                                    outputStreamWriter.write("<" + ((Field)object5).name + ">" + true + "</" + ((Field)object5).name + ">");
                                } else {
                                    outputStreamWriter.write("<" + ((Field)object5).name + ">" + object4[0] + "</" + ((Field)object5).name + ">");
                                }
                            } else {
                                outputStreamWriter.write("<" + ((Field)object5).name + "/>");
                            }
                            object2 = (String)object2 + "\n\t\t<xf:bind id=\"" + ((Field)object5).name + "\" nodeset=\"/fields/" + ((Field)object5).name + "\"";
                            if (((Field)object5).type.equals("checkbox")) {
                                object2 = (String)object2 + " type=\"xsd:boolean\"";
                            }
                            if (((Field)object5).readonly) {
                                object2 = (String)object2 + " readonly=\"true()\"";
                            }
                            if (((Field)object5).required) {
                                object2 = (String)object2 + " required=\"true()\"";
                            }
                            if (((Field)object5).calculate != null) {
                                object2 = (String)object2 + " calculate=\"" + ((Field)object5).calculate + "\"";
                            }
                            if (((Field)object5).format != null) {
                                object2 = (String)object2 + " type=\"" + ((Field)object5).format + "\"";
                            }
                            if (((Field)object5).keystroke != null) {
                                object2 = (String)object2 + " type=\"" + ((Field)object5).keystroke + "\"";
                            }
                            if (!((Field)object5).constraint.isEmpty()) {
                                object2 = (String)object2 + " constraint=\"" + ((Field)object5).constraintToString() + "\"";
                            }
                            object2 = (String)object2 + " />";
                        }
                        if (!((Field)object5).type.equals("submit")) continue;
                        object2 = (String)object2 + "\n\t\t<xf:submission action=\"" + ((Field)object5).action + "\"";
                        if (!((Field)object5).method.equals("")) {
                            object2 = (String)object2 + " method=\"" + ((Field)object5).method + "\"";
                        }
                        object2 = (String)object2 + " id=\"" + ((Field)object5).id + "\" />";
                    }
                    object = ((Hashtable)object3).keys();
                    while (object.hasMoreElements()) {
                        object5 = object.nextElement();
                        object4 = (String[])((Hashtable)object3).get(object5);
                        String[] stringArray = (String[])((Field)object4).option.get(0);
                        outputStreamWriter.write("\n\t\t\t\t");
                        if (stringArray[1].equalsIgnoreCase("true") || stringArray[1].equalsIgnoreCase("yes")) {
                            outputStreamWriter.write("<" + object5 + ">" + ((Field)object4).name + "</" + object5 + ">");
                        } else {
                            outputStreamWriter.write("<" + object5 + "/>");
                        }
                        object2 = (String)object2 + "\n\t\t<xf:bind id=\"" + object5 + "\" nodeset=\"/fields/" + object5 + "\"";
                        if (((Field)object4).readonly) {
                            object2 = (String)object2 + " readonly=\"true()\"";
                        }
                        if (((Field)object4).required) {
                            object2 = (String)object2 + " required=\"true()\"";
                        }
                        if (((Field)object4).calculate != null) {
                            object2 = (String)object2 + " calculate=\"" + ((Field)object4).calculate + "\"";
                        }
                        if (((Field)object4).format != null) {
                            object2 = (String)object2 + " type=\"" + ((Field)object4).format + "\"";
                        }
                        if (((Field)object4).keystroke != null) {
                            object2 = (String)object2 + " type=\"" + ((Field)object4).keystroke + "\"";
                        }
                        if (!((Field)object4).constraint.isEmpty()) {
                            object2 = (String)object2 + " constraint=\"" + ((Field)object4).constraintToString() + "\"";
                        }
                        object2 = (String)object2 + " />";
                    }
                    outputStreamWriter.write("\n\t\t\t</fields>\n\t\t</xf:instance>");
                    outputStreamWriter.write((String)object2);
                    outputStreamWriter.write("\n\t</xf:model>\n");
                }
                outputStreamWriter.write("\t</head>\n");
                outputStreamWriter.write("\t<body>");
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                throw new XHTMLIOException(iOException);
            }
            if (this.USE_TEMP_FILE) {
                n = 1;
                while (n <= this.maxP) {
                    if (this.tmpFiles.containsKey("" + n)) {
                        try {
                            int n2;
                            object3 = new File((String)this.tmpFiles.get("" + n));
                            object2 = new FileInputStream((File)object3);
                            object = new byte[512];
                            while ((n2 = ((FileInputStream)object2).read((byte[])object)) != -1) {
                                this.outstream.write((byte[])object, 0, n2);
                            }
                            this.outstream.flush();
                            ((FileInputStream)object2).close();
                            ((File)object3).delete();
                        }
                        catch (IOException iOException) {
                            throw new XHTMLIOException(iOException);
                        }
                    }
                    ++n;
                }
            } else {
                n = 1;
                while (n <= this.maxP) {
                    if (this.tmpStreams.containsKey("" + n)) {
                        try {
                            object3 = (ByteArrayOutputStream)this.tmpStreams.get("" + n);
                            this.outstream.write(((ByteArrayOutputStream)object3).toByteArray());
                            this.outstream.flush();
                            ((ByteArrayOutputStream)object3).close();
                        }
                        catch (IOException iOException) {
                            throw new XHTMLIOException(iOException);
                        }
                    }
                    ++n;
                }
            }
            try {
                outputStreamWriter.write("\n\t</body>");
                outputStreamWriter.write("\n</html>");
                ((Writer)outputStreamWriter).flush();
            }
            catch (IOException iOException) {
                throw new XHTMLIOException(iOException);
            }
        }
        try {
            this.addFrame();
            this.XHTMLStream.flush();
            this.XHTMLStream.close();
        }
        catch (IOException iOException) {
            this.session.error("Cannot close document: " + iOException);
        }
    }

    private void addXHTMLFile(String string) {
        ZipEntry zipEntry = new ZipEntry(string);
        try {
            this.XHTMLStream.putNextEntry(zipEntry);
        }
        catch (IOException iOException) {
            this.session.error("Cannot create ZIP Entry. " + iOException);
        }
    }

    private void addCSSFile(String string) {
        OutputStreamWriter outputStreamWriter;
        this.addXHTMLFile(string);
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)this.XHTMLStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = new OutputStreamWriter(this.XHTMLStream);
        }
        try {
            outputStreamWriter.write("div.shared {\n");
            outputStreamWriter.write("\tposition: absolute;\n");
            outputStreamWriter.write("\tmargin: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\tpadding: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\toverflow: hidden; clip: auto;\n");
            outputStreamWriter.write("}\n\n");
            outputStreamWriter.write("a.shared {\n");
            outputStreamWriter.write("\tposition: absolute;\n");
            outputStreamWriter.write("\tmargin: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\tpadding: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\toverflow: hidden; clip: auto;\n");
            outputStreamWriter.write("}\n\n");
            outputStreamWriter.write("embed.shared {\n");
            outputStreamWriter.write("\tposition: absolute;\n");
            outputStreamWriter.write("\tmargin: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\tpadding: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\toverflow: hidden; clip: auto;\n");
            outputStreamWriter.write("}\n\n");
            outputStreamWriter.write("img.shared {\n");
            outputStreamWriter.write("\tposition: absolute;\n");
            outputStreamWriter.write("\tmargin: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\tpadding: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\toverflow: hidden; clip: auto;\n");
            outputStreamWriter.write("}\n\n");
            outputStreamWriter.write("object.shared {\n");
            outputStreamWriter.write("\tposition: absolute;\n");
            outputStreamWriter.write("\tmargin: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\tpadding: 0pt 0pt 0pt 0pt;\n");
            outputStreamWriter.write("\toverflow: hidden; clip: auto;\n");
            outputStreamWriter.write("}\n");
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            throw new XHTMLIOException(iOException);
        }
        this.endXHTMLFile();
    }

    private void addFrame() {
        OutputStreamWriter outputStreamWriter;
        Object[] objectArray = this.page.toArray(new Integer[this.page.size()]);
        Arrays.sort(objectArray);
        this.addXHTMLFile("index.html");
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)this.XHTMLStream, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            outputStreamWriter = new OutputStreamWriter(this.XHTMLStream);
        }
        try {
            outputStreamWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n");
            outputStreamWriter.write("\t\"http://www.w3.org/TR/html4/frameset.dtd\">\n");
            outputStreamWriter.write("<html>\n");
            outputStreamWriter.write("\t<head>\n");
            outputStreamWriter.write("\t\t<title>\n");
            outputStreamWriter.write("\t\t\tPages overview\n");
            outputStreamWriter.write("\t\t</title>\n");
            outputStreamWriter.write("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
            outputStreamWriter.write("\t</head>\n");
            outputStreamWriter.write("\t<frameset cols=\"20%,75%\">\n");
            outputStreamWriter.write("\t\t<frame src=\"page0.html\" name=\"index\"/>\n");
            outputStreamWriter.write("\t\t<frame src=\"page1.html\" name=\"pages\"/>\n");
            outputStreamWriter.write("\t</frameset>\n");
            outputStreamWriter.write("</html>");
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            throw new XHTMLIOException(iOException);
        }
        this.endXHTMLFile();
        this.addXHTMLFile("page0.html");
        try {
            outputStreamWriter.write("<html>\n");
            outputStreamWriter.write("\t<head>\n");
            outputStreamWriter.write("\t\t<title>\n");
            outputStreamWriter.write("\t\t\tPage list\n");
            outputStreamWriter.write("\t\t</title>\n");
            outputStreamWriter.write("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
            outputStreamWriter.write("\t</head>\n");
            outputStreamWriter.write("\t<body>\n");
            int n = 0;
            while (n < objectArray.length) {
                outputStreamWriter.write("\t\t<br/>\n");
                outputStreamWriter.write("\t\t<a href=\"page" + objectArray[n] + ".html\" target=\"pages\">page" + objectArray[n] + ".html</a>\n");
                ++n;
            }
            outputStreamWriter.write("\t\t<br/>\n");
            outputStreamWriter.write("\t</body>\n");
            outputStreamWriter.write("</html>");
            ((Writer)outputStreamWriter).flush();
        }
        catch (IOException iOException) {
            throw new XHTMLIOException(iOException);
        }
        this.endXHTMLFile();
    }

    private void endXHTMLFile() {
        try {
            this.XHTMLStream.closeEntry();
        }
        catch (IOException iOException) {
            this.session.error("Cannot close ZIP Entry. " + iOException);
        }
    }

    public int parseInteger(String string) {
        return Integer.valueOf(string);
    }

    public float parseFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public float parseLength(String string) {
        return this.parseFloat(string) / 1000.0f;
    }

    public String CMYK2RGB(float f, float f2, float f3, float f4) {
        float f5 = 1.0f - f;
        int n = f5 > f2 ? Math.round((f5 - f2) * 255.0f) : 0;
        int n2 = f5 > f3 ? Math.round((f5 - f3) * 255.0f) : 0;
        int n3 = f5 > f4 ? Math.round((f5 - f4) * 255.0f) : 0;
        String string = Integer.toHexString(n);
        String string2 = Integer.toHexString(n2);
        String string3 = Integer.toHexString(n3);
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return string + string2 + string3;
    }

    public String Grey2RGB(float f) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        if (string.length() < 2) {
            string = "0" + string;
        }
        return string + string + string;
    }

    public String RGB2RGB(float f, float f2, float f3) {
        String string = Integer.toHexString(Math.round(255.0f * f));
        String string2 = Integer.toHexString(Math.round(255.0f * f2));
        String string3 = Integer.toHexString(Math.round(255.0f * f3));
        if (string.length() < 2) {
            string = "0" + string;
        }
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        return string + string2 + string3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attributes putImage(Attributes attributes) throws IOException {
        Object object;
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n = attributesImpl.getIndex("src");
        if (n == -1) {
            this.session.error("No source specified for an image");
            this.imageOK = false;
            return attributes;
        }
        String string = attributesImpl.getValue(n);
        String string2 = attributesImpl.getValue("base");
        URLSpec uRLSpec = string2 == null ? new URLSpec(string) : new URLSpec(new URLSpec(string2), string);
        String string3 = (String)this.imageIndex.get(string);
        String string4 = attributesImpl.getValue("type");
        String string5 = "0";
        String string6 = "0";
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Serializer serializer = null;
        XMLReader xMLReader = null;
        InputSource inputSource = null;
        if (!(string4.equalsIgnoreCase("image/svg") || string4.equalsIgnoreCase("image/svg+xml") || string4.equalsIgnoreCase("application/xepout"))) {
            try {
                object = this.imageFactory.makeImage(uRLSpec);
                string5 = "" + ((Image)object).width * 1000.0;
                string6 = "" + ((Image)object).height * 1000.0;
                this.imageOK = true;
            }
            catch (ImageFormatException imageFormatException) {
                this.imageOK = false;
                this.session.exception("Cannot parse image file", imageFormatException);
                this.imageOK = false;
            }
            catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
                this.imageOK = false;
                this.session.error("Unknown MIME type: " + unregisteredMIMETypeException.toString());
            }
        }
        if (string4.equalsIgnoreCase("application/xepout")) {
            block31: {
                object = new AttributesImpl();
                this.xepoutX = this.parseFloat(attributesImpl.getValue("x-from"));
                this.xepoutY = this.parseFloat(attributesImpl.getValue("y-from"));
                this.xepoutScaleXs.push(new Float(this.xepoutScaleX));
                this.xepoutScaleYs.push(new Float(this.xepoutScaleY));
                this.xepoutScaleX = this.parseFloat(attributesImpl.getValue("scale-x"));
                this.xepoutScaleY = this.parseFloat(attributesImpl.getValue("scale-y"));
                inputStream = uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session);
                try {
                    try {
                        XEPOUTImageHandler xEPOUTImageHandler = new XEPOUTImageHandler(this);
                        xMLReader = XMLReaderFactory.createXMLReader();
                        xMLReader.setContentHandler(xEPOUTImageHandler);
                        inputSource = new InputSource(inputStream);
                        xMLReader.parse(inputSource);
                        this.imageOK = true;
                    }
                    catch (Exception exception) {
                        this.imageOK = false;
                        this.session.error("XEPOUT image. " + exception.toString());
                        Object var19_25 = null;
                        inputStream.close();
                        break block31;
                    }
                    Object var19_24 = null;
                }
                catch (Throwable throwable) {
                    Object var19_26 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            this.xepoutScaleX = ((Float)this.xepoutScaleXs.pop()).floatValue();
            this.xepoutScaleY = ((Float)this.xepoutScaleYs.pop()).floatValue();
            return attributesImpl;
        }
        if (string3 != null) {
            attributesImpl.setValue(n, string3);
        } else {
            if (this.EMBED_IMAGES || string4.equalsIgnoreCase("image/svg") || string4.equalsIgnoreCase("image/svg+xml")) {
                Base64OutputStream base64OutputStream;
                if (string4 == null) {
                    string4 = "application/octet-stream";
                }
                object = new int[]{31, 139};
                inputStream = uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session);
                boolean bl = false;
                try {
                    bl = object[0] == inputStream.read() && object[1] == inputStream.read();
                    base64OutputStream = null;
                }
                catch (Throwable throwable) {
                    Object var21_29 = null;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                inputStream = bl ? (uRLSpec.scheme == 1 ? new GZIPInputStream(uRLSpec.openStream()) : new GZIPInputStream(this.session.config.cache.openStream(uRLSpec, this.session))) : (uRLSpec.scheme == 1 ? uRLSpec.openStream() : this.session.config.cache.openStream(uRLSpec, this.session));
                try {
                    if (string4.equals("image/svg") || string4.equals("image/svg+xml")) {
                        block32: {
                            this.svgScaleY = this.parseFloat(attributesImpl.getValue("scale-y"));
                            this.svgScaleX = this.parseFloat(attributesImpl.getValue("scale-x"));
                            serializer = new Serializer(byteArrayOutputStream, false, true);
                            serializer.setID(string);
                            try {
                                try {
                                    xMLReader = XMLReaderFactory.createXMLReader();
                                    xMLReader.setContentHandler(serializer);
                                    inputSource = new InputSource(inputStream);
                                    xMLReader.parse(inputSource);
                                    this.imageOK = true;
                                }
                                catch (Exception exception) {
                                    this.imageOK = false;
                                    this.session.error("SVG image. " + exception.toString());
                                    Object var23_34 = null;
                                    inputStream.close();
                                    break block32;
                                }
                                Object var23_33 = null;
                            }
                            catch (Throwable throwable) {
                                Object var23_35 = null;
                                inputStream.close();
                                throw throwable;
                            }
                            inputStream.close();
                        }
                        attributesImpl.setValue(n, new String(byteArrayOutputStream.toByteArray()));
                    } else {
                        StringWriter stringWriter = new StringWriter();
                        base64OutputStream = new Base64OutputStream(stringWriter);
                        byte[] byArray = new byte[8192];
                        int n2 = 0;
                        while (true) {
                            if ((n2 = inputStream.read(byArray)) == -1) {
                                ((OutputStream)base64OutputStream).close();
                                attributesImpl.setValue(n, stringWriter.toString());
                                break;
                            }
                            base64OutputStream.write(byArray, 0, n2);
                        }
                    }
                    Object var25_39 = null;
                }
                catch (Throwable throwable) {
                    Object var25_40 = null;
                    inputStream.close();
                    byteArrayOutputStream.close();
                    throw throwable;
                }
                inputStream.close();
                byteArrayOutputStream.close();
            } else {
                attributesImpl.setValue(n, uRLSpec.toString());
            }
            this.imageIndex.put(string, attributesImpl.getValue(n));
        }
        if ((string4.equalsIgnoreCase("image/svg") || string4.equalsIgnoreCase("image/svg+xml")) && this.SVGimage.containsKey(string)) {
            string5 = ((String[])this.SVGimage.get(string))[0];
            attributesImpl.addAttribute(XEPURI, "wunit", "wunit", "CDATA", ((String[])this.SVGimage.get(string))[1]);
            string6 = ((String[])this.SVGimage.get(string))[2];
            attributesImpl.addAttribute(XEPURI, "hunit", "hunit", "CDATA", ((String[])this.SVGimage.get(string))[3]);
        }
        if (attributesImpl.getValue("width") != null) {
            int n3 = attributesImpl.getIndex("width");
            attributesImpl.setValue(n3, string5);
        } else {
            attributesImpl.addAttribute(XEPURI, "width", "width", "CDATA", string5);
        }
        if (attributesImpl.getValue("height") != null) {
            int n4 = attributesImpl.getIndex("height");
            attributesImpl.setValue(n4, string6);
            return attributesImpl;
        }
        attributesImpl.addAttribute(XEPURI, "height", "height", "CDATA", string6);
        return attributesImpl;
    }

    private String[] parseUnits(String string) throws SAXException {
        if (string == null) {
            throw new SVGParseException("Missing either 'height' or 'width' on root element of SVG image ");
        }
        Length length = new Length(string);
        if (length.len == 0.0) {
            throw new SVGParseException("Zero-sized SVG: either 'height' or 'width' on root element of SVG image has value of '0'");
        }
        if (length.base == 3) {
            throw new SVGParseException("Percentages are not supported in dimensions of a top-level 'svg' element");
        }
        if (length.base == 1) {
            throw new SVGParseException("Em units are not supported in dimensions of a top-level 'svg' element");
        }
        if (length.base == 2) {
            throw new SVGParseException("Ex units are not supported in dimensions of a top-level 'svg' element");
        }
        if (length.base == 5) {
            throw new SVGParseException("Unspecified units are not supported in dimensions of a top-level 'svg' element");
        }
        return new String[]{"" + length.len, length.UNIT};
    }

    static {
        optab.put("EMBED_IMAGES", new Short(0));
        optab.put("GENERATE_FIRST_N_PAGES", new Short(1));
        optab.put("BREAK_PAGES", new Short(2));
        optab.put("PAGE_REORDERING", new Short(3));
        optab.put("XFORMS", new Short(4));
        optab.put("HTMLFORMS", new Short(5));
        dims = new java.util.Hashtable();
        dims.put("translate", new String[]{"x", "y"});
        dims.put("transform", new String[]{"e", "f"});
        dims.put("word-spacing", new String[]{"value"});
        dims.put("letter-spacing", new String[]{"value"});
        dims.put("font-stretch", new String[]{"value"});
        dims.put("text", new String[]{"x", "y", "width"});
        dims.put("line", new String[]{"x-from", "x-till", "y-from", "y-till", "thickness"});
        dims.put("image", new String[]{"x-from", "y-from", "scale-x", "scale-y"});
        dims.put("rectangle", new String[]{"x-from", "x-till", "y-from", "y-till"});
        dims.put("clip", new String[]{"x-from", "x-till", "y-from", "y-till"});
        dims.put("polygon", new String[]{"x-from", "y-from"});
        dims.put("point", new String[]{"x-till", "y-till"});
        dims.put("target", new String[]{"x", "y"});
        dims.put("internal-link", new String[]{"x-from", "x-till", "y-from", "y-till"});
        dims.put("external-link", new String[]{"x-from", "x-till", "y-from", "y-till"});
        dims.put("internal-bookmark", new String[]{"x-from", "x-till", "y-from", "y-till"});
        fontStretchAlias = new java.util.Hashtable();
        fontStretchAlias.put("482.0", "ultra-condensed");
        fontStretchAlias.put("579.0", "extra-condensed");
        fontStretchAlias.put("694.0", "condensed");
        fontStretchAlias.put("833.0", "semi-condensed");
        fontStretchAlias.put("1000.0", "normal");
        fontStretchAlias.put("1200.0", "semi-expanded");
        fontStretchAlias.put("1440.0", "expanded");
        fontStretchAlias.put("1728.0", "extra-expanded");
        fontStretchAlias.put("2074.0", "ultra-expanded");
        fontStretchAlias.put("120.0", "wider");
        fontStretchAlias.put("83.3", "narrower");
    }

    private class Field {
        String name;
        String type;
        String value;
        boolean readonly;
        boolean required;
        boolean hidden;
        boolean noexport;
        boolean printable;
        boolean multiselect;
        Hashtable style;
        String calculate;
        String format;
        String keystroke;
        String id;
        String method;
        String action;
        Stack constraint;
        Array option;
        Stack fields = new Stack();
        int i;

        Field(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            this.name = string;
            this.readonly = bl;
            this.required = bl2;
            this.hidden = bl3;
            this.noexport = bl4;
            this.printable = bl5;
            this.style = new Hashtable();
            this.option = new Array();
            this.id = Integer.toHexString((int)System.currentTimeMillis());
            this.i = 0;
            this.constraint = new Stack();
        }

        void addConstraint(String string) {
            this.constraint.push(string);
        }

        String constraintToString() {
            String string;
            if (this.constraint.length() > 1) {
                string = "(" + this.constraint.pop() + ")";
                while (!this.constraint.isEmpty()) {
                    string = string + " and (" + this.constraint.pop() + ")";
                }
            } else {
                string = "" + this.constraint.pop();
            }
            return this.writeNormalized(string.toCharArray(), 0, string.length());
        }

        String writeNormalized(char[] cArray, int n, int n2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n + n3];
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        break;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        break;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        break;
                    }
                    case '\'': {
                        stringBuffer.append("&apos;");
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("&#xA;");
                        break;
                    }
                    case '\t': {
                        stringBuffer.append("&#x9;");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n3;
            }
            return stringBuffer.toString();
        }

        void setType(String string) {
            this.type = string;
        }

        void setProperty(String string, String string2) {
            this.style.put(string, string2);
        }

        void addOption(String string, String string2) {
            this.option.put(this.i, new String[]{string, string2});
            ++this.i;
        }

        void setValue(String string) {
            this.value = string;
        }

        void setSelection(String string) {
            this.multiselect = "true".equals(string) || "yes".equals(string);
        }

        void setFields(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"(), \t\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                this.fields.push(stringTokenizer.nextToken());
            }
        }

        void createSubmissionProp(String string, String string2) {
            this.action = string;
            this.method = string2;
        }

        void setCalculation(String string) {
            this.calculate = string;
        }

        void setFormat(String string) {
            this.format = string;
        }

        void setKeystroke(String string) {
            this.keystroke = string;
        }
    }

    public class Serializer
    implements ContentHandler {
        protected final Writer out;
        private String topURI = null;
        private Hashtable uritab = new Hashtable();
        private Hashtable prefixtab = new Hashtable();
        private boolean hasUTF8 = true;
        private boolean opentag = true;
        private boolean closeOnExit = false;
        private boolean breakpage = false;
        private boolean inlineImage = false;
        private boolean root = true;
        private String id;
        private Stack elementNames = new Stack();
        private int prefIndex = 0;
        private String[] prefixCharacters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        private int indent = 2;

        public Serializer(OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
            OutputStreamWriter outputStreamWriter;
            this.breakpage = bl;
            this.inlineImage = bl2;
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
                this.hasUTF8 = true;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                outputStreamWriter = new OutputStreamWriter(outputStream);
                this.hasUTF8 = false;
            }
            this.out = outputStreamWriter;
        }

        public Serializer(Writer writer, boolean bl, boolean bl2) {
            this.out = writer;
            this.breakpage = bl;
            this.inlineImage = bl2;
        }

        protected void setID(String string) {
            this.id = string;
        }

        protected void closeTag() throws IOException {
            if (this.opentag) {
                this.out.write(">");
                this.opentag = false;
            }
            this.out.flush();
        }

        public void startDocument() throws SAXException {
            this.opentag = false;
            this.elementNames.clear();
            this.topURI = null;
            if (this.breakpage) {
                try {
                    this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    this.out.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n");
                    this.out.write("<html xmlns=\"http://www.w3.org/1999/xhtml\" ");
                    if (H4HTML.this.XFORMS) {
                        this.out.write("xmlns:xf=\"http://www.w3.org/2002/xforms\" \n\txmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\txmlns:ev=\"http://www.w3.org/2001/xml-events\" ");
                    }
                    this.out.write("xml:lang=\"en\" lang=\"en\">\n");
                    this.out.write("\t<head>\n");
                    this.out.write("\t\t<link rel=\"stylesheet\" href=\"index.css\" type=\"text/css\"/>\n");
                    this.out.write("\t\t<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\" />\n");
                    this.out.write("\t</head>\n");
                    this.out.write("\t<body>");
                    this.out.flush();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }

        public void endDocument() throws SAXException {
            try {
                this.closeTag();
                this.out.flush();
                if (this.breakpage) {
                    this.out.write("\n\t</body>");
                    this.out.write("\n</html>");
                    this.out.flush();
                }
                if (this.closeOnExit) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            try {
                this.closeTag();
                this.out.write("<?");
                this.out.write(string);
                if (string2 != null && string2.length() > 0) {
                    this.out.write(32);
                    this.out.write(string2);
                }
                this.out.write("?>");
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            try {
                this.closeTag();
                this.writePCDATA(cArray, n, n2);
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.characters(cArray, n, n2);
        }

        public void skippedEntity(String string) {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startComment(String string) throws SAXException {
            try {
                this.closeTag();
                this.out.write("<!--" + string + ">");
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void endComment(String string) throws SAXException {
            try {
                this.closeTag();
                this.out.write("<" + string + "-->");
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Object object;
            Object object2;
            String string4;
            if (string2.equalsIgnoreCase("svg") && this.inlineImage && this.root) {
                String string5;
                if (!H4HTML.SVGURI.equalsIgnoreCase(string)) {
                    throw new SAXException("Root element in an SVG image is not in the SVG namespace (http://www.w3.org/2000/svg)");
                }
                if (!"svg".equalsIgnoreCase(string2)) {
                    throw new SAXException("Root element is not 'svg' in SVG image ");
                }
                String string6 = "0";
                string4 = "0";
                try {
                    String[] stringArray = H4HTML.this.parseUnits(attributes.getValue("", "width"));
                    object2 = H4HTML.this.parseUnits(attributes.getValue("", "height"));
                    string6 = stringArray[0];
                    object = stringArray[1];
                    string4 = object2[0];
                    string5 = object2[1];
                }
                catch (SVGParseException sVGParseException) {
                    throw new SAXException(sVGParseException);
                }
                H4HTML.this.SVGimage.put(this.id, new String[]{"" + H4HTML.this.parseFloat(string6) * 1000.0f, object, "" + H4HTML.this.parseFloat(string4) * 1000.0f, string5});
                this.root = false;
            }
            this.ignorableWhitespace("\n".toCharArray(), 0, 1);
            int n = 0;
            while (n < this.indent) {
                this.ignorableWhitespace("\t".toCharArray(), 0, 1);
                ++n;
            }
            ++this.indent;
            object2 = null;
            if (string2 != null) {
                if (string == null || string.length() == 0) {
                    string3 = string2;
                } else {
                    object2 = (String[])this.uritab.get(string);
                    if (object2 == null) {
                        object2 = string.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : this.assignPrefix(string, string3);
                    }
                    string3 = (String)object2 + ":" + string2;
                }
            }
            this.elementNames.push(string3);
            try {
                this.closeTag();
                this.out.write("<");
                this.writeMarkupElement(string3);
                if (string2 != null && string != null && string.length() != 0 && !string.equals("http://www.w3.org/XML/1998/namespace") && !string.equals(this.topURI)) {
                    this.out.write(" xmlns:");
                    this.writeMarkupElement((String)object2);
                    this.out.write("=\"");
                    this.writeMarkupElement(string);
                    this.out.write("\"");
                    if (this.topURI == null) {
                        this.topURI = string;
                    }
                }
                if (attributes != null) {
                    object = new Hashtable();
                    int n2 = attributes.getLength();
                    int n3 = 0;
                    while (n3 < n2) {
                        string4 = attributes.getLocalName(n3);
                        String string7 = attributes.getURI(n3);
                        String string8 = attributes.getQName(n3);
                        if (string4 != null) {
                            if (string7 == null || string7.length() == 0) {
                                string8 = string4;
                            } else {
                                object2 = (String)this.uritab.get(string7);
                                if (object2 == null) {
                                    object2 = string7.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : this.assignPrefix(string7, string8);
                                }
                                string8 = (String)object2 + ":" + string4;
                                if (!(((Hashtable)object).containsKey(string7) || string7.equals(string) || string7.equals(this.topURI) || string7.equals("http://www.w3.org/XML/1998/namespace"))) {
                                    this.out.write(" xmlns:");
                                    this.writeMarkupElement((String)object2);
                                    this.out.write("=\"");
                                    this.writeMarkupElement(string7);
                                    this.out.write("\"");
                                    ((Hashtable)object).put(string7, object2);
                                }
                            }
                        }
                        this.out.write(" ");
                        this.writeMarkupElement(string8);
                        this.out.write("=\"");
                        this.writeMarkupElement(attributes.getValue(n3));
                        this.out.write("\"");
                        ++n3;
                    }
                }
                this.opentag = true;
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            --this.indent;
            if (!string2.equals("value") && !string2.equals("label")) {
                this.ignorableWhitespace("\n".toCharArray(), 0, 1);
                int n = 0;
                while (n < this.indent) {
                    this.ignorableWhitespace("\t".toCharArray(), 0, 1);
                    ++n;
                }
            }
            String string4 = (String)this.elementNames.pop();
            if (string2 != null) {
                if (string == null || string.length() == 0) {
                    string3 = string2;
                } else {
                    String string5 = (String)this.uritab.get(string);
                    if (string5 == null) {
                        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
                            string5 = "xml";
                        } else {
                            throw new SAXException("Namespace '" + string + "' first mentioned on the closing tag '" + string2 + "'");
                        }
                    }
                    string3 = string5 + ":" + string2;
                }
            }
            if (!string3.equals(string4)) {
                throw new SAXException("Open tag '" + string4 + "' does not match closing tag '" + string3 + "'");
            }
            try {
                if (this.opentag) {
                    this.out.write("/>");
                    this.opentag = false;
                } else {
                    this.out.write("</");
                    this.writeMarkupElement(string4);
                    this.out.write(">");
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }

        protected void writeNormalized(char[] cArray, int n, int n2, boolean bl) throws IOException {
            int n3 = 0;
            while (n3 < n2) {
                char c = cArray[n + n3];
                switch (c) {
                    case '<': {
                        this.out.write("&lt;");
                        break;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        break;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        break;
                    }
                    case '\"': {
                        if (bl) {
                            this.out.write("&quot;");
                            break;
                        }
                    }
                    case '\'': {
                        if (bl) {
                            this.out.write("&apos;");
                            break;
                        }
                    }
                    case '\n': {
                        if (bl) {
                            this.out.write("&#xA;");
                            break;
                        }
                    }
                    case '\t': {
                        if (bl) {
                            this.out.write("&#x9;");
                            break;
                        }
                    }
                    default: {
                        if (!(this.hasUTF8 || c <= '\u007f' && c >= '\u0000')) {
                            this.out.write("&#" + c + ";");
                            break;
                        }
                        this.out.write(c);
                    }
                }
                ++n3;
            }
            this.out.flush();
        }

        protected void writeMarkupElement(String string) throws IOException {
            this.writeNormalized(string.toCharArray(), 0, string.length(), true);
        }

        protected void writePCDATA(char[] cArray, int n, int n2) throws IOException {
            this.writeNormalized(cArray, n, n2, false);
        }

        protected String assignPrefix(String string, String string2) throws SAXException {
            String string3 = null;
            if (string2 != null && string2.indexOf(58) != -1 && this.prefixtab.containsKey(string3 = string2.substring(0, string2.indexOf(58)))) {
                string3 = null;
            }
            if (string3 == null) {
                int n = this.prefixCharacters.length;
                while (this.prefIndex < Integer.MAX_VALUE) {
                    int n2 = ++this.prefIndex;
                    string3 = "";
                    while (n2 != 0) {
                        int n3 = n2 % n;
                        n2 = (n2 - n3) / n;
                        string3 = string3 + this.prefixCharacters[n3];
                    }
                    if (!string3.equals("xml") && !this.prefixtab.containsKey(string3)) break;
                }
                if (this.prefIndex == Integer.MAX_VALUE) {
                    throw new SAXException("Cannot assign more than 2147483645 different prefixes");
                }
            }
            this.uritab.put(string, string3);
            this.prefixtab.put(string3, string);
            return string3;
        }
    }

    public class Lexer {
        public static final String blanks = " \t\r\n\f";
        public static final String token_delimiters = " \t\r\n\f'\"+()[]{},/:;";
        public static final String single_chars = "()[]{},/:;";
        public static final String quotes = "'\"";
        public static final String digits = "0123456789";
        public static final String hexdigits = "0123456789ABCDEFabcdef";
        private char[] data = null;
        private int length = 0;
        private int cursor = 0;

        public Lexer() {
        }

        public Lexer(String string) {
            this();
            this.setSource(string);
        }

        public Lexer(char[] cArray) {
            this();
            this.setSource(cArray);
        }

        public void setSource(String string) {
            this.setSource(string.toCharArray());
        }

        public void setSource(char[] cArray) {
            this.setSource(cArray, 0, cArray.length);
        }

        public void setSource(char[] cArray, int n, int n2) {
            this.data = cArray;
            this.cursor = n;
            this.length = n + n2;
        }

        private void skip_whitespace() {
            while (this.cursor < this.length) {
                if (blanks.indexOf(this.data[this.cursor]) == -1) break;
                ++this.cursor;
            }
        }

        public int nextToken(Token token) throws SVGParseException {
            token.reset();
            this.skip_whitespace();
            if (this.cursor >= this.length) {
                token.type = 1;
                return 1;
            }
            if (single_chars.indexOf(this.data[this.cursor]) != -1) {
                switch (this.data[this.cursor++]) {
                    case '(': {
                        token.type = 2;
                        return 2;
                    }
                    case ')': {
                        token.type = 3;
                        return 3;
                    }
                    case '[': {
                        token.type = 4;
                        return 4;
                    }
                    case ']': {
                        token.type = 5;
                        return 5;
                    }
                    case '{': {
                        token.type = 6;
                        return 6;
                    }
                    case '}': {
                        token.type = 7;
                        return 7;
                    }
                    case ',': {
                        token.type = 8;
                        return 8;
                    }
                    case '/': {
                        token.type = 9;
                        return 9;
                    }
                    case ':': {
                        token.type = 10;
                        return 10;
                    }
                    case ';': {
                        token.type = 11;
                        return 11;
                    }
                }
                throw new SVGParseException("Internal error: unrecognized separator character");
            }
            if (quotes.indexOf(this.data[this.cursor]) != -1) {
                char c = this.data[this.cursor];
                int n = ++this.cursor;
                do {
                    if (this.cursor != this.length) continue;
                    throw new SVGParseException("Unterminated quoted string");
                } while (this.data[this.cursor++] != c);
                token.stringValue = new String(this.data, n, this.cursor - n - 1);
                token.type = 14;
                return 14;
            }
            int n = this.cursor++;
            while (this.cursor < this.length) {
                if (token_delimiters.indexOf(this.data[this.cursor]) != -1) break;
                ++this.cursor;
            }
            if (this.data[n] == '#') {
                if (this.cursor - n == 7 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1 && hexdigits.indexOf(this.data[n + 4]) != -1 && hexdigits.indexOf(this.data[n + 5]) != -1 && hexdigits.indexOf(this.data[n + 6]) != -1) {
                    int n2 = Integer.parseInt(new String(this.data, n + 1, 2), 16);
                    int n3 = Integer.parseInt(new String(this.data, n + 3, 2), 16);
                    int n4 = Integer.parseInt(new String(this.data, n + 5, 2), 16);
                    token.numValue = (n2 << 16) + (n3 << 8) + n4;
                    token.type = 12;
                    return 12;
                }
                if (this.cursor - n == 4 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1) {
                    int n5 = Integer.parseInt(new String(this.data, n + 1, 1), 16) * 17;
                    int n6 = Integer.parseInt(new String(this.data, n + 2, 1), 16) * 17;
                    int n7 = Integer.parseInt(new String(this.data, n + 3, 1), 16) * 17;
                    token.numValue = (n5 << 16) + (n6 << 8) + n7;
                    token.type = 12;
                    return 12;
                }
            }
            int n8 = n;
            int n9 = 1;
            if (this.data[n8] == '-') {
                ++n8;
                n9 = -1;
            } else if (this.data[n8] == '+') {
                ++n8;
            }
            if (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1 || n8 < this.cursor - 1 && this.data[n8] == '.' && digits.indexOf(this.data[n8 + 1]) != -1) {
                int n10;
                boolean bl = false;
                double d = 1.0;
                token.numValue = 0.0;
                while (n8 < this.cursor) {
                    if (digits.indexOf(this.data[n8]) != -1) {
                        n10 = this.data[n8] - 48;
                        if (bl) {
                            token.numValue += (d /= 10.0) * (double)n10;
                        } else {
                            token.numValue *= 10.0;
                            token.numValue += (double)n10;
                        }
                    } else {
                        if (this.data[n8] != '.' || bl) break;
                        bl = true;
                    }
                    ++n8;
                }
                token.numValue *= (double)n9;
                if (n8 < this.cursor && (this.data[n8] == 'e' || this.data[n8] == 'E') && (n8 < this.cursor - 1 && digits.indexOf(this.data[n8 + 1]) != -1 || n8 < this.cursor - 2 && (this.data[n8 + 1] == '+' || this.data[n8 + 1] == '-') && digits.indexOf(this.data[n8 + 2]) != -1)) {
                    n10 = 1;
                    if (this.data[++n8] == '-') {
                        ++n8;
                        n10 = -1;
                    } else if (this.data[n8] == '+') {
                        ++n8;
                    }
                    int n11 = 0;
                    while (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1) {
                        n11 = (int)((double)n11 * 10.0);
                        n11 += this.data[n8] - 48;
                        ++n8;
                    }
                    token.numValue *= Math.pow(10.0, n11 *= n10);
                }
                if (n8 != this.cursor) {
                    token.stringValue = new String(this.data, n8, this.cursor - n8);
                }
                token.type = 15;
                return 15;
            }
            token.stringValue = new String(this.data, n, this.cursor - n);
            token.type = 13;
            return 13;
        }

        public Token getSingleToken(String string) throws SVGParseException {
            Lexer lexer = new Lexer(string);
            Token token = new Token();
            if (lexer.nextToken(token) == 1) {
                throw new SVGParseException("No meaningful data");
            }
            Token token2 = new Token();
            if (lexer.nextToken(token2) != 1) {
                throw new SVGParseException("Extra tokens in \"" + string.trim() + "\"");
            }
            return token;
        }
    }

    public class Token {
        public static final int INVALID_TYPE = Integer.MIN_VALUE;
        public static final int END_OF_DATA = 1;
        public static final int LEFT_PARENTHESIS = 2;
        public static final int RIGHT_PARENTHESIS = 3;
        public static final int LEFT_BRACKET = 4;
        public static final int RIGHT_BRACKET = 5;
        public static final int LEFT_BRACE = 6;
        public static final int RIGHT_BRACE = 7;
        public static final int COMMA = 8;
        public static final int SLASH = 9;
        public static final int COLON = 10;
        public static final int SEMICOLON = 11;
        public static final int COLOR = 12;
        public static final int STRING = 13;
        public static final int QUOTED_STRING = 14;
        public static final int QUANTITY = 15;
        public int type = Integer.MIN_VALUE;
        public double numValue = Double.MIN_VALUE;
        public String stringValue = null;

        public Token() {
        }

        public Token(int n) {
            this.type = n;
        }

        public String getTypeName() {
            switch (this.type) {
                case -2147483648: {
                    return "<INVALID TYPE>";
                }
                case 1: {
                    return "<END OF DATA>";
                }
                case 3: {
                    return "RIGHT PARENTHESIS";
                }
                case 2: {
                    return "LEFT PARENTHESIS";
                }
                case 5: {
                    return "RIGHT BRACKET";
                }
                case 4: {
                    return "LEFT BRACKET";
                }
                case 7: {
                    return "RIGHT BRACE";
                }
                case 6: {
                    return "LEFT BRACE";
                }
                case 8: {
                    return "COMMA";
                }
                case 9: {
                    return "SLASH";
                }
                case 10: {
                    return "COLON";
                }
                case 11: {
                    return "SEMICOLON";
                }
                case 12: {
                    return "COLOR";
                }
                case 13: {
                    return "STRING";
                }
                case 14: {
                    return "QUOTED STRING";
                }
                case 15: {
                    return "QUANTITY";
                }
            }
            return "<BAD TOKEN TYPE - INTERNAL ERROR>";
        }

        public void dump(PrintStream printStream) {
            printStream.print(this.getTypeName());
            switch (this.type) {
                case 13: 
                case 14: {
                    printStream.print(": \"" + this.stringValue + "\"");
                    break;
                }
                case 12: {
                    printStream.print(": #" + Long.toHexString(Math.round(this.numValue)));
                    break;
                }
                case 15: {
                    printStream.print(": " + this.numValue + (this.stringValue == null ? "" : this.stringValue));
                }
            }
            printStream.println();
        }

        public void reset() {
            this.numValue = Double.MIN_VALUE;
            this.stringValue = null;
        }
    }

    public class Length {
        public static final int ABSOLUTE = 0;
        public static final int RELATIVE_EM = 1;
        public static final int RELATIVE_EX = 2;
        public static final int RELATIVE_PERCENTS = 3;
        public static final int RELATIVE_PC = 4;
        public static final int UNSPECIFIED = 5;
        public String UNIT;
        public double len = 0.0;
        public int base = 0;

        public Length() {
        }

        public Length(String string) throws SVGParseException {
            this.parse(string);
        }

        public String toString() {
            switch (this.base) {
                case 0: {
                    return String.valueOf(this.len) + "pt";
                }
                case 1: {
                    return String.valueOf(this.len) + "em";
                }
                case 2: {
                    return String.valueOf(this.len) + "ex";
                }
                case 3: {
                    return String.valueOf(this.len * 100.0) + "%";
                }
                case 4: {
                    return String.valueOf(this.len) + "pc";
                }
                case 5: {
                    return String.valueOf(this.len) + "";
                }
            }
            return "<ERROR! INCORRECT BASE FOR LENGTH>";
        }

        public String getTypeName() {
            return "Length";
        }

        public void create(Token token) throws SVGParseException {
            if (token.type == 15) {
                this.len = token.numValue;
                this.UNIT = token.stringValue;
                if (token.stringValue == null) {
                    this.base = 5;
                } else if (token.stringValue.equals("em")) {
                    this.base = 1;
                } else if (token.stringValue.equals("ex")) {
                    this.base = 2;
                } else if (token.stringValue.equals("%")) {
                    this.base = 3;
                    this.len /= 100.0;
                } else if (token.stringValue.equals("pc")) {
                    this.base = 4;
                }
            } else {
                throw new SVGParseException("Data type mismatch: found " + token.getTypeName() + " where length is expected");
            }
        }

        public void parse(String string) throws SVGParseException {
            Lexer lexer = new Lexer();
            this.create(lexer.getSingleToken(string));
        }
    }

    public class XHTMLIOException
    extends RuntimeException {
        public XHTMLIOException() {
        }

        public XHTMLIOException(Exception exception) {
            super(exception.toString());
        }

        public XHTMLIOException(String string) {
            super(string);
        }
    }

    public class SVGParseException
    extends SAXException {
        public SVGParseException() {
            super("");
        }

        public SVGParseException(String string) {
            super(string);
        }
    }

    public class XEPOUTImageParseException
    extends SAXException {
        public XEPOUTImageParseException() {
            super("");
        }

        public XEPOUTImageParseException(String string) {
            super(string);
        }
    }

    public class XEPOUTImageHandler
    implements ContentHandler {
        private ContentHandler ch = null;
        private int page = 1;
        private float xepX = 0.0f;
        private float xepY = 0.0f;
        private float parentTranslateX = 0.0f;
        private float parentTranslateY = 0.0f;
        private float parentPageH = 0.0f;
        private float parentClipX = 0.0f;
        private float parentClipY = 0.0f;
        private float parentScaleX = 0.0f;
        private float parentScaleY = 0.0f;

        public XEPOUTImageHandler(ContentHandler contentHandler) {
            this.ch = contentHandler;
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void skippedEntity(String string) {
        }

        public void startPrefixMapping(String string, String string2) {
        }

        public void endPrefixMapping(String string) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            AttributesImpl attributesImpl = new AttributesImpl();
            if (!string.equalsIgnoreCase(H4HTML.XEPURI)) {
                throw new SAXException("Element in an XEPOUT image is not in the XEP namespace (http://www.renderx.com/XEP/xep)");
            }
            if (string2.equalsIgnoreCase("document")) {
                return;
            }
            if (this.page > 1) {
                return;
            }
            float f = 0.0f;
            float f2 = 0.0f;
            if (string2.equalsIgnoreCase("page")) {
                if (attributes.getValue("height") == null) {
                    throw new XEPOUTImageParseException("Attribute 'height' is null.");
                }
                f = H4HTML.this.parseFloat(attributes.getValue("height"));
                if (attributes.getValue("width") == null) {
                    throw new XEPOUTImageParseException("Attribute 'width' is null.");
                }
                f2 = H4HTML.this.parseFloat(attributes.getValue("width"));
                this.parentTranslateX = H4HTML.this.translateX;
                this.parentTranslateY = H4HTML.this.translateY;
                this.parentClipX = H4HTML.this.clipX;
                this.parentClipY = H4HTML.this.clipY;
                this.parentPageH = H4HTML.this.currentH;
                if (this.ch != null) {
                    attributesImpl.addAttribute("", "x", "x", "CDATA", "" + H4HTML.this.xepoutX);
                    attributesImpl.addAttribute("", "y", "y", "CDATA", "" + H4HTML.this.xepoutY);
                    this.ch.startElement(H4HTML.XEPURI, "translate", "http://www.renderx.com/XEP/xep:translate", attributesImpl);
                    this.ch.endElement(H4HTML.XEPURI, "translate", "http://www.renderx.com/XEP/xep:translate");
                    attributesImpl.clear();
                    attributesImpl.addAttribute("", "x-from", "x-from", "CDATA", "0");
                    attributesImpl.addAttribute("", "x-till", "x-till", "CDATA", "" + f2 * H4HTML.this.xepoutScaleX);
                    attributesImpl.addAttribute("", "y-from", "y-from", "CDATA", "0");
                    attributesImpl.addAttribute("", "y-till", "y-till", "CDATA", "" + f * H4HTML.this.xepoutScaleY);
                    this.ch.startElement(H4HTML.XEPURI, "clip", "http://www.renderx.com/XEP/xep:clip", attributesImpl);
                    attributesImpl.clear();
                }
                H4HTML.this.translateX = 0.0f;
                H4HTML.this.translateY = 0.0f;
                H4HTML.this.clipX = 0.0f;
                H4HTML.this.clipY = 0.0f;
                this.xepX = H4HTML.this.xepoutX;
                this.xepY = H4HTML.this.xepoutY;
                H4HTML.this.currentH = f * H4HTML.this.xepoutScaleY / 1000.0f;
                return;
            }
            if (this.ch != null) {
                AttributesImpl attributesImpl2 = new AttributesImpl(attributes);
                if (dims.containsKey(string2)) {
                    String[] stringArray = (String[])dims.get(string2);
                    int n = 0;
                    while (n < stringArray.length) {
                        int n2 = attributesImpl2.getIndex(stringArray[n]);
                        float f3 = 0.0f;
                        if (stringArray[n].startsWith("x") || stringArray[n].endsWith("x") || stringArray[n].endsWith("width") || stringArray[n].endsWith("value") || stringArray[n].equals("a") || stringArray[n].equals("e")) {
                            f3 = H4HTML.this.xepoutScaleX * H4HTML.this.parseFloat(attributesImpl2.getValue(stringArray[n]));
                        } else if (stringArray[n].startsWith("thickness")) {
                            if (H4HTML.this.parseFloat(attributesImpl2.getValue("x-from")) == H4HTML.this.parseFloat(attributesImpl2.getValue("x-till"))) {
                                f3 = H4HTML.this.xepoutScaleX * H4HTML.this.parseFloat(attributesImpl2.getValue(stringArray[n]));
                            } else if (H4HTML.this.parseFloat(attributesImpl2.getValue("y-from")) == H4HTML.this.parseFloat(attributesImpl2.getValue("y-till"))) {
                                f3 = H4HTML.this.xepoutScaleY * H4HTML.this.parseFloat(attributesImpl2.getValue(stringArray[n]));
                            }
                        } else {
                            f3 = H4HTML.this.xepoutScaleY * H4HTML.this.parseFloat(attributesImpl2.getValue(stringArray[n]));
                        }
                        attributesImpl2.setValue(n2, "" + f3);
                        ++n;
                    }
                }
                this.ch.startElement(H4HTML.XEPURI, string2, "http://www.renderx.com/XEP/xep:" + string2, attributesImpl2);
                return;
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (!string.equalsIgnoreCase(H4HTML.XEPURI)) {
                throw new SAXException("Element in an XEPOUT image is not in the XEP namespace (http://www.renderx.com/XEP/xep)");
            }
            if (string2.equalsIgnoreCase("document")) {
                return;
            }
            if (string2.equalsIgnoreCase("page") && this.page <= 1) {
                if (this.ch != null) {
                    this.ch.endElement(H4HTML.XEPURI, "clip", "http://www.renderx.com/XEP/xep:clip");
                }
                H4HTML.this.currentH = this.parentPageH;
                H4HTML.this.translateX = this.parentTranslateX;
                H4HTML.this.translateY = this.parentTranslateY;
                H4HTML.this.clipX = this.parentClipX;
                H4HTML.this.clipY = this.parentClipY;
                ++this.page;
                return;
            }
            if (this.page > 1) {
                return;
            }
            if (this.ch != null) {
                this.ch.endElement(H4HTML.XEPURI, string2, "http://www.renderx.com/XEP/xep:" + string2);
                return;
            }
        }
    }
}

