/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.svg;

import java.io.PrintStream;

class Token {
    public static final int INVALID_TYPE = Integer.MIN_VALUE;
    public static final int END_OF_DATA = 1;
    public static final int LEFT_PARENTHESIS = 2;
    public static final int RIGHT_PARENTHESIS = 3;
    public static final int LEFT_BRACKET = 4;
    public static final int RIGHT_BRACKET = 5;
    public static final int LEFT_BRACE = 6;
    public static final int RIGHT_BRACE = 7;
    public static final int COMMA = 8;
    public static final int SLASH = 9;
    public static final int COLON = 10;
    public static final int SEMICOLON = 11;
    public static final int COLOR = 12;
    public static final int STRING = 13;
    public static final int QUOTED_STRING = 14;
    public static final int QUANTITY = 15;
    public int type = Integer.MIN_VALUE;
    public double numValue = Double.MIN_VALUE;
    public String stringValue = null;

    public Token() {
    }

    public Token(int n) {
        this.type = n;
    }

    public String getTypeName() {
        switch (this.type) {
            case -2147483648: {
                return "<INVALID TYPE>";
            }
            case 1: {
                return "<END OF DATA>";
            }
            case 3: {
                return "RIGHT PARENTHESIS";
            }
            case 2: {
                return "LEFT PARENTHESIS";
            }
            case 5: {
                return "RIGHT BRACKET";
            }
            case 4: {
                return "LEFT BRACKET";
            }
            case 7: {
                return "RIGHT BRACE";
            }
            case 6: {
                return "LEFT BRACE";
            }
            case 8: {
                return "COMMA";
            }
            case 9: {
                return "SLASH";
            }
            case 10: {
                return "COLON";
            }
            case 11: {
                return "SEMICOLON";
            }
            case 12: {
                return "COLOR";
            }
            case 13: {
                return "STRING";
            }
            case 14: {
                return "QUOTED STRING";
            }
            case 15: {
                return "QUANTITY";
            }
        }
        return "<BAD TOKEN TYPE - INTERNAL ERROR>";
    }

    public void dump(PrintStream printStream) {
        printStream.print(this.getTypeName());
        switch (this.type) {
            case 13: 
            case 14: {
                printStream.print(": \"" + this.stringValue + "\"");
                break;
            }
            case 12: {
                printStream.print(": #" + Long.toHexString(Math.round(this.numValue)));
                break;
            }
            case 15: {
                printStream.print(": " + this.numValue + (this.stringValue == null ? "" : this.stringValue));
            }
        }
        printStream.println();
    }

    public void reset() {
        this.numValue = Double.MIN_VALUE;
        this.stringValue = null;
    }
}

