/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.fonts.FontCatalog;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import java.io.IOException;
import java.io.InputStream;

public abstract class Image {
    public URLSpec source = null;
    public String mimetype = null;
    public double width = 0.0;
    public double height = 0.0;
    public long lastModified = 0L;
    protected int hasbeenseen = 0;
    protected ImageFactory factory;
    public static final String PAGE_NUMBER_EXTENSION_STRING = "?rx:page-number=";
    public static final int DEFAULT_IMAGE_PAGE_NUMBER = -1;
    protected int page = 0;

    public ImageFactory getFactory() {
        return this.factory;
    }

    public abstract void parse() throws IOException, ImageFormatException;

    public int getCountPages() {
        return 0;
    }

    public String toString() {
        return this.getClass().getName() + ":" + "source='" + this.source + "'" + "," + "mimetype='" + this.mimetype + "'" + "," + "width=" + this.width + " pt" + "," + "height=" + this.height + " pt";
    }

    public String toDisplayString() {
        if (this.source == null) {
            return "[null]";
        }
        if (this.source.scheme == 1) {
            return "[instream]";
        }
        return this.source.toString();
    }

    public InputStream openImageStream() throws IOException {
        return this.factory.openStream(this.source == null ? this.factory.getSource(this) : this.source);
    }

    public SeekableInput openSeekableImageStream() throws IOException {
        this.source = this.source == null ? this.factory.getSource(this) : this.source;
        String string = this.source.toString();
        int n = string.indexOf(PAGE_NUMBER_EXTENSION_STRING);
        if (n != -1) {
            this.page = Integer.parseInt(string.substring(n + PAGE_NUMBER_EXTENSION_STRING.length()));
        }
        return this.factory.openSeekableStream(n == -1 ? this.source : new URLSpec(string.substring(0, n)));
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 1) {
            System.err.println("Usage: com.renderx.graphics.Image <image handler class> {<image file name>}");
            return;
        }
        int n = 1;
        while (n != stringArray.length) {
            try {
                Image image = (Image)Class.forName(stringArray[0]).newInstance();
                DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
                URLCache uRLCache = new URLCache(defaultErrorHandler);
                image.factory = new ImageFactory(new FontCatalog(uRLCache, defaultErrorHandler), uRLCache, defaultErrorHandler);
                image.source = new URLSpec(stringArray[n]);
                image.parse();
            }
            catch (Exception exception) {
                System.err.println(exception);
                exception.printStackTrace(System.err);
            }
            ++n;
        }
    }
}

