/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts.afp;

import com.renderx.fonts.afp.FontIndexData;
import com.renderx.fonts.afp.FontPositionData;
import com.renderx.fonts.afp.FontResourceObject;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class FontOrientationData {
    private byte[] characterRotation;
    private byte[] maxBaselineOffset;
    private byte[] maxCharacterIncrement;
    private byte[] spaceCharacterIncrement;
    private byte[] maxBaselineExtent;
    private byte controlFlags;
    private byte[] emSpaceIncrement;
    private byte[] figureSpace;
    private byte[] nominalCharacterIncrement;
    private byte[] defaultBaselineIncrement;
    private byte[] minimumASpace;
    private FontPositionData fontPositionData;
    private ArrayList fontIndex;

    public byte[] getCharacterRotation() {
        return this.characterRotation;
    }

    public byte[] getMaxBaselineOffset() {
        return this.maxBaselineOffset;
    }

    public byte[] getMaxCharacterIncrement() {
        return this.maxCharacterIncrement;
    }

    public byte[] getSpaceCharacterIncrement() {
        return this.spaceCharacterIncrement;
    }

    public byte[] getMaxBaselineExtent() {
        return this.maxBaselineExtent;
    }

    public byte getControlFlags() {
        return this.controlFlags;
    }

    public byte[] getEmSpaceIncrement() {
        return this.emSpaceIncrement;
    }

    public byte[] getFigureSpace() {
        return this.figureSpace;
    }

    public byte[] getNominalCharacterIncrement() {
        return this.nominalCharacterIncrement;
    }

    public byte[] getDefaultBaselineIncrement() {
        return this.defaultBaselineIncrement;
    }

    public byte[] getMinimumASpace() {
        return this.minimumASpace;
    }

    public FontPositionData getFontPositionData() {
        return this.fontPositionData;
    }

    public ArrayList getFontIndex() {
        return this.fontIndex;
    }

    public Short parse(byte[] byArray) {
        this.characterRotation = new byte[2];
        this.maxBaselineOffset = new byte[2];
        this.maxCharacterIncrement = new byte[2];
        this.spaceCharacterIncrement = new byte[2];
        this.maxBaselineExtent = new byte[2];
        this.emSpaceIncrement = new byte[2];
        this.figureSpace = new byte[2];
        this.nominalCharacterIncrement = new byte[2];
        this.defaultBaselineIncrement = new byte[2];
        this.minimumASpace = new byte[2];
        int n = 0;
        while (n < byArray.length) {
            if (n > 1 && n != 13 && (n < 16 || n > 17)) {
                if (n <= 3) {
                    this.characterRotation[n - 2] = byArray[n];
                } else if (n <= 5) {
                    this.maxBaselineOffset[n - 4] = byArray[n];
                } else if (n <= 7) {
                    this.maxCharacterIncrement[n - 6] = byArray[n];
                } else if (n <= 9) {
                    this.spaceCharacterIncrement[n - 8] = byArray[n];
                } else if (n <= 11) {
                    this.maxBaselineExtent[n - 10] = byArray[n];
                } else if (n == 12) {
                    this.controlFlags = byArray[n];
                } else if (n <= 15) {
                    this.emSpaceIncrement[n - 14] = byArray[n];
                } else if (n <= 19) {
                    this.figureSpace[n - 18] = byArray[n];
                } else if (n <= 21) {
                    this.nominalCharacterIncrement[n - 20] = byArray[n];
                } else if (n <= 23) {
                    this.defaultBaselineIncrement[n - 22] = byArray[n];
                } else if (n <= 25) {
                    this.minimumASpace[n - 24] = byArray[n];
                }
            }
            ++n;
        }
        int n2 = FontResourceObject.bytesToUnsignInt(new byte[]{this.characterRotation[0]}) * 2;
        return new Short((short)n2);
    }

    public void parseFontPosition(byte[] byArray) {
        this.fontPositionData = new FontPositionData();
        this.fontPositionData.parse(byArray);
    }

    public void parseFontIndex(byte[] byArray, byte by, String string) throws UnsupportedEncodingException {
        byte[] byArray2 = new byte[by];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n2 - by * n;
            byArray2[n3] = byArray[n2];
            if (n3 == by - 1) {
                FontIndexData fontIndexData = new FontIndexData();
                fontIndexData.parse(byArray2, string);
                if (this.fontIndex == null) {
                    this.fontIndex = new ArrayList();
                }
                this.fontIndex.add(fontIndexData);
                byArray2 = new byte[by];
                ++n;
            }
            ++n2;
        }
        byArray2 = null;
    }
}

