package com.renderx.xepx.x4u.as;

import java.io.*;
import javax.swing.*;

class FileChooser extends JFileChooser {
	FileChooser(String currentFile, String[] types) 
	{
		super();
		String currentDirectory = new java.io.File(currentFile).getParent();
		if(currentDirectory == null) currentDirectory = "";
		setCurrentDirectory(new java.io.File(currentDirectory));
		addChoosableFileFilter(new FileFilter(types));
	}
	
	static class FileFilter extends javax.swing.filechooser.FileFilter {
		String[] types;
		FileFilter(String[] str) {
			types = str;
		}

		public boolean accept (File f) {
			if (f==null) return false;
			if (f.isDirectory()) return true;
			if(types == null) return true;
			int dot=f.getName().lastIndexOf(".");
			if (dot==-1) return false; 
			String ext=f.getName().substring(dot+1);
			
			for (int i=0; i<types.length; i++) {
				if (ext.equalsIgnoreCase(types[i]))
					return true;
			}
			
			return false;
		}

		public String getDescription() {
			String description = "";
			if(types == null) return "All files(*.*)";
			
			for(int i=0; i< types.length; i++)
				description+=(i>0?"/":"")+types[i].toUpperCase();
			description+=" Files (";
			for(int i=0; i< types.length; i++)
				description+="*."+types[i].toLowerCase()+"; ";
			description+=")";
			return description;
		}
	}
}
