/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre;

import com.renderx.util.Hashtable;
import com.renderx.util.URLSpec;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeSieve;
import com.renderx.xep.pre.Bidi;
import com.renderx.xep.pre.BidiResolver;
import com.renderx.xep.pre.BorderComparator;
import com.renderx.xep.pre.CompilerException;
import com.renderx.xep.pre.Elem;
import com.renderx.xep.pre.ElementHandler;
import com.renderx.xep.pre.PIHandler;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

public class FOHandler
implements ContentHandler {
    private final Session session;
    private final ElementHandler handler;
    private final URLSpec baseURL;
    private final BidiResolver bidiFilter;
    private final AttributeSieve sieve = new AttributeSieve();
    private Locator locator = null;
    private ParserContext context = null;
    private int skipcount = 0;
    private int listid = 0;
    private int tableid = 0;

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    FOHandler(String string, ElementHandler elementHandler, Session session) {
        this.session = session;
        URLSpec uRLSpec = null;
        if (string != null && string.trim().length() != 0) {
            String string2 = string.trim();
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(0, n + 1);
            }
            try {
                uRLSpec = new URLSpec(uRLSpec, string2);
            }
            catch (Exception exception) {
                throw new RuntimeException("System ID '" + string + "' cannot be used as base URL: " + exception);
            }
        }
        this.session.warning("Null System ID: relative URLs may not work properly");
        try {
            uRLSpec = new URLSpec(null, "file:/example.com/missing/SystemId/");
        }
        catch (Exception exception) {
            throw new InternalException("Invalid default System ID: " + exception);
        }
        this.baseURL = uRLSpec;
        if (this.session.config.ENABLE_BIDI) {
            this.bidiFilter = new BidiResolver(elementHandler, session);
            this.handler = this.bidiFilter;
        } else {
            this.bidiFilter = null;
            this.handler = elementHandler;
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void skippedEntity(String string) {
    }

    public void processingInstruction(String string, String string2) {
        if (this.skipcount > 0) {
            return;
        }
        if (this.handler instanceof PIHandler) {
            String string3;
            if (string2 != null && string2.trim().startsWith("url") && (string3 = string2.trim().substring(3).trim()).length() > 2 && string3.charAt(0) == '(' && string3.charAt(string3.length() - 1) == ')') {
                if ((string3 = string3.substring(1, string3.length() - 1).trim()).length() > 2 && (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'' || string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"')) {
                    string3 = string3.substring(1, string3.length() - 1);
                }
                URLSpec uRLSpec = this.context == null ? this.baseURL : this.context.baseURL;
                try {
                    string2 = "url('" + new URLSpec(uRLSpec, string3).toString() + "')";
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                ((PIHandler)((Object)this.handler)).processingInstruction(string, string2);
            }
            catch (CompilerException compilerException) {
                this.session.warning("Processing instruction ignored: " + compilerException.getMessage());
            }
        }
    }

    public void startDocument() {
        this.skipcount = 0;
        this.listid = 0;
        this.tableid = 0;
        this.bidiFilter.reset();
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Object object;
        if (this.skipcount > 0) {
            ++this.skipcount;
            return;
        }
        if (this.context == null) {
            this.context = new ParserContext(null, this.session);
            this.context.baseURL = this.baseURL;
        } else {
            this.context = this.context.next == null ? new ParserContext(this.context, this.session) : this.context.next;
        }
        Elem.Descriptor descriptor = null;
        try {
            descriptor = Elem.getDescriptor(string2);
            if (descriptor == null) {
                throw new ParserException("Unknown element name: '" + string2 + "'");
            }
            this.context.initialize(descriptor, descriptor.id == 50 ? attributes.getValue("marker-class-name") : null);
            this.sieve.clear();
        }
        catch (ParserException parserException) {
            this.session.warning(parserException.toString());
            this.skipcount = 1;
            return;
        }
        if (descriptor.id == 41) {
            this.context.listid = ++this.listid;
        }
        int n = 0;
        while (n < attributes.getLength()) {
            try {
                String string4 = attributes.getURI(n);
                if (string4 == null || string4.length() == 0 || string4.equals("http://www.w3.org/1999/XSL/Format") || string4.equals("http://www.renderx.com/XSL/Extensions")) {
                    this.sieve.put(attributes.getLocalName(n), attributes.getValue(n));
                } else if (string4.equals("http://www.w3.org/XML/1998/namespace")) {
                    object = attributes.getLocalName(n);
                    if ("base".equals(object)) {
                        String string5 = attributes.getValue(n);
                        try {
                            this.context.baseURL = new URLSpec(this.context.baseURL, string5);
                        }
                        catch (Exception exception) {
                            this.session.warning("Invalid xml:base: cannot convert '" + string5 + "' to an URL: " + exception);
                        }
                    } else if ("lang".equals(object)) {
                        this.sieve.put("xml:lang", attributes.getValue(n));
                    }
                }
            }
            catch (ParserException parserException) {
                this.session.warning("Attribute ignored: " + parserException.getMessage());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 <= 15) {
            object = this.sieve.turns[n2];
            int n3 = this.sieve.turnCounts[n2];
            while (n3-- > 0) {
                try {
                    ((AttributeSieve.NameAndValue)object[n3]).att.process(((AttributeSieve.NameAndValue)object[n3]).value, this.context);
                }
                catch (ParserException parserException) {
                    this.session.warning("Bad attribute " + ((AttributeSieve.NameAndValue)object[n3]).att.name + ": " + parserException.getMessage());
                }
            }
            if (n2 == 1 && descriptor.id == 40) {
                try {
                    this.ComputeCellColumnNumber();
                }
                catch (ParserException parserException) {
                    this.session.warning(parserException.toString());
                    this.skipcount = 1;
                    return;
                }
            }
            ++n2;
        }
        try {
            descriptor.checkRequired(this.context.specified);
        }
        catch (ParserException parserException) {
            this.session.error(parserException.toString());
            this.skipcount = 1;
            return;
        }
        object = (Attr)this.context.specified.get(Attn.$span);
        if (object != null && ((Attr)object).word().equals("all") && (descriptor.id == 20 || descriptor.id == 21 || descriptor.id == 41 || descriptor.id == 34 || descriptor.id == 32)) {
            ParserContext parserContext = this.context.prev;
            while (parserContext != null && parserContext.element.id == 49) {
                parserContext = parserContext.prev;
            }
            if (parserContext != null && parserContext.element.id == 20) {
                parserContext = parserContext.prev;
            }
            if (parserContext == null || parserContext.element.id != 19) {
                this.session.warning("'span' attribute on " + descriptor.name + " ignored because the element is not a direct child of a flow");
            } else {
                this.context.extraFlowSection = true;
                AttList attList = new AttList();
                attList.put(Attn.$column_count, Attr.Count.create(1));
                this.callStartHandler((short)101, attList);
            }
        }
        try {
            switch (descriptor.id) {
                case 51: {
                    this.saveMarkerContext();
                    break;
                }
                case 34: {
                    this.startTable();
                    this.setCollapsePrecedence(6);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("table"));
                    if (this.context.specified.get(Attn.$table_omit_footer_at_break) == null) {
                        this.context.addAttribute(Attn.$table_omit_footer_at_break, Attr.Bool.create(this.session.config.OMIT_FOOTER_AT_BREAK));
                    }
                    this.halfCollapsedBorders();
                    break;
                }
                case 38: {
                    this.setCollapsePrecedence(2);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("body"));
                    this.context.addAttribute(Attn.$body_number, Attr.Count.create(++this.context.prev.bodyNumber));
                    this.startTableRowGroup();
                    this.zeroCollapsedBorders();
                    break;
                }
                case 36: {
                    this.setCollapsePrecedence(1);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("header"));
                    this.context.addAttribute(Attn.$body_number, Attr.header);
                    this.startTableRowGroup();
                    this.zeroCollapsedBorders();
                    break;
                }
                case 37: {
                    this.setCollapsePrecedence(0);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("footer"));
                    this.startTableRowGroup();
                    this.zeroCollapsedBorders();
                    this.context.addAttribute(Attn.$body_number, Attr.footer);
                    break;
                }
                case 35: {
                    this.setCollapsePrecedence(4);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("column"));
                    this.saveTableColumnContext();
                    break;
                }
                case 39: {
                    this.setCollapsePrecedence(3);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("row"));
                    this.startTableRow();
                    break;
                }
                case 40: {
                    this.setCollapsePrecedence(5);
                    this.context.addAttribute(Attn.$table_element_class, Attr.Word.create("cell"));
                    this.startTableCell();
                    this.halfCollapsedBorders();
                }
            }
        }
        catch (ParserException parserException) {
            this.session.info(parserException.toString());
            this.skipcount = 1;
            return;
        }
        if (descriptor.id != 35) {
            this.callStartHandler();
        }
    }

    private void callStartHandler() {
        AttList attList = new AttList();
        this.FillAttributeList(attList, this.context.inherited, this.context.element);
        this.FillAttributeList(attList, this.context.specified, this.context.element);
        if (this.context.element.useWritingMode) {
            attList.put(Attn.$writing_mode, this.context.activeMode.attribute);
        }
        if (this.context.element.usedProps.get(Attn.$direction) != null) {
            attList.put(Attn.$direction, this.context.direction);
        }
        this.callStartHandler(this.context.element.id, attList);
    }

    private void callStartHandler(short s, AttList attList) {
        try {
            this.handler.startElement(s, attList);
        }
        catch (CompilerException compilerException) {
            this.session.error("Error while opening element " + Elem.getDescriptor((short)s).name + ": " + compilerException.toString());
            this.skipcount = 1;
        }
    }

    public void endElement(String string, String string2, String string3) {
        if (this.context == null) {
            throw new InternalException("Context stack underflow");
        }
        if (this.skipcount > 0) {
            if (--this.skipcount == 0) {
                this.context.clear();
                this.context = this.context.prev;
            }
            return;
        }
        if (this.context.extraTableRow) {
            this.callEndHandler((short)39);
        }
        if (this.context.element.id == 38 || this.context.element.id == 36 || this.context.element.id == 37) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.context.busyCells.length()) {
                int n3;
                Integer n4 = (Integer)this.context.busyCells.get(n2);
                if (n4 != null && (n3 = n4.intValue()) > n) {
                    n = n3;
                }
                ++n2;
            }
            while (n-- > 0) {
                this.callStartHandler((short)39, AttList.empty);
                this.callEndHandler((short)39);
                ++this.context.prev.rowNumber;
            }
        }
        if (this.context.element.id != 35) {
            this.callEndHandler();
        }
        if (this.context.extraFlowSection) {
            this.callEndHandler((short)101);
        }
        if (this.context.endsRow) {
            this.callEndHandler((short)39);
            this.context.prev.extraTableRow = false;
            this.context.prev.nextColumn = 1;
        }
        this.context.clear();
        this.context = this.context.prev;
    }

    private void callEndHandler() {
        this.callEndHandler(this.context.element.id);
    }

    private void callEndHandler(short s) {
        try {
            this.handler.endElement(s);
        }
        catch (CompilerException compilerException) {
            this.session.error("Error while closing element " + Elem.getDescriptor((short)s).name + ": " + compilerException.toString());
        }
    }

    private void FillAttributeList(AttList attList, Hashtable hashtable, Elem.Descriptor descriptor) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Attn attn = (Attn)enumeration.nextElement();
            if (descriptor.usedProps.get(attn) == null || (this.context.collapseBorders ? descriptor.id == 34 && (attn == Attn.$border_separation_block_progression_direction || attn == Attn.$border_separation_inline_progression_direction) || !this.context.useCollapsePrecedence && (attn == Attn.$border_before_precedence || attn == Attn.$border_after_precedence || attn == Attn.$border_start_precedence || attn == Attn.$border_end_precedence) : !(descriptor.id != 39 && descriptor.id != 35 && descriptor.id != 38 && descriptor.id != 36 && descriptor.id != 37 || attn != Attn.$border_before_width_length && attn != Attn.$border_after_width_length && attn != Attn.$border_start_width_length && attn != Attn.$border_end_width_length && attn != Attn.$border_before_width_conditionality && attn != Attn.$border_after_width_conditionality && attn != Attn.$border_start_width_conditionality && attn != Attn.$border_end_width_conditionality && attn != Attn.$border_before_color && attn != Attn.$border_after_color && attn != Attn.$border_start_color && attn != Attn.$border_end_color && attn != Attn.$border_before_style && attn != Attn.$border_after_style && attn != Attn.$border_start_style && attn != Attn.$border_end_style))) continue;
            try {
                attList.put(attn, attn.postprocess((Attr)hashtable.get(attn), this.context));
            }
            catch (ParserException parserException) {
                this.session.error("Cannot store attribute " + attn.name + " in attribute list: " + parserException.toString());
            }
        }
    }

    private void FillCharacterAttribute(AttList attList, Attn attn) {
        if (Elem.$pcdata.usedProps.get(attn) == null) {
            return;
        }
        try {
            if (this.context.specified.containsKey(attn)) {
                attList.put(attn, attn.postprocess((Attr)this.context.specified.get(attn), this.context));
            }
        }
        catch (ParserException parserException) {
            this.session.error("Cannot store attribute " + attn.name + " in attribute list: " + parserException.toString());
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        if (this.skipcount > 0) {
            return;
        }
        if (n2 == 0) {
            return;
        }
        if (!this.context.element.enableTextChildren) {
            return;
        }
        AttList attList = new AttList();
        this.FillAttributeList(attList, this.context.inherited, Elem.$pcdata);
        this.FillCharacterAttribute(attList, Attn.$pdf_structure_tag);
        this.FillCharacterAttribute(attList, Attn.$role_mapping);
        this.FillCharacterAttribute(attList, Attn.$pdf_artifact_type);
        this.FillCharacterAttribute(attList, Attn.$pdf_artifact_subtype);
        this.FillCharacterAttribute(attList, Attn.$alt_description);
        this.FillCharacterAttribute(attList, Attn.$actual_text);
        this.FillCharacterAttribute(attList, Attn.$abbreviation);
        if (!this.session.config.ENABLE_BIDI) {
            this.callCharacterHandler(new String(cArray, n, n2), attList);
            return;
        }
        if (this.context.bidiOverride) {
            this.bidiFilter.characters(new String(cArray, n, n2), attList, Bidi.NEUTRAL, this.context);
            return;
        }
        int n3 = n + n2;
        int n4 = n;
        int n5 = n;
        while (n5 < n3 && Bidi.isNeutral(cArray[n5])) {
            ++n5;
        }
        if (n5 > n) {
            this.bidiFilter.characters(new String(cArray, n, n5 - n), attList, Bidi.NEUTRAL, this.context);
            n = n4 = n5;
        }
        while (n < n3) {
            Attr attr = Bidi.classes[cArray[n]] == Bidi.EN ? this.context.direction : Bidi.classes[cArray[n]];
            Attr attr2 = this.resolveBidiClass(attr, cArray, n);
            Attr attr3 = Bidi.NEUTRAL;
            while (n5 < n3 && this.resolveBidiClass(attr2, cArray, n5) == attr2) {
                n4 = n5;
                while (n4 < n3 && this.resolveBidiClass(attr2, cArray, n4) == attr2) {
                    ++n4;
                }
                n5 = n4;
                while (n5 < n3 && Bidi.isNeutral(cArray[n5])) {
                    ++n5;
                }
                attr3 = this.resolveNeutrals(attr2, cArray, n4, n5, n3);
                if (attr3 == Bidi.RIGHTTOLEFT) break;
            }
            if (attr2 == Bidi.EN || attr2 == Bidi.AN) {
                attr2 = Bidi.LEFTTORIGHT;
            }
            if (n4 > n) {
                this.bidiFilter.characters(new String(cArray, n, n4 - n), attList, attr2, this.context);
            }
            if (n5 > n4) {
                this.bidiFilter.characters(new String(cArray, n4, n5 - n4), attList, attr3, this.context);
            }
            n = n4 = n5;
        }
    }

    private void callCharacterHandler(String string, AttList attList) {
        attList.put(Attn.$TEXT, Attr.Word.createUncached(string));
        try {
            this.handler.startElement((short)0, attList);
            this.handler.endElement((short)0);
        }
        catch (CompilerException compilerException) {
            this.session.error("Error while processing text node: " + compilerException);
        }
    }

    private void saveMarkerContext() throws ParserException {
        Attr attr = (Attr)this.context.specified.get(Attn.$retrieve_class_name);
        if (attr == null) {
            throw new ParserException("fo:retrieve-marker element has no retrieve-class-name attribute; element ignored");
        }
        ParserContext parserContext = this.context.prev;
        while (parserContext.element.id != 16) {
            parserContext = parserContext.prev;
            if (parserContext != null) continue;
            throw new ParserException("fo:retrieve-marker element outside fo:page-sequence; element ignored");
        }
        parserContext.markerInfo.put(attr.word(), this.context.clone());
    }

    private void saveTableColumnContext() throws ParserException {
        Attr attr;
        int n;
        int n2;
        ParserContext parserContext = this.context.prev;
        if (parserContext == null) {
            throw new ParserException("Misplaced fo:table-column ignored");
        }
        if (parserContext.element.id != 34) {
            throw new ParserException("Misplaced fo:table-column ignored");
        }
        int n3 = parserContext.nextColumn;
        Attr attr2 = (Attr)this.context.specified.get(Attn.$column_number);
        if (attr2 == null) {
            while (parserContext.tableColumns.get(n3) != null) {
                ++n3;
            }
        } else {
            n3 = attr2.count();
        }
        if (n3 <= 0) {
            throw new ParserException("Invalid column number " + n3 + "; column descriptor ignored");
        }
        Attr attr3 = (Attr)this.context.specified.get(Attn.$number_columns_spanned);
        int n4 = n2 = attr3 == null ? 1 : attr3.count();
        if (n2 <= 0) {
            this.session.warning("Invalid value number-columns-spanned=\"" + n2 + "\"; defaulted to 1");
            n2 = 1;
        }
        int n5 = n = (attr = (Attr)this.context.specified.get(Attn.$number_columns_repeated)) == null ? 1 : attr.count();
        if (n <= 0) {
            this.session.warning("Invalid value number-columns-repeated=\"" + n + "\"; defaulted to 1");
            n = 1;
        }
        this.context.specified.remove(Attn.$number_columns_spanned);
        this.context.specified.remove(Attn.$number_columns_repeated);
        while (n-- > 0) {
            if (parserContext.tableColumns.get(n3) != null) {
                throw new ParserException("Column descriptors repeat or overlap: descriptor ignored");
            }
            this.context.specified.put(Attn.$column_number, Attr.Count.create(n3));
            parserContext.tableColumns.put(n3, new ParserContext.TableColumn(n2, this.context));
            this.context.specified.put(Attn.$column_number, Attr.Count.create(n3));
            this.callStartHandler();
            this.callEndHandler();
            parserContext.nextColumn = n3 += n2;
        }
    }

    private void startTable() throws ParserException {
        Attr attr = (Attr)this.context.inherited.get(Attn.$border_collapse);
        if (attr == null) {
            attr = this.session.config.BORDER_COLLAPSE_SEPARATE ? Attr.Word.create("separate") : Attn.$border_collapse.defaultValue;
        }
        this.context.setCollapsedBorderModel(attr);
        this.context.tableid = ++this.tableid;
        this.context.bodyNumber = 0;
        this.context.specified.put(Attn.$table_identifier, Attr.Count.create(this.context.tableid));
    }

    private void startTableRowGroup() throws ParserException {
        this.context.rowNumber = 0;
        this.context.specified.put(Attn.$table_identifier, Attr.Count.create(this.context.prev.tableid));
    }

    private void startTableRow() throws ParserException {
        ParserContext parserContext = this.context.prev;
        if (parserContext == null) {
            throw new ParserException("Misplaced table row element ignored");
        }
        if (parserContext.extraTableRow) {
            this.callEndHandler((short)39);
            parserContext.nextColumn = 1;
            parserContext.extraTableRow = false;
        }
        parserContext.decreaseBusyCells();
        ++parserContext.rowNumber;
    }

    private void ComputeCellColumnNumber() throws ParserException {
        Attr attr;
        ParserContext parserContext;
        ParserContext parserContext2 = this.context.prev;
        if (parserContext2 == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        ParserContext parserContext3 = parserContext2.element.id == 39 ? parserContext2 : null;
        ParserContext parserContext4 = parserContext = parserContext3 == null ? parserContext2 : parserContext3.prev;
        if (parserContext == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        if (parserContext.busyCells == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        if (parserContext3 == null) {
            boolean bl;
            attr = (Attr)this.context.specified.get(Attn.$starts_row);
            Attr attr2 = (Attr)this.context.specified.get(Attn.$ends_row);
            boolean bl2 = bl = attr != null && attr.bool();
            if (!parserContext.extraTableRow || bl) {
                this.startTableRow();
                this.callStartHandler((short)39, AttList.empty);
                parserContext.extraTableRow = true;
            }
            this.context.endsRow = attr2 != null && attr2.bool();
        }
        this.context.columnNumber = parserContext2.nextColumn;
        attr = (Attr)this.context.specified.get(Attn.$column_number);
        if (attr == null) {
            while (parserContext.busyCells.get(this.context.columnNumber) != null) {
                ++this.context.columnNumber;
            }
        } else {
            this.context.columnNumber = attr.count();
            if (parserContext.busyCells.get(this.context.columnNumber) != null) {
                throw new ParserException("Overlapping cells: cell ignored");
            }
        }
        if (this.context.columnNumber <= 0) {
            throw new ParserException("Invalid column number " + this.context.columnNumber + ": cell ignored");
        }
    }

    private void startTableCell() throws ParserException {
        ParserContext parserContext;
        ParserContext parserContext2;
        ParserContext parserContext3 = this.context.prev;
        if (parserContext3 == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        ParserContext parserContext4 = parserContext3.element.id == 39 ? parserContext3 : null;
        ParserContext parserContext5 = parserContext2 = parserContext4 == null ? parserContext3 : parserContext4.prev;
        if (parserContext2 == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        if (parserContext2.busyCells == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        ParserContext parserContext6 = parserContext2.prev;
        if (parserContext6 == null) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        if (parserContext6.element.id != 34) {
            throw new ParserException("Misplaced table cell element ignored");
        }
        Attr attr = (Attr)this.context.specified.get(Attn.$number_columns_spanned);
        int n = 1;
        if (attr != null) {
            n = attr.count();
        }
        if (n <= 0) {
            this.session.warning("Invalid value number-columns-spanned=\"" + n + "\"; defaulted to 1");
            n = 1;
        }
        Attr attr2 = (Attr)this.context.specified.get(Attn.$number_rows_spanned);
        int n2 = 1;
        if (attr2 != null) {
            n2 = attr2.count();
        }
        int n3 = 0;
        while (n3 < n) {
            if (parserContext2.busyCells.get(this.context.columnNumber + n3) != null) {
                this.session.warning("Bad table structure: overlapping cells may be truncated or skipped");
                n = n3;
                break;
            }
            parserContext2.busyCells.put(this.context.columnNumber + n3, new Integer(n2));
            ++n3;
        }
        this.context.specified.put(Attn.$column_number, Attr.Count.create(this.context.columnNumber));
        this.context.specified.put(Attn.$row_number, Attr.Count.create(parserContext2.rowNumber));
        this.context.specified.put(Attn.$number_columns_spanned, Attr.Count.create(n));
        this.context.specified.put(Attn.$number_rows_spanned, Attr.Count.create(n2));
        this.context.specified.put(Attn.$table_identifier, Attr.Count.create(parserContext6.tableid));
        switch (parserContext2.element.id) {
            case 36: {
                this.context.specified.put(Attn.$body_number, Attr.header);
                break;
            }
            case 37: {
                this.context.specified.put(Attn.$body_number, Attr.footer);
                break;
            }
            case 38: {
                this.context.specified.put(Attn.$body_number, Attr.Count.create(parserContext6.bodyNumber));
            }
        }
        parserContext3.nextColumn = this.context.columnNumber + n;
        ParserContext parserContext7 = this.getTableLayerContext(Attn.$background_color);
        if (parserContext7 != null) {
            this.copyProperty(parserContext7, Attn.$background_color);
        }
        if ((parserContext = this.getTableLayerContext(Attn.$background_image)) != null) {
            this.copyProperty(parserContext, Attn.$background_image);
            this.copyProperty(parserContext, Attn.$background_repeat);
            this.copyProperty(parserContext, Attn.$background_attachment);
            this.copyProperty(parserContext, Attn.$background_position_horizontal);
            this.copyProperty(parserContext, Attn.$background_position_vertical);
            this.copyProperty(parserContext, Attn.$background_content_width);
            this.copyProperty(parserContext, Attn.$background_content_height);
            this.copyProperty(parserContext, Attn.$background_scaling);
            this.copyProperty(parserContext, Attn.$image_base_url);
        }
        if (this.context.collapseBorders) {
            ParserContext.TableColumn tableColumn;
            ParserContext.TableColumn tableColumn2;
            if (parserContext4 != null) {
                this.overrideBorder("before", parserContext4);
                this.overrideBorder("after", parserContext4);
            }
            if ((tableColumn2 = (ParserContext.TableColumn)parserContext6.tableColumns.get(this.context.columnNumber)) != null) {
                this.overrideBorder("start", tableColumn2.context);
            }
            ParserContext.TableColumn tableColumn3 = tableColumn = n == 1 ? tableColumn2 : (ParserContext.TableColumn)parserContext6.tableColumns.get(this.context.columnNumber + n - 1);
            if (tableColumn != null) {
                this.overrideBorder("end", tableColumn.context);
            }
        }
    }

    private ParserContext getTableLayerContext(Attn attn) {
        if (this.context.specified.get(attn) != null) {
            return null;
        }
        ParserContext parserContext = this.context.prev;
        ParserContext parserContext2 = parserContext.element.id == 39 ? parserContext : null;
        ParserContext parserContext3 = parserContext2 == null ? parserContext : parserContext2.prev;
        ParserContext parserContext4 = parserContext3.prev;
        if (parserContext2 != null && parserContext2.specified.get(attn) != null) {
            return parserContext2;
        }
        if (parserContext3.specified.get(attn) != null) {
            return parserContext3;
        }
        ParserContext.TableColumn tableColumn = (ParserContext.TableColumn)parserContext4.tableColumns.get(this.context.columnNumber);
        if (tableColumn != null && tableColumn.context.specified.get(attn) != null) {
            return tableColumn.context;
        }
        return null;
    }

    private void copyProperty(ParserContext parserContext, Attn attn) {
        Attr attr = (Attr)parserContext.specified.get(attn);
        if (attr == null) {
            this.context.specified.remove(attn);
        } else {
            this.context.specified.put(attn, attr);
        }
    }

    private void setCollapsePrecedence(int n) throws ParserException {
        if (!this.context.useCollapsePrecedence) {
            return;
        }
        Attr.Count count = Attr.Count.create(n);
        if (this.context.specified.get(Attn.$border_before_precedence) == null) {
            this.context.addAttribute(Attn.$border_before_precedence, count);
        }
        if (this.context.specified.get(Attn.$border_after_precedence) == null) {
            this.context.addAttribute(Attn.$border_after_precedence, count);
        }
        if (this.context.specified.get(Attn.$border_start_precedence) == null) {
            this.context.addAttribute(Attn.$border_start_precedence, count);
        }
        if (this.context.specified.get(Attn.$border_end_precedence) == null) {
            this.context.addAttribute(Attn.$border_end_precedence, count);
        }
    }

    private void copyCollapsedBorders() {
        if (!this.context.collapseBorders) {
            return;
        }
        this.context.copySpecifiedValue(Attn.$border_before_width_length, Attn.$border_before_width_collapsed);
        this.context.copySpecifiedValue(Attn.$border_after_width_length, Attn.$border_after_width_collapsed);
        this.context.copySpecifiedValue(Attn.$border_start_width_length, Attn.$border_start_width_collapsed);
        this.context.copySpecifiedValue(Attn.$border_end_width_length, Attn.$border_end_width_collapsed);
    }

    private void zeroCollapsedBorders() {
        if (!this.context.collapseBorders) {
            return;
        }
        this.copyCollapsedBorders();
        this.context.specified.put(Attn.$border_before_width_length, Attr.zerolength);
        this.context.specified.put(Attn.$border_after_width_length, Attr.zerolength);
        this.context.specified.put(Attn.$border_start_width_length, Attr.zerolength);
        this.context.specified.put(Attn.$border_end_width_length, Attr.zerolength);
    }

    private void halfCollapsedBorders() {
        if (!this.context.collapseBorders) {
            return;
        }
        this.copyCollapsedBorders();
        this.divideByTwo(Attn.$border_before_width_length);
        this.divideByTwo(Attn.$border_after_width_length);
        this.divideByTwo(Attn.$border_start_width_length);
        this.divideByTwo(Attn.$border_end_width_length);
    }

    private void divideByTwo(Attn attn) {
        Attr attr = (Attr)this.context.specified.get(attn);
        if (attr == null || !(attr instanceof Attr.Length)) {
            return;
        }
        this.context.specified.put(attn, Attr.Length.create(attr.length() / 2));
    }

    private void overrideBorder(String string, ParserContext parserContext) throws ParserException {
        Attn attn = Attn.oldName("border-" + string + "-width.length");
        Attn attn2 = Attn.oldName("border-" + string + "-width.conditionality");
        Attn attn3 = Attn.oldName("border-" + string + "-color");
        Attn attn4 = Attn.oldName("border-" + string + "-style");
        Attn attn5 = Attn.oldName("border-" + string + "-precedence");
        if (this.compareBorderAttributes(parserContext, attn5, attn4, attn)) {
            this.copyProperty(parserContext, attn);
            this.copyProperty(parserContext, attn2);
            this.copyProperty(parserContext, attn3);
            this.copyProperty(parserContext, attn4);
            this.copyProperty(parserContext, attn5);
            this.copyProperty(parserContext, Attn.$table_element_class);
        }
    }

    private boolean compareBorderAttributes(ParserContext parserContext, Attn attn, Attn attn2, Attn attn3) {
        Attr attr;
        Attr attr2;
        Attr attr3;
        if (this.context.useCollapsePrecedence) {
            attr3 = (Attr)this.context.specified.get(attn);
            int n = BorderComparator.comparePrecedence(attr3, attr2 = (Attr)parserContext.specified.get(attn));
            if (n < 0) {
                return true;
            }
            if (n > 0) {
                return false;
            }
        }
        attr3 = (Attr)this.context.specified.get(attn3);
        attr2 = (Attr)parserContext.specified.get(attn3);
        Attr attr4 = (Attr)this.context.specified.get(attn2);
        return BorderComparator.compareWidthAndStyle(attr3, attr4, attr2, attr = (Attr)parserContext.specified.get(attn2)) < 0;
    }

    private Attr resolveBidiClass(Attr attr, char[] cArray, int n) {
        if (Bidi.classes[cArray[n]] == Bidi.EN && attr == Bidi.LEFTTORIGHT) {
            return Bidi.LEFTTORIGHT;
        }
        return Bidi.classes[cArray[n]];
    }

    private Attr resolveNeutrals(Attr attr, char[] cArray, int n, int n2, int n3) {
        if (attr == Bidi.EN || attr == Bidi.AN) {
            if (n2 < n3 && Bidi.classes[cArray[n2]] == attr && n2 - n == 1 && Bidi.classes[cArray[n]] == Bidi.CS) {
                return attr;
            }
            return Bidi.RIGHTTOLEFT;
        }
        return Bidi.NEUTRAL;
    }
}

