/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.InputSource;
import com.renderx.util.URLSpec;
import com.renderx.util.User;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.ParserAdapter;

public class XMLReaderFactory {
    private static final String DEFAULT_RESOLVER_CLASS_NAME = "none";

    public static final XMLReader createXMLReader() throws SAXException {
        XMLReader xMLReader = null;
        try {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (Exception exception) {
                throw new SAXException("cannot create SAX2 parser: " + exception);
            }
        }
        catch (Error error) {
            try {
                xMLReader = org.xml.sax.helpers.XMLReaderFactory.createXMLReader();
            }
            catch (Error error2) {
                xMLReader = new ParserAdapter();
            }
        }
        xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        xMLReader.setEntityResolver(XMLReaderFactory.getDefaultResolver());
        return xMLReader;
    }

    public static EntityResolver getDefaultResolver() throws SAXException {
        String string = User.getProperty("com.renderx.sax.entityresolver");
        if (string == null) {
            string = DEFAULT_RESOLVER_CLASS_NAME;
        }
        EntityResolver entityResolver = null;
        if (!DEFAULT_RESOLVER_CLASS_NAME.equals(string)) {
            try {
                entityResolver = (EntityResolver)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                throw new SAXException("Cannot create entity resolver " + string + ": " + exception.toString());
            }
        }
        return new DefaultEntityResolver(entityResolver);
    }

    static class DefaultEntityResolver
    implements EntityResolver {
        private EntityResolver parent = null;

        public DefaultEntityResolver() {
            this(null);
        }

        public DefaultEntityResolver(EntityResolver entityResolver) {
            this.parent = entityResolver;
        }

        public org.xml.sax.InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            Object object;
            if (this.parent != null) {
                try {
                    object = this.parent.resolveEntity(string, string2);
                    if (object != null) {
                        return object;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            object = null;
            try {
                object = new URLSpec(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            if (((URLSpec)object).scheme == 3) {
                return null;
            }
            return new InputSource((URLSpec)object);
        }
    }
}

