/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Hashtable;
import com.renderx.util.Stack;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Serializer
extends PrintWriter
implements ContentHandler {
    private boolean indentOutput = false;
    private final String INDENT = "  ";
    private int level = 0;
    private String topURI = null;
    private Hashtable uritab = new Hashtable();
    private Hashtable prefixtab = new Hashtable();
    private boolean hasUTF8 = true;
    private boolean opentag = true;
    private boolean closeOnExit = false;
    private Stack elementNames = new Stack();
    private int prefIndex = 0;
    private boolean emitDeclaration = true;
    private static final String[] prefixCharacters = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public void setEmitDeclaration(boolean bl) {
        this.emitDeclaration = bl;
    }

    public Serializer(String string) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(string)));
        this.closeOnExit = true;
    }

    public Serializer(OutputStream outputStream) throws IOException {
        super((Writer)new OutputStreamWriter(outputStream, "UTF8"), false);
    }

    public Serializer(Writer writer) throws IOException {
        super(writer, false);
    }

    public Serializer(OutputStream outputStream, boolean bl) throws IOException {
        super((Writer)new OutputStreamWriter(outputStream, "UTF8"), false);
        this.indentOutput = bl;
    }

    protected void printQuoted(char[] cArray, int n, int n2, boolean bl) {
        int n3;
        boolean bl2 = false;
        String string = bl ? "<>&'\"" : "<>&";
        int n4 = n;
        while (n4 < n2) {
            n3 = cArray[n4];
            if (string.indexOf(n3) != -1 || bl && n3 < 32 || !this.hasUTF8 && n3 > 112) {
                bl2 = true;
                break;
            }
            ++n4;
        }
        if (bl2) {
            n3 = n;
            int n5 = n;
            while (n5 < n2) {
                char c = cArray[n5];
                if (c == '<') {
                    this.write(cArray, n3, n5 - n3);
                    n3 = n5 + 1;
                    this.print("&lt;");
                } else if (c == '>') {
                    this.write(cArray, n3, n5 - n3);
                    n3 = n5 + 1;
                    this.print("&gt;");
                } else if (c == '&') {
                    this.write(cArray, n3, n5 - n3);
                    n3 = n5 + 1;
                    this.print("&amp;");
                } else if (bl) {
                    if (c == '\"') {
                        this.write(cArray, n3, n5 - n3);
                        n3 = n5 + 1;
                        this.print("&quot;");
                    } else if (c == '\'') {
                        this.write(cArray, n3, n5 - n3);
                        n3 = n5 + 1;
                        this.print("&apos;");
                    }
                } else if (bl && c < ' ' || !this.hasUTF8 && c > 'p') {
                    this.write(cArray, n3, n5 - n3);
                    n3 = n5 + 1;
                    this.print("&#x");
                    this.print(Integer.toHexString(c));
                    this.print(";");
                }
                ++n5;
            }
            this.write(cArray, n3, n2 - n3);
        } else {
            this.write(cArray, n, n2);
        }
    }

    protected void closeTag() {
        if (this.opentag) {
            this.print(">");
            this.opentag = false;
        }
    }

    public void startDocument() throws SAXException {
        this.level = 0;
        this.opentag = false;
        this.elementNames.clear();
        this.topURI = null;
        if (this.emitDeclaration) {
            this.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public void endDocument() throws SAXException {
        this.closeTag();
        this.flush();
        try {
            if (this.closeOnExit) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.printIndent();
        this.closeTag();
        this.print("<?");
        this.print(string);
        if (string2 != null && string2.length() > 0) {
            this.print(' ');
            this.print(string2);
        }
        this.print("?>");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.closeTag();
        this.printQuoted(cArray, n, n2, false);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void skippedEntity(String string) {
    }

    public void startPrefixMapping(String string, String string2) {
    }

    public void endPrefixMapping(String string) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.level;
        String string4 = null;
        if (string2 != null) {
            if (string == null || string.length() == 0) {
                string3 = string2;
            } else {
                string4 = (String)this.uritab.get(string);
                if (string4 == null) {
                    string4 = string.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : this.assignPrefix(string, string3);
                }
                string3 = string4.equals("") ? string2 : string4 + ":" + string2;
            }
        }
        this.elementNames.push(string3);
        this.closeTag();
        this.printIndent();
        this.print("<");
        this.print(string3);
        if (string2 != null && string != null && string.length() != 0 && !string.equals("http://www.w3.org/XML/1998/namespace") && !string.equals(this.topURI)) {
            if (!string4.equals("")) {
                this.print(" xmlns:");
                this.printMarkup(string4);
            } else {
                this.print(" xmlns");
            }
            this.print("=\"");
            this.printMarkup(string);
            this.print("\"");
            if (this.topURI == null) {
                this.topURI = string;
            }
        }
        if (attributes != null) {
            Hashtable hashtable = new Hashtable();
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string5 = attributes.getLocalName(n2);
                String string6 = attributes.getURI(n2);
                String string7 = attributes.getQName(n2);
                if (string5 != null) {
                    if (string6 == null || string6.length() == 0) {
                        string7 = string5;
                    } else {
                        string4 = (String)this.uritab.get(string6);
                        if (string4 == null) {
                            string4 = string6.equals("http://www.w3.org/XML/1998/namespace") ? "xml" : this.assignPrefix(string6, string7);
                        }
                        String string8 = string7 = string4.equals("") ? string5 : string4 + ":" + string5;
                        if (!(hashtable.containsKey(string6) || string6.equals(string) || string6.equals(this.topURI) || string6.equals("http://www.w3.org/XML/1998/namespace"))) {
                            if (!string4.equals("")) {
                                this.print(" xmlns:");
                                this.printMarkup(string4);
                            } else {
                                this.print(" xmlns");
                            }
                            this.print("=\"");
                            this.printMarkup(string6);
                            this.print("\"");
                            hashtable.put(string6, string4);
                        }
                    }
                }
                this.print(" ");
                this.print(string7);
                this.print("=\"");
                this.printAttributeValue(attributes.getValue(n2));
                this.print("\"");
                ++n2;
            }
        }
        this.opentag = true;
    }

    protected void printAttributeValue(String string) {
        this.printMarkup(string);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = (String)this.elementNames.pop();
        if (string2 != null) {
            if (string == null || string.length() == 0) {
                string3 = string2;
            } else {
                String string5 = (String)this.uritab.get(string);
                if (string5 == null) {
                    if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
                        string5 = "xml";
                    } else {
                        throw new SAXException("Namespace '" + string + "' first mentioned on the closing tag '" + string2 + "'");
                    }
                }
                String string6 = string3 = string5.equals("") ? string2 : string5 + ":" + string2;
            }
        }
        if (!string3.equals(string4)) {
            throw new SAXException("Open tag '" + string4 + "' does not match closing tag '" + string3 + "'");
        }
        if (this.opentag) {
            this.print("/>");
            this.opentag = false;
        } else {
            this.printIndent();
            this.print("</");
            this.printMarkup(string4);
            this.print(">");
        }
        --this.level;
    }

    protected final void printIndent() {
        if (this.indentOutput) {
            this.println("");
            int n = 1;
            while (n < this.level) {
                this.print("  ");
                ++n;
            }
        }
    }

    protected final void printMarkup(String string) {
        this.printQuoted(string.toCharArray(), 0, string.length(), true);
    }

    protected String assignPrefix(String string, String string2) throws SAXException {
        String string3 = null;
        if (string2 != null && string2.indexOf(58) != -1 && this.prefixtab.containsKey(string3 = string2.substring(0, string2.indexOf(58)))) {
            string3 = null;
        }
        if (string3 == null) {
            if (this.prefixtab.size() == 0) {
                string3 = "";
            } else {
                int n = prefixCharacters.length;
                while (this.prefIndex < Integer.MAX_VALUE) {
                    int n2 = ++this.prefIndex;
                    string3 = "";
                    while (n2 != 0) {
                        int n3 = n2 % n;
                        n2 = (n2 - n3) / n;
                        string3 = string3 + prefixCharacters[n3];
                    }
                    if (!string3.equals("xml") && !this.prefixtab.containsKey(string3)) break;
                }
                if (this.prefIndex == Integer.MAX_VALUE) {
                    throw new SAXException("Cannot assign more than 2147483645 different prefixes");
                }
            }
        }
        this.uritab.put(string, string3);
        this.prefixtab.put(string3, string);
        return string3;
    }

    public static void main(String[] stringArray) throws Exception {
        System.err.println("Serializing " + stringArray[0] + " to " + stringArray[1]);
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        Serializer serializer = new Serializer(stringArray[1]);
        xMLReader.setContentHandler(serializer);
        xMLReader.parse(new InputSource(new FileInputStream(stringArray[0])));
    }

    public static final class Test
    extends TestCase {
        private XMLReader parser;

        public void setUp() {
            try {
                this.parser = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                Assert.assertTrue((boolean)false);
            }
        }

        private boolean boomerang(String string) {
            try {
                StringWriter stringWriter = new StringWriter();
                this.parser.setContentHandler(new Serializer(stringWriter));
                this.parser.parse(new InputSource(new StringReader(string)));
                return stringWriter.toString().equals("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + string);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (SAXException sAXException) {
                return false;
            }
        }

        public void testSingleton() {
            Assert.assertTrue((boolean)this.boomerang("<a/>"));
        }

        public void testSimple() {
            Assert.assertTrue((boolean)this.boomerang("<a><b/></a>"));
        }

        public void testSimpleWithAttrs() {
            Assert.assertTrue((boolean)this.boomerang("<a x=\"y\"><b c=\"d\"/></a>"));
        }

        public void testNamespace() {
            Assert.assertTrue((boolean)this.boomerang("<x:a xmlns:x=\"y\"><x:b/></x:a>"));
        }

        public void testAttrs() {
            Assert.assertTrue((boolean)this.boomerang("<x:a xmlns:x=\"y&quot;\"><x:b/></x:a>"));
        }

        public void testCHAR() {
            Assert.assertTrue((boolean)this.boomerang("<x:a xmlns:x=\"y&quot;\"><x:b/>&amp;a&lt;&gt;</x:a>"));
        }
    }
}

