/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.RichMediaConfiguration;
import com.renderx.util.Hashtable;
import com.renderx.util.URLUtil;
import java.util.Enumeration;

class RichMediaContent
extends PDFObject {
    Assets assets = null;
    RichMediaConfiguration rmconf = null;

    RichMediaContent(IndirectObject indirectObject) {
        super(indirectObject);
    }

    String getType() {
        return "RichMediaContent";
    }

    void setAssets(Assets assets) {
        this.assets = assets;
    }

    Hashtable getAssets() {
        return this.assets.assets;
    }

    void setConfiguration(RichMediaConfiguration richMediaConfiguration) {
        this.rmconf = richMediaConfiguration;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        if (this.rmconf != null) {
            pDFOutputStream.print("/Configurations [" + this.rmconf.getID().toStringR() + "]");
        }
        if (this.assets != null) {
            pDFOutputStream.print("/Assets " + this.assets.getID().toStringR());
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (this.rmconf != null) {
            this.rmconf.write(pDFOutputStream);
        }
        if (this.assets != null) {
            this.assets.write(pDFOutputStream);
        }
    }

    static class Assets
    extends PDFObject {
        Hashtable assets = new Hashtable();

        Assets(IndirectObject indirectObject) {
            super(indirectObject);
        }

        void addAsset(String string, IndirectObject indirectObject) {
            this.assets.put(URLUtil.urlEncode(string), indirectObject);
        }

        void writeBody(PDFOutputStream pDFOutputStream) {
            if (!this.assets.isEmpty()) {
                pDFOutputStream.print("/Names [");
                Enumeration enumeration = this.assets.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    pDFOutputStream.print(" (");
                    pDFOutputStream.print(string);
                    pDFOutputStream.print(") ");
                    pDFOutputStream.print(((IndirectObject)this.assets.get(string)).toStringR());
                }
                pDFOutputStream.println("]");
            }
        }

        void writeSubObjects(PDFOutputStream pDFOutputStream) {
        }
    }
}

