/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.crypto.Hex;
import com.renderx.pdflib.Encrypt;
import com.renderx.pdflib.Encryption;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.Linearize;
import com.renderx.pdflib.PDFDocument;
import com.renderx.pdflib.PDFIOException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFTrailer;
import com.renderx.pdflib.PDFWrongElementException;
import com.renderx.pdflib.parser.PDFString;
import com.renderx.util.DeflaterOutputStream;
import com.renderx.util.List;
import com.renderx.util.SeekableByteArrayInputStream;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.Stack;
import com.renderx.util.User;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class PDFOutputStream
extends OutputStream {
    private static final int FLOAT_PRECISION_HIGH = 1000;
    private static final int FLOAT_PRECISION_LOW = 10;
    private static final String pdfEncodingCharset = "\u02c6\u02d9\u02dd\u02db\u02da\u02dc\u2022\u2020\u2021\u2026\u2014\u2013\u0192\u2044\u2039\u203a\u2212\u2030\u201e\u201c\u201d\u2018\u2019\u201a\u2122\ufb01\ufb02\u0141\u0152\u0160\u0178\u017d\u0131\u0142\u0153\u0161\u017e\u20ac\t\r\n\u00a0\u00a1\u00a2\u00a3\u00a4\u00a5\u00a6\u00a7\u00a8\u00a9\u00aa\u00ab\u00ac\u00ad\u00ae\u00af\u00b0\u00b1\u00b2\u00b3\u00b4\u00b5\u00b6\u00b7\u00b8\u00b9\u00ba\u00bb\u00bc\u00bd\u00be\u00bf\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    public static PrintStream dump = null;
    public int lastObjectNumber;
    float fontSize;
    static final double[] identity_matrix = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
    double[] matrix;
    private Stack states;
    OutputStream currentOS;
    DataOutputStream output;
    ByteArrayOutputStream outputBA;
    DeflaterOutputStream deflaterOS;
    OutputStream cipherOS;
    public boolean USE_TEMP_FILE;
    File tmpdir;
    File tmpfile;
    ByteArrayOutputStream tmpbaos;
    DataOutputStream realoutput;
    public int filenumber;
    public PDFTrailer trailer;
    boolean useEncryption;
    boolean saveUseEncryption;
    Encrypt encrypt;
    public boolean compression;
    private boolean linearize;
    public boolean unicodeAnnotations;
    IndirectObject stream_id;
    int stream_start_offset;
    int stream_end_offset;
    boolean printText;
    boolean printMarkedText;
    PDFDocument doc;

    public static void dumpprintln(String string) {
        PDFOutputStream.dumpprint(string + "\n");
    }

    public static void dumpprint(String string) {
        dump.print(string);
    }

    File getTempFile() {
        File file;
        while ((file = new File(this.tmpdir, "pdfgen_" + Integer.toHexString((int)System.currentTimeMillis()) + "_" + Integer.toHexString(++this.filenumber) + ".tmp")).exists()) {
        }
        return file;
    }

    public PDFOutputStream(OutputStream outputStream, PDFDocument pDFDocument) throws IOException {
        String string = User.getProperty("com.renderx.pdflib.debug.DUMP");
        String string2 = User.getProperty("com.renderx.pdflib.debug.DUMP.file");
        if (string != null && string.equalsIgnoreCase("on") || string2 != null) {
            if (string2 != null) {
                try {
                    dump = new PrintStream(new FileOutputStream(string2, true));
                }
                catch (Exception exception) {
                    System.err.println("Cannot redirect dump to " + string2 + ": " + exception);
                    dump = System.err;
                }
            } else {
                dump = System.err;
            }
        }
        this.fontSize = 0.0f;
        this.matrix = identity_matrix;
        this.states = new Stack();
        this.USE_TEMP_FILE = true;
        this.tmpdir = null;
        this.tmpfile = null;
        this.tmpbaos = null;
        this.filenumber = 0;
        this.stream_id = null;
        this.output = new DataOutputStream(outputStream);
        this.doc = pDFDocument;
        this.currentOS = this.output;
        this.compression = true;
        this.linearize = false;
        this.useEncryption = false;
        this.saveUseEncryption = false;
        this.unicodeAnnotations = true;
        this.printText = false;
        this.printMarkedText = false;
    }

    boolean getLinearize() {
        return this.linearize;
    }

    void setLinearize(boolean bl) {
        this.linearize = bl;
        if (this.linearize) {
            if (this.useEncryption) {
                this.useEncryption = false;
            }
            this.realoutput = this.output;
            try {
                if (this.USE_TEMP_FILE) {
                    this.tmpfile = this.getTempFile();
                    this.output = new DataOutputStream(new FileOutputStream(this.tmpfile));
                } else {
                    this.tmpbaos = new ByteArrayOutputStream();
                    this.output = new DataOutputStream(this.tmpbaos);
                }
                this.currentOS = this.output;
            }
            catch (IOException iOException) {
                throw new PDFIOException(iOException);
            }
        }
    }

    void finish() {
        try {
            this.output.flush();
            if (this.linearize) {
                this.output.close();
                Closeable closeable = null;
                if (this.USE_TEMP_FILE) {
                    closeable = new SeekableFileInputStream(this.tmpfile);
                } else {
                    closeable = new SeekableByteArrayInputStream(this.tmpbaos.toByteArray());
                    this.tmpbaos = null;
                }
                Linearize linearize = new Linearize((SeekableInput)((Object)closeable), (OutputStream)this.realoutput, this.doc.imageFactory, this.doc.fontCatalog, this.doc.errorHandler);
                linearize.setUseCompression(this.compression);
                if (this.saveUseEncryption) {
                    linearize.setUseEncryption(this.encrypt);
                }
                linearize.linearize();
                this.realoutput.flush();
                closeable.close();
                if (this.USE_TEMP_FILE) {
                    this.tmpfile.delete();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PDFIOException(exception);
        }
    }

    public void write(int n) throws IOException {
        this.currentOS.write(n);
    }

    public void setUseEncryption(String string, String string2, int n) {
        if (this.doc.hasPDFX()) {
            this.error("PDF/X of version " + this.doc.getPDFXConformanceStatus() + " may not use encryption.");
        }
        if (this.doc.hasPDFA()) {
            this.error("PDF/A of version " + this.doc.getPDFAConformanceStatus() + " may not use encryption.");
        }
        if (!this.linearize) {
            this.useEncryption = true;
        }
        this.saveUseEncryption = true;
        this.encrypt = new Encrypt(new IndirectObject(this.lastObjectNumber), string, string2, n, this.output.toString());
        if (!this.linearize) {
            ++this.lastObjectNumber;
        }
    }

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    public OutputStream getCurrentOutputStream() {
        return this.currentOS;
    }

    public void startCompressedStream() {
        if (this.useEncryption) {
            this.currentOS = this.cipherOS = this.encrypt.getCipherOutputStream(this.output);
        }
    }

    public void finishCompressedStream() {
        if (this.useEncryption) {
            try {
                this.cipherOS.flush();
            }
            catch (Exception exception) {
                throw new PDFIOException("Can not flush cipher stream");
            }
            this.cipherOS = null;
        }
        this.currentOS = this.output;
    }

    public boolean streamStarted() {
        return this.stream_id != null;
    }

    public IndirectObject beginStream(IndirectObject indirectObject) throws PDFWrongElementException {
        if (this.streamStarted()) {
            throw new PDFWrongElementException("You are already sending stream data");
        }
        this.stream_id = indirectObject;
        IndirectObject indirectObject2 = new IndirectObject(this.stream_id.num + 1);
        this.trailer.xref.addObjectOffset(this.stream_id, this.size());
        this.generateCurrentKey(this.stream_id.num);
        this.println(this.stream_id + " obj");
        this.println("<</Length " + indirectObject2.toStringR());
        if (this.compression) {
            this.println("/Filter /FlateDecode");
        }
        this.println(">>");
        this.println("stream");
        this.stream_start_offset = this.size();
        this.startStream();
        indirectObject2 = new IndirectObject(indirectObject2.num + 1);
        return indirectObject2;
    }

    public void startStream() {
        if (this.useEncryption) {
            this.currentOS = this.cipherOS = this.encrypt.getCipherOutputStream(this.output);
        }
        if (this.compression) {
            this.deflaterOS = new DeflaterOutputStream(this.currentOS);
            this.currentOS = this.deflaterOS;
        }
    }

    public void finishStream() {
        if (this.compression) {
            try {
                this.deflaterOS.finish();
            }
            catch (Exception exception) {
                throw new PDFIOException("Can not close compressed stream");
            }
            this.deflaterOS = null;
        }
        if (this.useEncryption) {
            try {
                this.cipherOS.flush();
            }
            catch (Exception exception) {
                throw new PDFIOException("Can not flush cipher stream");
            }
            this.cipherOS = null;
        }
        this.currentOS = this.output;
    }

    public void endStream() throws PDFWrongElementException {
        this.endText();
        if (this.stream_id == null) {
            throw new PDFWrongElementException("You finished sending stream data");
        }
        this.finishStream();
        this.stream_end_offset = this.size();
        this.println("\nendstream");
        this.println("endobj");
        this.printLength(new IndirectObject(this.stream_id.num + 1), this.stream_end_offset - this.stream_start_offset);
        this.stream_id = null;
    }

    void printLength(IndirectObject indirectObject, int n) {
        this.trailer.xref.addObjectOffset(indirectObject, this.size());
        this.println(indirectObject + " obj");
        this.println("" + n);
        this.println("endobj");
    }

    public void printVector(String string, List list) {
        if (list.length() <= 0) {
            return;
        }
        this.print("/" + string + " ");
        this.print("[");
        Enumeration enumeration = list.elements();
        while (enumeration.hasMoreElements()) {
            this.print(((IndirectObject)enumeration.nextElement()).toStringR() + " ");
        }
        this.print("]");
    }

    public void print(char c) {
        try {
            this.currentOS.write((byte)c & 0xFF);
        }
        catch (IOException iOException) {
            throw new PDFIOException(iOException);
        }
    }

    public void print(int n) {
        try {
            this.currentOS.write((byte)n & 0xFF);
        }
        catch (IOException iOException) {
            throw new PDFIOException(iOException);
        }
    }

    public void print(byte[] byArray) {
        this.print(byArray, 0, byArray.length);
    }

    public void print(byte[] byArray, int n, int n2) {
        try {
            this.currentOS.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new PDFIOException(iOException);
        }
    }

    public void print(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            this.print(string.charAt(n2));
            ++n2;
        }
    }

    public void println() {
        this.print("\n");
    }

    public void println(String string) {
        this.print(string + "\n");
    }

    void print_quote_bytes(byte[] byArray) {
        try {
            int n = 0;
            while (n < byArray.length) {
                byte by = byArray[n];
                if (0 <= by && by < 32) {
                    this.currentOS.write(92);
                    this.currentOS.write(48 + (by >> 6 & 7));
                    this.currentOS.write(48 + (by >> 3 & 7));
                    this.currentOS.write(48 + (by & 7));
                } else if (by == 40 || by == 41 || by == 92) {
                    this.currentOS.write(92);
                    this.currentOS.write(by);
                } else {
                    this.currentOS.write(by);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            throw new PDFIOException(iOException);
        }
    }

    public void print_annotation(String string) {
        this.print("(");
        boolean bl = false;
        if (this.unicodeAnnotations) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, pdfEncodingCharset);
            bl = stringTokenizer.hasMoreTokens();
        }
        if (bl) {
            new PDFString(string).unicode_quote(this);
        } else {
            new PDFString(string).pdfencoding_quote(this);
        }
        this.print(")");
    }

    public void printString(String string) {
        this.print("(");
        new PDFString(string).quote(this);
        this.print(")");
    }

    public void printStringUnicode(String string) {
        this.print("(");
        new PDFString(string).unicode_quote(this);
        this.print(")");
    }

    public void printStringPDFEncoding(String string) {
        this.print("(");
        new PDFString(string).pdfencoding_quote(this);
        this.print(")");
    }

    static String pdf_float(double d, int n) {
        int n2;
        int n3;
        if (d == 0.0) {
            return "0";
        }
        if (Double.isNaN(d)) {
            throw new PDFWrongElementException("Cannot output NaN as a float");
        }
        String string = "";
        if (d < 0.0) {
            d = -d;
            string = "-";
        }
        if ((n3 = (int)Math.round((d - (double)(n2 = (int)Math.floor(d))) * (double)n)) == n) {
            ++n2;
            n3 = 0;
        }
        if (n2 != 0) {
            string = string + n2;
            if (n3 != 0) {
                string = string + ".";
                int n4 = n / 10;
                while (n3 / n4 == 0) {
                    string = string + "0";
                    n4 /= 10;
                }
                while (n3 % 10 == 0) {
                    n3 /= 10;
                }
                string = string + n3;
            }
        } else {
            string = string + "0.";
            while (d < 0.1) {
                string = string + "0";
                d *= 10.0;
            }
            n3 = (int)Math.round(d * (double)n * 10.0);
            while (n3 % 10 == 0) {
                n3 /= 10;
            }
            string = string + n3;
        }
        return string;
    }

    public static String pdf_float(double d) {
        return PDFOutputStream.pdf_float(d, 1000);
    }

    public static String pdf_float_coarse(double d) {
        return PDFOutputStream.pdf_float(d, 10);
    }

    void setTextMatrix(float f, float f2, float f3, float f4) {
        this.startText();
        this.print(PDFOutputStream.pdf_float(f) + " " + 0 + " " + PDFOutputStream.pdf_float(f2) + " " + 1 + " ");
        this.println(PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " Tm");
    }

    void begin_dict() {
        this.print("<<");
    }

    void end_dict() {
        this.print(">>\n");
    }

    public int size() {
        return this.output.size();
    }

    void startMarkedText() {
        if (!this.printMarkedText) {
            this.printMarkedText = true;
            this.println("/Tx BMC");
        }
    }

    void endMarkedText() {
        if (this.printMarkedText) {
            this.printMarkedText = false;
            this.println("EMC");
        }
    }

    void startText() {
        if (!this.printText) {
            this.printText = true;
            this.println("BT");
        }
    }

    void endText() {
        if (this.printText) {
            this.printText = false;
            this.println("ET");
        }
    }

    public void generateCurrentKey(int n) {
        if (this.useEncryption) {
            this.encrypt.generateCurrentKey(n);
        }
    }

    PDFObject getEncryptObject() {
        return this.encrypt;
    }

    String getDocumentID() {
        if (this.useEncryption) {
            return this.encrypt.IDtoStr();
        }
        byte[] byArray = Encryption.generateID(this.output.toString());
        return Hex.toString(byArray);
    }

    public byte[] encryptArray(byte[] byArray) {
        return this.encrypt.encryptArray(byArray);
    }

    public void saveState() {
        this.states.push(this.matrix);
    }

    public void restoreState() {
        this.matrix = (double[])this.states.pop();
    }

    public void warning(String string) {
        if (this.doc.errorHandler == null) {
            return;
        }
        this.doc.errorHandler.warning(string);
    }

    public void error(String string) {
        if (this.doc.errorHandler == null) {
            return;
        }
        this.doc.errorHandler.error(string);
    }

    public IndirectObject getNextID() {
        return new IndirectObject(this.lastObjectNumber++);
    }

    public void exception(String string, Exception exception) {
        if (this.doc.errorHandler == null) {
            return;
        }
        this.doc.errorHandler.exception(string, exception);
    }

    public void close() throws IOException {
        this.output.close();
    }
}

