/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.fonts.FontCatalog;
import com.renderx.fonts.FontConfigurationException;
import com.renderx.fonts.FontDescriptor;
import com.renderx.fonts.FontRecord;
import com.renderx.fonts.U28;
import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.EPSImage;
import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.UnregisteredMIMETypeException;
import com.renderx.graphics.VectorImage;
import com.renderx.graphics.vector.Gradient;
import com.renderx.graphics.vector.GraphicObject;
import com.renderx.graphics.vector.PaintServer;
import com.renderx.pdflib.AcroField;
import com.renderx.pdflib.Annot;
import com.renderx.pdflib.AppearanceStream;
import com.renderx.pdflib.Bookmark;
import com.renderx.pdflib.Catalog;
import com.renderx.pdflib.ColorSpace;
import com.renderx.pdflib.EmbeddedFiles;
import com.renderx.pdflib.ExtGStates;
import com.renderx.pdflib.ExternalBookmark;
import com.renderx.pdflib.Fonts;
import com.renderx.pdflib.Images;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.Info;
import com.renderx.pdflib.Links;
import com.renderx.pdflib.LocalBookmark;
import com.renderx.pdflib.LocalLink;
import com.renderx.pdflib.Media;
import com.renderx.pdflib.NameTree;
import com.renderx.pdflib.Names;
import com.renderx.pdflib.Outlines;
import com.renderx.pdflib.OutputIntent;
import com.renderx.pdflib.OutputIntents;
import com.renderx.pdflib.PDFActionObject;
import com.renderx.pdflib.PDFComment;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFExternalFileException;
import com.renderx.pdflib.PDFLink;
import com.renderx.pdflib.PDFMediaAnnot;
import com.renderx.pdflib.PDFMediaClipData;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.PDFRendition;
import com.renderx.pdflib.PDFTrailer;
import com.renderx.pdflib.Page;
import com.renderx.pdflib.Pages;
import com.renderx.pdflib.Patterns;
import com.renderx.pdflib.Popup;
import com.renderx.pdflib.Resources;
import com.renderx.pdflib.RichMediaAnnot;
import com.renderx.pdflib.RichMediaConfiguration;
import com.renderx.pdflib.RichMediaContent;
import com.renderx.pdflib.RichMediaSettings;
import com.renderx.pdflib.SMask;
import com.renderx.pdflib.SMasks;
import com.renderx.pdflib.SpotColors;
import com.renderx.pdflib.StructAttrs;
import com.renderx.pdflib.StructElem;
import com.renderx.pdflib.StructElements;
import com.renderx.pdflib.StructTreeRoot;
import com.renderx.pdflib.TextAnnot;
import com.renderx.pdflib.WebLink;
import com.renderx.pdflib.XMPInfo;
import com.renderx.pdflib.parser.PDFInstance;
import com.renderx.sax.Serializer;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Base64OutputStream;
import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.RoleMap;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.URLUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class PDFDocument {
    public static final String DEFAULT_PDF_VERSION = "1.4";
    public static final String DEFAULT_PDFX_CONFORMANCE_STATUS = "none";
    public static final String DEFAULT_PDFA_CONFORMANCE_STATUS = "none";
    public static boolean useCustomStructureTypes = true;
    int NONE = 0;
    int FILL_WINDING = 0;
    int FILL_EVENODD = 1;
    int fillRule;
    PDFOutputStream outputPDF;
    PDFOutputStream out;
    boolean printText;
    boolean printMarkedContent;
    boolean initializationFinished;
    boolean dropUnusedDestinations;
    Page firstPage;
    Page currentPage;
    Resources currentResources;
    Links links;
    Fonts fonts;
    Images images;
    Media media;
    SpotColors spotColors;
    ExtGStates gStates;
    OutputIntents outputintents;
    StructElements structelems;
    Patterns patterns;
    SMasks smasks;
    StructElem currentStructElem;
    AcroField currentAcroField;
    Hashtable radioButtons;
    ByteArrayOutputStream acroBAOS;
    ColorSpace currentColorSpace;
    private RichMediaAnnot currentRMA;
    private PDFMediaAnnot currentMA;
    private PDFComment currentPDFC;
    private Bookmark currentB;
    EmbeddedFiles embeddedFiles = new EmbeddedFiles();
    private float text_x;
    private float text_y;
    private float hscale = 1.0f;
    private float wspace = 0.0f;
    private float cspace = 0.0f;
    private boolean newpos = true;
    private float fontSlant = 0.0f;
    boolean unsupportedOpacityWarning = false;
    boolean forcedCMYKColorWarning = false;
    boolean unsupportedAcroFieldMultiselect = false;
    boolean unsupportedAcroFieldSubmitFormatXFDF = false;
    boolean unsupportedAcroFieldSubmitFormatPDF = false;
    private Hashtable destStorage = null;
    private Hashtable usedDestinations = null;
    private String openActionJS = null;
    public static final String[] DocumentAdditionalAcrionNames = new String[]{"js-willclose", "js-willsave", "js-didsave", "js-willprint", "js-didprint"};
    String initialDestination = null;
    String initialZoom = null;
    String pdfVersion = "1.4";
    String pdfxConformanceStatus = "none";
    String pdfaConformanceStatus = "none";
    boolean taggedPDF;
    private final Hashtable pageboundaries = new Hashtable();
    private Hashtable currentPageBoundaries = null;
    private final List printermarks = new List();
    private List currentPrinterMarks = null;
    final ImageFactory imageFactory;
    final FontCatalog fontCatalog;
    final ErrorHandler errorHandler;
    final U28 u28;

    public void setOpenActionJS(String string) {
        this.openActionJS = string;
    }

    public void setDocumentAdditionalAction(String string, String string2) {
        try {
            this.outputPDF.trailer.catalog.setAdditionalAction(string, string2);
        }
        catch (PDFException pDFException) {
            this.errorHandler.warning(pDFException.getMessage() + "; parameter ignored");
        }
    }

    public void setInitialDestination(String string) {
        this.initialDestination = string;
    }

    public void setInitialZoom(String string) {
        this.initialZoom = string;
    }

    public void setViewMode(String string) {
        try {
            this.outputPDF.trailer.catalog.setViewMode(string);
        }
        catch (PDFException pDFException) {
            this.errorHandler.warning(pDFException.getMessage() + "; parameter ignored");
        }
    }

    public void setPageNumbering(boolean bl) {
        this.outputPDF.trailer.catalog.setPageNumbering(bl);
    }

    public void setPageLayout(String string) {
        try {
            this.outputPDF.trailer.catalog.setPageLayout(string);
        }
        catch (PDFException pDFException) {
            this.errorHandler.warning(pDFException.getMessage() + "; parameter ignored");
        }
    }

    public void setViewerSetting(String string) {
        try {
            this.outputPDF.trailer.catalog.setViewerSetting(string);
        }
        catch (PDFException pDFException) {
            this.errorHandler.warning(pDFException.getMessage() + "; parameter ignored");
        }
    }

    public void setAdobeExtension(String string, String string2) {
        this.outputPDF.trailer.catalog.setAdobeExtension(string, string2);
    }

    public void setPDFVersion(String string) {
        int n = Integer.valueOf(DEFAULT_PDF_VERSION.substring(0, DEFAULT_PDF_VERSION.indexOf(46)));
        int n2 = Integer.valueOf(DEFAULT_PDF_VERSION.substring(DEFAULT_PDF_VERSION.indexOf(46) + 1));
        int n3 = string.indexOf(46);
        try {
            n = Integer.valueOf(string.substring(0, n3));
            n2 = Integer.valueOf(string.substring(n3 + 1));
        }
        catch (Exception exception) {
            this.errorHandler.warning("Unrecognized PDF Version number: " + string + "; parameter ignored");
            return;
        }
        if (n == 1 && n2 < 3) {
            this.errorHandler.warning("Unsupported PDF Version: " + string + "; reverted to the lowest possible value: 1.3.");
            this.pdfVersion = "1.3";
            return;
        }
        this.pdfVersion = String.valueOf(n).concat(".").concat(String.valueOf(n2));
    }

    public int getPDFVersion_major() {
        int n = this.pdfVersion.indexOf(46);
        return Integer.valueOf(this.pdfVersion.substring(0, n));
    }

    public int getPDFVersion_minor() {
        int n = this.pdfVersion.indexOf(46);
        return Integer.valueOf(this.pdfVersion.substring(n + 1));
    }

    public void setPDFXConformanceStatus(String string) {
        if ("pdf-x-1a".equals(string)) {
            this.pdfxConformanceStatus = "PDF/X-1a";
        } else if ("pdf-x-3".equals(string)) {
            this.pdfxConformanceStatus = "PDF/X-3";
        } else if ("none".equals(string)) {
            this.pdfxConformanceStatus = "none";
        } else {
            this.pdfxConformanceStatus = "none";
            this.errorHandler.warning("Unsupported PDF/X version: " + string + "; reverted to default PDF/X status: " + "none" + ".");
        }
    }

    public String getPDFXConformanceStatus() {
        return this.pdfxConformanceStatus;
    }

    public boolean hasPDFX() {
        return "PDF/X-1a".equals(this.pdfxConformanceStatus) || "PDF/X-3".equals(this.pdfxConformanceStatus);
    }

    public void setPDFAConformanceStatus(String string) {
        if ("pdf-a-1a".equals(string)) {
            this.pdfaConformanceStatus = "PDF/A-1a";
        } else if ("pdf-a-1b".equals(string)) {
            this.pdfaConformanceStatus = "PDF/A-1b";
        } else if ("none".equals(string)) {
            this.pdfaConformanceStatus = "none";
        } else {
            this.pdfaConformanceStatus = "none";
            this.errorHandler.warning("Unsupported PDF/A version: " + string + "; reverted to default PDF/A status: " + "none" + ".");
        }
    }

    public String getPDFAConformanceStatus() {
        return this.pdfaConformanceStatus;
    }

    public boolean hasPDFA() {
        return "PDF/A-1a".equals(this.pdfaConformanceStatus) || "PDF/A-1b".equals(this.pdfaConformanceStatus);
    }

    public void setTaggedPDF(boolean bl) {
        this.taggedPDF = bl;
        if (bl) {
            if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4) {
                this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support Tagged PDF; PDF 1.4 will be generated.");
                this.pdfVersion = DEFAULT_PDF_VERSION;
            }
            this.outputPDF.trailer.catalog.structTreeRoot = new StructTreeRoot(this.outputPDF.getNextID());
            this.currentStructElem = this.outputPDF.trailer.catalog.structTreeRoot;
        }
    }

    public void setLanguage(String string) {
        this.outputPDF.trailer.catalog.setLanguage(string);
    }

    public void setPageBoundaryEntry(String string, Object object) {
        this.currentPageBoundaries.put(string, object);
    }

    public void setPrinterMarkEntry(String string) {
        this.currentPrinterMarks.append(string);
    }

    protected PDFDocument(String string) throws IOException, FontConfigurationException {
        this(new FileOutputStream(string));
    }

    protected PDFDocument(OutputStream outputStream) throws IOException, FontConfigurationException {
        this(outputStream, new URLCache(), new DefaultErrorHandler());
    }

    private PDFDocument(OutputStream outputStream, URLCache uRLCache, ErrorHandler errorHandler) throws IOException, FontConfigurationException {
        this(outputStream, new FontCatalog(uRLCache, errorHandler), uRLCache, errorHandler);
    }

    private PDFDocument(OutputStream outputStream, FontCatalog fontCatalog, URLCache uRLCache, ErrorHandler errorHandler) throws IOException {
        this(outputStream, new ImageFactory(fontCatalog, uRLCache, errorHandler), fontCatalog, errorHandler);
    }

    public PDFDocument(String string, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException {
        this((OutputStream)new FileOutputStream(string), imageFactory, fontCatalog, errorHandler);
    }

    public PDFDocument(OutputStream outputStream, ImageFactory imageFactory, FontCatalog fontCatalog, ErrorHandler errorHandler) throws IOException {
        this.fontCatalog = fontCatalog;
        this.imageFactory = imageFactory;
        this.errorHandler = errorHandler;
        this.out = this.outputPDF = new PDFOutputStream(outputStream, this);
        this.outputPDF.lastObjectNumber = 1;
        this.initializationFinished = false;
        this.printText = true;
        this.printMarkedContent = false;
        this.outputPDF.trailer = new PDFTrailer();
        this.outputPDF.trailer.catalog = new Catalog(this.outputPDF.getNextID());
        this.outputPDF.trailer.catalog.pages = new Pages(this.outputPDF.getNextID());
        this.outputPDF.trailer.catalog.metadata = new XMPInfo(this.outputPDF.getNextID());
        this.outputPDF.trailer.info = new Info(this.outputPDF.getNextID());
        this.links = new Links();
        this.fonts = new Fonts();
        this.images = new Images();
        this.media = new Media();
        this.spotColors = new SpotColors();
        this.gStates = new ExtGStates();
        this.outputintents = new OutputIntents();
        this.structelems = new StructElements();
        this.patterns = new Patterns();
        this.smasks = new SMasks();
        this.outputPDF.compression = true;
        this.firstPage = null;
        this.currentPage = null;
        this.currentResources = null;
        this.currentStructElem = null;
        this.currentAcroField = null;
        this.radioButtons = new Hashtable();
        this.acroBAOS = null;
        this.currentRMA = null;
        this.currentMA = null;
        this.currentPDFC = null;
        this.currentPageBoundaries = this.pageboundaries;
        this.currentPrinterMarks = this.printermarks;
        this.currentColorSpace = null;
        this.u28 = new PDFU28();
    }

    public void startDocument() {
        if (!this.initializationFinished) {
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dump.println("<pdf compression=\"" + this.outputPDF.compression + "\"" + "linearization=\"" + this.outputPDF.getLinearize() + "\"" + "encryption=\"" + this.outputPDF.getUseEncryption() + "\"" + "/>");
            }
            if (this.hasPDFX() && (this.getPDFVersion_major() != 1 || this.getPDFVersion_minor() > 3)) {
                this.errorHandler.warning("PDF Version " + this.pdfVersion + " is not allowed in " + this.pdfxConformanceStatus + "; reverted to maximum possible value: 1.3.");
                this.pdfVersion = "1.3";
            }
            if (this.hasPDFA()) {
                if (this.getPDFVersion_major() != 1 || this.getPDFVersion_minor() > 4) {
                    this.errorHandler.warning("PDF Version " + this.pdfVersion + " is not allowed in " + this.pdfaConformanceStatus + "; reverted to maximum possible value: 1.4.");
                    this.pdfVersion = DEFAULT_PDF_VERSION;
                }
                if ("PDF/A-1a".equals(this.getPDFAConformanceStatus()) && !this.taggedPDF) {
                    this.errorHandler.error("PDF/A-1a documents must be tagged; PDF/A status reverted to 'none'.");
                    this.pdfaConformanceStatus = "none";
                }
            }
            this.outputPDF.println("%PDF-" + this.pdfVersion);
            this.outputPDF.println("%\u00e2\u00e3\u00cf\u00d3");
            this.initializationFinished = true;
        } else {
            this.errorHandler.error("Document already started!");
        }
    }

    public void setTMPDIR(File file) {
        if (file != null) {
            if (!file.exists()) {
                this.errorHandler.error("Directory " + file + " does not exist; disk caching in PDF generator disabled.");
                file = null;
            } else if (!file.isDirectory()) {
                this.errorHandler.error("File " + file + " is not a directory; disk caching in PDF generator disabled.");
                file = null;
            } else if (!file.canWrite()) {
                this.errorHandler.error("Directory " + file + " is not writable; disk caching in PDF generator disabled.");
                file = null;
            }
        }
        this.outputPDF.tmpdir = file;
        this.outputPDF.USE_TEMP_FILE = file != null;
    }

    public void setCompression(boolean bl) {
        this.outputPDF.compression = bl;
    }

    public void setLinearize(boolean bl) {
        this.outputPDF.setLinearize(bl);
    }

    public void setUnicodeAnnotations(boolean bl) {
        this.outputPDF.unicodeAnnotations = bl;
    }

    public void setDestinationTreatment(boolean bl) {
        this.dropUnusedDestinations = bl;
        if (bl) {
            this.destStorage = new Hashtable();
            this.usedDestinations = new Hashtable();
        } else {
            this.destStorage = null;
            this.usedDestinations = null;
        }
    }

    public void setEncryption(String string, String string2, int n) {
        this.outputPDF.setUseEncryption(string, string2, n);
    }

    public void setInfo(String string, String string2) {
        this.outputPDF.trailer.info.set(string, string2);
    }

    public void beginPage(float f, float f2, String string) {
        this.beginPage(f, f2, string, null, null);
    }

    public void beginPage(float f, float f2, String string, String string2, String string3) {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<page>");
        }
        this.currentPage = new Page(this.outputPDF.getNextID(), f, f2, string);
        this.currentPage.addContentID(new IndirectObject(this.outputPDF.lastObjectNumber));
        this.outputPDF.lastObjectNumber = this.outputPDF.beginStream((IndirectObject)new IndirectObject((int)this.outputPDF.lastObjectNumber)).num;
        this.currentPage.addResources(this.outputPDF.getNextID());
        this.currentResources = this.currentPage.resources;
        this.currentColorSpace = this.currentPage.colorSpace;
        if (this.firstPage == null) {
            this.firstPage = this.currentPage;
        }
        this.currentPageBoundaries = this.currentPage.pageboundaries;
        this.currentPrinterMarks = this.currentPage.printermarks;
        if (this.pageboundaries.containsKey("CROP_OFFSET")) {
            this.setPageBoundaryEntry("CROP_OFFSET", (float[])this.pageboundaries.get("CROP_OFFSET"));
        }
        if (this.pageboundaries.containsKey("BLEED")) {
            this.setPageBoundaryEntry("BLEED", (float[])this.pageboundaries.get("BLEED"));
        }
        if (this.pageboundaries.containsKey("CROP_MARK_WIDTH")) {
            this.setPageBoundaryEntry("CROP_MARK_WIDTH", (String)this.pageboundaries.get("CROP_MARK_WIDTH"));
        }
        if (this.pageboundaries.containsKey("BLEED_MARK_WIDTH")) {
            this.setPageBoundaryEntry("BLEED_MARK_WIDTH", (String)this.pageboundaries.get("BLEED_MARK_WIDTH"));
        }
        if (this.taggedPDF) {
            this.outputPDF.trailer.catalog.structTreeRoot.addNextParentTreeNode();
            this.currentPage.setStructParents(this.outputPDF.trailer.catalog.structTreeRoot.parentTreeNextKey - 1);
            if (this.getPDFVersion_minor() > 4) {
                this.currentPage.setTabOrder();
            }
        }
        if (string2 != null) {
            this.currentPage.setJSOpen(string2);
        }
        if (string3 != null) {
            this.currentPage.setJSClose(string3);
        }
    }

    public void endPage() {
        Object object;
        this.out.endText();
        this.endMarkedContent();
        this.out.println("Q");
        float[] fArray = this.currentPage.getBleeds();
        float[] fArray2 = this.currentPage.getCropOffsets();
        float f = this.currentPage.getCropMarkWidth();
        float f2 = this.currentPage.getBleedMarkWidth();
        this.save();
        this.outputPDF.println(PDFOutputStream.pdf_float(-fArray2[0]) + " " + PDFOutputStream.pdf_float(-fArray2[1]) + " m");
        this.outputPDF.println(PDFOutputStream.pdf_float(-fArray2[0]) + " " + PDFOutputStream.pdf_float(this.currentPage.height + fArray2[3]) + " l");
        this.outputPDF.println(PDFOutputStream.pdf_float(this.currentPage.width + fArray2[2]) + " " + PDFOutputStream.pdf_float(this.currentPage.height + fArray2[3]) + " l");
        this.outputPDF.println(PDFOutputStream.pdf_float(this.currentPage.width + fArray2[2]) + " " + PDFOutputStream.pdf_float(-fArray2[1]) + " l");
        this.outputPDF.println("h");
        this.outputPDF.println(PDFOutputStream.pdf_float(-fArray[0]) + " " + PDFOutputStream.pdf_float(-fArray[1]) + " m");
        this.outputPDF.println(PDFOutputStream.pdf_float(this.currentPage.width + fArray[2]) + " " + PDFOutputStream.pdf_float(-fArray[1]) + " l");
        this.outputPDF.println(PDFOutputStream.pdf_float(this.currentPage.width + fArray[2]) + " " + PDFOutputStream.pdf_float(this.currentPage.height + fArray[3]) + " l");
        this.outputPDF.println(PDFOutputStream.pdf_float(-fArray[0]) + " " + PDFOutputStream.pdf_float(this.currentPage.height + fArray[3]) + " l");
        this.outputPDF.println("h");
        this.outputPDF.println("W n");
        if (f != 0.0f || f2 != 0.0f) {
            if (f != 0.0f) {
                object = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                this.drawMarks(fArray2, (float[])object, f, this.currentPage.width, this.currentPage.height);
            }
            if (f2 != 0.0f) {
                this.drawMarks(fArray2, fArray, f2, this.currentPage.width, this.currentPage.height);
            }
        }
        object = this.printermarks.elements();
        if (!this.currentPage.printermarks.isEmpty()) {
            object = this.currentPage.printermarks.elements();
        }
        while (object.hasMoreElements()) {
            String string;
            String string2 = (String)object.nextElement();
            XMLReader xMLReader = null;
            try {
                xMLReader = XMLReaderFactory.createXMLReader();
            }
            catch (SAXException sAXException) {
                this.errorHandler.error("Cannot create XML reader: " + sAXException.getMessage());
                continue;
            }
            StringWriter stringWriter = new StringWriter();
            Base64OutputStream base64OutputStream = new Base64OutputStream(stringWriter);
            try {
                string = PDFOutputStream.pdf_float(this.currentPage.width + fArray2[0] + fArray2[2]) + "pt";
                String string3 = PDFOutputStream.pdf_float(this.currentPage.height + fArray2[1] + fArray2[3]) + "pt";
                xMLReader.setContentHandler(new ImageSizeSetterHandler(new Serializer(base64OutputStream), string, string3));
            }
            catch (IOException iOException) {
                this.errorHandler.error("Cannot constructs serializer from an output stream: " + iOException.getMessage());
                continue;
            }
            stringWriter.write("data:image/svg+xml;base64,");
            try {
                xMLReader.parse(string2);
                ((OutputStream)base64OutputStream).close();
                stringWriter.close();
            }
            catch (IOException iOException) {
                this.errorHandler.warning("Invalid URL or non-existent file: " + string2 + "; setting ignored");
                continue;
            }
            catch (SAXException sAXException) {
                this.errorHandler.error("Cannot parse a document: " + sAXException.getMessage());
                continue;
            }
            string = stringWriter.toString();
            try {
                this.startArtifactMarkedContent("Page");
                this.save();
                this.transform(1.0f, 0.0f, 0.0f, 1.0f, -fArray2[0], -fArray2[1]);
                this.placeImage(new URLSpec(string), "image/svg+xml");
                this.restore();
                this.endArtifactMarkedContent();
            }
            catch (MalformedURLException malformedURLException) {
                this.errorHandler.warning("Invalid URL or non-existent file: " + string);
            }
            catch (PDFExternalFileException pDFExternalFileException) {
                this.errorHandler.warning("Cannot insert image: " + pDFExternalFileException.getMessage());
            }
        }
        this.restore();
        this.outputPDF.endStream();
        this.outputPDF.trailer.catalog.pages.addPage(this.currentPage);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</page>");
        }
        this.currentColorSpace = null;
        this.currentResources = null;
        this.currentPage = null;
        this.currentPageBoundaries = this.pageboundaries;
        this.currentPrinterMarks = this.printermarks;
        this.out.matrix = PDFOutputStream.identity_matrix;
    }

    public void drawMarks(float[] fArray, float[] fArray2, float f, float f2, float f3) {
        this.startArtifactMarkedContent("Page");
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(-fArray2[0], -fArray2[1]);
        this.lineTo(-fArray[0], -fArray2[1]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(-fArray2[0], -fArray2[1]);
        this.lineTo(-fArray2[0], -fArray[1]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(-fArray2[0], f3 + fArray2[3]);
        this.lineTo(-fArray[0], f3 + fArray2[3]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(-fArray2[0], f3 + fArray2[3]);
        this.lineTo(-fArray2[0], f3 + fArray[3]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(f2 + fArray2[2], f3 + fArray2[3]);
        this.lineTo(f2 + fArray[2], f3 + fArray2[3]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(f2 + fArray2[2], f3 + fArray2[3]);
        this.lineTo(f2 + fArray2[2], f3 + fArray[3]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(f2 + fArray2[2], -fArray2[1]);
        this.lineTo(f2 + fArray[2], -fArray2[1]);
        this.stroke();
        this.restore();
        this.save();
        this.setCMYKColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.setLineWidth(f);
        this.moveTo(f2 + fArray2[2], -fArray2[1]);
        this.lineTo(f2 + fArray2[2], -fArray[1]);
        this.stroke();
        this.restore();
        this.endArtifactMarkedContent();
    }

    public void endDocument() {
        Object object;
        if (this.outputPDF.trailer.catalog.pages.getPagesCount() == -1) {
            this.beginPage(100.0f, 100.0f, "1");
            this.endPage();
        }
        if (this.hasPDFX() && this.outputintents.getOutputIntentsCount() == 0) {
            this.errorHandler.error("Output color profile must be present in " + this.pdfxConformanceStatus + "; PDF/X status reverted to 'none'.");
            this.pdfxConformanceStatus = "none";
        }
        if ("PDF/X-1a".equals(this.pdfxConformanceStatus)) {
            this.setInfo("GTS_PDFXVersion", "PDF/X-1:2001");
            this.setInfo("GTS_PDFXConformance", "PDF/X-1a:2001");
        }
        if ("PDF/X-3".equals(this.pdfxConformanceStatus)) {
            this.setInfo("GTS_PDFXVersion", "PDF/X-3:2001");
        }
        if (this.hasPDFA() && this.outputintents.getOutputIntentsCount() == 0) {
            this.errorHandler.error("Output color profile must be present in " + this.pdfaConformanceStatus + "; PDF/A status reverted to 'none'.");
            this.pdfaConformanceStatus = "none";
        }
        this.outputPDF.trailer.info.write(this.outputPDF);
        this.outputPDF.trailer.catalog.metadata.setKeywords(this.outputPDF.trailer.info.Keywords);
        this.outputPDF.trailer.catalog.metadata.setSubject(this.outputPDF.trailer.info.Subject);
        this.outputPDF.trailer.catalog.metadata.setTitle(this.outputPDF.trailer.info.Title);
        this.outputPDF.trailer.catalog.metadata.setCreator(this.outputPDF.trailer.info.Creator);
        this.outputPDF.trailer.catalog.metadata.setAuthor(this.outputPDF.trailer.info.Author);
        this.outputPDF.trailer.catalog.metadata.setProducer(this.outputPDF.trailer.info.Producer);
        this.outputPDF.trailer.catalog.metadata.setPublisher(this.outputPDF.trailer.info.Publisher);
        this.outputPDF.trailer.catalog.metadata.setModDate(this.outputPDF.trailer.info.ca);
        this.outputPDF.trailer.catalog.metadata.setCreationDate(this.outputPDF.trailer.info.ca);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writeimages>");
        }
        while (!(this.images.isEmpty() && this.patterns.isEmpty() && this.smasks.isEmpty())) {
            this.images.write(this.outputPDF);
            this.patterns.write(this.outputPDF);
            this.smasks.write(this.outputPDF);
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writeimages>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writemedia>");
        }
        this.media.write(this.outputPDF);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writemedia>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writeembeddedfiles>");
        }
        this.embeddedFiles.write(this.outputPDF);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writeembeddedfiles>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writefonts>");
        }
        if (this.u28.fontStateTable != null) {
            this.fonts.write(this.outputPDF, this.u28.fontStateTable);
        } else {
            this.fonts.write(this.outputPDF);
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writefonts>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writespotcolors>");
        }
        this.spotColors.write(this.outputPDF);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writespotcolors>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writeextgstates>");
        }
        this.gStates.write(this.outputPDF);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writeextgstates>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writelinks>");
        }
        this.links.write(this.outputPDF);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writelinks>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writeoutputintents>");
        }
        this.outputintents.write(this.outputPDF);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writeoutputintents>");
        }
        if (this.dropUnusedDestinations) {
            object = this.usedDestinations.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                NamedDestRecord namedDestRecord = (NamedDestRecord)this.destStorage.get(string);
                if (namedDestRecord == null) continue;
                this.addNamedDestination(string, namedDestRecord.x, namedDestRecord.y, namedDestRecord.page);
            }
        }
        object = null;
        if (this.initialDestination != null && (object = (NamedDestRecord)this.destStorage.get(this.initialDestination)) == null) {
            this.errorHandler.warning("Initial destination '" + this.initialDestination + "' not found; parameter ignored");
        }
        if (object == null && "auto".equals(this.initialZoom) && this.openActionJS != null) {
            this.outputPDF.trailer.catalog.setOpenActionJS(this.openActionJS);
        } else if (object != null || this.initialZoom != null) {
            if (object == null) {
                object = new NamedDestRecord(this.firstPage.getID(), 0.0f, this.firstPage.height);
            }
            try {
                if (this.openActionJS != null) {
                    this.errorHandler.warning("Attribute 'js-open' on the document root has been ignored due to the presence of initial-destination or initial-zoom.");
                }
                this.outputPDF.trailer.catalog.setOpenAction(((NamedDestRecord)object).page, ((NamedDestRecord)object).x, ((NamedDestRecord)object).y, this.initialZoom);
            }
            catch (PDFException pDFException) {
                this.errorHandler.warning(pDFException.getMessage() + "; parameter ignored");
            }
        }
        this.outputPDF.trailer.catalog.setMarkInfo(this.taggedPDF ? "true" : "none");
        this.outputPDF.trailer.catalog.write(this.outputPDF);
        if (this.outputPDF.trailer.catalog.outlines != null) {
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dump.println("<writeoutlines>");
            }
            this.outputPDF.trailer.catalog.outlines.finish(this.outputPDF.trailer.catalog.pages);
            this.outputPDF.trailer.catalog.outlines.write(this.outputPDF);
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dump.println("</writeoutlines>");
            }
        }
        if (this.outputPDF.trailer.catalog.names != null) {
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dump.println("<writenames>");
            }
            this.outputPDF.trailer.catalog.names.write(this.outputPDF);
            if (PDFOutputStream.dump != null) {
                PDFOutputStream.dump.println("</writenames>");
            }
        }
        if (this.taggedPDF) {
            this.outputPDF.trailer.catalog.structTreeRoot.write(this.outputPDF);
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writetail>");
        }
        this.printTail();
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writetail>");
        }
        this.outputPDF.finish();
        this.initializationFinished = false;
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</pdf>");
        }
        this.destStorage = null;
        this.usedDestinations = null;
    }

    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.out.endText();
        this.out.matrix = GraphicObject.transform(this.out.matrix, f, f2, f3, f4, f5, f6);
        this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " " + PDFOutputStream.pdf_float(f5) + " " + PDFOutputStream.pdf_float(f6) + " cm");
    }

    public void scale(float f, float f2) {
        this.transform(f, 0.0f, 0.0f, f2, 0.0f, 0.0f);
    }

    public void rotate(float f) {
        float f2;
        float f3;
        if (f == 0.0f) {
            return;
        }
        if (f == 90.0f) {
            f3 = 1.0f;
            f2 = 0.0f;
        } else if (f == 180.0f) {
            f3 = 0.0f;
            f2 = -1.0f;
        } else if (f == 270.0f) {
            f3 = -1.0f;
            f2 = 0.0f;
        } else {
            double d = (double)f * Math.PI / 180.0;
            f2 = (float)Math.cos(d);
            f3 = (float)Math.sin(d);
        }
        this.transform(f2, f3, -f3, f2, 0.0f, 0.0f);
    }

    public void translate(float f, float f2) {
        this.transform(1.0f, 0.0f, 0.0f, 1.0f, f, f2);
    }

    public void moveTo(float f, float f2) {
        this.out.endText();
        this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " m");
    }

    public void lineTo(float f, float f2) {
        this.out.endText();
        this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " l");
    }

    public void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.out.endText();
        if (f3 == f5 && f4 == f6) {
            this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f5) + " " + PDFOutputStream.pdf_float(f6) + " y");
        } else {
            this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " " + PDFOutputStream.pdf_float(f5) + " " + PDFOutputStream.pdf_float(f6) + " c");
        }
    }

    public void rectangle(float f, float f2, float f3, float f4) {
        this.out.endText();
        this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " re");
    }

    public void setFont(FontDescriptor fontDescriptor, float f) {
        this.setFont(fontDescriptor, f, this.NONE);
    }

    public void setFont(FontDescriptor fontDescriptor, float f, int n) {
        this.out.fontSize = f;
        if (f == 0.0f) {
            return;
        }
        this.fontSlant = (float)fontDescriptor.record.extraSlantAngle;
        this.out.startText();
        String string = this.fonts.getPDFFontName(fontDescriptor, n);
        if (string == null) {
            this.fonts.addFont(fontDescriptor, n, this.outputPDF.getNextID());
            string = this.fonts.getPDFFontName(fontDescriptor, n);
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<font name=\"" + string + "\"/>");
        }
        this.out.println("/" + string + " " + PDFOutputStream.pdf_float(f) + " Tf");
        this.currentResources.addFont("/" + string + " " + this.fonts.getFontOID(fontDescriptor, n).toStringR());
        if (!fontDescriptor.forceEmbedSuccess) {
            if (this.hasPDFX()) {
                this.errorHandler.error("PDF/X status reverted to 'none'.");
                this.pdfxConformanceStatus = "none";
            }
            if (this.hasPDFA()) {
                this.errorHandler.error("PDF/A status reverted to 'none'.");
                this.pdfaConformanceStatus = "none";
            }
        }
        if (this.currentAcroField != null) {
            this.outputPDF.trailer.catalog.addAcroFormFont(string, "/" + string + " " + this.fonts.getFontOID(fontDescriptor, n).toStringR());
            this.currentAcroField.addFont(string, "/" + string + " " + PDFOutputStream.pdf_float(f) + " Tf");
        }
    }

    public void resetFont() {
        this.u28.resetFont();
    }

    public void setHorzScale(float f) {
        if (f <= 0.0f) {
            this.errorHandler.warning("Wrong font stretch: " + f + "!");
            f = 1.0f;
        }
        this.hscale = f;
        this.newpos = true;
        if (this.cspace != 0.0f) {
            this.resetCharSpacing();
        }
        if (this.wspace != 0.0f) {
            this.resetWordSpacing();
        }
    }

    public void setTextPos(float f, float f2) {
        if (this.currentAcroField != null) {
            this.text_x = f + this.currentAcroField.border_width;
            this.text_y = f2 - this.currentAcroField.border_width / 2.0f;
        } else {
            this.text_x = f;
            this.text_y = f2;
        }
        this.newpos = true;
    }

    public void setCharSpacing(float f) {
        this.cspace = f;
        this.resetCharSpacing();
    }

    private void resetCharSpacing() {
        this.out.println(PDFOutputStream.pdf_float(this.cspace / this.hscale) + " Tc");
    }

    public void setWordSpacing(float f) {
        this.wspace = f;
        this.resetWordSpacing();
    }

    public void resetWordSpacing() {
        this.out.println(PDFOutputStream.pdf_float(this.wspace / this.hscale) + " Tw");
    }

    public void setFontSize(float f) {
        this.out.fontSize = f;
        this.resetFont();
    }

    public void processText(String string) throws IOException {
        this.processText(string, false);
    }

    public void processText(String string, boolean bl) throws IOException {
        if (this.currentAcroField != null && this.currentAcroField.type == 1 && (this.currentAcroField.getProperties() & 0x2000) != 0) {
            char[] cArray = new char[string.length()];
            int n = 0;
            while (n < cArray.length) {
                cArray[n] = 42;
                ++n;
            }
            this.u28.processText(new String(cArray), bl, false);
        } else {
            this.u28.processText(string, bl, false);
        }
    }

    public void selectFont(String string, int n, String string2, String string3) {
        if (this.hasPDFX() || this.hasPDFA()) {
            this.u28.selectFont(string, n, string2, string3, true);
        } else {
            this.u28.selectFont(string, n, string2, string3);
        }
    }

    public void showXY(String string, float f, float f2, float f3) {
        if (string == null || string.length() == 0 || this.out.fontSize == 0.0f) {
            return;
        }
        this.out.setTextMatrix(f3, (float)Math.tan((double)this.fontSlant * (Math.PI / 180)), f, f2);
        this.show(string);
    }

    public void show(String string) {
        if (this.out == null) {
            this.currentAcroField.caption = string;
            return;
        }
        if (string == null || string.length() == 0 || this.out.fontSize == 0.0f) {
            return;
        }
        this.out.printString(string);
        this.out.println("Tj");
    }

    public void save() {
        this.out.endText();
        this.out.println("q");
        this.out.saveState();
    }

    public void restore() {
        this.out.endText();
        this.out.println("Q");
        this.out.restoreState();
    }

    public void setBorderStyle(String string, float f) {
    }

    public void setDash(float f, float f2, float f3) {
        if ((double)f2 < 0.0 || (double)f3 < 0.0) {
            return;
        }
        if ((double)f2 == 0.0 && (double)f3 == 0.0) {
            this.out.println("[] 0 d");
        } else {
            this.out.println("[" + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + "] " + PDFOutputStream.pdf_float(f) + " d");
        }
    }

    public void setLineCap(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        this.out.println("" + n + " J");
    }

    public void setLineWidth(float f) {
        if ((double)f <= 0.0) {
            return;
        }
        this.out.println(PDFOutputStream.pdf_float(f) + " w");
    }

    private void warnAnnot(String string, String string2) {
        this.errorHandler.warning("Annotations inside page area are not allowed in " + this.pdfxConformanceStatus + "; " + string + " '" + string2 + "' removed.");
    }

    private void addLink2StructureTree(Annot annot, String string) {
        if (string == null) {
            return;
        }
        StructElem structElem = this.structelems.getStructureElement(string);
        if (structElem == null) {
            return;
        }
        this.addPDFObjectItem(annot.getID(), this.currentPage.getID(), structElem);
        this.outputPDF.trailer.catalog.structTreeRoot.addNextParentTreeNode();
        annot.setStructParent(this.outputPDF.trailer.catalog.structTreeRoot.parentTreeNextKey - 1);
        int n = annot.getStructParent();
        IndirectObject indirectObject = structElem.getID();
        this.outputPDF.trailer.catalog.structTreeRoot.addParentTreeChild(n, indirectObject);
    }

    public Image getImage(URLSpec uRLSpec, String string, String string2) {
        try {
            return this.imageFactory.makeImage(uRLSpec, string);
        }
        catch (IOException iOException) {
            this.errorHandler.exception("Failed to read " + string2 + " file: ", iOException);
        }
        catch (ImageFormatException imageFormatException) {
            this.errorHandler.exception("Cannot parse " + string2 + " file: ", imageFormatException);
        }
        catch (UnregisteredMIMETypeException unregisteredMIMETypeException) {
            this.errorHandler.error("Unknown MIME type: " + string);
        }
        return null;
    }

    private float[] getMediaRect(Image image, double d, double d2, double d3, double d4) {
        double d5 = d + image.width * d3;
        double d6 = d2 + image.height * d4;
        double[] dArray = new double[]{d, d2, d5, d6};
        double[] dArray2 = GraphicObject.transformPoint(this.out.matrix, dArray[0], dArray[1]);
        double[] dArray3 = GraphicObject.transformPoint(this.out.matrix, dArray[2], dArray[3]);
        return new float[]{(float)dArray2[0], (float)dArray2[1], (float)dArray3[0], (float)dArray3[1]};
    }

    public void placeRichMedia(float f, float f2, float f3, float f4, URLSpec uRLSpec, String string, String string2, String string3, boolean bl, String string4, String string5, int n) {
        Image image;
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<placerichmedia src=\"" + uRLSpec + "\" type=\"" + string + "\"/>");
        }
        if ((image = this.getImage(uRLSpec, string, "media")) == null) {
            return;
        }
        if (!(image instanceof com.renderx.graphics.Media)) {
            this.placeImage(image);
            return;
        }
        IndirectObject indirectObject = this.media.makeMedia(uRLSpec, string2, true, this).getID();
        IndirectObject indirectObject2 = this.outputPDF.getNextID();
        RichMediaAnnot richMediaAnnot = new RichMediaAnnot(indirectObject2, this.getMediaRect(image, f, f2, f3, f4), string2);
        RichMediaSettings richMediaSettings = new RichMediaSettings(this.outputPDF.getNextID());
        RichMediaContent richMediaContent = new RichMediaContent(this.outputPDF.getNextID());
        RichMediaConfiguration richMediaConfiguration = new RichMediaConfiguration(this.outputPDF.getNextID(), indirectObject);
        RichMediaContent.Assets assets = new RichMediaContent.Assets(this.outputPDF.getNextID());
        assets.addAsset(richMediaAnnot.fileName, indirectObject);
        richMediaContent.setAssets(assets);
        richMediaContent.setConfiguration(richMediaConfiguration);
        richMediaSettings.setConfigurationID(richMediaConfiguration.getID());
        richMediaSettings.setTransparency(bl);
        richMediaSettings.setActivation(string4);
        richMediaSettings.setDeactivation(string5);
        richMediaSettings.setPlayCount(n);
        richMediaConfiguration.setTransparency(bl);
        richMediaAnnot.setContent(richMediaContent);
        richMediaAnnot.setSettings(richMediaSettings);
        richMediaAnnot.setParentPageID(this.currentPage.getID());
        richMediaAnnot.setAnnotProperties(4);
        this.links.addLink(richMediaAnnot);
        this.currentPage.addLinkID(indirectObject2);
        this.currentRMA = richMediaAnnot;
        if (this.taggedPDF) {
            this.addLink2StructureTree(richMediaAnnot, string3);
        }
    }

    public boolean isRMA() {
        return this.currentRMA != null;
    }

    public void addFlashVar(String string, String string2, boolean bl) {
        try {
            this.currentRMA.rmc.rmconf.mp.addFlashVar(string, string2, bl);
        }
        catch (IOException iOException) {
            this.errorHandler.warning("Invalid FLASH variable : " + iOException.getMessage() + "; FLASH variable ignored");
        }
        catch (PDFException pDFException) {
            this.errorHandler.warning(pDFException.getMessage() + "; FLASH variable ignored");
        }
    }

    public void addRichMediaResource(String string, URLSpec uRLSpec) {
        if (uRLSpec.scheme == 2) {
            InputStream inputStream = null;
            try {
                inputStream = uRLSpec.openStream();
                if (inputStream == null) {
                    this.errorHandler.error("resource not found and skipped: " + uRLSpec.toString());
                    return;
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                this.errorHandler.error("resource not available and skipped: " + uRLSpec.toString() + ": " + iOException.toString());
                return;
            }
        }
        if (!this.currentRMA.rmc.getAssets().containsKey(URLUtil.urlEncode(string))) {
            this.currentRMA.rmc.assets.addAsset(string, this.media.makeMedia(uRLSpec, string, true, this).getID());
        } else {
            this.errorHandler.warning("Duplicate resource name: '" + string + "'. The resource is skipped");
        }
    }

    public void endRichMedia() {
        this.currentRMA = null;
    }

    public void endMedia() {
        this.currentMA = null;
    }

    public void placeMedia(float f, float f2, float f3, float f4, URLSpec uRLSpec, String string, boolean bl, boolean bl2, String string2, String string3, String string4, String string5, float f5, int n) {
        Image image;
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<placemedia src=\"" + uRLSpec + "\" type=\"" + string + "\"/>");
        }
        if ((image = this.getImage(uRLSpec, string, "media")) == null) {
            return;
        }
        if (!(image instanceof com.renderx.graphics.Media)) {
            this.placeImage(image);
            return;
        }
        if (uRLSpec.scheme == 1) {
            bl = true;
        }
        IndirectObject indirectObject = this.media.makeMedia(uRLSpec, this.media.makeName(uRLSpec), bl, this).getID();
        IndirectObject indirectObject2 = this.outputPDF.getNextID();
        PDFMediaAnnot pDFMediaAnnot = new PDFMediaAnnot(indirectObject2, this.getMediaRect(image, f, f2, f3, f4));
        PDFActionObject pDFActionObject = new PDFActionObject(this.outputPDF.getNextID());
        PDFRendition pDFRendition = new PDFRendition(this.outputPDF.getNextID(), bl2, string5, f5, n);
        pDFRendition.setClipData(new PDFMediaClipData(this.outputPDF.getNextID(), indirectObject, string, string2, string3));
        pDFActionObject.setRendition(pDFRendition);
        pDFActionObject.setParentAnnotID(indirectObject2);
        pDFMediaAnnot.setAction(pDFActionObject);
        pDFMediaAnnot.setParentPageID(this.currentPage.getID());
        pDFMediaAnnot.setAnnotProperties(4);
        this.links.addLink(pDFMediaAnnot);
        this.currentMA = pDFMediaAnnot;
        this.currentPage.addLinkID(indirectObject2);
        if (this.taggedPDF) {
            this.addLink2StructureTree(pDFMediaAnnot, string4);
        }
    }

    public boolean isMA() {
        return this.currentMA != null;
    }

    public void placeImage(URLSpec uRLSpec, String string) {
        Image image = this.getImage(uRLSpec, string, "image");
        this.placeImage(image);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void placeImage(Image image) {
        Object[] objectArray;
        if (image == null) {
            return;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<placeimage src=\"" + image.source + "\" type=\"" + image.mimetype + "\"/>");
        }
        if ((objectArray = this.images.getImageNameAndOID(image)) == null) {
            this.images.addImage(this.outputPDF.getNextID(), image);
            objectArray = this.images.getImageNameAndOID(image);
        }
        String string = (String)objectArray[1];
        IndirectObject indirectObject = (IndirectObject)objectArray[2];
        if (this.currentRMA == null && this.currentMA == null) {
            this.save();
            this.out.println("0 Tw 0 Tc");
            if (image instanceof BitmapImage || image instanceof EPSImage) {
                this.out.println("" + PDFOutputStream.pdf_float((float)image.width) + " 0 0 " + PDFOutputStream.pdf_float((float)image.height) + " 0 0  cm");
            }
            this.out.println("/" + string + " Do");
            this.restore();
            this.currentResources.addImage("/" + string + " " + indirectObject.toStringR());
            if (image instanceof BitmapImage) {
                short s = ((BitmapImage)image).colorSpace;
                if (s == 1 || s == 2) {
                    this.currentColorSpace.cs = s;
                }
            } else if (image instanceof VectorImage && this.currentPage != null) {
                this.currentPage.hasTransparencyGroup = true;
            }
        }
        if (this.currentRMA != null) {
            this.currentRMA.setPoster(indirectObject, string, image.mimetype);
        }
        if (this.currentMA != null) {
            this.currentMA.setPoster(indirectObject, string, image.mimetype);
        }
        if (image instanceof PDFInstance) {
            block21: {
                try {
                    PDFInstance pDFInstance = null;
                    try {
                        block20: {
                            try {
                                pDFInstance = (PDFInstance)((PDFInstance)image).clone();
                                pDFInstance.open();
                                short s = pDFInstance.getColorSpace();
                                if (s != 1 && s != 2 && s != 4) break block20;
                                this.currentColorSpace.cs = s;
                            }
                            catch (ImageFormatException imageFormatException) {
                                this.out.exception("", imageFormatException);
                                Object var9_11 = null;
                                pDFInstance.close();
                                break block21;
                            }
                            catch (IOException iOException) {
                                this.out.exception("", iOException);
                                Object var9_12 = null;
                                pDFInstance.close();
                                break block21;
                            }
                        }
                        Object var9_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        pDFInstance.close();
                        throw throwable;
                    }
                    pDFInstance.close();
                }
                catch (IOException iOException) {
                    this.out.exception("", iOException);
                }
            }
            if (this.currentPage != null) {
                this.currentPage.hasTransparencyGroup = true;
                ((PDFInstance)image).parentPages.append(new Object[]{this.currentPage, this.out.matrix});
            }
        }
    }

    public void setCMYKColor(float f, float f2, float f3, float f4) {
        this.setCMYKColorFill(f, f2, f3, f4);
        this.setCMYKColorStroke(f, f2, f3, f4);
        if (this.currentAcroField != null) {
            if (this.currentAcroField.appearanceStreams.length() > 1) {
                return;
            }
            this.currentAcroField.addColor(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " k");
            this.currentAcroField.addColor(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " K");
        }
    }

    public void setCMYKColorFill(float f, float f2, float f3, float f4) {
        this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " k");
        this.currentColorSpace.cs = (short)2;
    }

    public void setCMYKColorStroke(float f, float f2, float f3, float f4) {
        this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " " + PDFOutputStream.pdf_float(f4) + " K");
        this.currentColorSpace.cs = (short)2;
    }

    public void setRGBColor(float f, float f2, float f3) {
        this.setRGBColorFill(f, f2, f3);
        this.setRGBColorStroke(f, f2, f3);
        if (this.currentAcroField != null) {
            if (this.currentAcroField.appearanceStreams.length() > 1) {
                return;
            }
            this.currentAcroField.addColor(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " rg");
            this.currentAcroField.addColor(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " RG");
        }
    }

    public void setRGBColorFill(float f, float f2, float f3) {
        if (this.hasPDFX()) {
            float f4 = 1.0f - f;
            float f5 = 1.0f - f2;
            float f6 = 1.0f - f3;
            float f7 = 1.0f;
            if (f4 < f7) {
                f7 = f4;
            }
            if (f5 < f7) {
                f7 = f5;
            }
            if (f6 < f7) {
                f7 = f6;
            }
            if ((double)f7 != 1.0) {
                f4 = (f4 - f7) / (1.0f - f7);
                f5 = (f5 - f7) / (1.0f - f7);
                f6 = (f6 - f7) / (1.0f - f7);
            } else {
                f6 = 0.0f;
                f5 = 0.0f;
                f4 = 0.0f;
            }
            this.setCMYKColorFill(f4, f5, f6, f7);
            if (!this.forcedCMYKColorWarning) {
                this.errorHandler.warning("RGB colors are not allowed in " + this.pdfxConformanceStatus + "; RGB color converted to CMYK");
            }
            this.forcedCMYKColorWarning = true;
        } else {
            this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " rg");
            this.currentColorSpace.cs = 1;
        }
    }

    public void setRGBColorStroke(float f, float f2, float f3) {
        if (this.hasPDFX()) {
            float f4 = 1.0f - f;
            float f5 = 1.0f - f2;
            float f6 = 1.0f - f3;
            float f7 = 1.0f;
            if (f4 < f7) {
                f7 = f4;
            }
            if (f5 < f7) {
                f7 = f5;
            }
            if (f6 < f7) {
                f7 = f6;
            }
            if ((double)f7 != 1.0) {
                f4 = (f4 - f7) / (1.0f - f7);
                f5 = (f5 - f7) / (1.0f - f7);
                f6 = (f6 - f7) / (1.0f - f7);
            } else {
                f6 = 0.0f;
                f5 = 0.0f;
                f4 = 0.0f;
            }
            this.setCMYKColorStroke(f4, f5, f6, f7);
            if (!this.forcedCMYKColorWarning) {
                this.errorHandler.warning("RGB colors are not allowed in " + this.pdfxConformanceStatus + "; RGB color converted to CMYK");
            }
            this.forcedCMYKColorWarning = true;
        } else {
            this.out.println(PDFOutputStream.pdf_float(f) + " " + PDFOutputStream.pdf_float(f2) + " " + PDFOutputStream.pdf_float(f3) + " RG");
            this.currentColorSpace.cs = 1;
        }
    }

    public void setGray(float f) {
        this.setGrayStroke(f);
        this.setGrayFill(f);
        if (this.currentAcroField != null) {
            if (this.currentAcroField.appearanceStreams.length() > 1) {
                return;
            }
            this.currentAcroField.addColor(PDFOutputStream.pdf_float(f) + " g");
            this.currentAcroField.addColor(PDFOutputStream.pdf_float(f) + " G");
        }
    }

    void setGrayFill(float f) {
        this.out.println(PDFOutputStream.pdf_float(f) + " g");
    }

    void setGrayStroke(float f) {
        this.out.println(PDFOutputStream.pdf_float(f) + " G");
    }

    public void setSpotColor(float f, String string, float[] fArray) {
        this.setSpotColorFill(f, string, fArray);
        this.setSpotColorStroke(f, string, fArray);
    }

    public void setSpotColorFill(float f, String string, float[] fArray) {
        this.addSpotColor(f, string, fArray);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<spot color name=\"" + this.spotColors.getPDFSpotColorName(string, fArray) + "\"/>");
        }
        this.out.println("/" + this.spotColors.getPDFSpotColorName(string, fArray) + " cs " + PDFOutputStream.pdf_float(f) + " scn");
    }

    public void setSpotColorStroke(float f, String string, float[] fArray) {
        this.addSpotColor(f, string, fArray);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<spot color name=\"" + this.spotColors.getPDFSpotColorName(string, fArray) + "\"/>");
        }
        this.out.println("/" + this.spotColors.getPDFSpotColorName(string, fArray) + " CS " + PDFOutputStream.pdf_float(f) + " SCN");
    }

    public void addSpotColor(float f, String string, float[] fArray) {
        String string2 = this.spotColors.getPDFSpotColorName(string, fArray);
        if (string2 == null) {
            this.spotColors.addSpotColor(f, string, fArray, this.outputPDF.getNextID());
            string2 = this.spotColors.getPDFSpotColorName(string, fArray);
        }
        this.currentResources.addSpotColor("/" + string2 + " " + this.spotColors.getSpotColorOID(string, fArray).toStringR());
    }

    void setAlphaIsShape(boolean bl) {
        String string = this.gStates.getAISName(bl);
        if (string == null) {
            this.gStates.addAIS(bl, this.outputPDF.getNextID());
            string = this.gStates.getAISName(bl);
        }
        this.currentResources.addExtGState("/" + string + " " + this.gStates.getAIS_OID(bl).toStringR());
        this.out.println("/" + string + " gs");
    }

    void setOpacityFill(double d) {
        String string;
        if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4) {
            if (!this.unsupportedOpacityWarning) {
                this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support opacity; feature ignored; please set PDF 1.4.");
            }
            this.unsupportedOpacityWarning = true;
            return;
        }
        if (this.hasPDFA()) {
            this.errorHandler.error("" + this.pdfaConformanceStatus + " files may not include transparency" + "; PDF/A status reverted to 'none'.");
            this.pdfaConformanceStatus = "none";
        }
        if ((string = this.gStates.getFillOpacityName(d)) == null) {
            this.gStates.addFillOpacity(d, this.outputPDF.getNextID());
            string = this.gStates.getFillOpacityName(d);
        }
        this.currentResources.addExtGState("/" + string + " " + this.gStates.getFillOpacityOID(d).toStringR());
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<opacity value for fill=\"" + string + "\"/>");
        }
        this.out.println("/" + string + " gs");
    }

    void setOpacityStroke(double d) {
        String string;
        if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4) {
            if (!this.unsupportedOpacityWarning) {
                this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support opacity; feature ignored; please set PDF 1.4.");
            }
            this.unsupportedOpacityWarning = true;
            return;
        }
        if (this.hasPDFA()) {
            this.errorHandler.error("" + this.pdfaConformanceStatus + " files may not include transparency" + "; PDF/A status reverted to 'none'.");
            this.pdfaConformanceStatus = "none";
        }
        if ((string = this.gStates.getStrokeOpacityName(d)) == null) {
            this.gStates.addStrokeOpacity(d, this.outputPDF.getNextID());
            string = this.gStates.getStrokeOpacityName(d);
        }
        this.currentResources.addExtGState("/" + string + " " + this.gStates.getStrokeOpacityOID(d).toStringR());
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<opacity value for opacity=\"" + string + "\"/>");
        }
        this.out.println("/" + string + " gs");
    }

    public void addPattern(PaintServer paintServer) {
        String string = this.patterns.getPDFPatternName(paintServer);
        if (string == null) {
            this.patterns.addPattern(paintServer, this.outputPDF.getNextID());
            string = this.patterns.getPDFPatternName(paintServer);
        }
        this.currentResources.addPattern("/" + string + " " + this.patterns.getPatternOID(paintServer).toStringR());
    }

    void setPatternFill(PaintServer paintServer) {
        this.addPattern(paintServer);
        this.out.println("/Pattern cs /" + this.patterns.getPDFPatternName(paintServer) + " scn");
    }

    void setPatternStroke(PaintServer paintServer) {
        this.addPattern(paintServer);
        this.out.println("/Pattern CS /" + this.patterns.getPDFPatternName(paintServer) + " SCN");
    }

    SMask getSoftMask(Gradient gradient) {
        SMask sMask = this.smasks.getSMask(gradient);
        if (sMask == null) {
            sMask = new SMask(this.outputPDF.getNextID());
            this.smasks.addSMask(gradient, sMask);
            this.gStates.addSMask(sMask.getID(), this.outputPDF.getNextID());
        }
        return sMask;
    }

    void setSoftMask(Gradient gradient) {
        IndirectObject indirectObject = this.smasks.getSMask(gradient).getID();
        String string = this.gStates.getSMaskName(indirectObject);
        this.currentResources.addExtGState("/" + string + " " + this.gStates.getSMaskOID(indirectObject).toStringR());
        this.out.println("/" + string + " gs");
    }

    public void setOverprintFlag(boolean bl) {
        String string = this.gStates.getOverprintingName(bl);
        if (string == null) {
            this.gStates.addOverprinting(bl, this.outputPDF.getNextID());
            string = this.gStates.getOverprintingName(bl);
        }
        this.currentResources.addExtGState("/" + string + " " + this.gStates.getOverprintingOID(bl).toStringR());
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<overprinting flag=\"" + bl + "\"/>");
        }
        this.out.println("/" + string + " gs");
    }

    void set_fillrule(String string) {
        if (string.equals("winding")) {
            this.fillRule = this.FILL_WINDING;
        } else if (string.equals("evenodd")) {
            this.fillRule = this.FILL_EVENODD;
        }
    }

    public void clip() {
        switch (this.fillRule) {
            case 0: {
                this.out.println("W");
                break;
            }
            case 1: {
                this.out.println("W*");
                break;
            }
            default: {
                return;
            }
        }
    }

    public void endPath() {
        this.out.println("n");
    }

    public void closePath() {
        this.out.println("h");
    }

    public void fill() {
        switch (this.fillRule) {
            case 0: {
                this.out.println("f");
                break;
            }
            case 1: {
                this.out.println("f*");
                break;
            }
            default: {
                return;
            }
        }
    }

    public void stroke() {
        this.out.println("S");
    }

    public void fillStroke() {
        this.out.println("");
        switch (this.fillRule) {
            case 0: {
                this.out.println("B");
                break;
            }
            case 1: {
                this.out.println("B*");
                break;
            }
            default: {
                return;
            }
        }
    }

    public void addLocalLink(float f, float f2, float f3, float f4, int n, float f5, float f6, String string) {
        if (this.hasPDFX()) {
            this.warnAnnot("local link", string);
            return;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<locallink page=\"" + n + "\"/>");
        }
        IndirectObject indirectObject = this.outputPDF.getNextID();
        this.links.addLink(new LocalLink(indirectObject, f, f2, f3, f4, n, f5, f6, string));
        this.currentPage.addLinkID(indirectObject);
    }

    public void addLocalLink(String string, float f, float f2, float f3, float f4, String string2, String string3) {
        if (this.hasPDFX()) {
            this.warnAnnot("local link", string2);
            return;
        }
        this.markDestination(string);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<locallink dest_id=\"" + string + "\"/>");
        }
        IndirectObject indirectObject = this.outputPDF.getNextID();
        LocalLink localLink = new LocalLink(indirectObject, string, f, f2, f3, f4, string2);
        this.links.addLink(localLink);
        this.currentPage.addLinkID(indirectObject);
        if (this.taggedPDF) {
            this.addLink2StructureTree(localLink, string3);
        }
    }

    public void addPDFLink(float f, float f2, float f3, float f4, int n, String string) {
        if (this.hasPDFX()) {
            this.warnAnnot("PDF link", string);
            return;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<pdflink page=\"" + n + "\" file=\"" + string + "\"/>");
        }
        IndirectObject indirectObject = this.outputPDF.getNextID();
        PDFLink pDFLink = new PDFLink(indirectObject, f, f2, f3, f4, n, string);
        if (this.hasPDFA()) {
            pDFLink.setAnnotProperties(4);
        }
        this.links.addLink(pDFLink);
        this.currentPage.addLinkID(indirectObject);
    }

    public void addWebLink(float f, float f2, float f3, float f4, String string, boolean bl, String string2) {
        if (this.hasPDFX()) {
            this.warnAnnot("external link", string);
            return;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<weblink url=\"" + string + "\"/>");
        }
        IndirectObject indirectObject = this.outputPDF.getNextID();
        WebLink webLink = new WebLink(indirectObject, f, f2, f3, f4, 0, string, bl);
        if (this.hasPDFA()) {
            webLink.setAnnotProperties(4);
        }
        this.links.addLink(webLink);
        this.currentPage.addLinkID(indirectObject);
        if (this.taggedPDF) {
            this.addLink2StructureTree(webLink, string2);
        }
    }

    public void addTextAnnotation(float f, float f2, float f3, float f4, String string, String string2, float[] fArray) {
        if (this.hasPDFX()) {
            this.warnAnnot("text annotation", string2);
            return;
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<textannotation txt=\"" + string + "\"/>");
        }
        IndirectObject indirectObject = this.outputPDF.getNextID();
        TextAnnot textAnnot = new TextAnnot(indirectObject, f, f2, f3, f4);
        textAnnot.title = string2;
        textAnnot.contents = string;
        if (fArray != null && fArray.length == 3) {
            textAnnot.border_red = fArray[0];
            textAnnot.border_green = fArray[1];
            textAnnot.border_blue = fArray[2];
        }
        this.links.addLink(textAnnot);
        this.currentPage.addLinkID(indirectObject);
    }

    public void addPDFComment(float f, float f2, float f3, float f4, String string, String string2, float f5) {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<pdfcommentannotation txt=\"" + string + "\"/>");
        }
        if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4 && f5 != 1.0f) {
            if (!this.unsupportedOpacityWarning) {
                this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support opacity; feature ignored; please set PDF 1.4.");
            }
            this.unsupportedOpacityWarning = true;
            f5 = 1.0f;
        }
        if (this.hasPDFA()) {
            this.errorHandler.error("" + this.pdfaConformanceStatus + " files may not include transparency" + "; PDF/A status reverted to 'none'.");
            this.pdfaConformanceStatus = "none";
        }
        IndirectObject indirectObject = this.outputPDF.getNextID();
        double[] dArray = new double[]{f, f2, f3, f4};
        double[] dArray2 = GraphicObject.transformPoint(this.out.matrix, dArray[0], dArray[1]);
        double[] dArray3 = GraphicObject.transformPoint(this.out.matrix, dArray[2], dArray[3]);
        PDFComment pDFComment = new PDFComment(indirectObject, (float)dArray2[0], (float)dArray2[1], (float)dArray3[0], (float)dArray3[1]);
        pDFComment.title = string2;
        pDFComment.contents = string;
        pDFComment.setParentPageID(this.currentPage.getID());
        pDFComment.setAnnotProperties(4);
        pDFComment.setAnnotProperties(8);
        pDFComment.setAnnotProperties(16);
        pDFComment.setOpacity(f5);
        this.links.addLink(pDFComment);
        this.currentPage.addLinkID(indirectObject);
        this.currentPDFC = pDFComment;
    }

    public void addPopup(boolean bl) {
        if (this.currentPDFC != null) {
            IndirectObject indirectObject = this.outputPDF.getNextID();
            Popup popup = new Popup(indirectObject, bl, this.currentPDFC.rect);
            popup.setParentID(this.currentPDFC.getID());
            this.currentPDFC.setPopupID(popup.getID());
            popup.setAnnotProperties(8);
            popup.setAnnotProperties(16);
            this.links.addLink(popup);
            this.currentPage.addLinkID(indirectObject);
        }
    }

    public void setCommentType(String string) {
        if (this.currentPDFC != null) {
            this.currentPDFC.setSubType(string);
        }
    }

    public void setIcon(String string) {
        if (this.currentPDFC != null) {
            this.currentPDFC.setIcon(string);
        }
    }

    public boolean isPDFComment() {
        return this.currentPDFC != null;
    }

    public void setAnnotColor(float f, float f2, float f3) {
        if (this.currentPDFC != null) {
            this.currentPDFC.setColor(new float[]{f, f2, f3});
        }
    }

    public void setAnnotColor(float f, float f2, float f3, float f4) {
        float f5 = 1.0f - f4;
        float f6 = f5 > f ? f5 - f : 0.0f;
        float f7 = f5 > f2 ? f5 - f2 : 0.0f;
        float f8 = f5 > f3 ? f5 - f3 : 0.0f;
        this.setAnnotColor(f6, f7, f8);
    }

    public void addAttachedFile(URLSpec uRLSpec, String string) {
        if (this.hasPDFX()) {
            this.warnAnnot("file attachment annotation", string);
            return;
        }
        if (this.currentPDFC != null) {
            IndirectObject indirectObject = this.links.makeFileAttachment(uRLSpec, string, this).getID();
            this.currentPDFC.setFID(indirectObject);
        }
    }

    public void endPDFComment() {
        this.currentPDFC = null;
    }

    public int setFontFlag(String string, int n) {
        int n2 = 0;
        if (string.equals("italic")) {
            ++n2;
        }
        if (n >= 700) {
            n2 += 2;
        }
        return n2;
    }

    public void addLocalBookmark(String string, String string2, int n, int n2, int n3, int n4, float f, float f2, boolean bl) {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<localbookmark label=\"" + string + "\"/>");
        }
        if (this.outputPDF.trailer.catalog.outlines == null) {
            this.outputPDF.trailer.catalog.outlines = new Outlines(this.outputPDF.getNextID());
        }
        LocalBookmark localBookmark = new LocalBookmark(string, this.setFontFlag(string2, n), n2, n3, n4, f, f2, bl);
        this.outputPDF.trailer.catalog.outlines.addBookmark(localBookmark, this.outputPDF);
        this.currentB = localBookmark;
    }

    public void addLocalBookmark(String string, String string2, String string3, int n, int n2, int n3, boolean bl) {
        this.markDestination(string);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<localbookmark label=\"" + string2 + "\"/>");
        }
        if (this.outputPDF.trailer.catalog.outlines == null) {
            this.outputPDF.trailer.catalog.outlines = new Outlines(this.outputPDF.getNextID());
        }
        LocalBookmark localBookmark = new LocalBookmark(string, string2, this.setFontFlag(string3, n), n2, n3, bl);
        this.outputPDF.trailer.catalog.outlines.addBookmark(localBookmark, this.outputPDF);
        this.currentB = localBookmark;
    }

    public void addWebBookmark(String string, String string2, int n, int n2, int n3, String string3, boolean bl, boolean bl2) {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<webbookmark label=\"" + string + "\"/>");
        }
        if (this.outputPDF.trailer.catalog.outlines == null) {
            this.outputPDF.trailer.catalog.outlines = new Outlines(this.outputPDF.getNextID());
        }
        ExternalBookmark externalBookmark = new ExternalBookmark(string, this.setFontFlag(string2, n), n2, n3, string3, bl, bl2);
        this.outputPDF.trailer.catalog.outlines.addBookmark(externalBookmark, this.outputPDF);
        this.currentB = externalBookmark;
    }

    public void addPDFBookmark(String string, String string2, int n, int n2, int n3, String string3, boolean bl, boolean bl2) {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<pdfbookmark label=\"" + string + "\"/>");
        }
        if (this.outputPDF.trailer.catalog.outlines == null) {
            this.outputPDF.trailer.catalog.outlines = new Outlines(this.outputPDF.getNextID());
        }
        ExternalBookmark externalBookmark = new ExternalBookmark(string, this.setFontFlag(string2, n), n2, n3, string3, bl, bl2);
        this.outputPDF.trailer.catalog.outlines.addBookmark(externalBookmark, this.outputPDF);
        this.currentB = externalBookmark;
    }

    public void endBookmark() {
        this.currentB = null;
    }

    public boolean isBookmark() {
        return this.currentB != null;
    }

    public void setBookmarkColor(float f, float f2, float f3) {
        this.currentB.setColor(f + " " + f2 + " " + f3);
    }

    public void setBookmarkColor(float f, float f2, float f3, float f4) {
        float f5 = 1.0f - f4;
        float f6 = f5 > f ? f5 - f : 0.0f;
        float f7 = f5 > f2 ? f5 - f2 : 0.0f;
        float f8 = f5 > f3 ? f5 - f3 : 0.0f;
        this.currentB.setColor(f6 + " " + f7 + " " + f8);
    }

    public void addNamedDestination(String string, float f, float f2) {
        if (this.currentPage == null || this.currentPage.getID() == null) {
            this.errorHandler.error("Named destination cannot be added, page is not initialized!");
            return;
        }
        if (this.dropUnusedDestinations) {
            this.destStorage.put(string, new NamedDestRecord(this.currentPage.getID(), f, f2));
        } else {
            this.addNamedDestination(string, f, f2, this.currentPage.getID());
        }
    }

    public void addNamedDestination(String string, float f, float f2, IndirectObject indirectObject) {
        if (this.outputPDF.trailer.catalog.names == null) {
            this.outputPDF.trailer.catalog.names = new Names(this.outputPDF.getNextID());
        }
        if (this.outputPDF.trailer.catalog.names.dests == null) {
            this.outputPDF.trailer.catalog.names.dests = new NameTree(this.outputPDF.getNextID());
        }
        this.outputPDF.trailer.catalog.names.dests.addName(string, indirectObject, f, f2);
    }

    public void addJavaScript(String string, String string2) {
        if (this.outputPDF.trailer.catalog.names == null) {
            this.outputPDF.trailer.catalog.names = new Names(this.outputPDF.getNextID());
        }
        if (this.outputPDF.trailer.catalog.names.javascript == null) {
            this.outputPDF.trailer.catalog.names.javascript = new NameTree(this.outputPDF.getNextID());
        }
        this.outputPDF.trailer.catalog.names.javascript.addName(string, string2);
    }

    void markDestination(String string) {
        if (!this.dropUnusedDestinations) {
            return;
        }
        this.usedDestinations.put(string, string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addOutputIntent(String string) {
        try {
            URLSpec uRLSpec;
            block5: {
                uRLSpec = new URLSpec(string);
                InputStream inputStream = null;
                try {
                    inputStream = uRLSpec.openStream();
                    Object var5_6 = null;
                    if (inputStream == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            IndirectObject indirectObject = null;
            if (this.hasPDFX()) {
                indirectObject = this.outputPDF.getNextID();
                this.outputPDF.trailer.catalog.addOutputIntentID(indirectObject);
                this.outputintents.addOutputIntent(new OutputIntent(indirectObject, uRLSpec, "/GTS_PDFX"));
            }
            if (!this.hasPDFA()) return;
            indirectObject = this.outputPDF.getNextID();
            this.outputPDF.trailer.catalog.addOutputIntentID(indirectObject);
            this.outputintents.addOutputIntent(new OutputIntent(indirectObject, uRLSpec, "/GTS_PDFA1"));
            return;
        }
        catch (Exception exception) {
            String string2 = this.hasPDFX() ? "PDF/X" : (this.hasPDFA() ? "PDF/A" : null);
            this.errorHandler.error("Invalid URL or non-existent file: " + string + "; setting ignored; " + string2 + " status reverted to 'none'.");
            this.pdfxConformanceStatus = "none";
            this.pdfaConformanceStatus = "none";
        }
    }

    public void addStructElemItem(String string, String string2, int n, String string3) {
        if (!this.taggedPDF) {
            return;
        }
        String string4 = (String)RoleMap.XEPAliases.get(RoleMap.makeXEPTagName(string));
        StructElem structElem = this.structelems.getStructureElement(string3);
        if (structElem != null) {
            if (string2 != null) {
                structElem.structType = string2;
                this.addRoleMap(string2, string4);
                this.addStructAttrs(structElem, (String)RoleMap.roleMapTable.get(string), string2);
                return;
            }
            this.currentStructElem = structElem;
            return;
        }
        StructElem structElem2 = this.structelems.getParentStructureElement(string3);
        if (structElem2 != null) {
            this.currentStructElem = structElem2;
        }
        String string5 = PDFDocument.getTagMapping(string, string2);
        StructElem structElem3 = new StructElem(this.outputPDF.getNextID(), string5, this.currentStructElem);
        if (string5 != null) {
            this.addRoleMap(string5, string4);
            this.addStructAttrs(structElem3, (String)RoleMap.roleMapTable.get(string), string2);
        } else {
            structElem3.structType = string4;
            structElem3.rolledUp = true;
        }
        boolean bl = string.endsWith("table-cell");
        this.currentStructElem.addStructElemChild(structElem3, bl ? n : -1);
        this.currentStructElem = structElem3;
        this.structelems.addStructureElement(string3, structElem3);
    }

    public static String getTagMapping(String string, String string2) {
        String string3 = (String)RoleMap.roleMapTable.get(string);
        return string2 == null ? string3 : string2;
    }

    public void addStructAttrs(StructElem structElem, String string, String string2) {
        if ("TH".equals(string2)) {
            this.outputPDF.lastObjectNumber = "TH".equals(structElem.parentElem.structType) ? StructAttrs.StructTableAttrs.createStructTableAttrs(this.outputPDF.lastObjectNumber, structElem.parentElem, "Both") : StructAttrs.StructTableAttrs.createStructTableAttrs(this.outputPDF.lastObjectNumber, structElem.parentElem, "Row");
            structElem.structType = string;
        } else if ("TH".equals(string)) {
            this.outputPDF.lastObjectNumber = StructAttrs.StructTableAttrs.createStructTableAttrs(this.outputPDF.lastObjectNumber, structElem, "Column");
        }
    }

    public void addPDFObjectItem(IndirectObject indirectObject, IndirectObject indirectObject2, StructElem structElem) {
        if (!this.taggedPDF) {
            return;
        }
        structElem.addPDFObjectChild(indirectObject, indirectObject2);
    }

    public void addMarkedContentItem(int n, IndirectObject indirectObject) {
        if (!this.taggedPDF) {
            return;
        }
        this.currentStructElem.addMarkedContentChild(n, indirectObject);
    }

    public void closeStructElemItem() {
        if (!this.taggedPDF) {
            return;
        }
        this.endMarkedContent();
        this.currentStructElem = this.currentStructElem.closeStructElem();
    }

    public void setStructOptionalKey(String string, String string2) {
        if (!this.taggedPDF) {
            return;
        }
        this.currentStructElem.setOptionalKey(string, string2);
    }

    public void addRoleMap(String string, String string2) {
        if (useCustomStructureTypes) {
            if (RoleMap.standardTypes.containsKey(string)) {
                return;
            }
            this.outputPDF.trailer.catalog.structTreeRoot.roleMap.put(string, string2);
        } else if (RoleMap.XEPAliases.containsKey(string)) {
            this.outputPDF.trailer.catalog.structTreeRoot.roleMap.put(string, RoleMap.XEPAliases.get(string));
        }
    }

    public void startMarkedContent(String string) {
        if (!this.taggedPDF) {
            return;
        }
        if (this.currentPage != null) {
            if (this.printMarkedContent) {
                this.endMarkedContent();
            }
            if (!this.printMarkedContent) {
                StructElem structElem = StructElem.getStructElem(this.currentStructElem);
                if (string == null) {
                    string = structElem.structType;
                }
                if (this.out.printText) {
                    throw new RuntimeException("Text operator isn't closed while opening '" + string + "' marked-content");
                }
                this.printMarkedContent = true;
                int n = this.currentPage.getStructParents();
                this.outputPDF.trailer.catalog.structTreeRoot.addParentTreeChild(n, structElem.getID());
                this.currentPage.setMarkedContentID();
                int n2 = this.currentPage.getMarkedContentID();
                IndirectObject indirectObject = this.currentPage.getID();
                this.addMarkedContentItem(n2, indirectObject);
                this.out.println("/" + string + " <</MCID " + this.currentPage.getMarkedContentID() + ">>");
                this.out.println("BDC");
            }
        } else if (this.currentResources == null) {
            throw new RuntimeException("Marked-content sequence is within invalid content stream.");
        }
    }

    public void startArtifactMarkedContent(String string) {
        this.startArtifactMarkedContent(string, null);
    }

    public void startArtifactMarkedContent(String string, String string2) {
        if (!this.taggedPDF) {
            return;
        }
        if (this.currentPage != null) {
            if (this.printMarkedContent) {
                this.endMarkedContent();
            }
            if (!this.printMarkedContent) {
                if (this.out.printText) {
                    throw new RuntimeException("Text operator isn't closed while opening 'Artifact' marked-content");
                }
                this.printMarkedContent = true;
                this.outputPDF.trailer.catalog.structTreeRoot.addParentTreeChild(this.currentPage.getStructParents(), null);
                this.out.println("/Artifact <</Type /" + (string == null ? "Page" : string) + (string2 == null ? "" : " /Subtype /" + string2) + ">>");
                this.out.println("BDC");
            }
        } else if (this.currentResources == null) {
            throw new RuntimeException("Artifact marked-content sequence is within invalid content stream.");
        }
    }

    public void endMarkedContent() {
        if (!this.taggedPDF) {
            return;
        }
        if (this.printMarkedContent) {
            this.resetFont();
            this.out.endText();
            this.printMarkedContent = false;
            this.out.println("EMC");
        }
    }

    public void endArtifactMarkedContent() {
        this.endMarkedContent();
    }

    private AppearanceStream setAppearanceStream(float[] fArray, String string, boolean bl) {
        AppearanceStream appearanceStream = new AppearanceStream(this.outputPDF.getNextID(), fArray, this);
        appearanceStream.initiallySelected = bl;
        appearanceStream.formResources = new Resources(this.outputPDF.getNextID());
        appearanceStream.streamName = string;
        this.currentResources = appearanceStream.formResources;
        try {
            this.acroBAOS.writeTo(appearanceStream.contentStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out = appearanceStream.contentStream;
        return appearanceStream;
    }

    private void addAppearanceStream() {
        this.addAppearanceStream(true);
    }

    private void addAppearanceStream(boolean bl) {
        String string = null;
        if (0 == this.currentAcroField.appearanceStreams.length()) {
            string = this.currentAcroField.getName();
        } else if (1 == this.currentAcroField.appearanceStreams.length()) {
            string = "Off";
        } else {
            throw new PDFException("Acro Form '" + this.currentAcroField.getName() + "' has invalid appearance stream");
        }
        this.currentAcroField.appearanceStreams.append(this.setAppearanceStream(this.currentAcroField.rect, string, bl));
    }

    private void startAppearanceStream() {
        this.startAppearanceStream(true);
    }

    private void startAppearanceStream(boolean bl) {
        if ((this.currentAcroField.getAnnotProperties() & 2) == 0) {
            this.addAppearanceStream(bl);
            this.out.startMarkedText();
            this.save();
        }
    }

    private void endAppearanceStream() {
        if ((this.currentAcroField.getAnnotProperties() & 2) == 0) {
            this.restore();
            this.out.endMarkedText();
        }
    }

    private void addAcroField(AcroField acroField) {
        this.outputPDF.trailer.catalog.addAcroField(acroField);
        this.currentPage.addAcroField(acroField);
    }

    public void addAcroField(String string, float[] fArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, boolean bl5, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11) {
        float[] fArray2;
        if (fArray == null) {
            float[] fArray3 = new float[4];
            fArray3[0] = 0.0f;
            fArray3[1] = 0.0f;
            fArray3[2] = 0.0f;
            fArray2 = fArray3;
            fArray3[3] = 0.0f;
        } else {
            fArray2 = fArray;
        }
        float[] fArray4 = fArray2;
        double[] dArray = GraphicObject.transformPoint(this.out.matrix, fArray4[0], fArray4[1]);
        double[] dArray2 = GraphicObject.transformPoint(this.out.matrix, fArray4[2], fArray4[3]);
        fArray4 = new float[]{(float)dArray[0], (float)dArray[1], (float)dArray2[0], (float)dArray2[1]};
        this.currentAcroField = new AcroField.Fake(string, this.outputPDF.getNextID(), fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
        if (bl) {
            this.currentAcroField.setProperties(1);
        }
        if (bl2) {
            this.currentAcroField.setProperties(2);
        }
        if (bl3) {
            this.currentAcroField.setProperties(4);
        }
        if (bl5) {
            this.currentAcroField.setAnnotProperties(4);
        }
        if (bl4) {
            this.currentAcroField.setAnnotProperties(2);
        }
        if (n > 0) {
            this.currentAcroField.setFieldNo(n);
        }
        if (string2 != null) {
            this.currentAcroField.setAdditionalAction((short)0, string2);
        }
        if (string3 != null) {
            this.currentAcroField.setAdditionalAction((short)1, string3);
        }
        if (string4 != null) {
            this.currentAcroField.setAdditionalAction((short)2, string4);
        }
        if (string5 != null) {
            this.currentAcroField.setAdditionalAction((short)3, string5);
        }
        if (string6 != null) {
            this.currentAcroField.setAdditionalAction((short)4, string6);
        }
        if (string7 != null) {
            this.currentAcroField.setAdditionalAction((short)5, string7);
        }
        if (string8 != null) {
            this.currentAcroField.setAdditionalAction((short)6, string8);
        }
        if (string9 != null) {
            this.currentAcroField.setAdditionalAction((short)7, string9);
        }
        if (string10 != null) {
            this.currentAcroField.setAdditionalAction((short)8, string10);
        }
        if (string11 != null) {
            this.currentAcroField.setAdditionalAction((short)9, string11);
        }
        try {
            if (this.acroBAOS == null) {
                this.acroBAOS = new ByteArrayOutputStream(128);
            }
            this.out = new PDFOutputStream(this.acroBAOS, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addAcroFieldText(String string, boolean bl, boolean bl2, int n) {
        this.addAcroField(this.currentAcroField);
        AcroField.Text text = new AcroField.Text(this.currentAcroField, string, n);
        text.setAnnotProperties(this.currentAcroField.getAnnotProperties());
        text.setProperties(this.currentAcroField.getProperties());
        if (bl) {
            text.setProperties(4096);
        }
        if (bl2) {
            text.setProperties(8192);
        }
        this.currentAcroField = text;
        this.links.addLink(text);
        this.startAppearanceStream();
    }

    public void addAcroFieldCheckbox() {
        this.addAcroField(this.currentAcroField);
        AcroField.Button.Checkbox checkbox = new AcroField.Button.Checkbox(this.currentAcroField);
        checkbox.setAnnotProperties(this.currentAcroField.getAnnotProperties());
        checkbox.setProperties(this.currentAcroField.getProperties());
        this.currentAcroField = checkbox;
        this.links.addLink(checkbox);
    }

    public void addAcroFieldRadio(String string) {
        AcroField.Button.RadioGroup radioGroup = (AcroField.Button.RadioGroup)this.radioButtons.get(string);
        if (radioGroup == null) {
            boolean bl = string.endsWith("_NoToggleToOff");
            String string2 = string;
            if (bl) {
                string2 = string.substring(0, string.length() - 14);
            }
            IndirectObject indirectObject = this.currentAcroField.getID();
            this.currentAcroField.obj_id = this.outputPDF.getNextID();
            radioGroup = new AcroField.Button.RadioGroup(string2, indirectObject, this.currentAcroField.rect[0], this.currentAcroField.rect[1], this.currentAcroField.rect[2], this.currentAcroField.rect[3]);
            radioGroup.setAnnotProperties(this.currentAcroField.getAnnotProperties());
            radioGroup.setProperties(this.currentAcroField.getProperties());
            radioGroup.setProperties(32768);
            if (bl) {
                radioGroup.setProperties(16384);
            }
            this.radioButtons.put(string, radioGroup);
            this.links.addLink(radioGroup);
            this.outputPDF.trailer.catalog.addAcroField(radioGroup);
        }
        radioGroup.setAnnotProperties(this.currentAcroField.getAnnotProperties());
        radioGroup.setProperties(this.currentAcroField.getProperties());
        this.currentPage.addAcroField(this.currentAcroField);
        AcroField.Radio radio = new AcroField.Radio(this.currentAcroField, radioGroup);
        radio.setAnnotProperties(this.currentAcroField.getAnnotProperties());
        radioGroup.buttons.append(radio);
        this.currentAcroField = radio;
    }

    public void addAcroFieldResetButton(String string, List list) {
        this.addAcroField(this.currentAcroField);
        AcroField.Button.Pushbutton.Reset reset = new AcroField.Button.Pushbutton.Reset(this.currentAcroField, list);
        reset.setProperties(this.currentAcroField.getProperties());
        reset.setProperties(65536);
        this.currentAcroField = reset;
        this.links.addLink(reset);
        this.startAppearanceStream();
    }

    public void addAcroFieldSubmitButton(String string, List list, String string2, String string3, String string4, String string5) {
        this.addAcroField(this.currentAcroField);
        AcroField.Button.Pushbutton.Submit submit = new AcroField.Button.Pushbutton.Submit(this.currentAcroField, list, string2);
        submit.setProperties(this.currentAcroField.getProperties());
        submit.setProperties(65536);
        if ("true".equals(string5)) {
            submit.setSubmitActionFlags(2);
        }
        short s = (Short)AcroField.submitActions.get(string3 == null ? "FDF" : string3.toUpperCase());
        short s2 = (Short)AcroField.submitActions.get(string4 == null ? "POST" : string4.toUpperCase());
        switch (s) {
            case 3: {
                if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4) {
                    if (this.unsupportedAcroFieldSubmitFormatPDF) break;
                    this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support 'PDF' " + "as a submit format for Acro Forms; please set PDF 1.4.");
                    this.unsupportedAcroFieldSubmitFormatPDF = true;
                    break;
                }
                submit.setSubmitActionFlags(256);
                break;
            }
            case 2: {
                if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4) {
                    if (this.unsupportedAcroFieldSubmitFormatXFDF) break;
                    this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support 'XFDFD' " + "as a submit format for Acro Forms; please set PDF 1.4.");
                    this.unsupportedAcroFieldSubmitFormatXFDF = true;
                    break;
                }
                submit.setSubmitActionFlags(32);
                break;
            }
            case 1: {
                submit.setSubmitActionFlags(4);
                break;
            }
        }
        switch (s2) {
            case 1: {
                if (s != 1) break;
                submit.setSubmitActionFlags(8);
                break;
            }
        }
        this.currentAcroField = submit;
        this.links.addLink(submit);
        this.startAppearanceStream();
    }

    public void addAcroFieldChoice(short s, boolean bl, boolean bl2) {
        this.addAcroField(this.currentAcroField);
        boolean bl3 = bl;
        if (this.getPDFVersion_major() == 1 && this.getPDFVersion_minor() < 4) {
            if (!this.unsupportedAcroFieldMultiselect && bl) {
                this.errorHandler.warning("PDF version " + this.pdfVersion + " does not support multi select " + " property for Interactive (Acro) Choice fields;" + " property ignored; please set PDF 1.4.");
                this.unsupportedAcroFieldMultiselect = true;
            }
            bl3 = false;
        }
        AcroField.Choice choice = new AcroField.Choice(this.currentAcroField, bl3);
        choice.setProperties(this.currentAcroField.getProperties());
        if (4 == s) {
            choice.setProperties(131072);
            if (bl2) {
                choice.setProperties(262144);
            }
        }
        if (bl3) {
            choice.setProperties(0x200000);
        }
        choice.type = s;
        this.links.addLink(choice);
        this.currentAcroField = choice;
        if (5 == s) {
            this.startAppearanceStream();
        }
    }

    public void addAcroFieldOption(String string, boolean bl) {
        this.currentAcroField.addOption(string, bl);
        if (this.currentAcroField.type == 2 || this.currentAcroField.type == 3) {
            this.startAppearanceStream(bl);
        }
        if (this.currentAcroField.type != 4) {
            this.out.startText();
        }
        if (1 == this.currentAcroField.appearanceStreams.length()) {
            this.currentAcroField.caption = string;
        }
    }

    public void endAcroFieldOption() {
        if (this.currentAcroField.type != 4) {
            this.out.endText();
        }
        if (this.currentAcroField.type == 2 || this.currentAcroField.type == 3) {
            this.endAppearanceStream();
            try {
                this.out = null;
                if (1 == this.currentAcroField.appearanceStreams.length()) {
                    this.u28.processText(this.currentAcroField.caption, true, true);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void endAcroField() {
        if (this.currentAcroField.type != 4 && this.currentAcroField.type != 2 && this.currentAcroField.type != 3) {
            this.endAppearanceStream();
        }
        this.acroBAOS.reset();
        this.out = this.outputPDF;
        this.currentResources = this.currentPage.resources;
        this.currentAcroField = null;
    }

    public void setPDFFormFieldColor(float[] fArray) {
        this.currentAcroField.current_color = fArray;
    }

    public void setPDFFormFieldBorder(float f, String string) {
        if (this.currentAcroField.border_color != null) {
            return;
        }
        this.currentAcroField.border_style = Annot.border_styles.containsKey(string.toUpperCase()) ? (Short)Annot.border_styles.get(string.toUpperCase()) : (short)0;
        this.currentAcroField.border_width = f;
        this.currentAcroField.border_color = this.currentAcroField.current_color;
    }

    public void setPDFFormFieldBackground() {
        this.currentAcroField.background_color = this.currentAcroField.current_color;
    }

    public void printTail() {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<tail/>");
        }
        this.outputPDF.trailer.encrypt = null;
        if (this.outputPDF.getUseEncryption()) {
            this.outputPDF.trailer.encrypt = this.outputPDF.getEncryptObject();
            this.outputPDF.trailer.encrypt.write(this.outputPDF);
        }
        this.outputPDF.trailer.xref.addObjectOffset(new IndirectObject(0), 0L);
        this.outputPDF.trailer.write(this.outputPDF);
    }

    class ImageSizeSetterHandler
    implements ContentHandler {
        private final ContentHandler parent;
        private final String height;
        private final String width;
        boolean firstElement = true;

        ImageSizeSetterHandler(ContentHandler contentHandler, String string, String string2) {
            this.parent = contentHandler;
            this.height = string2;
            this.width = string;
        }

        public void startDocument() throws SAXException {
            this.parent.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.parent.startPrefixMapping("svg", "http://www.w3.org/2000/svg");
            attributesImpl.addAttribute("", "width", "width", "CDATA", this.width);
            attributesImpl.addAttribute("", "height", "height", "CDATA", this.height);
            this.parent.startElement("http://www.w3.org/2000/svg", "svg", "svg:svg", attributesImpl);
        }

        public void endDocument() throws SAXException {
            this.parent.endElement("http://www.w3.org/2000/svg", "svg", "svg:svg");
            this.parent.endPrefixMapping("svg");
            this.parent.endDocument();
        }

        public void setDocumentLocator(Locator locator) {
            this.parent.setDocumentLocator(locator);
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.parent.startPrefixMapping(string, string2);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.parent.endPrefixMapping(string);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.parent.startElement(string, string2, string3, attributes);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.parent.endElement(string, string2, string3);
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.parent.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.parent.ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.parent.processingInstruction(string, string2);
        }

        public void skippedEntity(String string) throws SAXException {
            this.parent.skippedEntity(string);
        }
    }

    protected class PDFU28
    extends U28 {
        PDFU28() {
            super(PDFDocument.this.fontCatalog);
        }

        protected void flushTextBuffer() {
            if (this.itxt == 0 && !this.forceAddFont) {
                return;
            }
            if (!this.fontSpecified) {
                if (this.isOneByteText(this.curFont.record)) {
                    PDFDocument.this.setFont(this.curFont, PDFDocument.this.out.fontSize, this.fontEncoding);
                } else {
                    PDFDocument.this.setFont(this.curFont, PDFDocument.this.out.fontSize);
                }
                this.fontSpecified = true;
            }
            String string = new String(this.txt, 0, this.itxt);
            this.itxt = 0;
            if (PDFDocument.this.newpos) {
                PDFDocument.this.showXY(string, PDFDocument.this.text_x, PDFDocument.this.text_y, PDFDocument.this.hscale);
                PDFDocument.this.newpos = false;
            } else {
                PDFDocument.this.show(string);
            }
        }

        protected boolean isOneByteText(FontRecord fontRecord) {
            switch (fontRecord.datatype) {
                case 2: {
                    return !fontRecord.embed;
                }
                case 1: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid data type in font record");
        }

        protected boolean isProcessAsUnicode(FontRecord fontRecord) {
            return false;
        }
    }

    class NamedDestRecord {
        IndirectObject page;
        float x;
        float y;

        NamedDestRecord(IndirectObject indirectObject, float f, float f2) {
            this.page = indirectObject;
            this.x = f;
            this.y = f2;
        }
    }
}

