/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.AcroField;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.Names;
import com.renderx.pdflib.Outlines;
import com.renderx.pdflib.PDFException;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Page;
import com.renderx.pdflib.Pages;
import com.renderx.pdflib.StructTreeRoot;
import com.renderx.pdflib.XMPInfo;
import com.renderx.util.Array;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import java.util.Enumeration;

public class Catalog
extends PDFObject {
    public Pages pages;
    public Outlines outlines = null;
    public Names names = null;
    public StructTreeRoot structTreeRoot = null;
    public XMPInfo metadata = null;
    List outputIntentIDs;
    List viewerPreferences;
    List acroFieldIDs;
    Array JSCalculatableIDs;
    Hashtable acroFormFonts;
    Hashtable additionalActions;
    public static final int MODE_AUTO = 0;
    public static final int MODE_OUTLINES = 1;
    public static final int MODE_THUMBNAILS = 2;
    public static final int MODE_NONE = 3;
    public static final int MODE_FULLSCREEN = 4;
    public int pageMode = 0;
    public static final int MARKED_NONE = 0;
    public static final int MARKED_FALSE = 1;
    public static final int MARKED_TRUE = 2;
    public int markInfoMode = 0;
    String language;
    String initialDestination = null;
    boolean logicalPageNumbering = true;
    public static final int LAYOUT_AUTO = 0;
    public static final int LAYOUT_SINGLE_PAGE = 1;
    public static final int LAYOUT_ONE_COLUMN = 2;
    public static final int LAYOUT_TWO_COLUMNS_LEFT = 3;
    public static final int LAYOUT_TWO_COLUMNS_RIGHT = 4;
    public static final int LAYOUT_TWO_PAGES_LEFT = 5;
    public static final int LAYOUT_TWO_PAGES_RIGHT = 6;
    public int pageLayout = 1;
    private Extensions extensions = new Extensions();
    String openActionJS = null;

    final String getType() {
        return "Catalog";
    }

    Catalog(IndirectObject indirectObject) {
        super(indirectObject);
        this.outputIntentIDs = new List();
        this.viewerPreferences = new List();
        this.acroFieldIDs = new List();
        this.acroFormFonts = new Hashtable();
        this.additionalActions = new Hashtable();
        this.JSCalculatableIDs = new Array();
    }

    void addOutputIntentID(IndirectObject indirectObject) {
        this.outputIntentIDs.append(indirectObject);
    }

    void addAcroField(AcroField acroField) {
        this.acroFieldIDs.append(acroField.getID());
        if (acroField.js_calculate != null) {
            this.JSCalculatableIDs.put(acroField.getFieldNo() - 1, acroField.getID());
        }
    }

    void addAcroFieldID(IndirectObject indirectObject) {
        this.acroFieldIDs.append(indirectObject);
    }

    void addAcroFormFont(String string, String string2) {
        if (this.acroFormFonts.containsKey(string)) {
            return;
        }
        this.acroFormFonts.put(string, string2);
    }

    void setAdditionalAction(String string, String string2) throws PDFException {
        if ("js-willclose".equals(string)) {
            this.additionalActions.put("WC", string2);
        } else if ("js-willsave".equals(string)) {
            this.additionalActions.put("WS", string2);
        } else if ("js-didsave".equals(string)) {
            this.additionalActions.put("DS", string2);
        } else if ("js-willprint".equals(string)) {
            this.additionalActions.put("WP", string2);
        } else if ("js-didprint".equals(string)) {
            this.additionalActions.put("DP", string2);
        }
    }

    void setViewMode(String string) throws PDFException {
        if ("auto".equals(string)) {
            this.pageMode = 0;
        } else if ("show-bookmarks".equals(string)) {
            this.pageMode = 1;
        } else if ("show-thumbnails".equals(string)) {
            this.pageMode = 2;
        } else if ("show-none".equals(string)) {
            this.pageMode = 3;
        } else if ("full-screen".equals(string)) {
            this.pageMode = 4;
        } else {
            throw new PDFException("Wrong value for view mode: " + string);
        }
    }

    void setOpenActionJS(String string) {
        this.openActionJS = string;
    }

    void setOpenAction(IndirectObject indirectObject, float f, float f2, String string) throws PDFException {
        if (this.openActionJS != null) {
            return;
        }
        if (string == null) {
            string = "auto";
        }
        if ("fit".equals(string = string.trim())) {
            this.initialDestination = "[" + indirectObject.toStringR() + " /Fit]";
        } else if ("fit-width".equals(string)) {
            this.initialDestination = "[" + indirectObject.toStringR() + " /FitH " + PDFOutputStream.pdf_float_coarse(f2) + "]";
        } else if ("fit-height".equals(string)) {
            this.initialDestination = "[" + indirectObject.toStringR() + " /FitV " + PDFOutputStream.pdf_float_coarse(f) + "]";
        } else {
            this.initialDestination = "[" + indirectObject.toStringR() + " /XYZ " + PDFOutputStream.pdf_float_coarse(f) + " " + PDFOutputStream.pdf_float_coarse(f2) + " 0]";
            if ("auto".equals(string)) {
                return;
            }
            float f3 = 0.0f;
            try {
                f3 = string.endsWith("%") ? Float.valueOf(string.substring(0, string.length() - 1)).floatValue() / 100.0f : Float.valueOf(string).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
                throw new PDFException("Wrong value for zoom factor: " + string);
            }
            this.initialDestination = "[" + indirectObject.toStringR() + " /XYZ " + PDFOutputStream.pdf_float_coarse(f) + " " + PDFOutputStream.pdf_float_coarse(f2) + " " + PDFOutputStream.pdf_float(f3) + "]";
        }
    }

    void setMarkInfo(String string) {
        this.markInfoMode = "true".equals(string) ? 2 : ("false".equals(string) ? 1 : 0);
    }

    void setLanguage(String string) {
        this.language = string;
    }

    void setPageNumbering(boolean bl) {
        this.logicalPageNumbering = bl;
    }

    void setPageLayout(String string) {
        if ("auto".equals(string)) {
            this.pageLayout = 0;
        } else if ("single-page".equals(string)) {
            this.pageLayout = 1;
        } else if ("continuous".equals(string)) {
            this.pageLayout = 2;
        } else if ("two-columns-left".equals(string)) {
            this.pageLayout = 3;
        } else if ("two-columns-right".equals(string)) {
            this.pageLayout = 4;
        } else if ("two-pages-left".equals(string)) {
            this.pageLayout = 5;
        } else if ("two-pages-right".equals(string)) {
            this.pageLayout = 6;
        } else {
            throw new PDFException("Wrong value for view mode: " + string);
        }
    }

    void setViewerSetting(String string) {
        if ("hide-toolbar".equals(string)) {
            this.viewerPreferences.append("HideToolbar");
        } else if ("hide-menubar".equals(string)) {
            this.viewerPreferences.append("HideMenubar");
        } else if ("hide-window-ui".equals(string)) {
            this.viewerPreferences.append("HideWindowUI");
        } else if ("fit-window".equals(string)) {
            this.viewerPreferences.append("FitWindow");
        } else if ("center-window".equals(string)) {
            this.viewerPreferences.append("CenterWindow");
        } else if ("display-document-title".equals(string)) {
            this.viewerPreferences.append("DisplayDocTitle");
        } else {
            throw new PDFException("Wrong setting for viewer preferences: " + string);
        }
    }

    void setAdobeExtension(String string, String string2) {
        this.extensions.setExtension("ADBE", string, string2);
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Pages " + this.pages.getID().toStringR());
        if (this.logicalPageNumbering) {
            pDFOutputStream.println("/PageLabels << /Nums  [");
            boolean bl = false;
            int n = 1;
            int n2 = 0;
            while (n2 <= this.pages.getPagesCount()) {
                block46: {
                    Page page = (Page)this.pages.pages.get(new Integer(n2));
                    int n3 = n2 + 1;
                    if (page.number != null) {
                        try {
                            n3 = Integer.parseInt(page.number.trim());
                            if (n3 <= 0) {
                                throw new NumberFormatException();
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            pDFOutputStream.println(" " + n2 + " <</P (" + page.number + ")>>");
                            bl = false;
                            break block46;
                        }
                    }
                    if (!bl || n != n3 - n2) {
                        bl = true;
                        n = n3 - n2;
                        pDFOutputStream.println(" " + n2 + " <</S/D" + (n3 == 1 ? "" : "/St " + n3) + ">>");
                    }
                }
                ++n2;
            }
            pDFOutputStream.println("] >>");
        }
        if (this.names != null) {
            pDFOutputStream.println("/Names " + this.names.getID().toStringR());
        }
        if (!this.viewerPreferences.isEmpty()) {
            pDFOutputStream.print("/ViewerPreferences <<");
            Enumeration enumeration = this.viewerPreferences.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                pDFOutputStream.print("/" + string + " true ");
            }
            pDFOutputStream.println(">>");
        }
        switch (this.pageLayout) {
            case 0: {
                break;
            }
            case 1: {
                pDFOutputStream.println("/PageLayout /SinglePage");
                break;
            }
            case 2: {
                pDFOutputStream.println("/PageLayout /OneColumn");
                break;
            }
            case 3: {
                pDFOutputStream.println("/PageLayout /TwoColumnLeft");
                break;
            }
            case 4: {
                pDFOutputStream.println("/PageLayout /TwoColumnRight");
                break;
            }
            case 5: {
                pDFOutputStream.println("/PageLayout /TwoPageLeft");
                break;
            }
            case 6: {
                pDFOutputStream.println("/PageLayout /TwoPageRight");
            }
        }
        if (this.pageMode == 0) {
            this.pageMode = this.outlines == null ? 3 : 1;
        }
        switch (this.pageMode) {
            case 3: {
                pDFOutputStream.println("/PageMode /UseNone");
                break;
            }
            case 1: {
                pDFOutputStream.println("/PageMode /UseOutlines");
                break;
            }
            case 2: {
                pDFOutputStream.println("/PageMode /UseThumbs");
                break;
            }
            case 4: {
                pDFOutputStream.println("/PageMode /FullScreen");
            }
        }
        if (this.outlines != null) {
            pDFOutputStream.println("/Outlines " + this.outlines.getID().toStringR());
        }
        if (this.initialDestination != null) {
            pDFOutputStream.println("/OpenAction " + this.initialDestination);
        }
        if (this.openActionJS != null) {
            pDFOutputStream.print("/OpenAction <</JS");
            pDFOutputStream.printStringPDFEncoding(this.openActionJS);
            pDFOutputStream.println("/S/JavaScript>>");
        }
        if (!this.additionalActions.isEmpty()) {
            pDFOutputStream.print("/AA <<");
            Enumeration enumeration = this.additionalActions.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.additionalActions.get(string);
                pDFOutputStream.print("/" + string + " <</JS");
                pDFOutputStream.printStringPDFEncoding(string2);
                pDFOutputStream.print("/S/JavaScript>>");
            }
            pDFOutputStream.print(">>");
        }
        if (!this.acroFieldIDs.isEmpty()) {
            pDFOutputStream.print("/AcroForm");
            pDFOutputStream.begin_dict();
            if (!this.acroFormFonts.isEmpty()) {
                pDFOutputStream.print("/DR<</Font<<");
                Enumeration enumeration = this.acroFormFonts.elements();
                while (enumeration.hasMoreElements()) {
                    pDFOutputStream.print(" " + enumeration.nextElement());
                }
                pDFOutputStream.print(">>>>");
            }
            pDFOutputStream.printVector("Fields", this.acroFieldIDs);
            if (this.JSCalculatableIDs.length() > 0) {
                pDFOutputStream.print("/CO [");
                int n = 0;
                while (n < this.JSCalculatableIDs.length()) {
                    IndirectObject indirectObject = (IndirectObject)this.JSCalculatableIDs.get(n);
                    if (indirectObject != null) {
                        pDFOutputStream.print(indirectObject.toStringR() + " ");
                    }
                    ++n;
                }
                pDFOutputStream.println("]");
            }
            pDFOutputStream.end_dict();
        }
        if (this.metadata != null) {
            pDFOutputStream.println("/Metadata " + this.metadata.getID().toStringR());
        }
        if (this.structTreeRoot != null) {
            pDFOutputStream.println("/StructTreeRoot " + this.structTreeRoot.getID().toStringR());
        }
        switch (this.markInfoMode) {
            case 2: {
                pDFOutputStream.println("/MarkInfo <</Marked true>>");
                break;
            }
            case 1: {
                pDFOutputStream.println("/MarkInfo <</Marked false>>");
                break;
            }
        }
        if (this.language != null) {
            pDFOutputStream.print("/Lang ");
            pDFOutputStream.print_annotation(this.language);
            pDFOutputStream.println();
        }
        if (!this.extensions.isEmpty()) {
            pDFOutputStream.print("/Extensions<<");
            Enumeration enumeration = this.extensions.extensions.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                List list = (List)this.extensions.extensions.get(string);
                pDFOutputStream.print("/" + string);
                pDFOutputStream.print("<</BaseVersion /" + list.car() + " /ExtensionLevel " + list.last() + ">>");
            }
            pDFOutputStream.println(">>");
        }
        pDFOutputStream.printVector("OutputIntents", this.outputIntentIDs);
        pDFOutputStream.println("\n");
    }

    void addPage(Page page) {
        this.pages.addPage(page);
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writepages>");
        }
        this.pages.write(pDFOutputStream);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writepages>");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("<writemetadata>");
        }
        this.metadata.write(pDFOutputStream);
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dump.println("</writemetadata>");
        }
    }

    private static class Extensions {
        Hashtable extensions = null;

        void setExtension(String string, String string2, String string3) {
            if (this.extensions == null) {
                this.extensions = new Hashtable();
            }
            this.extensions.put(string, new List().append(string2).append(string3));
        }

        boolean isEmpty() {
            return this.extensions == null ? true : this.extensions.isEmpty();
        }
    }
}

