/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics;

import com.renderx.graphics.BitmapImage;
import com.renderx.graphics.ImageFormatException;
import com.renderx.graphics.ObjectRecordCoordinator;
import com.renderx.util.SeekableInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOCAImage
extends BitmapImage {
    public IOCAImage() {
        this.mimetype = "application/vnd.ibm.modcap";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse() throws IOException, ImageFormatException {
        this.canCopyData = true;
        this.canExpandData = false;
        SeekableInput seekableInput = this.openSeekableImageStream();
        try {
            try {}
            catch (EOFException eOFException) {
                throw new ImageFormatException("Premature end of file or corrupt data in IOCA image " + this.toDisplayString(), this.mimetype);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            seekableInput.close();
            throw throwable;
        }
        do {
            int n = seekableInput.readUnsignedByte();
            while (n != 211) {
                n = seekableInput.readUnsignedByte();
            }
        } while (seekableInput.readUnsignedByte() != 166 || seekableInput.readUnsignedByte() != 251);
        seekableInput.skipBytes(3);
        int n = seekableInput.readUnsignedByte();
        int n2 = seekableInput.readUnsignedShort();
        int n3 = seekableInput.readUnsignedShort();
        this.pxWidth = seekableInput.readUnsignedShort();
        this.pxHeight = seekableInput.readUnsignedShort();
        switch (n) {
            case 0: {
                this.horzResolution = (double)n2 * 0.1;
                this.vertResolution = (double)n3 * 0.1;
                break;
            }
            case 1: {
                this.horzResolution = (double)n2 * 0.254;
                this.vertResolution = (double)n3 * 0.254;
                break;
            }
            default: {
                throw new ImageFormatException("Unknown UNITBASE in IOCA image " + this.toDisplayString(), this.mimetype);
            }
        }
        Object var7_7 = null;
        seekableInput.close();
        this.setDimensions();
    }

    public void copyData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws IOException {
        InputStream inputStream = this.openImageStream();
        try {
            int n;
            byte[] byArray = new byte[objectRecordCoordinator != null ? objectRecordCoordinator.getRecordLength() : 8192];
            while ((n = inputStream.read(byArray)) != -1) {
                if (objectRecordCoordinator != null) {
                    objectRecordCoordinator.beginRecord(outputStream, n);
                }
                outputStream.write(byArray, 0, n);
                if (objectRecordCoordinator == null) continue;
                objectRecordCoordinator.endRecord(outputStream, n);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    public void expandData(OutputStream outputStream, ObjectRecordCoordinator objectRecordCoordinator) throws ImageFormatException {
        throw new ImageFormatException("IOCA image '" + this.toDisplayString() + "' cannot be expanded: not yet implemented");
    }
}

