/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.crypto;

import com.renderx.crypto.CryptoException;
import com.renderx.crypto.MD5;
import com.renderx.crypto.PGPHeader;
import com.renderx.crypto.RSAPublicKey;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;

public final class PGPSignature {
    private static final byte[] PADDING = new byte[]{0, 48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
    private static final int SIGNATURE_TYPE = 2;
    private BigInteger number;
    private byte[] extra;
    private byte[] keyId;
    private int pkeAlgorithm = 1;
    private int hashAlgorithm = 1;
    private byte[] hashId;

    public PGPSignature(DataInput dataInput) throws IOException {
        int n;
        int n2;
        try {
            PGPHeader pGPHeader = new PGPHeader(dataInput);
            n2 = pGPHeader.len;
            n = pGPHeader.type;
        }
        catch (EOFException eOFException) {
            throw new EOFException("no signature");
        }
        if (n != 2) {
            throw new CryptoException("Packet is not a signature. Unknown packet type (" + n + ")");
        }
        this.read(dataInput, n2);
    }

    public void read(DataInput dataInput, int n) throws IOException {
        dataInput.readByte();
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 != 5 && n2 != 7) {
            throw new CryptoException("The length of the extra data field is incorrect.");
        }
        this.extra = new byte[n2];
        dataInput.readFully(this.extra);
        this.keyId = new byte[8];
        dataInput.readFully(this.keyId);
        this.pkeAlgorithm = dataInput.readByte();
        this.hashAlgorithm = dataInput.readByte();
        this.hashId = new byte[2];
        dataInput.readFully(this.hashId);
        this.number = PGPSignature.readMPI(dataInput);
    }

    public static BigInteger readMPI(DataInput dataInput) throws IOException {
        int n = dataInput.readShort() & 0xFFFF;
        byte[] byArray = new byte[(n + 7) / 8];
        dataInput.readFully(byArray);
        return new BigInteger(1, byArray);
    }

    public boolean check(RSAPublicKey rSAPublicKey, byte[] byArray) {
        if (byArray[0] != this.hashId[0] || byArray[1] != this.hashId[1]) {
            return false;
        }
        byte[] byArray2 = rSAPublicKey.id();
        int n = byArray2.length;
        if (n == this.keyId.length) {
            int n2 = 0;
            while (n2 < n) {
                if (byArray2[n2] != this.keyId[n2]) {
                    return false;
                }
                ++n2;
            }
        }
        BigInteger bigInteger = rSAPublicKey.encrypt(this.number);
        BigInteger bigInteger2 = PGPSignature.bigIntFromHash(rSAPublicKey, byArray);
        return bigInteger.equals(bigInteger2);
    }

    public void addExtasToHash(MD5 mD5) {
        mD5.update(this.extra);
    }

    public static BigInteger bigIntFromHash(RSAPublicKey rSAPublicKey, byte[] byArray) {
        if (byArray.length != 16) {
            throw new Error("The code for hashes of lengths other than 16 is not in place yet.");
        }
        int n = rSAPublicKey.bitLength() / 8;
        int n2 = n - (19 + byArray.length);
        byte[] byArray2 = new byte[n];
        byArray2[0] = 0;
        byArray2[1] = 1;
        int n3 = 2;
        while (n3 < n2) {
            byArray2[n3] = -1;
            ++n3;
        }
        System.arraycopy(PADDING, 0, byArray2, n2, 19);
        System.arraycopy(byArray, 0, byArray2, n2 + 19, byArray.length);
        return new BigInteger(byArray2);
    }
}

