package com.renderx.xepx.x4u.ct.charsetspanel;

import javax.swing.border.*;
import java.awt.*;
import javax.swing.*;
import org.w3c.dom.*;
import java.awt.event.*;
/**
 * @author: Roschupkin Alexander
 * @version: 1.0
 * @todo
 **/

public class CharacterMappingPanel extends JPanel
{
    private static final long serialVersionUID = -5440310225279575178L;

    // implements TableModelListener{

    Node root = null;

    JTable rangeTable = null;
    JTable mappingTable = null;

    int currentRow = 0;

    public CharacterMappingPanel(Node node)
    {
	this.root = node;
	jbInit();
    }


    private void jbInit()
    {
	this.setBorder(new TitledBorder(BorderFactory.createLineBorder(
		Color.black, 2), "Character mapping"));
	this.setLayout(new BorderLayout());// borderLayout1);
	JPanel tablePanel = new JPanel(new GridLayout(1, 1)); // Panel with
                                                                // ScrollPane
                                                                // for JTable
	JPanel commandPanel = new JPanel();
	this.add(tablePanel, BorderLayout.CENTER);
	this.add(commandPanel, BorderLayout.SOUTH);

	JScrollPane tableScrollPane = new JScrollPane();
	tablePanel.add(tableScrollPane, null);
	
	mappingTable = new JTable(new DomToTableMappingModel((Element) root, false));
	mappingTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
	mappingTable.setSelectionBackground(Color.gray);
	mappingTable.setCellSelectionEnabled(true);
	mappingTable.setColumnSelectionAllowed(true);
	tableScrollPane.getViewport().add(mappingTable, null);
	
	// Enable after others buttons are pressed
	JButton deleteButton = new JButton("Delete mapping");
	JButton addButton = new JButton("Add mapping");
	addButton.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(ActionEvent e)
	    {
		addButton_actionPerformed(e);
	    }
	});
	deleteButton.addActionListener(new java.awt.event.ActionListener()
	{
	    public void actionPerformed(ActionEvent e)
	    {
		deleteButton_actionPerformed(e);
	    }
	});

	commandPanel.add(addButton, null);
	commandPanel.add(deleteButton, null);
    }

    void addButton_actionPerformed(ActionEvent e)
    {
	DomToTableMappingModel ctm = (DomToTableMappingModel) mappingTable.getModel();
	Element ctmp = root.getOwnerDocument().createElement("character");
	ctmp.setAttribute("unicode", "");
	ctmp.setAttribute("afp", "");

	root.appendChild(ctmp);
	ctm.addRow(ctmp);
	currentRow = ctm.getRowCount() - 1;	
    }

    void deleteButton_actionPerformed(ActionEvent e)
    {
	int mrow = mappingTable.getSelectedRow();
	if (mrow < 0)
	    return; // IF table not selected !!!
	DomToTableMappingModel mtm = (DomToTableMappingModel) mappingTable.getModel();
	Node mtmp = (Element) mtm.getNodeAt(mrow);
	root.removeChild(mtmp);
	mtm.deleteRow(mrow);
	currentRow = (currentRow == 0) ? 0 : currentRow - 1;	
    }
}
