/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFConstants;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.Text;

public abstract class AbstractExtTextOut
extends EMFTag
implements EMFConstants {
    private Rectangle bounds;
    private int mode;
    private float xScale;
    private float yScale;

    protected AbstractExtTextOut(int id, int version, Rectangle bounds, int mode, float xScale, float yScale) {
        super(id, version);
        this.bounds = bounds;
        this.mode = mode;
        this.xScale = xScale;
        this.yScale = yScale;
    }

    public abstract Text getText();

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  mode: " + this.mode + "\n  xScale: " + this.xScale + "\n  yScale: " + this.yScale + "\n" + this.getText().toString();
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.mode);
        emf.writeFLOAT(this.xScale);
        emf.writeFLOAT(this.yScale);
        this.getText().write(emf);
    }

    public void render(EMFRenderer renderer) {
        Text text = this.getText();
        renderer.drawOrAppendText(text.getString(), text.getPos().getX(), text.getPos().getY());
    }
}

