/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.lib;

import com.renderx.xep.lib.Logger;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class DefaultLogger
implements Logger {
    private final PrintWriter out;
    private String indent = "";
    private boolean newline = true;

    public DefaultLogger() {
        this(new OutputStreamWriter(System.err));
    }

    public DefaultLogger(Writer writer) {
        this.out = new PrintWriter(writer, true);
    }

    public void openDocument() {
        if (!this.newline) {
            this.out.println();
        }
        this.out.print("(document ");
        this.indent = "  ";
        this.newline = false;
        this.out.flush();
    }

    public void closeDocument() {
        this.out.println(")");
        this.indent = "";
        this.newline = false;
        this.out.flush();
    }

    public void event(String string, String string2) {
        if (this.newline) {
            this.out.print(this.indent);
        }
        if ("page-number".equals(string)) {
            this.out.print("[" + string2 + "]");
        } else if ("region-name".equals(string)) {
            this.out.print("|" + string2 + "|");
        } else {
            this.out.print("[" + string + " " + string2 + "]");
        }
        this.newline = false;
        this.out.flush();
    }

    public void openState(String string) {
        if (!this.newline) {
            this.out.println();
        }
        this.out.print(this.indent + "(" + string + " ");
        this.indent = this.indent + "  ";
        this.newline = false;
        this.out.flush();
    }

    public void closeState(String string) {
        if (this.indent.length() >= 2) {
            this.indent = this.indent.substring(2);
        }
        if (this.newline) {
            this.out.print(this.indent);
        }
        this.out.print(")");
        this.newline = false;
        this.out.flush();
    }

    public void info(String string) {
        if (!this.newline) {
            this.out.println();
        }
        this.out.println(this.indent + string);
        this.newline = true;
        this.out.flush();
    }

    public void warning(String string) {
        if (!this.newline) {
            this.out.println();
        }
        this.out.println(this.indent + "[warning] " + string);
        this.newline = true;
        this.out.flush();
    }

    public void error(String string) {
        if (!this.newline) {
            this.out.println();
        }
        this.out.println(this.indent + "[error] " + string);
        this.newline = true;
        this.out.flush();
    }

    public void exception(String string, Exception exception) {
        this.error(string);
        this.error(exception.toString());
    }
}

