/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.fmt;

import com.renderx.graphics.Image;
import com.renderx.xep.cmp.Item;
import com.renderx.xep.cmp.Xattr;
import com.renderx.xep.fmt.Edge;
import com.renderx.xep.fmt.Instruction;
import com.renderx.xep.fmt.InstructionDispatcher;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.AttList;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.Attributed;

public class BPB
extends Xattr
implements Instruction {
    public int[] r;
    public Image im = null;
    public boolean draw = true;
    public boolean first;
    protected Block par = null;
    public Attr writing_mode = Attr.lr_tb;

    public void pass(InstructionDispatcher instructionDispatcher) {
        instructionDispatcher.process(this);
    }

    BPB(Attributed attributed, int[] nArray, Session session) {
        super(attributed);
        this.r = nArray;
        Attr attr = attributed.get(Attn.$background_image);
        if (attr != Attr.none) {
            this.im = session.config.imageFactory.makeImage(attr, attributed.get(Attn.$image_base_url), attributed.get(Attn.$background_content_type), session);
        }
        this.writing_mode = attributed.get(Attn.$writing_mode);
    }

    public Object clone() {
        BPB bPB = (BPB)super.clone();
        bPB.r = (int[])this.r.clone();
        return bPB;
    }

    public static class Anchor
    extends Inline {
        public Item.Id id;
        public int[] rabs;

        Anchor(Item.Anchor anchor, int[] nArray, Session session) {
            super(anchor, nArray, session);
        }
    }

    public static class Inline
    extends BPB {
        public Item.PDFFormField pdfformfield = null;

        Inline(Item.Span span, int[] nArray, Session session) {
            super(span, nArray, session);
            if (span.pdfformfield != null) {
                this.pdfformfield = span.pdfformfield;
            }
        }
    }

    public static class Table
    extends Frame {
        boolean header = false;
        boolean footer = false;
        int dyh = 0;
        int dyf = 0;

        Table(Item.Table table, int[] nArray, Session session) {
            super(table, nArray, session);
        }
    }

    public static class ListItem
    extends Block {
        Block alt = null;

        ListItem(Item.ListItem listItem, int[] nArray, Session session) {
            super(listItem, nArray, session);
        }
    }

    public static class Frame
    extends Block {
        int y0s = Integer.MAX_VALUE;
        int y0e = Integer.MAX_VALUE;
        Edge start_edge = Edge.empty;
        Edge end_edge = Edge.empty;
        public Item.PDFFormField pdfformfield = null;

        Frame(Item.Frame frame, int[] nArray, Session session) {
            super(frame, nArray, session);
            if (frame.pdfformfield != null) {
                this.pdfformfield = frame.pdfformfield;
            }
        }
    }

    public static class Block
    extends BPB {
        int r1 = Integer.MAX_VALUE;
        int margin_after;
        int shiftx = 0;
        int shifty = 0;
        Block desc = null;
        int baseline = Integer.MAX_VALUE;
        private boolean shifted = false;
        boolean first_line = false;
        public Integer bno;
        public AttList ruler = null;

        Block(Item.Block block, int[] nArray, Session session) {
            super(block, nArray, session);
            this.bno = block.bno;
            this.ruler = block.proplist.get0((short)109);
            this.margin_after = block.get(Attn.$margin_after).length();
        }

        final void shift() {
            if (!this.shifted) {
                int n = this.r1 - this.r[1];
                Attr attr = this.get(Attn.$display_align);
                if (attr != Attr.before) {
                    if (attr == Attr.center) {
                        this.shifty = -n / 2;
                    } else if (attr == Attr.after) {
                        this.shifty = -n;
                    }
                }
                if (this.par != null) {
                    int n2 = this.par.get(Attn.$reference_orientation).count();
                    switch (n2 / 90) {
                        case 0: {
                            this.shiftx += this.par.shiftx;
                            this.shifty += this.par.shifty;
                            break;
                        }
                        case 1: {
                            this.shiftx += this.par.shifty;
                            this.shifty -= this.par.shiftx;
                            break;
                        }
                        case 2: {
                            this.shiftx -= this.par.shiftx;
                            this.shifty -= this.par.shifty;
                            break;
                        }
                        case 3: {
                            this.shiftx -= this.par.shifty;
                            this.shifty += this.par.shiftx;
                            break;
                        }
                        default: {
                            throw new InternalException("illegal value of reference-orientation: " + this.par.get(Attn.$reference_orientation));
                        }
                    }
                }
                this.shifted = true;
            }
        }
    }
}

