/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.smil;

import com.renderx.smil.SMILParseException;
import java.io.PrintStream;

public abstract class SMILAttrValue {
    public static final double PIXEL_SIZE = 0.6;

    public abstract String toString();

    public abstract String getTypeName();

    public abstract void parse(String var1) throws SMILParseException;

    public class Lexer {
        public static final String blanks = " \t\r\n\f";
        public static final String token_delimiters = " \t\r\n\f'\"+()[]{},/:;";
        public static final String single_chars = "()[]{},/:;";
        public static final String quotes = "'\"";
        public static final String digits = "0123456789";
        public static final String hexdigits = "0123456789ABCDEFabcdef";
        private char[] data = null;
        private int length = 0;
        private int cursor = 0;

        public Lexer() {
        }

        public Lexer(String string) {
            this();
            this.setSource(string);
        }

        public Lexer(char[] cArray) {
            this();
            this.setSource(cArray);
        }

        public void setSource(String string) {
            this.setSource(string.toCharArray());
        }

        public void setSource(char[] cArray) {
            this.setSource(cArray, 0, cArray.length);
        }

        public void setSource(char[] cArray, int n, int n2) {
            this.data = cArray;
            this.cursor = n;
            this.length = n + n2;
        }

        private void skip_whitespace() {
            while (this.cursor < this.length) {
                if (blanks.indexOf(this.data[this.cursor]) == -1) break;
                ++this.cursor;
            }
        }

        public int nextToken(Token token) throws SMILParseException {
            token.reset();
            this.skip_whitespace();
            if (this.cursor >= this.length) {
                token.type = 1;
                return 1;
            }
            if (single_chars.indexOf(this.data[this.cursor]) != -1) {
                switch (this.data[this.cursor++]) {
                    case '(': {
                        token.type = 2;
                        return 2;
                    }
                    case ')': {
                        token.type = 3;
                        return 3;
                    }
                    case '[': {
                        token.type = 4;
                        return 4;
                    }
                    case ']': {
                        token.type = 5;
                        return 5;
                    }
                    case '{': {
                        token.type = 6;
                        return 6;
                    }
                    case '}': {
                        token.type = 7;
                        return 7;
                    }
                    case ',': {
                        token.type = 8;
                        return 8;
                    }
                    case '/': {
                        token.type = 9;
                        return 9;
                    }
                    case ':': {
                        token.type = 10;
                        return 10;
                    }
                    case ';': {
                        token.type = 11;
                        return 11;
                    }
                }
                throw new SMILParseException("Internal error: unrecognized separator character");
            }
            if (quotes.indexOf(this.data[this.cursor]) != -1) {
                char c = this.data[this.cursor];
                int n = ++this.cursor;
                do {
                    if (this.cursor != this.length) continue;
                    throw new SMILParseException("Unterminated quoted string");
                } while (this.data[this.cursor++] != c);
                token.stringValue = new String(this.data, n, this.cursor - n - 1);
                token.type = 14;
                return 14;
            }
            int n = this.cursor++;
            while (this.cursor < this.length) {
                if (token_delimiters.indexOf(this.data[this.cursor]) != -1) break;
                ++this.cursor;
            }
            if (this.data[n] == '#') {
                if (this.cursor - n == 7 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1 && hexdigits.indexOf(this.data[n + 4]) != -1 && hexdigits.indexOf(this.data[n + 5]) != -1 && hexdigits.indexOf(this.data[n + 6]) != -1) {
                    int n2 = Integer.parseInt(new String(this.data, n + 1, 2), 16);
                    int n3 = Integer.parseInt(new String(this.data, n + 3, 2), 16);
                    int n4 = Integer.parseInt(new String(this.data, n + 5, 2), 16);
                    token.numValue = (n2 << 16) + (n3 << 8) + n4;
                    token.type = 12;
                    return 12;
                }
                if (this.cursor - n == 4 && hexdigits.indexOf(this.data[n + 1]) != -1 && hexdigits.indexOf(this.data[n + 2]) != -1 && hexdigits.indexOf(this.data[n + 3]) != -1) {
                    int n5 = Integer.parseInt(new String(this.data, n + 1, 1), 16) * 17;
                    int n6 = Integer.parseInt(new String(this.data, n + 2, 1), 16) * 17;
                    int n7 = Integer.parseInt(new String(this.data, n + 3, 1), 16) * 17;
                    token.numValue = (n5 << 16) + (n6 << 8) + n7;
                    token.type = 12;
                    return 12;
                }
            }
            int n8 = n;
            int n9 = 1;
            if (this.data[n8] == '-') {
                ++n8;
                n9 = -1;
            } else if (this.data[n8] == '+') {
                ++n8;
            }
            if (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1 || n8 < this.cursor - 1 && this.data[n8] == '.' && digits.indexOf(this.data[n8 + 1]) != -1) {
                int n10;
                boolean bl = false;
                double d = 1.0;
                token.numValue = 0.0;
                while (n8 < this.cursor) {
                    if (digits.indexOf(this.data[n8]) != -1) {
                        n10 = this.data[n8] - 48;
                        if (bl) {
                            token.numValue += (d /= 10.0) * (double)n10;
                        } else {
                            token.numValue *= 10.0;
                            token.numValue += (double)n10;
                        }
                    } else {
                        if (this.data[n8] != '.' || bl) break;
                        bl = true;
                    }
                    ++n8;
                }
                token.numValue *= (double)n9;
                if (n8 < this.cursor && (this.data[n8] == 'e' || this.data[n8] == 'E') && (n8 < this.cursor - 1 && digits.indexOf(this.data[n8 + 1]) != -1 || n8 < this.cursor - 2 && (this.data[n8 + 1] == '+' || this.data[n8 + 1] == '-') && digits.indexOf(this.data[n8 + 2]) != -1)) {
                    n10 = 1;
                    if (this.data[++n8] == '-') {
                        ++n8;
                        n10 = -1;
                    } else if (this.data[n8] == '+') {
                        ++n8;
                    }
                    int n11 = 0;
                    while (n8 < this.cursor && digits.indexOf(this.data[n8]) != -1) {
                        n11 = (int)((double)n11 * 10.0);
                        n11 += this.data[n8] - 48;
                        ++n8;
                    }
                    token.numValue *= Math.pow(10.0, n11 *= n10);
                }
                if (n8 != this.cursor) {
                    token.stringValue = new String(this.data, n8, this.cursor - n8);
                }
                token.type = 15;
                return 15;
            }
            token.stringValue = new String(this.data, n, this.cursor - n);
            token.type = 13;
            return 13;
        }

        public Token getSingleToken(String string) throws SMILParseException {
            Lexer lexer = new Lexer(string);
            Token token = new Token();
            if (lexer.nextToken(token) == 1) {
                throw new SMILParseException("No meaningful data");
            }
            Token token2 = new Token();
            if (lexer.nextToken(token2) != 1) {
                throw new SMILParseException("Extra tokens in \"" + string.trim() + "\"");
            }
            return token;
        }
    }

    class Token {
        public static final int INVALID_TYPE = Integer.MIN_VALUE;
        public static final int END_OF_DATA = 1;
        public static final int LEFT_PARENTHESIS = 2;
        public static final int RIGHT_PARENTHESIS = 3;
        public static final int LEFT_BRACKET = 4;
        public static final int RIGHT_BRACKET = 5;
        public static final int LEFT_BRACE = 6;
        public static final int RIGHT_BRACE = 7;
        public static final int COMMA = 8;
        public static final int SLASH = 9;
        public static final int COLON = 10;
        public static final int SEMICOLON = 11;
        public static final int COLOR = 12;
        public static final int STRING = 13;
        public static final int QUOTED_STRING = 14;
        public static final int QUANTITY = 15;
        public int type = Integer.MIN_VALUE;
        public double numValue = Double.MIN_VALUE;
        public String stringValue = null;

        public Token() {
        }

        public Token(int n) {
            this.type = n;
        }

        public String getTypeName() {
            switch (this.type) {
                case -2147483648: {
                    return "<INVALID TYPE>";
                }
                case 1: {
                    return "<END OF DATA>";
                }
                case 3: {
                    return "RIGHT PARENTHESIS";
                }
                case 2: {
                    return "LEFT PARENTHESIS";
                }
                case 5: {
                    return "RIGHT BRACKET";
                }
                case 4: {
                    return "LEFT BRACKET";
                }
                case 7: {
                    return "RIGHT BRACE";
                }
                case 6: {
                    return "LEFT BRACE";
                }
                case 8: {
                    return "COMMA";
                }
                case 9: {
                    return "SLASH";
                }
                case 10: {
                    return "COLON";
                }
                case 11: {
                    return "SEMICOLON";
                }
                case 12: {
                    return "COLOR";
                }
                case 13: {
                    return "STRING";
                }
                case 14: {
                    return "QUOTED STRING";
                }
                case 15: {
                    return "QUANTITY";
                }
            }
            return "<BAD TOKEN TYPE - INTERNAL ERROR>";
        }

        public void dump(PrintStream printStream) {
            printStream.print(this.getTypeName());
            switch (this.type) {
                case 13: 
                case 14: {
                    printStream.print(": \"" + this.stringValue + "\"");
                    break;
                }
                case 12: {
                    printStream.print(": #" + Long.toHexString(Math.round(this.numValue)));
                    break;
                }
                case 15: {
                    printStream.print(": " + this.numValue + (this.stringValue == null ? "" : this.stringValue));
                }
            }
            printStream.println();
        }

        public void reset() {
            this.numValue = Double.MIN_VALUE;
            this.stringValue = null;
        }
    }

    public static class Length
    extends SMILAttrValue {
        public static final int ABSOLUTE = 0;
        public static final int RELATIVE_EM = 1;
        public static final int RELATIVE_EX = 2;
        public static final int RELATIVE_PERCENTS = 3;
        public double len = 0.0;
        public int base = 0;

        public Length() {
        }

        public Length(String string) throws SMILParseException {
            this.parse(string);
        }

        Length(Token token) throws SMILParseException {
            this();
            this.create(token);
        }

        public String toString() {
            switch (this.base) {
                case 0: {
                    return String.valueOf(this.len) + "pt";
                }
                case 1: {
                    return String.valueOf(this.len) + "em";
                }
                case 2: {
                    return String.valueOf(this.len) + "ex";
                }
                case 3: {
                    return String.valueOf(this.len * 100.0) + "%";
                }
            }
            return "<ERROR! INCORRECT BASE FOR LENGTH>";
        }

        public final String getTypeName() {
            return "Length";
        }

        void create(Token token) throws SMILParseException {
            if (token.type == 15) {
                this.len = token.numValue;
                if (token.stringValue == null || token.stringValue.equals("px")) {
                    this.len *= 0.6;
                } else if (token.stringValue.equals("in")) {
                    this.len *= 72.0;
                } else if (token.stringValue.equals("pc")) {
                    this.len *= 12.0;
                } else if (token.stringValue.equals("mm")) {
                    this.len *= 2.834645669291339;
                } else if (token.stringValue.equals("cm")) {
                    this.len *= 28.346456692913385;
                } else if (token.stringValue.equals("em")) {
                    this.base = 1;
                } else if (token.stringValue.equals("ex")) {
                    this.base = 2;
                } else if (token.stringValue.equals("%")) {
                    this.base = 3;
                    this.len /= 100.0;
                } else if (!token.stringValue.equals("pt")) {
                    throw new SMILParseException("Invalid length unit: " + token.stringValue);
                }
            } else {
                throw new SMILParseException("Data type mismatch: found " + token.getTypeName() + " where length is expected");
            }
        }

        public void parse(String string) throws SMILParseException {
            Lexer lexer = new Lexer();
            this.create(lexer.getSingleToken(string));
        }
    }
}

