/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.graphics.ImageFormatException;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFIndirectObject;
import com.renderx.util.Hashtable;
import com.renderx.util.SeekableInput;
import java.io.IOException;

class ParseUtils {
    ParseUtils() {
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isNumber(char c) {
        return ParseUtils.isDigit(c) || c == '.' || c == '+' || c == '-';
    }

    public static long readDigits(String string) {
        String string2 = "";
        int n = 0;
        int n2 = string.length();
        char c = string.charAt(0);
        while (n < n2 && !ParseUtils.isDigit(c)) {
            c = string.charAt(++n);
        }
        while (n < n2 && ParseUtils.isDigit(c)) {
            string2 = string2 + c;
            if (++n >= n2) continue;
            c = string.charAt(n);
        }
        return new Long(string2);
    }

    public static int getIntFromIndirectObject(PDFElement pDFElement) throws ImageFormatException {
        if (pDFElement instanceof PDFIndirectObject) {
            return ((PDFIndirectObject)pDFElement).intValue();
        }
        throw new ImageFormatException("Broken indirect object " + pDFElement.toString());
    }

    public static int getIntFromHash(Hashtable hashtable, int n) {
        return (Integer)hashtable.get(new Integer(n));
    }

    public static boolean isSpace(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c == ' ';
    }

    public static boolean isTerminal(char c) {
        return c == '}' || c == '{' || c == '%' || c == '[' || c == ']' || c == '/' || c == '(' || c == '<' || c == '>' || ParseUtils.isSpace(c);
    }

    public static byte[] getStreamData(SeekableInput seekableInput, long l, long l2) throws IOException {
        seekableInput.seek(l);
        byte[] byArray = new byte[(int)l2];
        seekableInput.readFully(byArray);
        return byArray;
    }
}

