/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.util.Base64InputStream;
import com.renderx.util.Hashtable;
import com.renderx.util.URLUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;

class RichMediaConfiguration
extends PDFObject {
    final IndirectObject media_id;
    MediaParams mp = null;
    boolean transparency = false;

    RichMediaConfiguration(IndirectObject indirectObject, IndirectObject indirectObject2) {
        super(indirectObject);
        this.media_id = indirectObject2;
        this.mp = new MediaParams();
    }

    String getType() {
        return "RichMediaConfiguration";
    }

    void setTransparency(boolean bl) {
        this.transparency = bl;
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.print("/Subtype/Flash/Instances[<<");
        pDFOutputStream.print("/Type/RichMediaInstance/Subtype/Flash");
        pDFOutputStream.print("/Asset " + this.media_id.toStringR());
        if (this.transparency) {
            pDFOutputStream.print("/Params <</Binding /Foreground /Type /RichMediaParams");
        } else {
            pDFOutputStream.print("/Params <</Binding /Background /Type /RichMediaParams");
        }
        if (!this.mp.flashVars.isEmpty()) {
            pDFOutputStream.print(" /FlashVars (");
            Enumeration enumeration = this.mp.flashVars.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                pDFOutputStream.print(URLUtil.urlEncode(string));
                pDFOutputStream.print('=');
                pDFOutputStream.print(URLUtil.urlEncode((String)this.mp.flashVars.get(string)));
                if (!enumeration.hasMoreElements()) continue;
                pDFOutputStream.print('&');
            }
            pDFOutputStream.print(") ");
        }
        pDFOutputStream.print(">>");
        pDFOutputStream.print(">>]");
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
    }

    class MediaParams {
        Hashtable flashVars = new Hashtable();

        void addFlashVar(String string, String string2, boolean bl) throws IOException {
            if (bl) {
                this.flashVars.put(string, this.decodeContent(string2));
            } else {
                this.flashVars.put(string, string2);
            }
        }

        private String decodeContent(String string) throws IOException {
            StringReader stringReader = new StringReader(string);
            Base64InputStream base64InputStream = new Base64InputStream(stringReader);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[8192];
            int n = 0;
            while ((n = base64InputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            String string2 = byteArrayOutputStream.toString();
            base64InputStream.close();
            byteArrayOutputStream.close();
            return string2;
        }
    }
}

