/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.Bookmark;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.PDFObject;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.Pages;
import com.renderx.util.Hashtable;
import java.util.Enumeration;

public class Outlines
extends PDFObject {
    IndirectObject first_id = null;
    IndirectObject last_id = null;
    int count;
    Hashtable bookmarks = new Hashtable();
    Hashtable bookmarkIDs = new Hashtable();

    Outlines(IndirectObject indirectObject) {
        super(indirectObject);
    }

    void addBookmark(Bookmark bookmark, PDFOutputStream pDFOutputStream) {
        if (this.bookmarkIDs.containsKey(new Integer(bookmark.getExternalID()))) {
            pDFOutputStream.error("Bookmark with id " + bookmark.getExternalID() + " already exists.");
            return;
        }
        bookmark.obj_id = pDFOutputStream.getNextID();
        this.bookmarkIDs.put(new Integer(bookmark.getExternalID()), "");
        if (bookmark.getExtParentID() == 0) {
            if (this.first_id == null || this.first_id.num > bookmark.getID().num) {
                this.first_id = bookmark.getID();
            }
            if (this.last_id == null || this.last_id.num < bookmark.getID().num) {
                this.last_id = bookmark.getID();
            }
            ++this.count;
            bookmark.setParentID(this.obj_id);
            this.addNext(bookmark);
        } else {
            Bookmark bookmark2 = (Bookmark)this.bookmarks.get(new Integer(bookmark.getExtParentID()));
            if (bookmark2 != null) {
                bookmark2.addBookmark(bookmark);
                this.bookmarks.put(new Integer(bookmark2.getExternalID()), bookmark2);
            } else {
                Enumeration enumeration = this.bookmarks.keys();
                while (enumeration.hasMoreElements()) {
                    Bookmark bookmark3 = (Bookmark)this.bookmarks.get(enumeration.nextElement());
                    if (!bookmark3.addBookmark(bookmark)) continue;
                    this.bookmarks.put(new Integer(bookmark3.getExternalID()), bookmark3);
                }
            }
        }
    }

    void addNext(Bookmark bookmark) {
        Enumeration enumeration = this.bookmarks.keys();
        IndirectObject indirectObject = null;
        Bookmark bookmark2 = null;
        while (enumeration.hasMoreElements() && indirectObject == null) {
            bookmark2 = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            if (bookmark2.getNextID() != null) continue;
            indirectObject = bookmark2.getID();
        }
        if (indirectObject != null && bookmark2 != null) {
            bookmark.setPrevID(indirectObject);
            bookmark2.setNextID(bookmark.getID());
            this.bookmarks.put(new Integer(bookmark2.getExternalID()), bookmark2);
        }
        this.bookmarks.put(new Integer(bookmark.getExternalID()), bookmark);
    }

    void writeBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.println("/Count " + this.count);
        pDFOutputStream.println("/First " + this.first_id.toStringR());
        pDFOutputStream.println("/Last " + this.last_id.toStringR());
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        Enumeration enumeration = this.bookmarks.keys();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            bookmark.write(pDFOutputStream);
        }
    }

    void finish(Pages pages) {
        Enumeration enumeration = this.bookmarks.keys();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)this.bookmarks.get(enumeration.nextElement());
            bookmark.finish(pages);
            this.bookmarks.put(new Integer(bookmark.getExternalID()), bookmark);
        }
    }
}

