/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.CharString;
import com.renderx.fonts.Encoding;
import com.renderx.fonts.StandardAdobeEncoding;
import com.renderx.fonts.Type1Encryption;
import com.renderx.util.Hashtable;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public final class PFxFont {
    private static final int PFB_SEGMENT_MARKER = 128;
    private static final int reexec_default = 55665;
    private boolean separated = false;
    private boolean subsetinprogress = false;
    private static int charsPerRow = 64;
    protected static final char[] hd = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public String head = "";
    public byte[] body;
    private byte[] bodye;
    public String bodytail;
    public byte[] subsetbody;
    public String tail = new String("0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000\ncleartomark");
    int privateDictLength;
    Vector subsetchars;
    Hashtable chars;

    public PFxFont(SeekableInput seekableInput) throws IOException {
        boolean bl = seekableInput.readUnsignedByte() == 128;
        seekableInput.seek(0L);
        if (bl) {
            this.PFBdecode(seekableInput);
        } else {
            this.PFAdecode(seekableInput);
        }
    }

    public void PFAdecode(SeekableInput seekableInput) throws IOException {
        int n;
        String string;
        while ((string = seekableInput.readLine()) != null && !string.startsWith("currentfile eexec")) {
            this.head = this.head + string + "\n";
        }
        if (string != null) {
            this.head = this.head + string + "\n";
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = -1;
        while ((string = seekableInput.readLine()) != null && !string.startsWith("0000000000000000000")) {
            string = string.toLowerCase();
            n = 0;
            while (n < string.length()) {
                int n3 = PFxFont.hexval(string.charAt(n));
                if (n3 != -1) {
                    if (n2 == -1) {
                        n2 = n3;
                    } else {
                        byteArrayOutputStream.write((n2 << 4) + n3);
                        n2 = -1;
                    }
                }
                ++n;
            }
        }
        this.body = byteArrayOutputStream.toByteArray();
        while ((string = seekableInput.readLine()) != null && string.startsWith("0000000000000000000")) {
        }
        n = -1;
        byte[] byArray = new byte[1024];
        byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = seekableInput.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
    }

    public void PFBdecode(SeekableInput seekableInput) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = true;
        block0: while (seekableInput.readUnsignedByte() == 128) {
            byte by = seekableInput.readByte();
            if (by == 3) break;
            int n = this.readSegmentLength(seekableInput);
            byte[] byArray = new byte[n];
            int n2 = 0;
            while (n != 0 && (n2 = seekableInput.read(byArray, 0, n)) <= n && n2 != -1) {
                if (by == 1) {
                    if (bl) {
                        bl = this.fillPFBHeader(byArray);
                    }
                } else {
                    if (by != 2) continue block0;
                    byteArrayOutputStream.write(byArray);
                }
                n -= n2;
            }
        }
        this.body = byteArrayOutputStream.toByteArray();
    }

    int readSegmentLength(SeekableInput seekableInput) throws IOException {
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        while (n3 < 4) {
            n += seekableInput.readUnsignedByte() * n2;
            n2 *= 256;
            ++n3;
        }
        return n;
    }

    boolean fillPFBHeader(byte[] byArray) throws IOException {
        boolean bl = true;
        String string = new String(byArray, "ISO-8859-1");
        int n = string.lastIndexOf("currentfile eexec");
        if (n != -1) {
            this.head = this.head + string.substring(0, n + 17) + "\n";
            bl = false;
        } else {
            this.head = this.head + string;
        }
        return bl;
    }

    void separateBody() throws IOException {
        if (this.separated) {
            return;
        }
        this.bodye = Type1Encryption.decrypt(55665, this.body);
        int n = 4;
        int n2 = 0;
        String string = "";
        boolean bl = true;
        while (n < this.bodye.length && bl) {
            int n3 = n;
            while (n3 < this.bodye.length && this.bodye[n3] != 10) {
                ++n3;
            }
            string = new String(this.bodye, n, n3 - n, "ISO-8859-1");
            if (string.indexOf("/CharStrings") != -1) {
                bl = false;
                continue;
            }
            n = n3 + 1;
        }
        if (!bl) {
            this.privateDictLength = n += string.indexOf("/CharStrings") + new String("/CharStrings").length();
        }
        n = this.skipSpace(n);
        n2 = new Integer(new String(this.bodye, n, this.skipDigits(n) - n, "ISO-8859-1"));
        n = this.skipLine(n);
        this.chars = new Hashtable();
        boolean bl2 = false;
        while (n < this.bodye.length && !bl2) {
            String string2;
            int n4;
            if (this.bodye[n = this.skipSpace(n)] == 47) {
                n4 = ++n;
                n = this.skipWord(n);
                string2 = new String(this.bodye, n4, n - n4, "ISO-8859-1");
                n4 = this.skipSpace(n);
                n = this.skipDigits(n4);
                int n5 = new Integer(new String(this.bodye, n4, n - n4, "ISO-8859-1"));
                n4 = n = this.skipSpace(n);
                n = this.skipWord(n);
                String string3 = new String(this.bodye, n4, n - n4, "ISO-8859-1");
                byte[] byArray = new byte[n5];
                System.arraycopy(this.bodye, ++n, byArray, 0, n5);
                n += n5;
                n4 = n = this.skipSpace(n);
                n = this.skipLine(n);
                String string4 = new String(this.bodye, n4, n - n4, "ISO-8859-1");
                CharString charString = new CharString(byArray, string3, string4);
                this.chars.put(string2, charString);
                continue;
            }
            if (this.bodye[n] == 37) {
                n = this.skipLine(n);
                continue;
            }
            n4 = n;
            string2 = new String(this.bodye, n4, (n = this.skipWord(n)) - n4, "ISO-8859-1");
            if (!string2.startsWith("end")) continue;
            bl2 = true;
            this.bodytail = new String(this.bodye, n4, this.bodye.length - n4, "ISO-8859-1");
        }
        this.separated = true;
    }

    public void newSubset() throws IOException {
        this.subsetchars = new Vector();
        this.subsetinprogress = true;
        this.separateBody();
    }

    public void addGlyph(String string, Encoding encoding) throws IOException {
        if (this.chars.get(string) == null) {
            throw new IOException("Wrong glyph " + string);
        }
        if (this.subsetchars.contains(string)) {
            return;
        }
        this.subsetchars.addElement(string);
        CharString charString = (CharString)this.chars.get(string);
        int[] nArray = charString.composeGlyphs();
        if (nArray != null) {
            this.addGlyph(StandardAdobeEncoding.getGlyphName(nArray[0]), encoding);
            this.addGlyph(StandardAdobeEncoding.getGlyphName(nArray[1]), encoding);
        }
    }

    public void writePFASubset(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.writePFxSubset(false));
        fileOutputStream.close();
    }

    public void writePFBSubset(String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(this.writePFxSubset(true));
        fileOutputStream.close();
    }

    public byte[] writePFASubset() throws IOException {
        return this.writePFxSubset(false);
    }

    public byte[] writePFBSubset() throws IOException {
        return this.writePFxSubset(true);
    }

    private void writeChar(String string, OutputStream outputStream) throws IOException {
        CharString charString = (CharString)this.chars.get(string);
        outputStream.write(new String("/" + string + " " + charString.encodedChar.length + " " + charString.firstDelimiter + " ").getBytes("ISO-8859-1"));
        outputStream.write(charString.encodedChar);
        outputStream.write(new String(" " + charString.secondDelimiter + "").getBytes("ISO-8859-1"));
    }

    public void endSubset() throws IOException {
        if (!this.subsetinprogress) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.bodye, 0, this.privateDictLength);
        byteArrayOutputStream.write(new String(" " + (this.subsetchars.size() + 1) + " dict dup begin\n").getBytes("ISO-8859-1"));
        Enumeration enumeration = this.subsetchars.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.writeChar(string, byteArrayOutputStream);
        }
        this.writeChar(".notdef", byteArrayOutputStream);
        byteArrayOutputStream.write(this.bodytail.getBytes("ISO-8859-1"));
        this.subsetbody = byteArrayOutputStream.toByteArray();
        Type1Encryption.encrypt(55665, this.subsetbody);
        this.subsetinprogress = false;
    }

    public byte[] writePFxSubset(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bl) {
            byteArrayOutputStream.write(128);
            byteArrayOutputStream.write(1);
            byteArrayOutputStream.write(this.int2long(this.head.length()));
        }
        byteArrayOutputStream.write(this.head.getBytes("ISO-8859-1"));
        this.endSubset();
        if (bl) {
            byteArrayOutputStream.write(128);
            byteArrayOutputStream.write(2);
            byteArrayOutputStream.write(this.int2long(this.subsetbody.length));
            byteArrayOutputStream.write(this.subsetbody);
        } else {
            PFxFont.encode(new ByteArrayInputStream(this.subsetbody), byteArrayOutputStream);
        }
        if (bl) {
            byteArrayOutputStream.write(128);
            byteArrayOutputStream.write(1);
            byteArrayOutputStream.write(this.int2long(this.tail.length()));
        }
        byteArrayOutputStream.write(this.tail.getBytes("ISO-8859-1"));
        if (bl) {
            byteArrayOutputStream.write(128);
            byteArrayOutputStream.write(3);
        }
        return byteArrayOutputStream.toByteArray();
    }

    int skipSpace(int n) throws IOException {
        while (n < this.bodye.length) {
            switch (this.bodye[n]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++n;
                    break;
                }
                case 37: {
                    n = this.skipLine(n);
                }
                default: {
                    return n;
                }
            }
        }
        if (n > this.bodye.length) {
            throw new IOException("Broken font file body");
        }
        return n;
    }

    int skipWord(int n) {
        while (n < this.body.length) {
            switch (this.bodye[n]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    int skipLine(int n) throws IOException {
        while (n < this.body.length) {
            switch (this.bodye[n]) {
                case 10: {
                    return this.skipSpace(++n);
                }
                case 13: {
                    return this.skipSpace(++n);
                }
            }
            ++n;
        }
        return n;
    }

    int skipDigits(int n) {
        while (n < this.body.length) {
            switch (this.bodye[n]) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    ++n;
                    break;
                }
                default: {
                    return n;
                }
            }
        }
        return n;
    }

    private static int hexval(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return n - 48;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return n - 97 + 10;
            }
        }
        return -1;
    }

    public static void encode(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[charsPerRow + 1];
        byte[] byArray2 = new byte[1024];
        int n2 = 0;
        while ((n = inputStream.read(byArray2)) > 0) {
            int n3 = 0;
            while (n3 < n) {
                byArray[n2++] = (byte)hd[(byArray2[n3] & 0xF0) >> 4];
                byArray[n2++] = (byte)hd[byArray2[n3] & 0xF];
                if (n2 >= charsPerRow) {
                    outputStream.write(byArray, 0, n2);
                    outputStream.write(10);
                    n2 = 0;
                }
                ++n3;
            }
            if (n2 <= 0) continue;
            outputStream.write(byArray, 0, n2);
            outputStream.write(10);
        }
    }

    byte[] int2long(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n >> 24 & 0xFF);
        byArray[2] = (byte)(n >> 16 & 0xFF);
        byArray[1] = (byte)(n >> 8 & 0xFF);
        byArray[0] = (byte)(n & 0xFF);
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        PFxFont pFxFont = new PFxFont(new SeekableFileInputStream(stringArray[0]));
        pFxFont.newSubset();
        pFxFont.writePFBSubset(stringArray[1]);
    }
}

