/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.att;

import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import com.renderx.xep.pre.att.Parsed;
import java.util.Stack;

public class BackgroundPosition
extends Attn {
    private final Parsed horz = (Parsed)Attn.$background_position_horizontal;
    private final Parsed vert = (Parsed)Attn.$background_position_vertical;

    public BackgroundPosition(String string) throws ParserException {
        super(string);
    }

    public void process(String string, ParserContext parserContext) throws ParserException {
        if (string.trim().equals("inherit")) {
            this.horz.process("inherit", parserContext);
            this.vert.process("inherit", parserContext);
            return;
        }
        Token token = null;
        Token token2 = null;
        Stack stack = AttributeParser.parseShorthand(string);
        switch (stack.size()) {
            case 1: {
                token = (Token)stack.elementAt(0);
                if (token.type != 8192) {
                    throw new ParserException("Incorrect shorthand structure: " + this.name + "=\"" + string + "\"");
                }
                this.horz.process("50%", parserContext);
                this.vert.process("50%", parserContext);
                this.processToken(token, this.horz, parserContext);
                break;
            }
            case 2: {
                token = (Token)stack.elementAt(0);
                token2 = (Token)stack.elementAt(1);
                if (token.type != 8192 || token2.type != 8192) {
                    throw new ParserException("Incorrect shorthand structure: " + this.name + "=\"" + string + "\"");
                }
                if (token.value instanceof Attr.Word != token2.value instanceof Attr.Word) {
                    throw new ParserException("Incorrect shorthand structure: " + this.name + "=\"" + string + "\"");
                }
                this.horz.process("50%", parserContext);
                this.vert.process("50%", parserContext);
                this.processToken(token, this.horz, parserContext);
                this.processToken(token2, this.vert, parserContext);
                break;
            }
            default: {
                throw new ParserException("Too many tokens in shorthand: " + this.name + "=\"" + string + "\"");
            }
        }
    }

    private void processToken(Token token, Parsed parsed, ParserContext parserContext) throws ParserException {
        if (token.value instanceof Attr.Word) {
            String string = token.value.word();
            if ("center".equals(string)) {
                return;
            }
            if ("top".equals(string)) {
                this.vert.process("0%", parserContext);
                return;
            }
            if ("bottom".equals(string)) {
                this.vert.process("100%", parserContext);
                return;
            }
            if ("left".equals(string)) {
                this.horz.process("0%", parserContext);
                return;
            }
            if ("right".equals(string)) {
                this.horz.process("100%", parserContext);
                return;
            }
            parserContext.session.warning("Ignored unexpected token in " + this.name + ": \"" + string + "\"");
        } else {
            parsed.process(token.value, parserContext);
        }
    }
}

