/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.fmt;

import com.renderx.util.Applicator;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.Stack;
import com.renderx.xep.cmp.Flow;
import com.renderx.xep.cmp.Item;
import com.renderx.xep.cmp.Xattr;
import com.renderx.xep.fmt.BPB;
import com.renderx.xep.fmt.MTF;
import com.renderx.xep.fmt.Markers;
import com.renderx.xep.fmt.TD;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.lib.Util;
import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import java.util.Enumeration;

final class LineBuffer
implements Cloneable {
    private final Session session;
    List words = new List();
    private MTF fmt;
    TD cur;
    boolean empty = true;
    boolean edge = true;
    boolean hyphenated = false;
    int width;
    int max_width;
    int height_before;
    int height_after;
    Item.Space.Inline iaccu = new Item.Space.Inline();

    LineBuffer(MTF mTF) {
        this.fmt = mTF;
        this.cur = mTF.cur;
        this.session = mTF.session;
        this.width = 0;
        this.max_width = this.cur.width;
        if (this.cur.b.bpb.first_line) {
            this.max_width -= this.cur.b.text_indent;
        }
        this.height_before = this.cur.b.tt.max_ascender + this.cur.b.tt.lea;
        this.height_after = -this.cur.b.tt.min_descender + this.cur.b.tt.lea;
        this.prolog();
    }

    LineBuffer cp(TD tD) {
        try {
            LineBuffer lineBuffer = (LineBuffer)this.clone();
            lineBuffer.words = (List)this.words.clone();
            lineBuffer.cur = tD;
            return lineBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void size(Phrase phrase, boolean bl) {
        phrase.width = this.width;
        phrase.height_before = this.height_before;
        phrase.height_after = this.height_after;
        if (bl) {
            phrase.size(this);
        } else {
            Stack stack = (Stack)this.cur.sstack.clone();
            Item.Span span = this.cur.s;
            List list = phrase.words;
            phrase.size(this);
            this.cur.sstack = stack;
            this.cur.s = span;
            phrase.words = list;
        }
    }

    void add(Phrase phrase) {
        this.empty = this.empty && phrase.empty;
        this.hyphenated = phrase.hyphenated;
        this.width = phrase.width;
        this.max_width = phrase.max_width;
        this.height_before = phrase.height_before;
        this.height_after = phrase.height_after;
        Item item = null;
        Enumeration enumeration = phrase.words.elements();
        while (enumeration.hasMoreElements()) {
            item = (Item)enumeration.nextElement();
            this.words.cons(item);
        }
    }

    void prolog() {
        if (!this.cur.sstack.isEmpty()) {
            Item item;
            Object object;
            Phrase phrase = new Phrase(this.fmt);
            int n = 0;
            Enumeration enumeration = this.cur.sstack.reverse().elements();
            Item.Span span = this.cur.s;
            this.cur.s = (Item.Span)enumeration.nextElement();
            this.cur.sstack = new Stack();
            do {
                object = enumeration.hasMoreElements() ? (Item.Span)enumeration.nextElement() : span;
                item = (Item.Span)((Xattr)object).clone();
                phrase.words.append(item);
            } while (object != span);
            this.size(phrase, true);
            this.height_before = phrase.height_before;
            this.height_after = phrase.height_after;
            object = phrase.words.elements();
            while (object.hasMoreElements()) {
                item = (Item)object.nextElement();
                if (!(item instanceof Item.Span)) continue;
                Item item2 = item;
                int n2 = ((Item.Span)item2).start_indent - n;
                ((Item.Span)item2).bpb = item2 instanceof Item.Anchor ? new BPB.Anchor((Item.Anchor)item2, new int[]{0, 0, 0, 0}, this.session) : new BPB.Inline((Item.Span)item2, new int[]{0, 0, 0, 0}, this.session);
                ((Item.Span)item2).bpb.par = this.cur.b.bpb;
                if (item2.get(Attn.$border_start_width_conditionality) == Attr.discard) {
                    n2 -= item2.get(Attn.$border_start_width_length).length();
                    ((Item.Span)item2).bpb.put(Attn.$border_start_width_length, Attr.zerolength);
                }
                if (item2.get(Attn.$padding_start_conditionality) == Attr.discard) {
                    n2 -= item2.get(Attn.$padding_start_length).length();
                    ((Item.Span)item2).bpb.put(Attn.$padding_start_length, Attr.zerolength);
                }
                if (Util.ne0(n2)) {
                    this.words.cons(new Item.Washer.Inline(n2));
                    this.width += n2;
                }
                this.words.cons(item2);
                n = ((Item.Span)item2).start_indent;
            }
        }
    }

    void epilog() {
        Object object;
        Item.Inline inline;
        if (this.hyphenated) {
            inline = (Item.Text)this.words.car();
            object = new Item.Text(inline.get(Attn.$hyphenation_character).word(), ((Item.Text)inline).a, this.session);
            if (((Item.Text)object).tt.multifont) {
                ((Item.Text)inline).tt.multifont = true;
            }
            ((Item.Text)object).tt = ((Item.Text)inline).tt;
            ((Item.Text)object).offset = ((Item.Text)inline).offset;
            this.words.cons(object);
            this.width += ((Item.Text)object).width;
        }
        if (!this.cur.sstack.isEmpty()) {
            inline = this.cur.s;
            object = this.cur.sstack.elements();
            while (object.hasMoreElements()) {
                Item.Span span = (Item.Span)object.nextElement();
                this.words.cons(Item.ends);
                int n = ((Item.Span)inline).end_indent - span.end_indent;
                if (inline.get(Attn.$border_end_width_conditionality) == Attr.discard) {
                    n -= inline.get(Attn.$border_end_width_length).length();
                    ((Item.Span)inline).bpb.put(Attn.$border_end_width_length, Attr.zerolength);
                }
                if (inline.get(Attn.$padding_end_conditionality) == Attr.discard) {
                    n -= inline.get(Attn.$padding_end_length).length();
                    ((Item.Span)inline).bpb.put(Attn.$padding_end_length, Attr.zerolength);
                }
                if (Util.ne0(n)) {
                    this.words.cons(new Item.Washer.Inline(n));
                    this.width += n;
                }
                inline = span;
            }
        }
    }

    static class Phrase
    implements Cloneable {
        private final List.Mark strmmark;
        private final boolean footnotes_pending;
        private final MTF fmt;
        private final TD cur;
        private final List topfloats;
        private final List footnotes;
        private final List bodynotes;
        private final Markers markers;
        private final Flow flow;
        private final Stack sstack;
        private final Item.Span s;
        private final Session session;
        List words = new List();
        boolean empty = true;
        boolean hyphenated = false;
        int width;
        int max_width;
        int height_before;
        int height_after;
        private static final short BASELINE = 0;
        private static final short BEFORE = 1;
        private static final short TEXT_BEFORE = 2;
        private static final short MIDDLE = 3;
        private static final short CENTRAL = 4;
        private static final short TEXT_AFTER = 5;
        private static final short AFTER = 6;
        private static final Hashtable baseline_xlat = new Hashtable();

        Phrase(MTF mTF) {
            this.fmt = mTF;
            this.cur = mTF.cur;
            this.session = mTF.session;
            this.strmmark = mTF.strm.mark();
            this.footnotes_pending = mTF.footnotes_pending;
            this.flow = this.cur.flow;
            this.sstack = (Stack)this.cur.sstack.map(new Stack(), new Applicator(this){
                private final /* synthetic */ Phrase this$0;
                {
                    this.this$0 = phrase;
                }

                public Object f(Object object) {
                    return ((Item.Span)object).clone();
                }
            });
            this.s = (Item.Span)this.cur.s.clone();
            this.topfloats = (List)mTF.bkm.topfloats.clone();
            this.footnotes = (List)mTF.bkm.footnotes.clone();
            this.bodynotes = (List)mTF.bkm.bodynotes.clone();
            this.markers = (Markers)mTF.bkm.page.markers.clone();
        }

        void restore() {
            this.fmt.strm.cut(this.strmmark);
            this.fmt.footnotes_pending = this.footnotes_pending;
            this.fmt.bkm.topfloats.clear().append(this.topfloats);
            this.fmt.bkm.footnotes.clear().append(this.footnotes);
            this.fmt.bkm.bodynotes.clear().append(this.bodynotes);
            this.fmt.bkm.page.markers.clear();
            Enumeration enumeration = this.markers.keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                this.fmt.bkm.page.markers.put(e, this.markers.get(e));
            }
            this.cur.flow = this.flow;
            this.cur.sstack = this.sstack;
            this.cur.s = this.s;
        }

        void size(LineBuffer lineBuffer) {
            List list = new List();
            Item item = null;
            Enumeration enumeration = this.words.elements();
            while (enumeration.hasMoreElements()) {
                Item item2;
                item = (Item)enumeration.nextElement();
                if (item.breaksInlineSpace()) {
                    lineBuffer.iaccu = new Item.Space.Inline();
                }
                if (item instanceof Item.Inline) {
                    item2 = (Item.Inline)item;
                    this.width += ((Item.Inline)item2).width;
                    if (((Item.Inline)item2).tt.offset == Integer.MIN_VALUE) {
                        ((Item.Inline)item2).offset = this.cur.s.offset;
                        if (item instanceof Item.Span) {
                            Attr attr = item2.get(Attn.$baseline_shift);
                            if (attr instanceof Attr.Word) {
                                if (attr == Attr.sub) {
                                    ((Item.Inline)item2).offset -= this.cur.s.tt.x_height / 2;
                                } else if (attr == Attr.supper) {
                                    ((Item.Inline)item2).offset += this.cur.s.tt.x_height;
                                } else if (attr != Attr.baseline) {
                                    throw new InternalException("illegal value for baseline-shift: " + attr.word());
                                }
                            } else {
                                ((Item.Inline)item2).offset += attr.length_or_ratio(this.cur.s.tt.line_height);
                            }
                            Attr attr2 = item2.get(Attn.$alignment_baseline);
                            if (attr2 == Attr.auto) {
                                attr2 = Attr.baseline;
                            }
                            try {
                                switch ((Short)baseline_xlat.get(attr2)) {
                                    case 0: {
                                        break;
                                    }
                                    case 1: {
                                        ((Item.Inline)item2).offset += this.cur.s.tt.max_ascender;
                                        break;
                                    }
                                    case 2: {
                                        ((Item.Inline)item2).offset += this.cur.s.tt.max_ascender;
                                        break;
                                    }
                                    case 3: {
                                        ((Item.Inline)item2).offset += this.cur.s.tt.x_height / 2;
                                        break;
                                    }
                                    case 4: {
                                        ((Item.Inline)item2).offset += (this.cur.s.tt.max_ascender + this.cur.s.tt.min_descender) / 2;
                                        break;
                                    }
                                    case 5: {
                                        ((Item.Inline)item2).offset += this.cur.s.tt.min_descender;
                                        break;
                                    }
                                    case 6: {
                                        ((Item.Inline)item2).offset += this.cur.s.tt.min_descender;
                                    }
                                }
                            }
                            catch (Exception exception) {
                                throw new InternalException("invalid baseline " + attr2);
                            }
                            Attr attr3 = item2.get(Attn.$alignment_adjust);
                            if (attr3 instanceof Attr.Word) {
                                if (attr3 == Attr.auto) {
                                    attr3 = attr2;
                                }
                                try {
                                    switch ((Short)baseline_xlat.get(attr3)) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            ((Item.Inline)item2).offset -= ((Item.Inline)item2).ascender;
                                            break;
                                        }
                                        case 2: {
                                            ((Item.Inline)item2).offset -= ((Item.Inline)item2).tt.max_ascender;
                                            break;
                                        }
                                        case 3: {
                                            ((Item.Inline)item2).offset -= ((Item.Inline)item2).tt.x_height / 2;
                                            break;
                                        }
                                        case 4: {
                                            ((Item.Inline)item2).offset -= (((Item.Inline)item2).ascender + ((Item.Inline)item2).descender) / 2;
                                            break;
                                        }
                                        case 5: {
                                            ((Item.Inline)item2).offset -= ((Item.Inline)item2).tt.min_descender;
                                            break;
                                        }
                                        case 6: {
                                            ((Item.Inline)item2).offset -= ((Item.Inline)item2).descender;
                                        }
                                    }
                                }
                                catch (Exception exception) {
                                    throw new InternalException("invalid baseline " + attr2);
                                }
                            } else {
                                ((Item.Inline)item2).offset += attr3.length_or_ratio(((Item.Inline)item2).tt.font_size);
                            }
                        }
                        ((Item.Inline)item2).tt.offset = ((Item.Inline)item2).offset;
                    } else {
                        ((Item.Inline)item2).offset = ((Item.Inline)item2).tt.offset;
                    }
                    int n = this.cur.b.consider_shifts ? ((Item.Inline)item2).offset : 0;
                    int n2 = 0;
                    int n3 = 0;
                    switch (this.cur.b.lss) {
                        case 0: {
                            n2 = this.height_before;
                            n3 = this.height_after;
                            break;
                        }
                        case 1: {
                            n2 = this.cur.s.tt.lea + ((Item.Inline)item2).tt.max_ascender + n;
                            n3 = this.cur.s.tt.lea - ((Item.Inline)item2).tt.min_descender - n;
                            break;
                        }
                        case 2: {
                            n2 = ((Item.Inline)item2).tt.lea + ((Item.Inline)item2).ascender + n;
                            n3 = ((Item.Inline)item2).tt.lea - ((Item.Inline)item2).descender - n;
                            break;
                        }
                        default: {
                            throw new InternalException("illegal value for cur.b.lss");
                        }
                    }
                    if (this.height_before < n2) {
                        this.height_before = n2;
                    }
                    if (this.height_after < n3) {
                        this.height_after = n3;
                    }
                    if (item instanceof Item.Span) {
                        int n4;
                        ((Item.Span)item).dimensions(this.cur.s, this.cur.width);
                        this.cur.sstack.push(this.cur.s);
                        Item.Span span = this.cur.s;
                        (this.cur.s = (Item.Span)item).bpb = this.cur.s instanceof Item.Anchor ? new BPB.Anchor((Item.Anchor)this.cur.s, new int[]{0, 0, 0, 0}, this.session) : new BPB.Inline(this.cur.s, new int[]{0, 0, 0, 0}, this.session);
                        this.cur.s.bpb.par = this.cur.b.bpb;
                        if (Util.ne0(this.cur.s.start_indent)) {
                            lineBuffer.iaccu = new Item.Space.Inline();
                        }
                        if (Util.ne0(n4 = this.cur.s.start_indent - span.start_indent)) {
                            list.append(new Item.Washer.Inline(n4));
                            this.width += n4;
                        }
                    }
                    list.append(item);
                    continue;
                }
                if (item instanceof Item.Washer.Inline) {
                    this.width += ((Item.Washer.Inline)item).thickness;
                    list.append(item);
                    continue;
                }
                if (item instanceof Item.Space.Inline) {
                    item2 = (Item.Space.Inline)item;
                    if (!Util.ne0(((Item.Space.Inline)item2).optimum) && ((Item.Space.Inline)item2).precedence == 0) continue;
                    Item.Space.Inline inline = (Item.Space.Inline)lineBuffer.iaccu.merge((Item.Space)item2);
                    this.width += inline.optimum;
                    list.append(inline);
                    continue;
                }
                if (!(item instanceof Item.Ends)) continue;
                if (Util.ne0(this.cur.s.end_indent)) {
                    lineBuffer.iaccu = new Item.Space.Inline();
                }
                item2 = this.cur.s;
                this.cur.s = (Item.Span)this.cur.sstack.pop();
                int n = ((Item.Span)item2).end_indent - this.cur.s.end_indent;
                list.append(item);
                if (!Util.ne0(n)) continue;
                list.append(new Item.Washer.Inline(n));
                this.width += n;
            }
            this.hyphenated = item instanceof Item.Text && ((Item.Text)item).isHyphenated();
            this.words = list;
            this.max_width = this.cur.width;
            int n = this.cur.start_edge.depth(this.cur.y - this.height_after - this.height_before, this.cur.y);
            int n5 = this.cur.end_edge.depth(this.cur.y - this.height_after - this.height_before, this.cur.y);
            if (n > this.cur.b.start_indent) {
                this.max_width -= n - this.cur.b.start_indent;
            }
            if (n5 > this.cur.b.end_indent) {
                this.max_width -= n5 - this.cur.b.end_indent;
            }
            if (this.cur.b.bpb.first_line) {
                this.max_width -= this.cur.b.text_indent;
            }
        }

        static {
            baseline_xlat.put(Attr.newWord("baseline"), new Short(0));
            baseline_xlat.put(Attr.newWord("before-edge"), new Short(1));
            baseline_xlat.put(Attr.newWord("text-before-edge"), new Short(2));
            baseline_xlat.put(Attr.newWord("middle"), new Short(3));
            baseline_xlat.put(Attr.newWord("central"), new Short(4));
            baseline_xlat.put(Attr.newWord("text-after-edge"), new Short(5));
            baseline_xlat.put(Attr.newWord("after-edge"), new Short(6));
            baseline_xlat.put(Attr.newWord("top"), baseline_xlat.get(Attr.newWord("before-edge")));
            baseline_xlat.put(Attr.newWord("text-top"), baseline_xlat.get(Attr.newWord("text-before-edge")));
            baseline_xlat.put(Attr.newWord("text-bottom"), baseline_xlat.get(Attr.newWord("text-after-edge")));
            baseline_xlat.put(Attr.newWord("bottom"), baseline_xlat.get(Attr.newWord("after-edge")));
            baseline_xlat.put(Attr.newWord("alphabetic"), baseline_xlat.get(Attr.newWord("baseline")));
            baseline_xlat.put(Attr.newWord("mathematical"), baseline_xlat.get(Attr.newWord("central")));
            baseline_xlat.put(Attr.newWord("hanging"), baseline_xlat.get(Attr.newWord("text-before-edge")));
            baseline_xlat.put(Attr.newWord("ideographic"), baseline_xlat.get(Attr.newWord("text-after-edge")));
        }
    }
}

