/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.DataURL;
import com.renderx.util.URLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class URLSpec
implements Serializable {
    public static final int INVALID_SCHEME = 0;
    public static final int SCHEME_DATA = 1;
    public static final int SCHEME_RESOURCE = 2;
    public static final int SCHEME_OTHER = 3;
    public final int scheme;
    public DataURL data = null;
    public String resource = null;
    public URL url = null;
    static /* synthetic */ Class class$com$renderx$util$URLUtil;

    public URLSpec(String string) throws MalformedURLException {
        this(null, string);
    }

    public URLSpec(URLSpec uRLSpec, String string) throws MalformedURLException {
        if (uRLSpec != null) {
            uRLSpec = uRLSpec.getBase();
        }
        int n = string.indexOf(58);
        int n2 = string.indexOf(47);
        if (n != -1 && (n2 == -1 || n2 > n)) {
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase("data")) {
                this.scheme = 1;
                this.data = new DataURL(uRLSpec, string);
            } else if (string2.equalsIgnoreCase("resource")) {
                this.scheme = 2;
                this.resource = string.substring("resource:".length());
            } else {
                this.scheme = 3;
                this.url = this.getOtherURL(null, string);
            }
        } else if (uRLSpec == null || uRLSpec.scheme == 1) {
            this.scheme = 3;
            this.url = this.getOtherURL(null, string);
        } else if (uRLSpec.scheme == 2) {
            this.scheme = 2;
            this.resource = this.appendResource(uRLSpec.resource, string);
        } else {
            this.scheme = 3;
            this.url = this.getOtherURL(uRLSpec.url, string);
        }
    }

    private URL getOtherURL(URL uRL, String string) throws MalformedURLException {
        try {
            return new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.exists()) {
                return URLUtil.toURL(file);
            }
            throw new MalformedURLException("Invalid URL or non-existent file: " + string);
        }
    }

    private String appendResource(String string, String string2) {
        if (string2.startsWith("/")) {
            return string2;
        }
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string2;
        }
        return string.substring(0, n + 1) + string2;
    }

    public String toString() {
        switch (this.scheme) {
            case 1: {
                return this.data.toString();
            }
            case 2: {
                return "resource:" + this.resource;
            }
            case 3: {
                if (this.url.getProtocol().equalsIgnoreCase("file")) {
                    String string;
                    String string2 = this.url.getHost();
                    String string3 = this.url.getFile();
                    if (string3.startsWith("//") && (string2 == null || string2.length() == 0) && !(string = this.url.toExternalForm().substring(5)).startsWith("////")) {
                        return "file://" + string;
                    }
                }
                return this.url.toExternalForm();
            }
        }
        throw new RuntimeException("Invalid structure in URLSpec: incorrect value for scheme switch (" + this.scheme + ")");
    }

    public InputStream openStream() throws IOException {
        switch (this.scheme) {
            case 1: {
                return this.data.openStream();
            }
            case 3: {
                return this.url.openStream();
            }
            case 2: {
                ClassLoader classLoader;
                String string = this.resource.trim();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                if ((classLoader = (class$com$renderx$util$URLUtil == null ? (class$com$renderx$util$URLUtil = URLSpec.class$("com.renderx.util.URLUtil")) : class$com$renderx$util$URLUtil).getClassLoader()) != null) {
                    return classLoader.getResourceAsStream(string);
                }
                return ClassLoader.getSystemResourceAsStream(string);
            }
        }
        throw new RuntimeException("Invalid structure in URLSpec: incorrect value for scheme switch (" + this.scheme + ")");
    }

    public String getProtocol() {
        switch (this.scheme) {
            case 2: {
                return "resource";
            }
            case 1: {
                return "data";
            }
            case 3: {
                return this.url.getProtocol();
            }
        }
        throw new RuntimeException("Invalid structure in URLSpec: incorrect value for scheme switch (" + this.scheme + ")");
    }

    public String getContentType() throws IOException {
        switch (this.scheme) {
            case 2: {
                return null;
            }
            case 1: {
                return this.data.getContentType();
            }
            case 3: {
                if ("file".equalsIgnoreCase(this.url.getProtocol())) {
                    return null;
                }
                return this.url.openConnection().getContentType();
            }
        }
        throw new RuntimeException("Invalid structure in URLSpec: incorrect value for scheme switch (" + this.scheme + ")");
    }

    public URLSpec getBase() {
        if (this.scheme != 1) {
            return this;
        }
        return this.data.baseURL == null ? null : this.data.baseURL.getBase();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof URLSpec) {
            return this.toString().equals(((URLSpec)object).toString());
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

