/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import com.renderx.util.DefaultErrorHandler;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.SeekableByteArrayInputStream;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.URLSpec;
import com.renderx.util.URLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Enumeration;

public class URLCache {
    private final Hashtable urltab = new Hashtable();
    private final List filelist = new List();
    public final File dir;
    private static long fileno = 0L;

    private static synchronized long nextfileno() {
        return fileno++;
    }

    public URLCache() {
        this(new DefaultErrorHandler());
    }

    public URLCache(ErrorHandler errorHandler) {
        this(null, errorHandler);
    }

    public URLCache(File file, ErrorHandler errorHandler) {
        if (file != null) {
            if (!file.exists()) {
                if (errorHandler != null) {
                    errorHandler.error("Directory " + file + " does not exist; disk caching disabled.");
                }
                file = null;
            } else if (!file.isDirectory()) {
                if (errorHandler != null) {
                    errorHandler.error("File " + file + " is not a directory; disk caching disabled.");
                }
                file = null;
            } else if (!file.canWrite()) {
                if (errorHandler != null) {
                    errorHandler.error("Directory " + file + " is not writable; disk caching disabled.");
                }
                file = null;
            }
        }
        this.dir = file;
    }

    protected ItemDescriptor lookCache(URLSpec uRLSpec) {
        Hashtable hashtable = this.urltab;
        synchronized (hashtable) {
            ItemDescriptor itemDescriptor = (ItemDescriptor)this.urltab.get(uRLSpec.toString());
            return itemDescriptor;
        }
    }

    protected void saveCache(URLSpec uRLSpec, ItemDescriptor itemDescriptor) {
        Hashtable hashtable = this.urltab;
        synchronized (hashtable) {
            this.urltab.put(uRLSpec.toString(), itemDescriptor);
        }
    }

    protected void markFile(File file) {
        if (file == null) {
            return;
        }
        List list = this.filelist;
        synchronized (list) {
            this.filelist.append(file);
        }
    }

    public ItemDescriptor getItemDescriptor(URLSpec uRLSpec, ErrorHandler errorHandler) throws IOException {
        if ("file".equalsIgnoreCase(uRLSpec.getProtocol())) {
            return new ItemDescriptor(URLUtil.toFile(uRLSpec), null);
        }
        ItemDescriptor itemDescriptor = this.lookCache(uRLSpec);
        try {
            long l = 0L;
            long l2 = 0L;
            String string = null;
            InputStream inputStream = null;
            URLConnection uRLConnection = null;
            if (uRLSpec.scheme != 3) {
                if (itemDescriptor != null) {
                    return itemDescriptor;
                }
                inputStream = uRLSpec.openStream();
                string = uRLSpec.getContentType();
            } else {
                uRLConnection = uRLSpec.url.openConnection();
                if (itemDescriptor != null) {
                    if (itemDescriptor.expiration >= System.currentTimeMillis()) {
                        return itemDescriptor;
                    }
                    uRLConnection.setIfModifiedSince(itemDescriptor.lastModified);
                }
                uRLConnection.connect();
                if (uRLConnection instanceof HttpURLConnection) {
                    int n = ((HttpURLConnection)uRLConnection).getResponseCode();
                    if (n == 304) {
                        return itemDescriptor;
                    }
                    if (n != 200) {
                        throw new IOException("HTTP response status is " + n);
                    }
                }
                l = uRLConnection.getLastModified();
                if (itemDescriptor != null && l != 0L && itemDescriptor.lastModified >= l) {
                    return itemDescriptor;
                }
                l2 = uRLConnection.getExpiration();
                string = uRLConnection.getContentType();
                inputStream = uRLConnection.getInputStream();
            }
            File file = this.getTempFile();
            OutputStream outputStream = null;
            outputStream = file != null ? new FileOutputStream(file) : new ByteArrayOutputStream();
            try {
                ItemDescriptor itemDescriptor2;
                try {
                    byte[] byArray = new byte[2048];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        outputStream.write(byArray, 0, n);
                    }
                    if (itemDescriptor == null) {
                        itemDescriptor = new ItemDescriptor();
                    }
                    if (file != null) {
                        itemDescriptor.file = file;
                        itemDescriptor.contents = null;
                    } else {
                        itemDescriptor.file = null;
                        itemDescriptor.contents = ((ByteArrayOutputStream)outputStream).toByteArray();
                    }
                    itemDescriptor.expiration = l2;
                    itemDescriptor.contentType = string;
                    itemDescriptor.lastModified = l;
                    this.markFile(file);
                    this.saveCache(uRLSpec, itemDescriptor);
                    itemDescriptor2 = itemDescriptor;
                    Object var17_17 = null;
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    inputStream.close();
                    outputStream.close();
                    throw throwable;
                }
                inputStream.close();
                outputStream.close();
                return itemDescriptor2;
            }
            catch (IOException iOException) {
                if (file != null) {
                    file.delete();
                }
                throw iOException;
            }
        }
        catch (IOException iOException) {
            if (itemDescriptor != null) {
                errorHandler.warning("Cannot reconnect to \"" + uRLSpec + "\": " + iOException.toString() + ". A previously cached copy will be used.");
                return itemDescriptor;
            }
            throw iOException;
        }
    }

    public void cleanup() {
        Hashtable hashtable = this.urltab;
        synchronized (hashtable) {
            this.urltab.clear();
        }
        List list = this.filelist;
        synchronized (list) {
            Enumeration enumeration = this.filelist.elements();
            while (enumeration.hasMoreElements()) {
                ((File)enumeration.nextElement()).delete();
            }
            this.filelist.clear();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }

    protected File getTempFile(String string) {
        File file;
        if (this.dir == null) {
            return null;
        }
        while ((file = new File(this.dir, "" + URLCache.nextfileno() + string)).exists()) {
        }
        return file;
    }

    protected File getTempFile() {
        return this.getTempFile(".tmp");
    }

    public String getContentType(URLSpec uRLSpec, ErrorHandler errorHandler) throws IOException {
        if (uRLSpec.scheme != 3) {
            return uRLSpec.getContentType();
        }
        return this.getItemDescriptor((URLSpec)uRLSpec, (ErrorHandler)errorHandler).contentType;
    }

    public InputStream openStream(URLSpec uRLSpec, ErrorHandler errorHandler) throws IOException {
        if (uRLSpec.scheme != 3) {
            return uRLSpec.openStream();
        }
        ItemDescriptor itemDescriptor = this.getItemDescriptor(uRLSpec, errorHandler);
        if (itemDescriptor.file != null) {
            return new FileInputStream(itemDescriptor.file);
        }
        if (itemDescriptor.contents != null) {
            return new ByteArrayInputStream(itemDescriptor.contents);
        }
        return null;
    }

    public SeekableInput openSeekableStream(URLSpec uRLSpec, ErrorHandler errorHandler) throws IOException {
        ItemDescriptor itemDescriptor = this.getItemDescriptor(uRLSpec, errorHandler);
        if (itemDescriptor.file != null) {
            return new SeekableFileInputStream(itemDescriptor.file);
        }
        if (itemDescriptor.contents != null) {
            return new SeekableByteArrayInputStream(itemDescriptor.contents);
        }
        return null;
    }

    public long getLastModified(URLSpec uRLSpec, ErrorHandler errorHandler) throws IOException {
        if (uRLSpec.scheme != 3) {
            return -1L;
        }
        return this.getItemDescriptor((URLSpec)uRLSpec, (ErrorHandler)errorHandler).lastModified;
    }

    public static class ItemDescriptor {
        public File file = null;
        public byte[] contents = null;
        public String contentType = null;
        public long expiration = 0L;
        public long lastModified = 0L;

        public ItemDescriptor() {
        }

        public ItemDescriptor(File file, String string) {
            this.file = file;
            this.contentType = string;
        }

        public ItemDescriptor(byte[] byArray, String string) {
            this.contents = byArray;
            this.contentType = string;
        }
    }
}

