/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.util;

import cryptix.math.RandomStream;
import cryptix.mime.LegacyString;
import cryptix.pgp.KeyRingTrust;
import cryptix.pgp.Packet;
import cryptix.pgp.PacketFactory;
import cryptix.pgp.Passphrase;
import cryptix.pgp.PublicKeyCertificate;
import cryptix.pgp.PublicKeyRing;
import cryptix.pgp.SecretKeyCertificate;
import cryptix.pgp.SecretKeyRing;
import cryptix.pgp.UserId;
import cryptix.provider.Cryptix;
import cryptix.security.CSRandomStream;
import cryptix.security.MD5;
import cryptix.security.SHA;
import cryptix.security.rsa.PublicKey;
import cryptix.security.rsa.RSAKeyGen;
import cryptix.security.rsa.RSAKeyGenObserver;
import cryptix.security.rsa.SecretKey;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.Provider;
import java.security.Security;
import java.util.Date;

public class KeyGen
implements RSAKeyGenObserver {
    private static final int MIN_KEY_LENGTH = 384;
    private static final int MAX_KEY_LENGTH = 6000;
    protected DataInputStream in;
    protected PrintStream out;

    public KeyGen(InputStream inputStream, PrintStream printStream) {
        Provider provider = Security.getProvider("Cryptix");
        if (provider == null) {
            Security.addProvider((Provider)new Cryptix());
        }
        this.in = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        this.out = printStream;
    }

    public KeyGen() {
        this(System.in, System.out);
    }

    public static void main(String[] stringArray) {
        new KeyGen().begin();
    }

    protected final void begin() {
        try {
            String string = this.getUserName();
            int n = this.getKeyLength();
            RandomStream randomStream = this.getRandomStream(n);
            SecretKey secretKey = this.getKey(n, randomStream);
            System.out.println("Key generated.");
            String string2 = this.getPassphrase();
            this.saveNewKey(secretKey, string, string2, randomStream);
        }
        catch (Exception exception) {
            System.out.println("Key gen aborted.");
            exception.printStackTrace();
        }
    }

    protected SecretKey getKey(int n, RandomStream randomStream) {
        return new RSAKeyGen(randomStream).createKey(n, (RSAKeyGenObserver)this);
    }

    protected String getUserName() throws IOException {
        this.out.print("Please enter your user name: ");
        this.out.flush();
        String string = this.in.readLine();
        this.out.println("using name '" + string + "'");
        return string;
    }

    protected int getKeyLength() throws IOException {
        int n;
        while (true) {
            this.out.print("Please enter key size (512, 2048 etc).");
            this.out.flush();
            try {
                n = Integer.parseInt(this.in.readLine().trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.out.println("Bad format number try again.");
                continue;
            }
            if (n < 384) {
                this.out.println("Key bit length too short. (<384)");
                continue;
            }
            if (n <= 6000) break;
            this.out.println("Key bit length too long. (>6000)");
        }
        return n;
    }

    protected RandomStream getRandomStream(int n) throws IOException {
        int n2 = n / 6 + 10;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        printStream.print(new Date());
        printStream.println("Please enter some random data");
        this.out.print("You will have to enter a minimum of ");
        this.out.print(n2);
        this.out.println(" characters;");
        printStream.print(System.currentTimeMillis());
        SHA sHA = new SHA();
        MD5 mD5 = new MD5();
        while (n2 > 0) {
            String string = this.in.readLine();
            sHA.add(LegacyString.toByteArray((String)Long.toString(System.currentTimeMillis())));
            sHA.add(LegacyString.toByteArray((String)string));
            printStream.print(n2 -= string.length());
            printStream.print(string.length());
            printStream.print(System.currentTimeMillis());
            printStream.print(string);
            this.out.print("characters to go ");
            this.out.println(n2 < 0 ? 0 : n2);
            mD5.add(LegacyString.toByteArray((String)string));
            mD5.add(LegacyString.toByteArray((String)Long.toString(System.currentTimeMillis(), 16)));
        }
        try {
            printStream.write(sHA.digest());
            printStream.write(mD5.digest());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(printStream);
        }
        return new CSRandomStream(SHA.hash((byte[])byteArrayOutputStream.toByteArray()));
    }

    protected String getPassphrase() throws IOException {
        String string = "";
        while (true) {
            this.out.print(" please enter passphrase ");
            this.out.flush();
            String string2 = this.in.readLine();
            this.out.print(" please re-enter passphrase ");
            this.out.flush();
            string = this.in.readLine();
            if (string2.equals(string)) {
                return string;
            }
            this.out.println("Passphrases do not match.");
            this.out.println("Please try again.");
        }
    }

    private final void saveNewKey(SecretKey secretKey, String string, String string2, RandomStream randomStream) throws IOException {
        UserId userId = new UserId(string);
        PublicKeyRing publicKeyRing = new PublicKeyRing("pubring.pgp");
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream("pubring.pgp"));
        publicKeyRing.write((OutputStream)dataOutputStream);
        PublicKeyCertificate publicKeyCertificate = new PublicKeyCertificate((PublicKey)secretKey);
        PacketFactory.write((DataOutput)dataOutputStream, (Packet)publicKeyCertificate);
        PacketFactory.write((DataOutput)dataOutputStream, (Packet)new KeyRingTrust(-121));
        PacketFactory.write((DataOutput)dataOutputStream, (Packet)userId);
        PacketFactory.write((DataOutput)dataOutputStream, (Packet)new KeyRingTrust(3));
        dataOutputStream.close();
        SecretKeyRing secretKeyRing = new SecretKeyRing("secring.pgp");
        DataOutputStream dataOutputStream2 = new DataOutputStream(new FileOutputStream("secring.pgp"));
        secretKeyRing.write((OutputStream)dataOutputStream2);
        SecretKeyCertificate secretKeyCertificate = new SecretKeyCertificate(secretKey, new Passphrase(string2), randomStream);
        PacketFactory.write((DataOutput)dataOutputStream2, (Packet)secretKeyCertificate);
        PacketFactory.write((DataOutput)dataOutputStream2, (Packet)userId);
        dataOutputStream2.close();
    }

    public void handleEvent(int n) {
        switch (n) {
            case 1: {
                this.out.print("-");
                this.out.flush();
                break;
            }
            case 3: {
                this.out.print("+");
                this.out.flush();
                break;
            }
            case 4: {
                this.out.print("*");
                this.out.flush();
                break;
            }
            case 5: {
                this.out.println();
                this.out.print("p:");
                this.out.flush();
                break;
            }
            case 6: {
                this.out.println();
                this.out.print("q:");
                this.out.flush();
                break;
            }
            case 7: {
                this.out.println("Key resolving begins");
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            default: {
                this.out.println("Unexpected event : " + n);
            }
        }
    }
}

