package com.renderx.xepx.x4u.as;

import java.util.Properties;

class Formatter {
	private Settings settings;
	private Logger logger;
	private Thread thread;
	public static final int FORMATTING=0, FAILURE=-1, SUCCESSFUL=1;
	private boolean failed=false;
	Formatter(Settings settings,Logger logger){
		this.settings = settings;
		this.logger = logger;
	}

	void start(final String xepConfigPath) {
		thread = new Thread() {
			public void run() {
				try
				{
					failed = false;
					render(xepConfigPath);
				} 
				catch(Exception ex) 
				{	
					failed = true;
					logger.exception("formatting failed: ",ex);
				}
			}
		};
		thread.start();
	}

	void stop() {
		if(thread!=null)
			thread.stop();
		thread = null;
	}

	int state() {
		if(thread!=null && thread.isAlive()) 
			return FORMATTING;
		else 
			if(failed)
				return FAILURE;
			else 
				return SUCCESSFUL;
	}
		
	void render(String xepConfigPath) 
			throws java.io.IOException,
			org.xml.sax.SAXException, javax.xml.transform.TransformerException,
			com.renderx.xep.lib.ConfigurationException {
		java.io.OutputStream result = new java.io.BufferedOutputStream(
			new java.io.FileOutputStream(settings.result));
		try {
			Properties environment = new Properties();
			environment.put(Settings.XEP_CONFIG_SHORT, xepConfigPath);
			com.renderx.xep.FormatterImpl formatter = new com.renderx.xep.FormatterImpl(environment, logger);
			com.renderx.xep.FOTarget target = null;
			try {
				java.util.Properties res = new java.util.Properties();
				if (settings.setRes) {
					res.put("RESOURCE", settings.afpRes);
					target = new com.renderx.xep.FOTarget(result, settings.format, res);
				} else {
					target = new com.renderx.xep.FOTarget(result, settings.format);
				}
				javax.xml.transform.sax.SAXSource source = 
					new javax.xml.transform.sax.SAXSource(
						com.renderx.sax.XMLReaderFactory.createXMLReader(), 
						new org.xml.sax.InputSource(
							new java.io.File(settings.source).toURL().toString()));
				com.renderx.xep.FOTransformer transformer;
	
				if(settings.transform) {
					javax.xml.transform.Source stylesheet = 
						new javax.xml.transform.sax.SAXSource(
							com.renderx.sax.XMLReaderFactory.createXMLReader(), 
							new org.xml.sax.InputSource(
								new java.io.File(settings.stylesheet).toURL().toString()));
					transformer = new com.renderx.xep.FOTransformer(
						createTransformer(stylesheet),formatter);
					for(java.util.Enumeration ep = settings.xslparams.elements();ep.hasMoreElements();) {
						java.util.Vector param = (java.util.Vector)ep.nextElement();
						transformer.setParameter((String)param.elementAt(0),param.elementAt(1));
					}
				} else {
					transformer = new com.renderx.xep.FOTransformer(formatter);
				}
	
				transformer.setLogger(logger);
				transformer.setErrorListener(
					new javax.xml.transform.ErrorListener() {
						private String message(javax.xml.transform.TransformerException e)
								throws javax.xml.transform.TransformerException {
							String msg = e.getMessageAndLocation();
							Throwable subex = e.getException();
							if(subex!=null)
									msg += ": "+subex.getMessage();
							return msg;
						}
						public  void warning(javax.xml.transform.TransformerException e)
								throws javax.xml.transform.TransformerException {
							logger.warning(message(e));
						}
						public  void error(javax.xml.transform.TransformerException e)
								throws javax.xml.transform.TransformerException {
							logger.error(message(e));
						}
						public  void fatalError(javax.xml.transform.TransformerException e)
								throws javax.xml.transform.TransformerException {
							logger.error(message(e));
						}
					}
				);
				transformer.transform(source,target);
			} finally {
				formatter.cleanup();
			}
			result.close();
		} 
		catch(Exception e) 
		{
			failed = true;
			logger.exception(
				e instanceof com.renderx.xep.lib.LicenseException?
					"license check failed"
			:	e instanceof com.renderx.xep.lib.ConfigurationException?
					"configuration is corrupt"
			:		"formatting failed",
				e);
			try  
			{
				result.close();
				new java.io.File(settings.result).delete();
			} 
			catch(Exception ex) 
			{
			}
		}
	}

	/* a patch to the current faulty FOTransformer */
	 private javax.xml.transform.Transformer createTransformer(
	  	javax.xml.transform.Source stylesource)
			throws javax.xml.transform.TransformerConfigurationException {
    javax.xml.transform.TransformerFactory factory = createTransformerFactory();
    javax.xml.transform.Transformer trans = factory.newTransformer(stylesource);
    javax.xml.transform.URIResolver res = factory.getURIResolver();
    if(res!=null) trans.setURIResolver(res);
    return trans;
  }


  private javax.xml.transform.TransformerFactory createTransformerFactory()
  		throws javax.xml.transform.TransformerConfigurationException {
    javax.xml.transform.TransformerFactory factory = null;
    try 
		{
      factory = javax.xml.transform.TransformerFactory.newInstance();
    } 
		catch (javax.xml.transform.TransformerFactoryConfigurationError e) 
		{
      throw new javax.xml.transform.TransformerConfigurationException(e.toString());
    }

    if (!factory.getFeature(javax.xml.transform.sax.SAXResult.FEATURE))
      throw new javax.xml.transform.TransformerConfigurationException(
      	"TransformerFactory does not support SAX result: "
	      +"cannot create FOTransformer");

    String resolverClassName=System.getProperty("com.renderx.jaxp.uriresolver");
    if (resolverClassName==null) resolverClassName="none";
    if(!"none".equals(resolverClassName)) 
		{
      try 
			{
        factory.setURIResolver(
         	(javax.xml.transform.URIResolver)Class.forName(resolverClassName)
	        .newInstance());
      } 
			catch (Exception e) 
			{
        throw new javax.xml.transform.TransformerConfigurationException(
        	"Cannot create URI resolver "+resolverClassName+": "+e.toString());
      }
    }
    factory.setErrorListener(
			new javax.xml.transform.ErrorListener() 
			{
				public	void warning(javax.xml.transform.TransformerException e)
						throws javax.xml.transform.TransformerException {
					logger.warning(e.getMessageAndLocation());
				}
				public	void error(javax.xml.transform.TransformerException e)
						throws javax.xml.transform.TransformerException {
					logger.error(e.getMessageAndLocation());
				}
				public	void fatalError(javax.xml.transform.TransformerException e)
						throws javax.xml.transform.TransformerException {
					logger.exception(e.getMessageAndLocation(),e);
				}
			}
		);
    return factory;
  }
}
