/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.lib;

import com.renderx.afpcommon.CodePage;
import com.renderx.crypto.CheckSignedXML;
import com.renderx.fonts.FontCatalog;
import com.renderx.hyphen.HyphenatorFactory;
import com.renderx.hyphen.TeXHyphenatorFactory;
import com.renderx.sax.CarbonCopyParser;
import com.renderx.sax.ConfigHandler;
import com.renderx.sax.ConfigHandlerAdapter;
import com.renderx.sax.InputSource;
import com.renderx.sax.NullSource;
import com.renderx.sax.SAXStorage;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Hashtable;
import com.renderx.util.RoleMap;
import com.renderx.util.RoleMapConfigurationException;
import com.renderx.util.URLCache;
import com.renderx.util.URLSpec;
import com.renderx.util.URLUtil;
import com.renderx.util.User;
import com.renderx.xep.cmp.ImageFactory;
import com.renderx.xep.lib.ConfigurationException;
import com.renderx.xep.lib.DefaultLogger;
import com.renderx.xep.lib.LicenseException;
import com.renderx.xep.lib.Logger;
import com.renderx.xep.pre.Parser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Conf {
    public static final String NAME = "XEP";
    public static final String TAG = "XEP";
    public static final String VERSION_NUMBER = "4.22 build 2013";
    public static final String PUBLICKEY = "8F6F0559B81D00517D296DC703CDC2636A23225C392F80FBB6D29D2AAB3D29B6D58DB38E97A61F2C259C46D77002E5C3F5DC3811E0FFF08FFCFCCE475EB047C3:13";
    public static final String CUSTOM_FIELD_PREFIX = "__custom_field__";
    public static final boolean DEBUG = false;
    public static final boolean TRIAL_MODE = false;
    public static final int SCALE = 1000;
    public static final int RNDERR = 50;
    public static final String DEFAULT_SYSTEMID = "file:/example.com/missing/SystemId/";
    private static final String OPTION_PREFIX = "com.renderx.xep.";
    private static final String CONFIG = "xep.xml";
    private String AFPCodePageName;
    private CodePage AFPCodePage;
    private String AFPName;
    private String AFPIbmName;
    private boolean AFPForceLatin;
    private int AFPCodePageCounter;
    private ArrayList arrayFrom;
    private ArrayList arrayTo;
    private HashMap unicodeToAfp;
    private DataType dataType;
    public Hashtable dataTypes;
    public String defaultDataType;
    private static final Properties optionTypes = new Properties();
    private static final Properties defaultOptions = new Properties();
    protected static final Properties backendClasses;
    protected static final Properties backendAliases;
    public final String ANNOTATION;
    public final boolean PUT_STAMP;
    public final String APPLICATION_ID;
    public final boolean AFP;
    public final boolean AFPTrial;
    public final boolean FEATHERING;
    public final String CUSTOM_STAMP;
    public final boolean SVG;
    public final boolean SVGTrial;
    public final boolean XPS;
    public final boolean XPSTrial;
    public final boolean PPML;
    public final boolean PPMLTrial;
    public final boolean RichMediaObject;
    public final boolean RichMediaObjectTrial;
    public final boolean XHTML;
    public final boolean XHTMLTrial;
    public final boolean XForms;
    public final boolean XFormsTrial;
    public final boolean PDFForms;
    public File TMPDIR;
    public final URLSpec BROKENIMAGE;
    public final URLSpec LOGO;
    public final URLSpec STAMP_PNG;
    public final URLSpec XSL11_TO_XSL10RX_STYLESHEET;
    public final URLSpec FOOTNOTE_REORDERING_STYLESHEET;
    public final URLSpec VALIDATOR_STYLESHEET;
    public final URLSpec SPOT_COLOR_TRANSLATION_TABLE;
    public final URLSpec ROLE_MAP;
    public final boolean SUPPORT_XSL11;
    public final boolean ENABLE_FOLIO;
    public final boolean FOOTNOTE_REORDERING;
    public final boolean VALIDATE;
    public final boolean DISCARD_IF_NOT_VALID;
    public final int STRICTNESS;
    public final String TARGET_FORMAT;
    public final boolean XEP2_COMPATIBLE_MODE;
    public final boolean ENABLE_BIDI;
    public final boolean PAGEWIDE_FOOTNOTES;
    public final boolean DISCARD_AFTER_HEADER;
    public final boolean ENABLE_ACCESSIBILITY;
    public final boolean BORDER_COLLAPSE_SEPARATE;
    public final boolean OMIT_FOOTER_AT_BREAK;
    public final boolean ROTATE_ZERO_DEGREES;
    public final boolean OMIT_IDENTICAL_FOOTNOTES;
    public final boolean ENABLE_PAGE_NUMBERS;
    public final int MIN_PAGE_HEIGHT;
    public final int MIN_PAGE_WIDTH;
    public final int PAGE_HEIGHT;
    public final int PAGE_WIDTH;
    public final int MAX_PAGE_HEIGHT;
    public final int MAX_PAGE_WIDTH;
    public final int FDL;
    public final int LTF;
    public final int CJF;
    public final int PAGE_ID_WIDTH;
    public final boolean KERN;
    public final boolean INVALIDATE_IMAGE_CACHE;
    public final int IMAGE_MEMOIZE_THRESHOLD;
    public final double SHIFT_TARGET_X;
    public final double SHIFT_TARGET_Y;
    public final boolean IGNORE_SPANNED_COLUMN_WIDTH;
    public final boolean MERGE_WHITE_SPACE;
    public final URLCache cache;
    public final Logger logger;
    public final FontCatalog fontCatalog;
    public final ImageFactory imageFactory;
    public final HyphenatorFactory hyphenFactory;
    public final Hashtable generatorOptions;
    private Config config;

    private static final void createOption(String string, String string2, Object object) {
        optionTypes.put(string, string2);
        defaultOptions.put(string, object);
    }

    public static final String getBackendClassName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = backendAliases.getProperty(string.trim().toLowerCase());
        if (string2 == null) {
            return null;
        }
        return backendClasses.getProperty(string2);
    }

    public Properties getBackendOptions(String string) {
        if (string == null) {
            return null;
        }
        String string2 = backendAliases.getProperty(string.trim().toLowerCase());
        if (string2 == null) {
            return null;
        }
        return (Properties)this.generatorOptions.get(string2);
    }

    public void cleanup() {
        this.imageFactory.clearCache();
        this.cache.cleanup();
    }

    protected URLCache getCache() {
        return new URLCache(this.TMPDIR, this.logger);
    }

    private static final String getDefaultConfigFile(Properties properties) {
        String string = properties.getProperty("CONFIG");
        if (string == null) {
            string = properties.getProperty("com.renderx.xep.CONFIG");
        }
        if (string == null) {
            string = User.getProperty("com.renderx.xep.CONFIG");
        }
        if (string == null) {
            string = CONFIG;
        }
        return string;
    }

    private static final org.xml.sax.InputSource createInputSource(String string) throws ConfigurationException {
        try {
            return new InputSource(string);
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException);
        }
    }

    private static final XMLReader createXMLReader() throws ConfigurationException {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            throw new ConfigurationException(sAXException);
        }
    }

    public Conf() throws ConfigurationException {
        this(new Properties(), new DefaultLogger());
    }

    public Conf(Properties properties, Logger logger) throws ConfigurationException {
        this(Conf.getDefaultConfigFile(properties), properties, logger);
    }

    public Conf(String string, Properties properties, Logger logger) throws ConfigurationException {
        this(Conf.createInputSource(string), Conf.createXMLReader(), properties, logger);
    }

    public Conf(org.xml.sax.InputSource inputSource, XMLReader xMLReader, Properties properties, Logger logger) throws ConfigurationException {
        Object object;
        Hashtable hashtable;
        Object object2;
        String string;
        block33: {
            Object object3;
            String string2;
            Object object4;
            this.AFPCodePageName = null;
            this.AFPCodePage = null;
            this.AFPName = null;
            this.AFPIbmName = null;
            this.AFPForceLatin = false;
            this.AFPCodePageCounter = 0;
            this.arrayFrom = new ArrayList();
            this.arrayTo = new ArrayList();
            this.dataType = null;
            this.dataTypes = new Hashtable();
            this.generatorOptions = new Hashtable();
            this.config = new Config();
            this.logger = logger;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if ("CONFIG".equals(string) || optionTypes.get(string) != null) continue;
                this.printError("Invalid option name in the argument list: " + string);
            }
            enumeration = User.getProperties().propertyNames();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.startsWith(OPTION_PREFIX) || ((String)(object2 = string.substring(OPTION_PREFIX.length()))).indexOf(46) != -1 || "CONFIG".equals(object2) || optionTypes.get(object2) != null) continue;
                this.printError("Invalid name of the configuration system property: " + string);
            }
            string = inputSource.getSystemId();
            object2 = new SAXStorage();
            try {
                xMLReader.setContentHandler((ContentHandler)object2);
                xMLReader.parse(inputSource);
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Error while reading configuration file: " + iOException.toString());
            }
            catch (SAXException sAXException) {
                throw new ConfigurationException("Structure error in configuration file: " + sAXException.toString());
            }
            try {
                this.config.parse(new NullSource(string), (XMLReader)object2);
            }
            catch (IOException iOException) {
                throw new ConfigurationException("Error while reading configuration file: " + iOException.toString());
            }
            catch (SAXException sAXException) {
                throw new ConfigurationException("Structure error in configuration file: " + sAXException.toString());
            }
            hashtable = new Hashtable();
            enumeration = optionTypes.propertyNames();
            while (enumeration.hasMoreElements()) {
                object4 = (String)enumeration.nextElement();
                string2 = optionTypes.getProperty((String)object4);
                object3 = properties.getProperty((String)object4);
                if (object3 == null) {
                    object3 = this.config.options.get(object4);
                }
                if (object3 == null) {
                    object3 = User.getProperty(OPTION_PREFIX + (String)object4);
                }
                if (object3 == null) {
                    object3 = defaultOptions.getProperty((String)object4);
                }
                if (string2.equals("URI") && object3 instanceof String) {
                    object3 = this.resolveURI((String)object3, string, (String)object4);
                }
                hashtable.put(object4, object3);
            }
            object4 = new LicenseReader((URLSpec)hashtable.get("LICENSE"));
            this.ANNOTATION = ((LicenseReader)object4).getAnnotation();
            this.PUT_STAMP = ((LicenseReader)object4).hasStamp();
            this.AFP = ((LicenseReader)object4).AFPOn();
            this.AFPTrial = ((LicenseReader)object4).AFPTrialOn();
            this.SVG = ((LicenseReader)object4).SVGOn();
            this.SVGTrial = ((LicenseReader)object4).SVGTrialOn();
            this.XHTML = ((LicenseReader)object4).XHTMLOn();
            this.XHTMLTrial = ((LicenseReader)object4).XHTMLTrialOn();
            this.XForms = ((LicenseReader)object4).XFormsOn();
            this.XFormsTrial = ((LicenseReader)object4).XFormsTrialOn();
            this.XPS = ((LicenseReader)object4).XPSOn();
            this.XPSTrial = ((LicenseReader)object4).XPSTrialOn();
            this.PPML = ((LicenseReader)object4).PPMLOn();
            this.PPMLTrial = ((LicenseReader)object4).PPMLTrialOn();
            this.RichMediaObject = ((LicenseReader)object4).RichMediaObjectOn();
            this.RichMediaObjectTrial = ((LicenseReader)object4).RichMediaObjectTrialOn();
            this.FEATHERING = ((LicenseReader)object4).FeatheringOn();
            this.CUSTOM_STAMP = ((LicenseReader)object4).getCustomStamp();
            this.PDFForms = ((LicenseReader)object4).PDFFormsOn();
            this.APPLICATION_ID = "XEP 4.22 build 2013";
            this.XSL11_TO_XSL10RX_STYLESHEET = (URLSpec)hashtable.get("XSL11_TO_XSL10RX_STYLESHEET");
            this.FOOTNOTE_REORDERING_STYLESHEET = (URLSpec)hashtable.get("FOOTNOTE_REORDERING_STYLESHEET");
            this.VALIDATOR_STYLESHEET = (URLSpec)hashtable.get("VALIDATOR_STYLESHEET");
            this.BROKENIMAGE = (URLSpec)hashtable.get("BROKENIMAGE");
            this.LOGO = (URLSpec)hashtable.get("LOGO");
            this.STAMP_PNG = (URLSpec)hashtable.get("STAMP_PNG");
            if (this.getBooleanOption("SUPPORT_XSL11", hashtable)) {
                this.printWarning("The option 'SUPPORT_XSL11' is deprecated and ignored starting from XEP 4.19.\nIt's functionality has been refactored into Java code in XEP core.\nSee XEP User Guide for details.");
            }
            this.SUPPORT_XSL11 = false;
            this.ENABLE_FOLIO = this.getBooleanOption("ENABLE_FOLIO", hashtable);
            this.FOOTNOTE_REORDERING = this.getBooleanOption("FOOTNOTE_REORDERING", hashtable);
            this.VALIDATE = this.getBooleanOption("VALIDATE", hashtable);
            this.DISCARD_IF_NOT_VALID = this.getBooleanOption("DISCARD_IF_NOT_VALID", hashtable);
            this.STRICTNESS = this.getIntOption("STRICTNESS", hashtable);
            this.XEP2_COMPATIBLE_MODE = this.getBooleanOption("XEP2_COMPATIBLE_MODE", hashtable);
            this.PAGEWIDE_FOOTNOTES = this.getBooleanOption("PAGEWIDE_FOOTNOTES", hashtable);
            this.DISCARD_AFTER_HEADER = this.getBooleanOption("DISCARD_AFTER_HEADER", hashtable);
            this.ENABLE_BIDI = this.getBooleanOption("ENABLE_BIDI", hashtable);
            this.ENABLE_ACCESSIBILITY = this.getBooleanOption("ENABLE_ACCESSIBILITY", hashtable);
            this.BORDER_COLLAPSE_SEPARATE = this.getBooleanOption("BORDER_COLLAPSE_SEPARATE", hashtable);
            this.OMIT_FOOTER_AT_BREAK = this.getBooleanOption("OMIT_FOOTER_AT_BREAK", hashtable);
            this.ROTATE_ZERO_DEGREES = this.getBooleanOption("ROTATE_ZERO_DEGREES", hashtable);
            this.OMIT_IDENTICAL_FOOTNOTES = this.getBooleanOption("OMIT_IDENTICAL_FOOTNOTES", hashtable);
            this.ENABLE_PAGE_NUMBERS = this.getBooleanOption("ENABLE_PAGE_NUMBERS", hashtable);
            this.MIN_PAGE_HEIGHT = this.getLengthOption("MIN_PAGE_HEIGHT", hashtable);
            this.MIN_PAGE_WIDTH = this.getLengthOption("MIN_PAGE_WIDTH", hashtable);
            this.PAGE_HEIGHT = this.getLengthOption("PAGE_HEIGHT", hashtable);
            this.PAGE_WIDTH = this.getLengthOption("PAGE_WIDTH", hashtable);
            this.MAX_PAGE_HEIGHT = this.getLengthOption("MAX_PAGE_HEIGHT", hashtable);
            this.MAX_PAGE_WIDTH = this.getLengthOption("MAX_PAGE_WIDTH", hashtable);
            this.FDL = this.getIntOption("FDL", hashtable);
            this.LTF = this.getIntOption("LTF", hashtable);
            this.KERN = this.getBooleanOption("KERN", hashtable);
            this.INVALIDATE_IMAGE_CACHE = this.getBooleanOption("INVALIDATE_IMAGE_CACHE", hashtable);
            this.CJF = this.getIntOption("CJF", hashtable);
            this.PAGE_ID_WIDTH = this.getIntOption("PAGE_ID_WIDTH", hashtable);
            this.SHIFT_TARGET_X = this.getDoubleOption("SHIFT_TARGET_X", hashtable);
            this.SHIFT_TARGET_Y = this.getDoubleOption("SHIFT_TARGET_Y", hashtable);
            this.IGNORE_SPANNED_COLUMN_WIDTH = this.getBooleanOption("IGNORE_SPANNED_COLUMN_WIDTH", hashtable);
            this.MERGE_WHITE_SPACE = this.getBooleanOption("MERGE_WHITE_SPACE", hashtable);
            string2 = (String)hashtable.get("SPOT_COLOR_TRANSLATION_TABLE");
            if ("none".equals(string2.trim())) {
                this.SPOT_COLOR_TRANSLATION_TABLE = null;
            } else {
                this.SPOT_COLOR_TRANSLATION_TABLE = this.resolveURI(string2, string, "SPOT_COLOR_TRANSLATION_TABLE");
                object3 = User.getProperties();
                ((Properties)object3).setProperty("com.renderx.xep.SPOT_COLOR_TRANSLATION_TABLE", this.SPOT_COLOR_TRANSLATION_TABLE.toString());
                User.setProperties((Properties)object3);
            }
            this.TARGET_FORMAT = (String)hashtable.get("TARGET_FORMAT");
            object3 = (String)hashtable.get("TMPDIR");
            if ("none".equals(((String)object3).trim())) {
                this.TMPDIR = null;
            } else {
                if (((String)object3).toLowerCase().startsWith("file:")) {
                    object = null;
                    try {
                        object = new URL((String)object3);
                    }
                    catch (MalformedURLException malformedURLException) {
                        throw new ConfigurationException("File URL '" + (String)object3 + "'in TMPDIR option cannot be parsed: " + malformedURLException.getMessage());
                    }
                    this.TMPDIR = URLUtil.toFile((URL)object);
                } else {
                    this.TMPDIR = new File((String)object3);
                }
                if (!this.TMPDIR.exists()) {
                    throw new ConfigurationException("Temporary directory " + this.TMPDIR + " does not exist");
                }
                if (!this.TMPDIR.isDirectory()) {
                    throw new ConfigurationException("Temporary directory " + this.TMPDIR + " is not a directory");
                }
                if (!this.TMPDIR.canWrite()) {
                    throw new ConfigurationException("Temporary directory " + this.TMPDIR + " is not writeable");
                }
            }
            this.IMAGE_MEMOIZE_THRESHOLD = this.TMPDIR == null ? 0 : this.getIntOption("IMAGE_MEMOIZE_THRESHOLD", hashtable);
            this.cache = this.getCache();
            object = null;
            try {
                object = new TeXHyphenatorFactory(new NullSource(string), (XMLReader)object2, this.logger);
            }
            catch (Exception exception) {
                if (this.logger == null) break block33;
                this.logger.exception("Hyphenation failed to initialize; hyphenation disabled", exception);
            }
        }
        this.hyphenFactory = object;
        try {
            this.fontCatalog = new FontCatalog(new NullSource(string), (XMLReader)object2, this.cache, this.logger);
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
        this.imageFactory = new ImageFactory(this.fontCatalog, this.cache, this.logger, this.BROKENIMAGE, this.TMPDIR != null && this.IMAGE_MEMOIZE_THRESHOLD > 0 ? this.TMPDIR : null, this.IMAGE_MEMOIZE_THRESHOLD, this.INVALIDATE_IMAGE_CACHE);
        Parser.init();
        URLSpec uRLSpec = null;
        if (this.ENABLE_ACCESSIBILITY) {
            try {
                uRLSpec = (URLSpec)hashtable.get("ROLE_MAP");
                new RoleMap(uRLSpec, this.logger);
            }
            catch (RoleMapConfigurationException roleMapConfigurationException) {
                if (this.logger != null) {
                    this.logger.warning(roleMapConfigurationException.toString() + "; PDF accessibility turned off!");
                }
                uRLSpec = null;
            }
        }
        this.ROLE_MAP = uRLSpec;
    }

    private URLSpec resolveURI(String string, String string2, String string3) throws ConfigurationException {
        URLSpec uRLSpec = null;
        URLSpec uRLSpec2 = null;
        boolean bl = false;
        if (uRLSpec == null && string2 != null && !bl) {
            try {
                uRLSpec = new URLSpec(string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.printError("Cannot make base directory from system ID: '" + string2 + "'");
                bl = true;
            }
        }
        try {
            uRLSpec2 = new URLSpec(uRLSpec, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ConfigurationException("Invalid URL in the value of property " + string3 + ": '" + string + "'");
        }
        return uRLSpec2;
    }

    private static final int compareDate(String string) throws LicenseException {
        if (string == null) {
            return 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-/ \t\r\n");
        try {
            if (!stringTokenizer.hasMoreTokens()) {
                return 0;
            }
            int n = Integer.parseInt(stringTokenizer.nextToken());
            if (n >= 0 && n <= 99) {
                n += 2000;
            } else if (n < 2000) {
                return 0;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return 0;
            }
            int n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
            if (n2 < 0 || n2 >= 12) {
                return 0;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return 0;
            }
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (n3 <= 0 || n3 > 31) {
                return 0;
            }
            if (stringTokenizer.hasMoreTokens()) {
                return 0;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            int n4 = gregorianCalendar.get(1);
            int n5 = gregorianCalendar.get(2);
            int n6 = gregorianCalendar.get(5);
            if (n4 != n) {
                return n - n4;
            }
            if (n5 != n2) {
                return n2 - n5;
            }
            if (n6 != n3) {
                return n3 - n6;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    public void testStartElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable) {
        this.config.startElement(string, string2, string3, attributes, hashtable);
    }

    public void testEndElement(String string, String string2, String string3, Hashtable hashtable) {
        this.config.endElement(string, string2, string3, hashtable);
    }

    private void printWarning(String string) {
        if (this.logger == null) {
            return;
        }
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.warning(string);
        }
    }

    private void printError(String string) {
        if (this.logger == null) {
            return;
        }
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.error(string);
        }
    }

    private void printException(String string, Exception exception) {
        if (this.logger == null) {
            return;
        }
        Logger logger = this.logger;
        synchronized (logger) {
            this.logger.exception(string, exception);
        }
    }

    private boolean getBooleanOption(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        if ("true".equalsIgnoreCase(string2.trim())) {
            return true;
        }
        if ("false".equalsIgnoreCase(string2.trim())) {
            return false;
        }
        if ("yes".equalsIgnoreCase(string2.trim())) {
            return true;
        }
        if ("no".equalsIgnoreCase(string2.trim())) {
            return false;
        }
        String string3 = (String)defaultOptions.get(string);
        this.printError("Invalid boolean value " + string + "='" + string2 + "'; reverting to the default value of '" + string3 + "'");
        return "true".equalsIgnoreCase(string3);
    }

    private int getIntOption(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = (String)defaultOptions.get(string);
            this.printError("Invalid integer value " + string + "='" + string2 + "'; reverting to the default value of '" + string3 + "'");
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Invalid integer value " + string + "='" + string3 + "' in the default values: " + numberFormatException2.getMessage());
            }
        }
    }

    private double getDoubleOption(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        try {
            return Double.valueOf(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = (String)defaultOptions.get(string);
            this.printError("Invalid double value " + string + "='" + string2 + "'; reverting to the default value of '" + string3 + "'");
            try {
                return Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Invalid double value " + string + "='" + string3 + "' in the default values: " + numberFormatException2.getMessage());
            }
        }
    }

    private int getLengthOption(String string, Hashtable hashtable) {
        String string2 = (String)hashtable.get(string);
        try {
            return Conf.parseLengthSpecifier(string2.trim());
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = (String)defaultOptions.get(string);
            this.printError("Invalid length specifier " + string + "='" + string2 + "'; reverting to the default value of '" + string3 + "'");
            try {
                return Conf.parseLengthSpecifier(string3);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Invalid length specifier " + string + "='" + string3 + "' in the default values: " + numberFormatException2.getMessage());
            }
        }
    }

    private static final int parseLengthSpecifier(String string) throws NumberFormatException {
        double d = 1.0;
        if (string.endsWith("pt")) {
            d = 1.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("in")) {
            d = 72.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            d = 0.6;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pc")) {
            d = 12.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("cm")) {
            d = 28.346456692913385;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("mm")) {
            d = 2.834645669291339;
            string = string.substring(0, string.length() - 2);
        } else {
            throw new NumberFormatException("Unknown measurement units in '" + string + "'");
        }
        return (int)Math.round(Double.valueOf(string.trim()) * d * 1000.0);
    }

    static {
        Conf.createOption("TMPDIR", "file", ".");
        Conf.createOption("LICENSE", "URI", "license.xml");
        Conf.createOption("VALIDATOR_STYLESHEET", "URI", "resource:com/renderx/xep/folint.xsl");
        Conf.createOption("ROLE_MAP", "URI", "rolemap.xml");
        Conf.createOption("XSL11_TO_XSL10RX_STYLESHEET", "URI", "resource:com/renderx/xep/xsl11-to-rx.xsl");
        Conf.createOption("FOOTNOTE_REORDERING_STYLESHEET", "URI", "resource:com/renderx/xep/footnote-reordering.xsl");
        Conf.createOption("BROKENIMAGE", "URI", "404.gif");
        Conf.createOption("LOGO", "URI", "../Tools/logo-renderx.svg");
        Conf.createOption("STAMP_PNG", "URI", "../Tools/stamp-renderx.png");
        Conf.createOption("SPOT_COLOR_TRANSLATION_TABLE", "URI_EXTENDED", "none");
        Conf.createOption("VALIDATE", "boolean", "true");
        Conf.createOption("DISCARD_IF_NOT_VALID", "boolean", "true");
        Conf.createOption("STRICTNESS", "int", "1");
        Conf.createOption("SUPPORT_XSL11", "boolean", "false");
        Conf.createOption("ENABLE_FOLIO", "boolean", "false");
        Conf.createOption("FOOTNOTE_REORDERING", "boolean", "false");
        Conf.createOption("XEP2_COMPATIBLE_MODE", "boolean", "false");
        Conf.createOption("ENABLE_BIDI", "boolean", "true");
        Conf.createOption("PAGEWIDE_FOOTNOTES", "boolean", "true");
        Conf.createOption("DISCARD_AFTER_HEADER", "boolean", "false");
        Conf.createOption("ENABLE_ACCESSIBILITY", "boolean", "false");
        Conf.createOption("BORDER_COLLAPSE_SEPARATE", "boolean", "false");
        Conf.createOption("OMIT_FOOTER_AT_BREAK", "boolean", "false");
        Conf.createOption("ROTATE_ZERO_DEGREES", "boolean", "false");
        Conf.createOption("OMIT_IDENTICAL_FOOTNOTES", "boolean", "true");
        Conf.createOption("ENABLE_PAGE_NUMBERS", "boolean", "false");
        Conf.createOption("MIN_PAGE_HEIGHT", "length", "3pt");
        Conf.createOption("MIN_PAGE_WIDTH", "length", "3pt");
        Conf.createOption("PAGE_HEIGHT", "length", "11in");
        Conf.createOption("PAGE_WIDTH", "length", "8in");
        Conf.createOption("MAX_PAGE_HEIGHT", "length", "200in");
        Conf.createOption("MAX_PAGE_WIDTH", "length", "200in");
        Conf.createOption("FDL", "int", "2");
        Conf.createOption("LTF", "int", "20");
        Conf.createOption("CJF", "int", "100");
        Conf.createOption("PAGE_ID_WIDTH", "int", "1200");
        Conf.createOption("KERN", "boolean", "true");
        Conf.createOption("INVALIDATE_IMAGE_CACHE", "boolean", "false");
        Conf.createOption("IMAGE_MEMOIZE_THRESHOLD", "int", "0");
        Conf.createOption("SHIFT_TARGET_X", "double", "0.9");
        Conf.createOption("SHIFT_TARGET_Y", "double", "0.9");
        Conf.createOption("IGNORE_SPANNED_COLUMN_WIDTH", "boolean", "false");
        Conf.createOption("MERGE_WHITE_SPACE", "boolean", "true");
        backendClasses = new Properties();
        backendClasses.put("PDF", "com.renderx.xep.gen.backends.H4PDF");
        backendClasses.put("PostScript", "com.renderx.xep.gen.backends.H4PS");
        backendClasses.put("AFP", "com.renderx.xep.gen.backends.H4AFP");
        backendClasses.put("XEP", "com.renderx.xep.gen.backends.H4XEP");
        backendClasses.put("SVG", "com.renderx.xep.gen.backends.H4SVG");
        backendClasses.put("XPS", "com.renderx.xep.gen.backends.H4XPS");
        backendClasses.put("HTML", "com.renderx.xep.gen.backends.H4HTML");
        backendClasses.put("PPML", "com.renderx.xep.gen.backends.H4PPML");
        backendAliases = new Properties();
        backendAliases.put("pdf", "PDF");
        backendAliases.put("postscript", "PostScript");
        backendAliases.put("ps", "PostScript");
        backendAliases.put("afp", "AFP");
        backendAliases.put("xep", "XEP");
        backendAliases.put("at", "XEP");
        backendAliases.put("xml", "XEP");
        backendAliases.put("svg", "SVG");
        backendAliases.put("xps", "XPS");
        backendAliases.put("html", "HTML");
        backendAliases.put("ppml", "PPML");
    }

    private class Config
    implements ConfigHandler {
        private static final String NSURI = "http://www.renderx.com/XEP/config";
        public final Hashtable options = new Hashtable();
        private int skip = 0;

        public void startDocument(Hashtable hashtable) {
        }

        public void endDocument(Hashtable hashtable) {
        }

        public void characters(char[] cArray, int n, int n2, Hashtable hashtable) {
            if (this.skip > 0) {
                return;
            }
        }

        public void processingInstruction(String string, String string2, Hashtable hashtable) {
            if (this.skip > 0) {
                return;
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes, Hashtable hashtable) {
            if (this.skip > 0) {
                ++this.skip;
                return;
            }
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
            if (string2.equals("option")) {
                String string4 = this.getRequiredValue(string2, attributes, "name");
                String string5 = this.getRequiredValue(string2, attributes, "value");
                if (string4 == null || string5 == null) {
                    return;
                }
                String string6 = (String)hashtable.get("generator-format");
                if (string6 == null) {
                    String string7 = string4.trim().toUpperCase().replace('-', '_');
                    String string8 = (String)optionTypes.get(string7);
                    if (string8 == null) {
                        Conf.this.printError("Invalid option name in the configuration file: " + string4);
                        return;
                    }
                    if ("URI".equals(string8)) {
                        try {
                            this.options.put(string7, new URLSpec((URLSpec)hashtable.get("base"), string5));
                        }
                        catch (MalformedURLException malformedURLException) {
                            Conf.this.printError("Invalid value in the configuration file: " + string4 + "=\"" + string5 + "\"; setting ignored");
                        }
                    } else {
                        this.options.put(string7, string5);
                    }
                } else {
                    Properties properties = (Properties)Conf.this.generatorOptions.get(string6);
                    if (properties == null) {
                        properties = new Properties();
                        Conf.this.generatorOptions.put(string6, properties);
                    }
                    properties.put(string4, string5);
                }
            } else if (string2.equals("generator-options")) {
                String string9 = this.getRequiredValue(string2, attributes, "format");
                if (string9 == null) {
                    return;
                }
                String string10 = backendAliases.getProperty(string9.trim().toLowerCase());
                if (string10 == null) {
                    Conf.this.printError("Invalid format name for generator options: '" + string9 + "'");
                }
                hashtable.put("generator-format", string10);
            } else if (string2.equals("charset")) {
                Conf.this.AFPCodePageName = this.getRequiredValue(string2, attributes, "name");
                Conf.this.arrayFrom.clear();
                Conf.this.arrayTo.clear();
                Conf.this.AFPCodePage = null;
                Conf.this.AFPName = null;
                Conf.this.AFPIbmName = null;
                Conf.this.AFPForceLatin = false;
            } else if (string2.equals("code-range")) {
                try {
                    int n = Integer.parseInt(this.getRequiredValue(string2, attributes, "from").substring(2, 6), 16);
                    int n2 = Integer.parseInt(this.getRequiredValue(string2, attributes, "to").substring(2, 6), 16);
                    Conf.this.arrayFrom.add(new Integer(n));
                    Conf.this.arrayTo.add(new Integer(n2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.skip = 1;
                    Conf.this.printError("Wrong number format; element skipped");
                }
            } else if (string2.equals("codepage")) {
                Conf.this.AFPName = this.getRequiredValue(string2, attributes, "name");
                Conf.this.AFPIbmName = this.getRequiredValue(string2, attributes, "ibm-name");
                String string11 = this.getRequiredValue(string2, attributes, "forcelatin");
                Conf.this.AFPForceLatin = this.parseBoolean(string11);
            } else if (string2.equals("character")) {
                String string12 = this.getRequiredValue(string2, attributes, "unicode");
                String string13 = "";
                if (this.skip != 0) {
                    return;
                }
                string13 = this.getRequiredValue(string2, attributes, "afp");
                try {
                    int n = Integer.parseInt(string12.substring(2, 6), 16);
                    int n3 = Integer.parseInt(string13.substring(2, 4), 16);
                    if (Conf.this.unicodeToAfp == null) {
                        Conf.this.unicodeToAfp = new HashMap();
                    }
                    Conf.this.unicodeToAfp.put(new Integer(n), new Integer(n3));
                }
                catch (NumberFormatException numberFormatException) {
                    this.skip = 1;
                    Conf.this.printError("Wrong number format; element skipped");
                }
            } else if (string2.equals("data-types")) {
                String string14 = attributes.getValue("default-name");
                if (string14 != null) {
                    Conf.this.defaultDataType = string14;
                }
            } else if (string2.equals("data-type")) {
                try {
                    String string15 = this.getRequiredValue(string2, attributes, "name");
                    boolean bl = this.parseBoolean(attributes.getValue("allow-instream"));
                    int n = Integer.decode(this.getRequiredValue(string2, attributes, "compression-code"));
                    int n4 = Integer.decode(this.getRequiredValue(string2, attributes, "recording-code"));
                    Conf.this.dataType = new DataType(string15, bl, n, n4);
                    if (string15 == Conf.this.defaultDataType) {
                        Conf.this.dataTypes.put("", Conf.this.dataType);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.skip = 1;
                    Conf.this.printError("Wrong number format" + numberFormatException.getMessage() + "; element skipped");
                }
            } else if (string2.equals("mime-type")) {
                String string16 = this.getRequiredValue(string2, attributes, "code");
                Conf.this.dataTypes.put(string16, Conf.this.dataType);
            }
        }

        private boolean parseBoolean(String string) {
            return "true".equals(string) || "yes".equals(string) || "1".equals(string);
        }

        public void endElement(String string, String string2, String string3, Hashtable hashtable) {
            if (this.skip > 0) {
                --this.skip;
                return;
            }
            if (!"".equals(string) && !NSURI.equals(string)) {
                return;
            }
            if (string2.equals("charset")) {
                String string4 = "AFP";
                Properties properties = (Properties)Conf.this.generatorOptions.get(string4);
                if (properties == null) {
                    properties = new Properties();
                    Conf.this.generatorOptions.put(string4, properties);
                }
                if (Conf.this.AFPName == null || Conf.this.AFPIbmName == null) {
                    return;
                }
                if (Conf.this.arrayFrom.size() == 0) {
                    Conf.this.printError("For codepage " + Conf.this.AFPCodePageName + "don`t define any code-range.");
                    return;
                }
                int n = (Integer)Conf.this.arrayFrom.get(0);
                int n2 = (Integer)Conf.this.arrayTo.get(0);
                Conf.this.AFPCodePage = new CodePage(Conf.this.AFPIbmName, Conf.this.AFPName, n, n2, Conf.this.AFPForceLatin);
                int n3 = 1;
                while (n3 < Conf.this.arrayFrom.size()) {
                    n = (Integer)Conf.this.arrayFrom.get(n3);
                    n2 = (Integer)Conf.this.arrayTo.get(n3);
                    Conf.this.AFPCodePage.addCodeRange(n, n2);
                    ++n3;
                }
                if (Conf.this.unicodeToAfp != null && Conf.this.unicodeToAfp.size() > 0) {
                    ((Conf)Conf.this).AFPCodePage.unicodeToAFP = Conf.this.unicodeToAfp;
                }
                Conf.this.unicodeToAfp = null;
                ((Conf)Conf.this).AFPCodePage.codePageNumber = Conf.this.AFPCodePageCounter;
                ((Conf)Conf.this).AFPCodePage.name = new String(Conf.this.AFPCodePageName);
                properties.put("CODEPAGE" + Conf.this.AFPCodePageName.toUpperCase(), Conf.this.AFPCodePage);
                properties.put("COUNTERCODEPAGE", new Integer(Conf.this.AFPCodePageCounter));
                Conf.this.AFPCodePageCounter++;
            } else if (string2.equals("data-types")) {
                String string5 = "AFP";
                Properties properties = (Properties)Conf.this.generatorOptions.get(string5);
                if (properties == null) {
                    properties = new Properties();
                    Conf.this.generatorOptions.put(string5, properties);
                }
                properties.put("DATATYPES", Conf.this.dataTypes);
            }
        }

        private final String getRequiredValue(String string, Attributes attributes, String string2) {
            String string3 = attributes.getValue(string2);
            if (string3 == null) {
                Conf.this.printError("Mandatory attribute '" + string2 + "' is missing on element '" + string + "'; element skipped");
                this.skip = 1;
            }
            return string3;
        }

        public final void parse(org.xml.sax.InputSource inputSource, XMLReader xMLReader) throws SAXException, IOException {
            xMLReader.setContentHandler(new ConfigHandlerAdapter(this, new URLSpec(inputSource.getSystemId())));
            xMLReader.parse(inputSource);
        }
    }

    private class LicenseReader
    extends DefaultHandler {
        private boolean insideAnnotation = false;
        private boolean insideProduct = false;
        private StringBuffer annotationBuffer = null;
        private String expirationDate = null;
        private boolean hasStamp = false;
        private boolean SVG = false;
        private boolean SVGTrial = false;
        private boolean XHTML = false;
        private boolean XHTMLTrial = false;
        private boolean XForms = false;
        private boolean XFormsTrial = false;
        private boolean XPS = false;
        private boolean XPSTrial = false;
        private boolean PPML = false;
        private boolean PPMLTrial = false;
        private boolean RichMediaObject = false;
        private boolean RichMediaObjectTrial = false;
        private boolean AFP = false;
        private boolean AFPTrial = false;
        private boolean feathering = false;
        private boolean insideCustomStamp = false;
        private StringBuffer customStamp = null;
        private boolean pdfforms = false;

        public LicenseReader(URLSpec uRLSpec) throws LicenseException {
            boolean bl = false;
            try {
                CarbonCopyParser carbonCopyParser = new CarbonCopyParser(XMLReaderFactory.createXMLReader());
                bl = CheckSignedXML.check(new InputSource(uRLSpec), carbonCopyParser, Conf.PUBLICKEY);
                SAXStorage sAXStorage = carbonCopyParser.getCC();
                sAXStorage.setContentHandler(this);
                sAXStorage.play();
            }
            catch (SAXException sAXException) {
                throw new LicenseException("Cannot parse license file '" + uRLSpec + "'", sAXException);
            }
            catch (IOException iOException) {
                throw new LicenseException("Cannot read license file '" + uRLSpec + "'", iOException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new LicenseException("Error processing license file '" + uRLSpec + "'", exception);
            }
            if (!bl) {
                throw new LicenseException("License check failed on license file '" + uRLSpec + "'");
            }
            if (Conf.compareDate(this.expirationDate) < 0) {
                throw new LicenseException("License in file '" + uRLSpec + "' expired " + this.expirationDate);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("license".equals(string2)) {
                this.expirationDate = attributes.getValue("expires");
            } else if ("product".equals(string2) && "XEP".equals(attributes.getValue("name"))) {
                this.insideProduct = true;
            } else if (this.insideProduct && "feature".equals(string2)) {
                String string4 = attributes.getValue("name");
                if ("stamp".equals(string4)) {
                    this.hasStamp = true;
                } else if ("annotation".equals(string4)) {
                    this.annotationBuffer = new StringBuffer();
                    this.insideAnnotation = true;
                } else if ("AFPBackend".equals(string4)) {
                    this.AFP = true;
                } else if ("AFPBackendTrial".equals(string4)) {
                    this.AFP = true;
                    this.AFPTrial = true;
                } else if ("XPSBackend".equals(string4)) {
                    this.XPS = true;
                } else if ("XPSBackend-trial".equals(string4)) {
                    this.XPS = true;
                    this.XPSTrial = true;
                } else if ("PPMLBackend".equals(string4)) {
                    this.PPML = true;
                } else if ("PPMLBackend-trial".equals(string4)) {
                    this.PPMLTrial = true;
                } else if ("RichMediaObject".equals(string4)) {
                    this.RichMediaObject = true;
                } else if ("RichMediaObject-trial".equals(string4)) {
                    this.RichMediaObjectTrial = true;
                } else if ("SVGBackend".equals(string4)) {
                    this.SVG = true;
                } else if ("SVGBackend-trial".equals(string4)) {
                    this.SVGTrial = true;
                } else if ("XHTMLBackend".equals(string4)) {
                    this.XHTML = true;
                } else if ("XHTMLBackend-trial".equals(string4)) {
                    this.XHTMLTrial = true;
                } else if ("XForms".equals(string4)) {
                    this.XForms = true;
                } else if ("XForms-trial".equals(string4)) {
                    this.XFormsTrial = true;
                } else if ("Feathering".equals(string4)) {
                    this.feathering = true;
                } else if ("CustomStamp".equals(string4)) {
                    this.customStamp = new StringBuffer();
                    this.insideCustomStamp = true;
                } else if ("PDFForms".equals(string4)) {
                    this.pdfforms = true;
                }
            }
        }

        public void endElement(String string, String string2, String string3) {
            if ("product".equals(string2)) {
                this.insideProduct = false;
            }
            if (this.insideProduct && "feature".equals(string2)) {
                this.insideAnnotation = false;
                this.insideCustomStamp = false;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            if (this.insideAnnotation) {
                this.annotationBuffer.append(cArray, n, n2);
            }
            if (this.insideCustomStamp) {
                this.customStamp.append(cArray, n, n2);
            }
        }

        public String getAnnotation() {
            if (this.annotationBuffer == null) {
                return null;
            }
            return this.annotationBuffer.toString().trim();
        }

        boolean hasStamp() {
            return this.hasStamp;
        }

        boolean AFPOn() {
            return this.AFP;
        }

        boolean AFPTrialOn() {
            return this.AFPTrial;
        }

        boolean SVGOn() {
            return this.SVG;
        }

        boolean SVGTrialOn() {
            return this.SVGTrial;
        }

        boolean XHTMLOn() {
            return this.XHTML;
        }

        boolean XHTMLTrialOn() {
            return this.XHTMLTrial;
        }

        boolean XFormsOn() {
            return this.XForms;
        }

        boolean XFormsTrialOn() {
            return this.XFormsTrial;
        }

        boolean XPSOn() {
            return this.XPS;
        }

        boolean XPSTrialOn() {
            return this.XPSTrial;
        }

        boolean PPMLOn() {
            return this.PPML;
        }

        boolean PPMLTrialOn() {
            return this.PPMLTrial;
        }

        boolean RichMediaObjectOn() {
            return this.RichMediaObject;
        }

        boolean RichMediaObjectTrialOn() {
            return this.RichMediaObjectTrial;
        }

        boolean FeatheringOn() {
            return this.feathering;
        }

        String getCustomStamp() {
            if (this.customStamp == null) {
                return null;
            }
            return this.customStamp.toString().trim();
        }

        boolean PDFFormsOn() {
            return this.pdfforms;
        }
    }

    public static class DataType {
        String name;
        boolean allowInstream;
        int compressionCode;
        int recordingCode;

        public DataType(String string, boolean bl, int n, int n2) {
            this.name = string;
            this.allowInstream = bl;
            this.compressionCode = n;
            this.recordingCode = n2;
        }

        public boolean isAllowInstream() {
            return this.allowInstream;
        }

        public int getCompressionCode() {
            return this.compressionCode;
        }

        public int getRecordingCode() {
            return this.recordingCode;
        }
    }
}

