/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.gen.backends;

import com.renderx.graphics.Image;
import com.renderx.graphics.ImageFactory;
import com.renderx.pdflib.PDFDocument;
import com.renderx.pdflib.PDFExternalFileException;
import com.renderx.util.Base32;
import com.renderx.util.ErrorHandler;
import com.renderx.util.Hashtable;
import com.renderx.util.List;
import com.renderx.util.RoleMap;
import com.renderx.util.Stack;
import com.renderx.util.URLSpec;
import com.renderx.xep.gen.H4base;
import com.renderx.xep.gen.backends.PDFLibInternalError;
import com.renderx.xep.gen.backends.Stamp;
import com.renderx.xep.gen.backends.Sticker;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Session;
import com.renderx.xep.pre.Elem;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class H4PDF
extends H4base {
    private static final short O_COMPRESS = 0;
    private static final short O_UNICODE_ANNOTATIONS = 1;
    private static final short O_OWNERPASSWORD = 2;
    private static final short O_USERPASSWORD = 3;
    private static final short O_USERPRIVILEGES = 4;
    private static final short O_DROP_UNUSED_DESTINATIONS = 5;
    private static final short O_LINEARIZE = 6;
    private static final short O_INITIAL_ZOOM = 7;
    private static final short O_VIEW_MODE = 8;
    private static final short O_PDF_VERSION = 9;
    private static final short O_CROP_OFFSET = 10;
    private static final short O_CROP_MARK_WIDTH = 11;
    private static final short O_BLEED = 12;
    private static final short O_BLEED_MARK_WIDTH = 13;
    private static final short O_PRINTER_MARK = 14;
    private static final short O_PDF_X = 15;
    private static final short O_ICC_PROFILE = 16;
    private static final short O_LOGICAL_PAGE_NUMBERING = 17;
    private static final short O_PAGE_LAYOUT = 18;
    private static final short O_VIEWER_PREFERENCES = 19;
    private static final short O_PDF_A = 20;
    private static final Hashtable optab = new Hashtable();
    private boolean COMPRESS;
    private boolean UNICODE_ANNOTATIONS;
    private boolean DROP_UNUSED_DESTINATIONS;
    private boolean LINEARIZE;
    private String OWNERPASSWORD;
    private String USERPASSWORD;
    private String USERPRIVILEGES;
    private String ZOOM;
    private String VIEW_MODE;
    private String PDF_VERSION;
    private Hashtable PAGE_BOUNDARIES;
    private List PRINTER_MARKS;
    private boolean needsAnnotation = false;
    private String PDF_X;
    private String ICC_PROFILE;
    private boolean taggedPDF = false;
    private boolean LOGICAL_PAGE_NUMBERING;
    private String PAGE_LAYOUT;
    private List VIEWER_PREFERENCES;
    private String PDF_A;
    private XPathList gXPath;
    private Stack cellType;
    private boolean footnotePending = false;
    private boolean tableRowPending = false;
    private boolean structElementBreak = false;
    private String structureTagName = null;
    private String artifactType = null;
    private String artifactSubtype = null;
    private static final String DEFAULT_LANG = "en";
    private static final String DEFAULT_ALT = "No alternate description specified";
    float[] currentAcroFieldRect = null;
    private boolean noAltDescWarning = false;
    private boolean noTRParentWarned = false;
    private boolean PDFFormsNotLicensedWarned = false;
    private boolean RichMediaObjectNotLicensedWarned = false;
    private int skip = 0;
    private static final String[] extraction_policy;
    private static final String DEFAULT_EXTRACTION_POLICY = "TEMPACCESS";
    private static final String DEFAULT_DURATION = "intrinsic";
    private static final float DEFAULT_PLAY_MODE = 1.0f;
    private static final int DEFAULT_VOLUME = 100;
    private static final Hashtable activate_condition;
    private static final String DEFAULT_ACTIVATE_CONDITION = "PV";
    private static final Hashtable deactivate_condition;
    private static final String DEFAULT_DEACTIVATE_CONDITION = "PI";
    private static final int DEFAULT_PLAY_COUNT = -1;
    private PDFDocument pdf = null;

    public H4PDF(OutputStream outputStream, Session session, Properties properties) throws IOException {
        super(outputStream, session, properties);
    }

    protected void resetDefaultOptions() {
        this.COMPRESS = true;
        this.UNICODE_ANNOTATIONS = true;
        this.DROP_UNUSED_DESTINATIONS = true;
        this.LINEARIZE = false;
        this.OWNERPASSWORD = "";
        this.USERPASSWORD = "";
        this.USERPRIVILEGES = "annotate";
        this.ZOOM = "auto";
        this.VIEW_MODE = "auto";
        this.PDF_VERSION = "1.4";
        this.PAGE_BOUNDARIES = new Hashtable();
        this.PRINTER_MARKS = new List();
        this.PDF_X = "";
        this.ICC_PROFILE = "";
        this.LOGICAL_PAGE_NUMBERING = true;
        this.PAGE_LAYOUT = "auto";
        this.VIEWER_PREFERENCES = new List();
        this.PDF_A = "";
    }

    protected void setOption(String string, String string2) {
        Object object = optab.get(string);
        if (object == null) {
            this.session.warning("Unrecognized PDF option " + string + ": setting ignored");
            return;
        }
        switch ((Short)object) {
            case 0: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.COMPRESS = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.COMPRESS = false;
                    break;
                }
                this.session.warning("Invalid COMPRESS value: " + string2 + "; setting ignored");
                break;
            }
            case 6: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.LINEARIZE = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.LINEARIZE = false;
                    break;
                }
                this.session.warning("Invalid LINEARIZE value: " + string2 + "; setting ignored");
                break;
            }
            case 5: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.DROP_UNUSED_DESTINATIONS = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.DROP_UNUSED_DESTINATIONS = false;
                    break;
                }
                this.session.warning("Invalid value for DROP_UNUSED_DESTINATIONS: " + string2 + "; setting ignored");
                break;
            }
            case 1: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.UNICODE_ANNOTATIONS = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.UNICODE_ANNOTATIONS = false;
                    break;
                }
                this.session.warning("Invalid UNICODE_ANNOTATIONS value: " + string2 + "; setting ignored");
                break;
            }
            case 2: {
                this.OWNERPASSWORD = string2;
                break;
            }
            case 3: {
                this.USERPASSWORD = string2;
                break;
            }
            case 4: {
                this.USERPRIVILEGES = string2;
                break;
            }
            case 7: {
                this.ZOOM = string2;
                break;
            }
            case 8: {
                this.VIEW_MODE = string2;
                break;
            }
            case 9: {
                this.PDF_VERSION = string2;
                break;
            }
            case 10: 
            case 12: {
                float[] fArray = this.parseOffsets(string, string2);
                if (this.pdf != null) {
                    this.pdf.setPageBoundaryEntry(string, fArray);
                    break;
                }
                this.PAGE_BOUNDARIES.put(string, fArray);
                break;
            }
            case 11: 
            case 13: {
                string2 = string2.trim();
                if ("none".equals(string2)) {
                    string2 = "0pt";
                }
                try {
                    string2 = String.valueOf(H4PDF.parseLengthSpecifier(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.session.error(numberFormatException.getMessage() + "; option '" + string + "' ignored");
                    break;
                }
                if (this.pdf != null) {
                    this.pdf.setPageBoundaryEntry(string, string2);
                    break;
                }
                this.PAGE_BOUNDARIES.put(string, string2);
                break;
            }
            case 14: {
                String string3 = this.resolveURL(string, string2);
                if (this.pdf != null) {
                    this.pdf.setPrinterMarkEntry(string3);
                    break;
                }
                this.PRINTER_MARKS.append(string3);
                break;
            }
            case 15: {
                this.PDF_X = string2;
                break;
            }
            case 16: {
                this.ICC_PROFILE = this.resolveURL(string, string2);
                break;
            }
            case 17: {
                string2 = string2.trim().toLowerCase();
                if ("true".equals(string2) || "yes".equals(string2)) {
                    this.LOGICAL_PAGE_NUMBERING = true;
                    break;
                }
                if ("false".equals(string2) || "no".equals(string2)) {
                    this.LOGICAL_PAGE_NUMBERING = false;
                    break;
                }
                this.session.warning("Invalid LOGICAL_PAGE_NUMBERING value: " + string2 + "; setting ignored");
                break;
            }
            case 18: {
                this.PAGE_LAYOUT = string2;
                break;
            }
            case 19: {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4 = stringTokenizer.nextToken();
                    string4.trim();
                    this.VIEWER_PREFERENCES.append(string4);
                }
                break;
            }
            case 20: {
                this.PDF_A = string2;
            }
        }
    }

    private final float[] parseOffsets(String string, String string2) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        string2.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,\t\n\r\f");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringTokenizer.nextToken();
            ++n;
        }
        stringTokenizer = new StringTokenizer(string2);
        try {
            switch (n) {
                case 1: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        string3.trim();
                        f = H4PDF.parseLengthSpecifier(string3);
                        f2 = H4PDF.parseLengthSpecifier(string3);
                        f3 = H4PDF.parseLengthSpecifier(string3);
                        f4 = H4PDF.parseLengthSpecifier(string3);
                    }
                    break;
                }
                case 2: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        string4.trim();
                        f = H4PDF.parseLengthSpecifier(string4);
                        f3 = H4PDF.parseLengthSpecifier(string4);
                        if (stringTokenizer.hasMoreTokens()) {
                            string4 = stringTokenizer.nextToken();
                            string4.trim();
                            f2 = H4PDF.parseLengthSpecifier(string4);
                            f4 = H4PDF.parseLengthSpecifier(string4);
                        }
                    }
                    break;
                }
                case 3: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        string5.trim();
                        f = H4PDF.parseLengthSpecifier(string5);
                        if (stringTokenizer.hasMoreTokens()) {
                            string5 = stringTokenizer.nextToken();
                            string5.trim();
                            f2 = H4PDF.parseLengthSpecifier(string5);
                            f4 = H4PDF.parseLengthSpecifier(string5);
                            if (stringTokenizer.hasMoreTokens()) {
                                string5 = stringTokenizer.nextToken();
                                string5.trim();
                                f3 = H4PDF.parseLengthSpecifier(string5);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        string6.trim();
                        f = H4PDF.parseLengthSpecifier(string6);
                        if (stringTokenizer.hasMoreTokens()) {
                            string6 = stringTokenizer.nextToken();
                            string6.trim();
                            f2 = H4PDF.parseLengthSpecifier(string6);
                            if (stringTokenizer.hasMoreTokens()) {
                                string6 = stringTokenizer.nextToken();
                                string6.trim();
                                f3 = H4PDF.parseLengthSpecifier(string6);
                                if (stringTokenizer.hasMoreTokens()) {
                                    string6 = stringTokenizer.nextToken();
                                    string6.trim();
                                    f4 = H4PDF.parseLengthSpecifier(string6);
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    this.session.warning("Incorrect number of tokens in " + string + "; setting ignored");
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.session.warning(numberFormatException.getMessage() + "; option '" + string + "' ignored");
        }
        return new float[]{f4, f3, f2, f};
    }

    private static final float parseLengthSpecifier(String string) throws NumberFormatException {
        double d = 1.0;
        if (string.endsWith("pt")) {
            d = 1.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("in")) {
            d = 72.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("px")) {
            d = 0.6;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("pc")) {
            d = 12.0;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("cm")) {
            d = 28.346456692913385;
            string = string.substring(0, string.length() - 2);
        } else if (string.endsWith("mm")) {
            d = 2.834645669291339;
            string = string.substring(0, string.length() - 2);
        } else {
            throw new NumberFormatException("Unknown measurement units in '" + string + "'");
        }
        return (float)(Double.valueOf(string.trim()) * d);
    }

    private final String resolveURL(String string, String string2) {
        String string3;
        if (string2 != null && string2.trim().startsWith("url") && (string3 = string2.trim().substring(3).trim()).length() > 2 && string3.charAt(0) == '(' && string3.charAt(string3.length() - 1) == ')' && (string3 = string3.substring(1, string3.length() - 1).trim()).length() > 2) {
            if (string3.charAt(0) == '\'' && string3.charAt(string3.length() - 1) == '\'' || string3.charAt(0) == '\"' && string3.charAt(string3.length() - 1) == '\"') {
                string3 = string3.substring(1, string3.length() - 1);
            }
            return string3;
        }
        this.session.warning("Incorrect syntax in " + string + "; should be: url('<sorce name>')");
        return string2;
    }

    public String outFormat() {
        return "pdf";
    }

    protected String getPropertyPrefix() {
        return "com.renderx.xep.H4PDF.";
    }

    protected String getProcessingInstructionPrefix() {
        return "xep-pdf-";
    }

    private void initDocument() {
        Object object;
        Object object2;
        try {
            this.pdf = new PDFDocument(this.outstream, (ImageFactory)this.session.config.imageFactory, this.session.config.fontCatalog, (ErrorHandler)this.session);
        }
        catch (IOException iOException) {
            this.session.exception("Cannot initialize PDF document", iOException);
            throw new RuntimeException("Invalid output stream" + iOException.toString());
        }
        this.pdf.setTMPDIR(this.session.config.TMPDIR);
        this.pdf.setCompression(this.COMPRESS);
        this.pdf.setUnicodeAnnotations(this.UNICODE_ANNOTATIONS);
        this.pdf.setDestinationTreatment(this.DROP_UNUSED_DESTINATIONS);
        this.pdf.setLinearize(this.LINEARIZE);
        this.pdf.setInitialZoom(this.ZOOM);
        this.pdf.setViewMode(this.VIEW_MODE);
        this.pdf.setPDFVersion(this.PDF_VERSION);
        this.taggedPDF = this.session.config.ENABLE_ACCESSIBILITY && this.session.config.ROLE_MAP != null;
        this.pdf.setTaggedPDF(this.taggedPDF);
        if (this.taggedPDF) {
            this.gXPath = new XPathList();
            this.cellType = new Stack();
        }
        if (this.PDF_X.length() != 0) {
            this.pdf.setPDFXConformanceStatus(this.PDF_X);
        }
        if (this.PDF_A.length() != 0) {
            this.pdf.setPDFAConformanceStatus(this.PDF_A);
        }
        if (this.session.config.ANNOTATION != null) {
            this.needsAnnotation = true;
        }
        if (this.OWNERPASSWORD.length() != 0 || this.USERPASSWORD.length() != 0) {
            if (this.pdf.hasPDFX()) {
                this.session.warning("PDF/X of version " + this.pdf.getPDFXConformanceStatus() + " may not use encryption; settings ignored.");
            } else if (this.pdf.hasPDFA()) {
                this.session.warning("PDF/A of version " + this.pdf.getPDFXConformanceStatus() + " may not use encryption; settings ignored.");
            } else {
                if (this.OWNERPASSWORD.length() == 0) {
                    this.OWNERPASSWORD = this.USERPASSWORD;
                }
                int n = -64;
                if (this.USERPRIVILEGES != null) {
                    object2 = new StringTokenizer(this.USERPRIVILEGES, " \t\r\n,+;:");
                    while (((StringTokenizer)object2).hasMoreTokens()) {
                        object = ((StringTokenizer)object2).nextToken();
                        if ("print".equalsIgnoreCase((String)object)) {
                            n |= 4;
                            continue;
                        }
                        if ("annotate".equalsIgnoreCase((String)object)) {
                            n |= 0x20;
                            continue;
                        }
                        if ("modify".equalsIgnoreCase((String)object)) {
                            n |= 8;
                            continue;
                        }
                        if ("copy".equalsIgnoreCase((String)object)) {
                            n |= 0x10;
                            continue;
                        }
                        this.session.warning("Invalid token in USERPRIVILEGES: " + (String)object + "; token ignored");
                    }
                }
                this.pdf.setEncryption(this.USERPASSWORD, this.OWNERPASSWORD, n);
            }
        }
        Enumeration enumeration = this.PAGE_BOUNDARIES.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = this.PAGE_BOUNDARIES.get(object2);
            this.pdf.setPageBoundaryEntry((String)object2, object);
        }
        enumeration = this.PRINTER_MARKS.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            this.pdf.setPrinterMarkEntry((String)object2);
        }
        if (this.ICC_PROFILE.length() != 0) {
            this.pdf.addOutputIntent(this.ICC_PROFILE);
        }
        this.pdf.setPageNumbering(this.LOGICAL_PAGE_NUMBERING);
        this.pdf.setPageLayout(this.PAGE_LAYOUT);
        enumeration = this.VIEWER_PREFERENCES.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            this.pdf.setViewerSetting((String)object2);
        }
    }

    private void writeHeader() throws PDFLibInternalError {
        try {
            this.pdf.startDocument();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setInfo(String string, String string2) throws PDFLibInternalError {
        try {
            this.pdf.setInfo(string, string2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void beginPage(float f, float f2, String string, String string2, String string3) throws PDFLibInternalError {
        try {
            this.pdf.beginPage(f, f2, string, string2, string3);
            if (this.needsAnnotation) {
                this.pdf.addTextAnnotation(0.0f, f2 - Sticker.height, Sticker.width, f2, Sticker.makeText(this.session.config.ANNOTATION), Sticker.title, Sticker.color);
                this.needsAnnotation = false;
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void endPage() throws PDFLibInternalError {
        try {
            if (this.session.config.CUSTOM_STAMP == null & this.session.config.PUT_STAMP) {
                Stamp.put(this, this.session);
            }
            if (this.session.config.CUSTOM_STAMP != null) {
                this.putCustomStamp();
            }
            this.pdf.endPage();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void close() throws PDFLibInternalError {
        try {
            this.pdf.endDocument();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void rotate(float f) throws PDFLibInternalError {
        try {
            this.pdf.rotate(f);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void scale(float f, float f2) throws PDFLibInternalError {
        try {
            this.pdf.scale(f, f2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void translate(float f, float f2) throws PDFLibInternalError {
        try {
            this.pdf.translate(f, f2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void transform(float f, float f2, float f3, float f4, float f5, float f6) throws PDFLibInternalError {
        try {
            this.pdf.transform(f, f2, f3, f4, f5, f6);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void moveTo(float f, float f2) throws PDFLibInternalError {
        try {
            this.pdf.moveTo(f, f2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void lineTo(float f, float f2) throws PDFLibInternalError {
        try {
            this.pdf.lineTo(f, f2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        try {
            this.pdf.curveTo(f, f2, f3, f4, f5, f6);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void rectangle(float f, float f2, float f3, float f4) throws PDFLibInternalError {
        try {
            this.pdf.rectangle(f, f2, f3, f4);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setTextPos(float f, float f2) throws PDFLibInternalError {
        try {
            this.pdf.setTextPos(f, f2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setCharSpacing(float f) throws PDFLibInternalError {
        try {
            this.pdf.setCharSpacing(f);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setWordSpacing(float f) throws PDFLibInternalError {
        try {
            this.pdf.setWordSpacing(f);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setFontStretch(float f) {
        this.pdf.setHorzScale(f);
    }

    private void processText(String string) throws PDFLibInternalError, IOException {
        this.pdf.processText(string, this.currentAcroFieldRect != null);
    }

    private void setFont(String string, int n, String string2, String string3, float f) {
        this.pdf.selectFont(string, n, string2, string3);
        this.pdf.setFontSize(f);
    }

    private void save() throws PDFLibInternalError {
        try {
            this.pdf.save();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void restore() throws PDFLibInternalError {
        try {
            this.pdf.restore();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setBorderStyle(String string, int n) throws PDFLibInternalError {
        try {
            this.pdf.setBorderStyle(string, n);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setDash(float f, float f2, float f3) throws PDFLibInternalError {
        try {
            this.pdf.setDash(f, f2, f3);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setLineCap(int n) throws PDFLibInternalError {
        try {
            this.pdf.setLineCap(n);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setLineWidth(float f) throws PDFLibInternalError {
        try {
            this.pdf.setLineWidth(f);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void placeImage(String string, String string2, String string3, int n) throws PDFLibInternalError {
        try {
            String string4 = n == -1 ? string : string + "?rx:page-number=" + n;
            try {
                this.pdf.placeImage(new URLSpec(string2 == null ? null : new URLSpec(string2), string4), string3);
            }
            catch (PDFExternalFileException pDFExternalFileException) {
                this.session.warning("Cannot insert image: " + pDFExternalFileException.getMessage());
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void placeMedia(float f, float f2, float f3, float f4, String string, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, String string6, String string7, float f5, int n) throws PDFLibInternalError {
        try {
            try {
                this.pdf.placeMedia(f, f2, f3, f4, new URLSpec(string2 == null ? null : new URLSpec(string2), string), string3, bl, bl2, string4, string5, string6, string7, f5, n);
            }
            catch (RuntimeException runtimeException) {
                this.session.warning("Cannot insert media: " + runtimeException.getMessage());
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void placeRichMedia(float f, float f2, float f3, float f4, String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, int n) throws PDFLibInternalError {
        try {
            try {
                this.pdf.placeRichMedia(f, f2, f3, f4, new URLSpec(string2 == null ? null : new URLSpec(string2), string), string3, string4, string5, bl, string6, string7, n);
            }
            catch (RuntimeException runtimeException) {
                this.session.warning("Cannot insert media: " + runtimeException.getMessage());
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addAttachedFile(String string, String string2, String string3) throws PDFLibInternalError {
        try {
            try {
                this.pdf.addAttachedFile(new URLSpec(string2 == null ? null : new URLSpec(string2), string), string3);
            }
            catch (RuntimeException runtimeException) {
                this.session.warning("Cannot attach file: " + runtimeException.getMessage());
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setRGBColor(float f, float f2, float f3) throws PDFLibInternalError {
        try {
            this.pdf.setRGBColor(f, f2, f3);
            if (this.currentAcroFieldRect != null) {
                this.pdf.setPDFFormFieldColor(new float[]{f, f2, f3});
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setGray(float f) throws PDFLibInternalError {
        try {
            this.pdf.setGray(f);
            if (this.currentAcroFieldRect != null) {
                this.pdf.setPDFFormFieldColor(new float[]{f});
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setCMYKColor(float f, float f2, float f3, float f4) throws PDFLibInternalError {
        try {
            this.pdf.setCMYKColor(f, f2, f3, f4);
            if (this.currentAcroFieldRect != null) {
                this.pdf.setPDFFormFieldColor(new float[]{f, f2, f3, f4});
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setSpotColor(float f, String string, float[] fArray) throws PDFLibInternalError {
        try {
            this.pdf.setSpotColor(f, string, fArray);
            if (this.currentAcroFieldRect != null) {
                this.pdf.setPDFFormFieldColor(fArray);
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void clip() throws PDFLibInternalError {
        try {
            this.pdf.clip();
            this.pdf.endPath();
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void closePath() throws PDFLibInternalError {
        try {
            this.pdf.closePath();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void fill() throws PDFLibInternalError {
        try {
            this.pdf.fill();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void stroke() throws PDFLibInternalError {
        try {
            this.pdf.stroke();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void fill_stroke() throws PDFLibInternalError {
        try {
            this.pdf.fillStroke();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void endPath() throws PDFLibInternalError {
        try {
            this.pdf.endPath();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addLocalLink(String string, float f, float f2, float f3, float f4, String string2, String string3) throws PDFLibInternalError {
        try {
            this.pdf.addLocalLink(string, f, f2, f3, f4, string2, string3);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addWebLink(float f, float f2, float f3, float f4, String string, boolean bl, String string2) throws PDFLibInternalError {
        try {
            this.pdf.addWebLink(f, f2, f3, f4, string, bl, string2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addLocalBookmark(String string, String string2, String string3, int n, int n2, int n3, boolean bl) throws PDFLibInternalError {
        try {
            this.pdf.addLocalBookmark(string, string2, string3, n, n2, n3, bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addWebBookmark(String string, String string2, int n, int n2, int n3, String string3, boolean bl, boolean bl2) throws PDFLibInternalError {
        try {
            this.pdf.addWebBookmark(string, string2, n, n2, n3, string3, bl, bl2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addNamedDestination(String string, float f, float f2) throws PDFLibInternalError {
        try {
            this.pdf.addNamedDestination(string, f, f2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addJavaScript(String string, String string2) throws PDFLibInternalError {
        try {
            this.pdf.addJavaScript(string, string2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setOverprintFlag(String string) throws PDFLibInternalError {
        if (null == string) {
            return;
        }
        try {
            this.pdf.setOverprintFlag("true".equals(string));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void addStructElemItem(Node node, String string) throws PDFLibInternalError {
        try {
            this.pdf.addStructElemItem(node.name(), node.last ? this.structureTagName : null, node.position(), string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void closeStructElemItem() throws PDFLibInternalError {
        try {
            this.pdf.closeStructElemItem();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void setStructOptionalKey(String string, String string2) throws PDFLibInternalError {
        try {
            this.pdf.setStructOptionalKey(string, string2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    public void startMarkedContent(String string) throws PDFLibInternalError {
        try {
            this.pdf.startMarkedContent(string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    public void startArtifactMarkedContent(String string, String string2) throws PDFLibInternalError {
        try {
            this.pdf.startArtifactMarkedContent(string, string2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    public void endMarkedContent(short s) throws PDFLibInternalError {
        switch (s) {
            case 6: 
            case 7: {
                break;
            }
            default: {
                this.structElementBreak = true;
                try {
                    this.pdf.endMarkedContent();
                    break;
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new PDFLibInternalError(exception);
                }
            }
        }
    }

    private void setLanguage(String string) throws PDFLibInternalError {
        try {
            this.pdf.setLanguage(string);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void processXPath(String string) throws PDFLibInternalError {
        if (!this.taggedPDF) {
            return;
        }
        try {
            XPathParser xPathParser = new XPathParser(string, this.session);
            xPathParser.parse();
            if (xPathParser.isMarkedContent()) {
                Node node = xPathParser.currentNode();
                String string2 = PDFDocument.getTagMapping(node.name(), this.structureTagName);
                if ("Artifact".equals(string2)) {
                    this.startArtifactMarkedContent(this.artifactType, this.artifactSubtype);
                } else {
                    this.startMarkedContent(string2 == null ? (String)RoleMap.roleMapTable.get(node.name()) : string2);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    private void closeXPath() throws PDFLibInternalError {
        if (!this.taggedPDF) {
            return;
        }
        try {
            XPathParser xPathParser = new XPathParser(null);
            xPathParser.closeAll();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new PDFLibInternalError(exception);
        }
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        try {
            this.close();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at the end of document " + exception);
        }
        super.endDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.skip > 0) {
            ++this.skip;
            return;
        }
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            this.skip = 1;
            return;
        }
        if (this.taggedPDF && attributes.getValue("xpath") == null) {
            this.endMarkedContent((Short)H4base.idtab.get(string2));
        }
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    String string4;
                    String string5;
                    this.initDocument();
                    this.writeHeader();
                    this.setBorderStyle("solid", 0);
                    this.setInfo("Producer", this.normalize_space(attributes.getValue("producer")));
                    this.setInfo("Publisher", this.normalize_space(attributes.getValue("publisher")));
                    this.setInfo("Creator", this.normalize_space(attributes.getValue("creator")));
                    this.setInfo("Author", this.normalize_space(attributes.getValue("author")));
                    this.setInfo("Title", this.normalize_space(attributes.getValue("title")));
                    this.setInfo("Subject", this.normalize_space(attributes.getValue("subject")));
                    this.setInfo("Keywords", this.normalize_space(attributes.getValue("keywords")));
                    int n = 0;
                    while (n < attributes.getLength()) {
                        string5 = attributes.getLocalName(n);
                        if (string5.startsWith("__custom_field__")) {
                            string4 = string5.substring("__custom_field__".length());
                            string4 = new String(Base32.decode(string4));
                            this.setInfo(string4, this.normalize_space(attributes.getValue(n)));
                        }
                        ++n;
                    }
                    string5 = attributes.getValue("initial-destination");
                    if (string5 != null) {
                        this.pdf.setInitialDestination(string5);
                    }
                    if (this.taggedPDF) {
                        string4 = attributes.getValue("language");
                        if (string4 == null) {
                            if (this.PDF_A.length() != 0) {
                                this.session.warning("Some text elements have no language specified; 'en' will be used.");
                            }
                            string4 = DEFAULT_LANG;
                        }
                        this.setLanguage(string4);
                    }
                    if (attributes.getValue("js-open") != null) {
                        this.pdf.setOpenActionJS(attributes.getValue("js-open"));
                    }
                    int n2 = 0;
                    while (n2 < PDFDocument.DocumentAdditionalAcrionNames.length) {
                        String string6 = PDFDocument.DocumentAdditionalAcrionNames[n2];
                        String string7 = attributes.getValue(string6);
                        if (string7 != null) {
                            this.pdf.setDocumentAdditionalAction(string6, string7);
                        }
                        ++n2;
                    }
                    break;
                }
                case 37: {
                    this.addJavaScript(attributes.getValue("name"), attributes.getValue("value"));
                    break;
                }
                case 1: {
                    this.structElementBreak = true;
                    this.beginPage(H4PDF.parseLength(attributes.getValue("width")), H4PDF.parseLength(attributes.getValue("height")), attributes.getValue("page-id"), attributes.getValue("js-open"), attributes.getValue("js-close"));
                    break;
                }
                case 2: {
                    this.rotate(H4PDF.parseAngle(attributes.getValue("phi")));
                    break;
                }
                case 3: {
                    this.translate(H4PDF.parseLength(attributes.getValue("x")), H4PDF.parseLength(attributes.getValue("y")));
                    break;
                }
                case 4: {
                    this.transform(H4PDF.parseFloat(attributes.getValue("a")), H4PDF.parseFloat(attributes.getValue("b")), H4PDF.parseFloat(attributes.getValue("c")), H4PDF.parseFloat(attributes.getValue("d")), H4PDF.parseFloat(attributes.getValue("e")), H4PDF.parseFloat(attributes.getValue("f")));
                    break;
                }
                case 6: {
                    this.setWordSpacing(H4PDF.parseLength(attributes.getValue("value")));
                    break;
                }
                case 7: {
                    this.setCharSpacing(H4PDF.parseLength(attributes.getValue("value")));
                    break;
                }
                case 8: {
                    this.setFontStretch(H4PDF.parseFloat(attributes.getValue("value")));
                    break;
                }
                case 9: {
                    this.setFont(attributes.getValue("family"), H4PDF.parseInteger(attributes.getValue("weight")), attributes.getValue("style"), attributes.getValue("variant"), H4PDF.parseLength(attributes.getValue("size")));
                    break;
                }
                case 10: 
                case 45: {
                    if (this.taggedPDF) {
                        this.structureTagName = attributes.getValue("pdf-structure-tag");
                        this.artifactType = attributes.getValue("pdf-artifact-type");
                        this.artifactSubtype = attributes.getValue("pdf-artifact-subtype");
                        this.processXPath(attributes.getValue("xpath"));
                        String string8 = attributes.getValue("language");
                        if (string8 != null) {
                            String string9 = attributes.getValue("country");
                            if (string9 != null) {
                                string8 = string8 + "-" + string9;
                            }
                            this.setStructOptionalKey("Lang", string8);
                        }
                        this.setStructOptionalKey("Alt", attributes.getValue("alt-description"));
                        this.setStructOptionalKey("ActualText", attributes.getValue("actual-text"));
                        this.setStructOptionalKey("E", attributes.getValue("abbreviation"));
                    }
                    this.setTextPos(H4PDF.parseLength(attributes.getValue("x")), H4PDF.parseLength(attributes.getValue("y")));
                    this.processText(attributes.getValue("value"));
                    break;
                }
                case 11: {
                    float f = H4PDF.parseLength(attributes.getValue("thickness"));
                    String string10 = attributes.getValue("style");
                    if (this.currentAcroFieldRect != null) {
                        this.pdf.setPDFFormFieldBorder(f, string10);
                    }
                    if (!(f <= 0.0f)) {
                        float f2 = H4PDF.parseLength(attributes.getValue("x-from"));
                        float f3 = H4PDF.parseLength(attributes.getValue("y-from"));
                        float f4 = H4PDF.parseLength(attributes.getValue("x-till"));
                        float f5 = H4PDF.parseLength(attributes.getValue("y-till"));
                        this.save();
                        if (string10.equals("dotted")) {
                            float f6 = H4PDF.getLineLength(f2, f3, f4, f5) / f;
                            float f7 = f6 - (float)(2.0 * Math.floor(f6 / 2.0f));
                            float f8 = 2.0f - f7 / 2.0f;
                            if (f6 > 2.0f && (double)f8 > 1.5) {
                                f8 -= 1.0f;
                            }
                            this.setDash(f8 * f, 0.0f, 2.0f * f);
                            this.setLineCap(1);
                        } else if (string10.equals("dashed")) {
                            float f9 = H4PDF.getLineLength(f2, f3, f4, f5) / f;
                            float f10 = f9 + 4.0f - (float)(10.0 * Math.floor((f9 + 4.0f) / 10.0f));
                            float f11 = 10.0f - f10 / 2.0f;
                            if (f11 < 8.0f || f9 < 6.0f) {
                                f11 -= 5.0f;
                            }
                            if (f11 == 10.0f) {
                                f11 = 0.0f;
                            }
                            this.setDash(f11 * f, 6.0f * f, 4.0f * f);
                            this.setLineCap(0);
                        } else {
                            this.setLineCap(0);
                        }
                        this.setLineWidth(f);
                        this.moveTo(f2, f3);
                        this.lineTo(f4, f5);
                        this.stroke();
                        this.restore();
                    }
                    break;
                }
                case 38: {
                    if (!this.pdf.isRMA() && !this.pdf.isMA()) break;
                }
                case 15: {
                    float f = H4PDF.parseFloat(attributes.getValue("scale-x"));
                    float f12 = H4PDF.parseFloat(attributes.getValue("scale-y"));
                    if (f != 0.0f && f12 != 0.0f) {
                        int n;
                        String string11 = attributes.getValue("src");
                        String string12 = attributes.getValue("base");
                        String string13 = attributes.getValue("type");
                        String string14 = attributes.getValue("page-number");
                        int n3 = n = string14 == null ? -1 : H4PDF.parseInteger(string14) - 1;
                        if (this.taggedPDF) {
                            this.structureTagName = attributes.getValue("pdf-structure-tag");
                            this.artifactType = attributes.getValue("pdf-artifact-type");
                            this.artifactSubtype = attributes.getValue("pdf-artifact-subtype");
                            String string15 = attributes.getValue("xpath");
                            if ("true".equals(attributes.getValue("is-background"))) {
                                string15 = string15 + "/*[1][name()='external-graphic']";
                            }
                            this.processXPath(string15);
                            String string16 = attributes.getValue("alt-description");
                            if (string16 == null) {
                                string16 = attributes.getValue("role");
                            }
                            if ("none".equals(string16)) {
                                if (!this.noAltDescWarning) {
                                    if (this.PDF_A.length() != 0) {
                                        this.session.warning("Some images lack alternate desription; 'No alternate description specified' will be used for these images.");
                                    }
                                    this.noAltDescWarning = true;
                                }
                                string16 = DEFAULT_ALT;
                            }
                            this.setStructOptionalKey("Alt", string16);
                            this.setStructOptionalKey("ActualText", attributes.getValue("actual-text"));
                            this.setStructOptionalKey("E", attributes.getValue("abbreviation"));
                        }
                        this.save();
                        this.translate(H4PDF.parseLength(attributes.getValue("x-from")), H4PDF.parseLength(attributes.getValue("y-from")));
                        this.scale(f, f12);
                        this.placeImage(string11, string12, string13, n);
                        this.restore();
                        break;
                    }
                }
                {
                    break;
                }
                case 16: {
                    if (this.pdf.isBookmark()) {
                        if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 4) {
                            this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " bookmarks coloring is supported only for PDF 1.4 and higher.");
                            break;
                        }
                        this.pdf.setBookmarkColor(H4PDF.parseFloat(attributes.getValue("red")), H4PDF.parseFloat(attributes.getValue("green")), H4PDF.parseFloat(attributes.getValue("blue")));
                        break;
                    }
                    if (this.pdf.isPDFComment()) {
                        this.pdf.setAnnotColor(H4PDF.parseFloat(attributes.getValue("red")), H4PDF.parseFloat(attributes.getValue("green")), H4PDF.parseFloat(attributes.getValue("blue")));
                        break;
                    }
                    this.setOverprintFlag(attributes.getValue("overprint"));
                    this.setRGBColor(H4PDF.parseFloat(attributes.getValue("red")), H4PDF.parseFloat(attributes.getValue("green")), H4PDF.parseFloat(attributes.getValue("blue")));
                    break;
                }
                case 17: {
                    if (this.pdf.isBookmark()) {
                        if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 4) {
                            this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " bookmarks coloring is supported only for PDF 1.4 and higher.");
                            break;
                        }
                        this.pdf.setBookmarkColor(H4PDF.parseFloat(attributes.getValue("gray")), H4PDF.parseFloat(attributes.getValue("gray")), H4PDF.parseFloat(attributes.getValue("gray")));
                        break;
                    }
                    if (this.pdf.isPDFComment()) {
                        this.pdf.setAnnotColor(H4PDF.parseFloat(attributes.getValue("gray")), H4PDF.parseFloat(attributes.getValue("gray")), H4PDF.parseFloat(attributes.getValue("gray")));
                        break;
                    }
                    this.setOverprintFlag(attributes.getValue("overprint"));
                    this.setGray(H4PDF.parseFloat(attributes.getValue("gray")));
                    break;
                }
                case 18: {
                    if (this.pdf.isBookmark()) {
                        if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 4) {
                            this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " bookmarks coloring is supported only for PDF 1.4 and higher.");
                            break;
                        }
                        this.pdf.setBookmarkColor(H4PDF.parseFloat(attributes.getValue("cyan")), H4PDF.parseFloat(attributes.getValue("magenta")), H4PDF.parseFloat(attributes.getValue("yellow")), H4PDF.parseFloat(attributes.getValue("black")));
                        break;
                    }
                    if (this.pdf.isPDFComment()) {
                        this.pdf.setAnnotColor(H4PDF.parseFloat(attributes.getValue("cyan")), H4PDF.parseFloat(attributes.getValue("magenta")), H4PDF.parseFloat(attributes.getValue("yellow")), H4PDF.parseFloat(attributes.getValue("black")));
                        break;
                    }
                    this.setOverprintFlag(attributes.getValue("overprint"));
                    this.setCMYKColor(H4PDF.parseFloat(attributes.getValue("cyan")), H4PDF.parseFloat(attributes.getValue("magenta")), H4PDF.parseFloat(attributes.getValue("yellow")), H4PDF.parseFloat(attributes.getValue("black")));
                    break;
                }
                case 19: {
                    if (this.pdf.isBookmark() || this.pdf.isPDFComment()) {
                        this.session.warning("Spot color is not supported in '" + string2 + "' element");
                        break;
                    }
                    this.setOverprintFlag(attributes.getValue("overprint"));
                    String string17 = attributes.getValue("colorant");
                    float f = H4PDF.parseFloat(attributes.getValue("tint"));
                    if (attributes.getValue("alt-gray") != null) {
                        this.setSpotColor(f, string17, new float[]{H4PDF.parseFloat(attributes.getValue("alt-gray"))});
                        break;
                    }
                    if (attributes.getValue("alt-red") != null) {
                        this.setSpotColor(f, string17, new float[]{H4PDF.parseFloat(attributes.getValue("alt-red")), H4PDF.parseFloat(attributes.getValue("alt-green")), H4PDF.parseFloat(attributes.getValue("alt-blue"))});
                        break;
                    }
                    if (attributes.getValue("alt-cyan") != null) {
                        this.setSpotColor(f, string17, new float[]{H4PDF.parseFloat(attributes.getValue("alt-cyan")), H4PDF.parseFloat(attributes.getValue("alt-magenta")), H4PDF.parseFloat(attributes.getValue("alt-yellow")), H4PDF.parseFloat(attributes.getValue("alt-black"))});
                        break;
                    }
                    this.setSpotColor(f, string17, new float[]{0.0f});
                    break;
                }
                case 20: {
                    if (this.pdf.isBookmark() || this.pdf.isPDFComment()) {
                        this.session.warning("Registration color is not supported in '" + string2 + "' element");
                        break;
                    }
                    this.setOverprintFlag(attributes.getValue("overprint"));
                    this.setSpotColor(H4PDF.parseFloat(attributes.getValue("tint")), "All", new float[]{0.0f});
                    break;
                }
                case 12: {
                    float f = H4PDF.parseLength(attributes.getValue("x-from"));
                    float f13 = H4PDF.parseLength(attributes.getValue("y-from"));
                    float f14 = H4PDF.parseLength(attributes.getValue("x-till"));
                    float f15 = H4PDF.parseLength(attributes.getValue("y-till"));
                    this.moveTo(f, f13);
                    this.lineTo(f, f15);
                    this.lineTo(f14, f15);
                    this.lineTo(f14, f13);
                    this.closePath();
                    this.fill();
                    if (this.currentAcroFieldRect != null) {
                        this.pdf.setPDFFormFieldBackground();
                    }
                    break;
                }
                case 5: {
                    float f = H4PDF.parseLength(attributes.getValue("x-from"));
                    float f16 = H4PDF.parseLength(attributes.getValue("y-from"));
                    float f17 = H4PDF.parseLength(attributes.getValue("x-till"));
                    float f18 = H4PDF.parseLength(attributes.getValue("y-till"));
                    this.save();
                    this.moveTo(f, f16);
                    this.lineTo(f, f18);
                    this.lineTo(f17, f18);
                    this.lineTo(f17, f16);
                    this.closePath();
                    this.clip();
                    break;
                }
                case 13: {
                    this.moveTo(H4PDF.parseLength(attributes.getValue("x-from")), H4PDF.parseLength(attributes.getValue("y-from")));
                    break;
                }
                case 14: {
                    this.lineTo(H4PDF.parseLength(attributes.getValue("x-till")), H4PDF.parseLength(attributes.getValue("y-till")));
                    break;
                }
                case 22: {
                    this.addLocalLink(attributes.getValue("destination-id"), H4PDF.parseLength(attributes.getValue("x-from")), H4PDF.parseLength(attributes.getValue("y-from")), H4PDF.parseLength(attributes.getValue("x-till")), H4PDF.parseLength(attributes.getValue("y-till")), "retain", attributes.getValue("xpath"));
                    break;
                }
                case 23: {
                    this.addWebLink(H4PDF.parseLength(attributes.getValue("x-from")), H4PDF.parseLength(attributes.getValue("y-from")), H4PDF.parseLength(attributes.getValue("x-till")), H4PDF.parseLength(attributes.getValue("y-till")), attributes.getValue("destination"), "new".equals(attributes.getValue("show-destination")), attributes.getValue("xpath"));
                    break;
                }
                case 24: {
                    if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 4 && attributes.getValue("font-style") != null && H4PDF.parseInteger(attributes.getValue("font-weight") == null ? "0" : attributes.getValue("font-weight")) != 0) {
                        this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " bookmarks font styling is supported only for PDF 1.4 and higher.");
                    }
                    this.addLocalBookmark(attributes.getValue("destination-id"), this.normalize_space(attributes.getValue("label")), attributes.getValue("font-style") == null ? "normal" : attributes.getValue("font-style"), H4PDF.parseInteger(attributes.getValue("font-weight") == null ? "0" : attributes.getValue("font-weight")), H4PDF.parseInteger(attributes.getValue("id")), H4PDF.parseInteger(attributes.getValue("parent-id")), "false".equals(attributes.getValue("collapse-subtree")));
                    break;
                }
                case 25: {
                    if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 4 && attributes.getValue("font-style") != null && H4PDF.parseInteger(attributes.getValue("font-weight") == null ? "0" : attributes.getValue("font-weight")) != 0) {
                        this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " bookmarks font styling is supported only for PDF 1.4 and higher.");
                    }
                    this.addWebBookmark(this.normalize_space(attributes.getValue("label")), attributes.getValue("font-style") == null ? "normal" : attributes.getValue("font-style"), H4PDF.parseInteger(attributes.getValue("font-weight") == null ? "0" : attributes.getValue("font-weight")), H4PDF.parseInteger(attributes.getValue("id")), H4PDF.parseInteger(attributes.getValue("parent-id")), attributes.getValue("destination"), "false".equals(attributes.getValue("collapse-subtree")), "new".equals(attributes.getValue("show-destination")));
                    break;
                }
                case 26: {
                    break;
                }
                case 21: {
                    String string18 = attributes.getValue("id");
                    if (string18 == null) {
                        string18 = attributes.getValue("name");
                    }
                    this.addNamedDestination(string18, H4PDF.parseLength(attributes.getValue("x")), H4PDF.parseLength(attributes.getValue("y")));
                    break;
                }
                case 27: {
                    if (!this.session.config.PDFForms) {
                        if (!this.PDFFormsNotLicensedWarned) {
                            this.session.warning("PDF Forms support is not licensed for this installation.");
                            this.PDFFormsNotLicensedWarned = true;
                        }
                        this.skip = 1;
                        break;
                    }
                    boolean bl = "true".equals(attributes.getValue("hidden"));
                    if (!bl) {
                        this.currentAcroFieldRect = new float[]{H4PDF.parseLength(attributes.getValue("x-from")), H4PDF.parseLength(attributes.getValue("y-from")), H4PDF.parseLength(attributes.getValue("x-till")), H4PDF.parseLength(attributes.getValue("y-till"))};
                    }
                    int n = attributes.getValue("fieldno") == null ? -1 : Integer.parseInt(attributes.getValue("fieldno"));
                    this.pdf.addAcroField(attributes.getValue("name"), this.currentAcroFieldRect, "true".equals(attributes.getValue("readonly")), "true".equals(attributes.getValue("required")), "true".equals(attributes.getValue("noexport")), bl, n, "true".equals(attributes.getValue("printable")), attributes.getValue("js-keystroke"), attributes.getValue("js-format"), attributes.getValue("js-validate"), attributes.getValue("js-calculate"), attributes.getValue("js-blur"), attributes.getValue("js-focus"), attributes.getValue("js-mousedown"), attributes.getValue("js-mouseup"), attributes.getValue("js-mouseenter"), attributes.getValue("js-mouseexit"));
                    break;
                }
                case 28: {
                    int n = attributes.getValue("maxlen") == null ? -1 : H4PDF.parseInteger(attributes.getValue("maxlen"));
                    boolean bl = "true".equals(attributes.getValue("password"));
                    String string19 = attributes.getValue("text");
                    this.pdf.addAcroFieldText(string19, "true".equals(attributes.getValue("multiline")), bl, n);
                    break;
                }
                case 29: {
                    this.pdf.addAcroFieldRadio(attributes.getValue("group-name"));
                    break;
                }
                case 30: {
                    this.pdf.addAcroFieldCheckbox();
                    break;
                }
                case 31: {
                    this.pdf.addAcroFieldChoice((short)5, "true".equals(attributes.getValue("multiselect")), false);
                    break;
                }
                case 32: {
                    this.pdf.addAcroFieldChoice((short)4, "true".equals(attributes.getValue("multiselect")), "true".equals(attributes.getValue("editable")));
                    break;
                }
                case 33: {
                    List list = null;
                    if (attributes.getValue("fields") != null) {
                        list = new List();
                        StringTokenizer stringTokenizer = new StringTokenizer(attributes.getValue("fields"), " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            list.append(stringTokenizer.nextToken());
                        }
                    }
                    this.pdf.addAcroFieldResetButton(attributes.getValue("text"), list);
                    break;
                }
                case 34: {
                    List list = null;
                    if (attributes.getValue("fields") != null) {
                        list = new List();
                        StringTokenizer stringTokenizer = new StringTokenizer(attributes.getValue("fields"), " ");
                        while (stringTokenizer.hasMoreTokens()) {
                            list.append(stringTokenizer.nextToken());
                        }
                    }
                    this.pdf.addAcroFieldSubmitButton(attributes.getValue("text"), list, attributes.getValue("url"), attributes.getValue("submit-format"), attributes.getValue("method"), attributes.getValue("novalue-fields"));
                    break;
                }
                case 35: {
                    this.pdf.addAcroFieldOption(attributes.getValue("text"), "true".equals(attributes.getValue("initially-selected")));
                    break;
                }
                case 36: {
                    if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 5) {
                        this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " does not support multimedia framework; feature ignored; please set PDF 1.5.");
                        break;
                    }
                    float f = H4PDF.parseFloat(attributes.getValue("scale-x"));
                    float f19 = H4PDF.parseFloat(attributes.getValue("scale-y"));
                    if (f != 0.0f && f19 != 0.0f) {
                        int n;
                        String string20;
                        String string21;
                        String string22 = attributes.getValue("src");
                        String string23 = attributes.getValue("base");
                        String string24 = attributes.getValue("type");
                        float f20 = H4PDF.parseLength(attributes.getValue("x-from"));
                        float f21 = H4PDF.parseLength(attributes.getValue("y-from"));
                        boolean bl = true;
                        boolean bl2 = false;
                        if (attributes.getValue("embed") != null) {
                            string21 = attributes.getValue("embed");
                            if ("false".equals(string21 = string21.trim().toLowerCase()) || "no".equals(string21)) {
                                bl = false;
                            }
                        }
                        if (attributes.getValue("show-controls") != null) {
                            string21 = attributes.getValue("show-controls");
                            if ("true".equals(string21 = string21.trim().toLowerCase()) || "yes".equals(string21)) {
                                bl2 = true;
                            }
                        }
                        String string25 = DEFAULT_ALT;
                        if (attributes.getValue("alt") != null) {
                            string25 = attributes.getValue("alt");
                        }
                        String string26 = DEFAULT_EXTRACTION_POLICY;
                        if (attributes.getValue("extraction-policy") != null) {
                            string20 = attributes.getValue("extraction-policy");
                            string20 = string20.trim().toUpperCase();
                            boolean bl3 = false;
                            n = 0;
                            while (n < extraction_policy.length) {
                                if (extraction_policy[n].equals(string20)) {
                                    bl3 = true;
                                }
                                ++n;
                            }
                            if (bl3) {
                                string26 = string20;
                            }
                        }
                        string20 = DEFAULT_DURATION;
                        if (attributes.getValue("duration") != null) {
                            String string27 = attributes.getValue("duration");
                            string20 = (string27 = string27.trim().toLowerCase()).equals(DEFAULT_DURATION) || string27.equals("infinity") ? string27 : "" + H4PDF.parseFloat(attributes.getValue("duration"));
                        }
                        float f22 = 1.0f;
                        if (attributes.getValue("play-mode") != null) {
                            f22 = H4PDF.parseFloat(attributes.getValue("play-mode"));
                        }
                        if (f22 < 0.0f) {
                            f22 = 1.0f;
                        }
                        n = 100;
                        if (attributes.getValue("volume") != null) {
                            n = (int)(H4PDF.parseFloat(attributes.getValue("volume")) * 100.0f);
                        }
                        if (n < 0) {
                            n = 100;
                        }
                        this.placeMedia(f20, f21, f, f19, string22, string23, string24, bl, bl2, string25, string26, attributes.getValue("xpath") != null ? attributes.getValue("xpath") : "", string20, f22, n);
                    }
                    break;
                }
                case 39: {
                    if (!this.session.config.RichMediaObject && !this.session.config.RichMediaObjectTrial) {
                        if (!this.RichMediaObjectNotLicensedWarned) {
                            this.session.warning("Rich Media Object support is not licensed for this installation.");
                            this.RichMediaObjectNotLicensedWarned = true;
                        }
                        this.skip = 1;
                        break;
                    }
                    if (this.pdf.getPDFVersion_major() == 1 && this.pdf.getPDFVersion_minor() < 7) {
                        this.session.warning("PDF version " + this.pdf.getPDFVersion_major() + "." + this.pdf.getPDFVersion_minor() + " does not support rich media framework; feature ignored; please set PDF 1.7.");
                        break;
                    }
                    float f = H4PDF.parseFloat(attributes.getValue("scale-x"));
                    float f23 = H4PDF.parseFloat(attributes.getValue("scale-y"));
                    if (f != 0.0f && f23 != 0.0f) {
                        String string28;
                        String string29;
                        String string30 = attributes.getValue("src");
                        String string31 = attributes.getValue("base");
                        String string32 = attributes.getValue("type");
                        String string33 = attributes.getValue("name");
                        float f24 = H4PDF.parseLength(attributes.getValue("x-from"));
                        float f25 = H4PDF.parseLength(attributes.getValue("y-from"));
                        boolean bl = false;
                        if (attributes.getValue("transparency") != null) {
                            string29 = attributes.getValue("transparency");
                            if ("true".equals(string29 = string29.trim().toLowerCase()) || "yes".equals(string29)) {
                                bl = true;
                            }
                        }
                        string29 = DEFAULT_ACTIVATE_CONDITION;
                        if (attributes.getValue("activate-condition") != null) {
                            string28 = attributes.getValue("activate-condition");
                            if (activate_condition.containsKey(string28 = string28.trim().toLowerCase())) {
                                string29 = "" + activate_condition.get(string28);
                            }
                        }
                        string28 = DEFAULT_DEACTIVATE_CONDITION;
                        if (attributes.getValue("deactivate-condition") != null) {
                            String string34 = attributes.getValue("deactivate-condition");
                            if (deactivate_condition.containsKey(string34 = string34.trim().toLowerCase())) {
                                string28 = "" + deactivate_condition.get(string34);
                            }
                        }
                        int n = -1;
                        if (attributes.getValue("play-count") != null) {
                            n = H4PDF.parseInteger(attributes.getValue("play-count"));
                        }
                        this.placeRichMedia(f24, f25, f, f23, string30, string31, string32, string33, attributes.getValue("xpath") != null ? attributes.getValue("xpath") : "", bl, string29, string28, n);
                    }
                    this.pdf.setAdobeExtension("1.7", "3");
                    break;
                }
                case 40: {
                    if (!this.session.config.RichMediaObject && !this.session.config.RichMediaObjectTrial) {
                        if (!this.RichMediaObjectNotLicensedWarned) {
                            this.session.warning("Rich Media Object support is not licensed for this installation.");
                            this.RichMediaObjectNotLicensedWarned = true;
                        }
                        this.skip = 1;
                        break;
                    }
                    if (this.pdf.isRMA()) {
                        boolean bl = attributes.getValue("value") == null;
                        this.pdf.addFlashVar(attributes.getValue("name"), bl ? attributes.getValue("content") : attributes.getValue("value"), bl);
                    }
                    break;
                }
                case 41: {
                    if (!this.session.config.RichMediaObject && !this.session.config.RichMediaObjectTrial) {
                        if (!this.RichMediaObjectNotLicensedWarned) {
                            this.session.warning("Rich Media Object support is not licensed for this installation.");
                            this.RichMediaObjectNotLicensedWarned = true;
                        }
                        this.skip = 1;
                        break;
                    }
                    if (!this.pdf.isRMA()) break;
                    String string35 = attributes.getValue("base");
                    URLSpec uRLSpec = null;
                    try {
                        uRLSpec = new URLSpec(string35 == null ? null : new URLSpec(string35), attributes.getValue("src"));
                    }
                    catch (Exception exception) {
                        this.session.warning("Rich media resource not found and skipped: " + exception);
                    }
                    if (uRLSpec != null) {
                        this.pdf.addRichMediaResource(attributes.getValue("name"), uRLSpec);
                    }
                    break;
                }
                case 42: {
                    this.pdf.addPDFComment(H4PDF.parseLength(attributes.getValue("x-from")), H4PDF.parseLength(attributes.getValue("y-from")), H4PDF.parseLength(attributes.getValue("x-till")), H4PDF.parseLength(attributes.getValue("y-till")), attributes.getValue("content"), attributes.getValue("title"), H4PDF.parseFloat(attributes.getValue("opacity") != null ? attributes.getValue("opacity") : "1.0"));
                    this.pdf.setAnnotColor(1.0f, 1.0f, 0.0f);
                    break;
                }
                case 43: {
                    if (this.pdf.isPDFComment()) {
                        this.pdf.setCommentType("Text");
                        this.pdf.setIcon(attributes.getValue("icon-type"));
                        boolean bl = false;
                        if (attributes.getValue("open") != null) {
                            String string36 = attributes.getValue("open");
                            if ("true".equals(string36 = string36.trim().toLowerCase()) || "yes".equals(string36)) {
                                bl = true;
                            }
                        }
                        this.pdf.addPopup(bl);
                    }
                    break;
                }
                case 44: {
                    if (this.pdf.isPDFComment()) {
                        this.pdf.setCommentType("FileAttachment");
                        this.pdf.setIcon(attributes.getValue("icon-type"));
                        String string37 = attributes.getValue("src");
                        String string38 = attributes.getValue("base");
                        String string39 = attributes.getValue("filename");
                        this.addAttachedFile(string37, string38, string39);
                    }
                    break;
                }
                case 46: {
                    URLSpec uRLSpec = new URLSpec(attributes.getValue("src"));
                    Image image = this.pdf.getImage(uRLSpec, null, "document");
                    AttributesImpl attributesImpl = new AttributesImpl();
                    int n = 0;
                    while (n < image.getCountPages()) {
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "width", "width", "CDATA", String.valueOf(image.width * 1000.0));
                        attributesImpl.addAttribute("", "height", "height", "CDATA", String.valueOf(image.height * 1000.0));
                        attributesImpl.addAttribute("", "page-id", "page-id", "CDATA", String.valueOf(n + 1));
                        this.startElement("http://www.renderx.com/XEP/xep", "page", "xep:page", attributesImpl);
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "gray", "gray", "CDATA", "0");
                        this.startElement("http://www.renderx.com/XEP/xep", "gray-color", "xep:gray-color", attributesImpl);
                        this.endElement("http://www.renderx.com/XEP/xep", "gray-color", "xep:gray-color");
                        attributesImpl.clear();
                        attributesImpl.addAttribute("", "scale-x", "scale-x", "CDATA", "1");
                        attributesImpl.addAttribute("", "scale-y", "scale-y", "CDATA", "1");
                        attributesImpl.addAttribute("", "x-from", "x-from", "CDATA", "0");
                        attributesImpl.addAttribute("", "y-from", "y-from", "CDATA", "0");
                        attributesImpl.addAttribute("", "src", "src", "CDATA", uRLSpec.toString());
                        attributesImpl.addAttribute("", "type", "type", "CDATA", "application/pdf");
                        attributesImpl.addAttribute("", "page-number", "page-number", "CDATA", String.valueOf(n + 1));
                        this.startElement("http://www.renderx.com/XEP/xep", "image", "xep:image", attributesImpl);
                        this.endElement("http://www.renderx.com/XEP/xep", "image", "xep:image");
                        this.endElement("http://www.renderx.com/XEP/xep", "page", "xep:page");
                        ++n;
                    }
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element '" + string2 + "' : " + exception);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (!"http://www.renderx.com/XEP/xep".equals(string)) {
            return;
        }
        if (this.skip > 0) {
            --this.skip;
            return;
        }
        try {
            switch ((Short)H4base.idtab.get(string2)) {
                case 0: {
                    this.closeXPath();
                    break;
                }
                case 1: {
                    this.structElementBreak = false;
                    this.endPage();
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 15: 
                case 45: {
                    this.structureTagName = null;
                    this.artifactType = null;
                    this.artifactSubtype = null;
                    break;
                }
                case 12: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: {
                    break;
                }
                case 5: {
                    this.restore();
                    break;
                }
                case 13: {
                    this.closePath();
                    this.fill();
                    break;
                }
                case 14: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.pdf.endBookmark();
                    break;
                }
                case 21: 
                case 26: {
                    break;
                }
                case 27: {
                    this.pdf.endAcroField();
                    this.currentAcroFieldRect = null;
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    break;
                }
                case 35: {
                    this.pdf.endAcroFieldOption();
                    break;
                }
                case 36: {
                    this.pdf.endMedia();
                    break;
                }
                case 39: {
                    this.pdf.endRichMedia();
                    break;
                }
                case 37: 
                case 38: 
                case 40: 
                case 41: {
                    break;
                }
                case 42: {
                    this.pdf.endPDFComment();
                    break;
                }
                case 43: 
                case 44: 
                case 46: {
                    break;
                }
                default: {
                    throw new InternalException("unknown instruction '" + string2 + "'");
                }
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new InternalException("fatal error at element: " + string2 + " : " + exception);
        }
    }

    private static final int parseInteger(String string) {
        return Integer.valueOf(string);
    }

    private static final float parseFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    private static final float parseAngle(String string) {
        return H4PDF.parseFloat(string);
    }

    private static final float parseLength(String string) {
        return H4PDF.parseFloat(string) / 1000.0f;
    }

    private static final int parseCount(String string) {
        return H4PDF.parseInteger(string);
    }

    private String normalize_space(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + " " + stringTokenizer.nextToken();
        }
        return string2.trim();
    }

    private static final float getLineLength(float f, float f2, float f3, float f4) {
        if (f == f3) {
            return f2 > f4 ? f2 - f4 : f4 - f2;
        }
        if (f2 == f4) {
            return f > f3 ? f - f3 : f3 - f;
        }
        float f5 = f - f3;
        float f6 = f2 - f4;
        return (float)Math.sqrt(f5 * f5 + f6 * f6);
    }

    static {
        optab.put("COMPRESS", new Short(0));
        optab.put("UNICODE_ANNOTATIONS", new Short(1));
        optab.put("OWNERPASSWORD", new Short(2));
        optab.put("USERPASSWORD", new Short(3));
        optab.put("USERPRIVILEGES", new Short(4));
        optab.put("DROP_UNUSED_DESTINATIONS", new Short(5));
        optab.put("LINEARIZE", new Short(6));
        optab.put("INITIAL_ZOOM", new Short(7));
        optab.put("VIEW_MODE", new Short(8));
        optab.put("PDF_VERSION", new Short(9));
        optab.put("CROP_OFFSET", new Short(10));
        optab.put("CROP_MARK_WIDTH", new Short(11));
        optab.put("BLEED", new Short(12));
        optab.put("BLEED_MARK_WIDTH", new Short(13));
        optab.put("PRINTER_MARK", new Short(14));
        optab.put("PDF_X", new Short(15));
        optab.put("ICC_PROFILE", new Short(16));
        optab.put("LOGICAL_PAGE_NUMBERING", new Short(17));
        optab.put("PAGE_LAYOUT", new Short(18));
        optab.put("VIEWER_PREFERENCES", new Short(19));
        optab.put("PDF_A", new Short(20));
        extraction_policy = new String[]{"TEMPNEVER", "TEMPEXTRACT", DEFAULT_EXTRACTION_POLICY, "TEMPALWAYS"};
        activate_condition = new Hashtable();
        activate_condition.put("explicit_activation", "XA");
        activate_condition.put("page_open", "PO");
        activate_condition.put("page_visible", DEFAULT_ACTIVATE_CONDITION);
        deactivate_condition = new Hashtable();
        deactivate_condition.put("explicit_deactivation", "XD");
        deactivate_condition.put("page_close", "PC");
        deactivate_condition.put("page_invisible", DEFAULT_DEACTIVATE_CONDITION);
    }

    public static class XPathList
    extends List {
        public XPathList() {
            this(null);
        }

        public XPathList(String string) {
            this.toXPath(string);
        }

        public Node curnode() {
            return (Node)this.last();
        }

        public XPathList ascenders() {
            return (XPathList)((XPathList)this.reverse()).cdr();
        }

        public XPathList toXPath(String string) {
            if (string == null) {
                return this;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = string2.substring(2, string2.indexOf("]"));
                String string4 = string2.substring(string2.lastIndexOf("='") + 2, string2.lastIndexOf("']"));
                Node node = new Node(string4, Integer.valueOf(string3), !stringTokenizer.hasMoreTokens());
                this.snoc(node);
            }
            return this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Enumeration enumeration = this.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                stringBuffer = stringBuffer.append("/*[").append(new Integer(node.position())).append("][name()='").append(node.name()).append("']");
            }
            return stringBuffer.toString();
        }
    }

    public static class Node
    extends List {
        public final boolean last;

        public Node(String string, Integer n, boolean bl) {
            this.last = bl;
            this.snoc(string).snoc(n);
        }

        public final String name() {
            return (String)this.car();
        }

        public final int position() {
            return (Integer)this.last();
        }
    }

    public class XPathParser {
        private static final short ADD_ELEMENT = 1;
        private static final short CLOSE_ELEMENT = 2;
        private static final short HEADER_CELL = 0;
        private static final short BODY_CELL = 1;
        private static final short FOOTER_CELL = 2;
        private XPathList name_id = new XPathList();
        private XPathList cur_xpath;
        private boolean markContent;
        private Session session;

        public XPathParser(String string, Session session) throws PDFLibInternalError {
            this.cur_xpath = new XPathList(string);
            this.markContent = false;
            this.session = session;
        }

        public XPathParser(String string) throws PDFLibInternalError {
            this(null, null);
        }

        public Node currentNode() {
            return this.cur_xpath.curnode();
        }

        public boolean isMarkedContent() {
            return this.markContent;
        }

        public void parse() {
            if (this.cur_xpath.isEmpty()) {
                return;
            }
            Enumeration enumeration = this.cur_xpath.elements();
            while (enumeration.hasMoreElements()) {
                Node node = (Node)enumeration.nextElement();
                this.name_id.snoc(node);
                this.processElement(node);
            }
            if (!H4PDF.this.gXPath.isEmpty()) {
                this.closeAll();
                this.markContent = true;
            }
            H4PDF.this.gXPath = (XPathList)this.cur_xpath.clone();
            H4PDF.this.structElementBreak = false;
        }

        private void processElement(Node node) {
            if (H4PDF.this.gXPath.isEmpty()) {
                this.markContent = true;
                this.addElement(node);
                return;
            }
            Node node2 = (Node)H4PDF.this.gXPath.shift();
            String string = node2.name();
            int n = node2.position();
            if (node.name().equals(string) && node.position() == n) {
                if (H4PDF.this.structElementBreak && H4PDF.this.gXPath.isEmpty()) {
                    this.markContent = true;
                } else if (node.last && H4PDF.this.structureTagName != null) {
                    this.addElement(node);
                    this.markContent = false;
                } else {
                    this.markContent = false;
                }
            } else {
                H4PDF.this.gXPath.cons(node2);
                this.closeAll();
                this.markContent = true;
                this.addElement(node);
            }
        }

        private void addElement(Node node) {
            this.dispatch(node, (short)1);
        }

        private void closeElement(Node node) {
            this.dispatch(node, (short)2);
        }

        private void dispatch(Node node, short s) {
            Elem.Descriptor descriptor = Elem.getDescriptor(node.name());
            if (descriptor == null) {
                throw new PDFLibInternalError("Unknown FO element name: '" + node.name() + "'");
            }
            switch (descriptor.id) {
                case 1: 
                case 16: 
                case 18: 
                case 19: 
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    this.markContent = false;
                }
                case 20: 
                case 21: 
                case 25: 
                case 26: 
                case 29: 
                case 30: 
                case 31: 
                case 48: 
                case 49: 
                case 109: 
                case 201: {
                    if (s == 1) {
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 34: {
                    H4PDF.this.tableRowPending = s == 2;
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 36: {
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.cellType.push(new Integer(0));
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.cellType.pop();
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 38: {
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.cellType.push(new Integer(1));
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.cellType.pop();
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 37: {
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.cellType.push(new Integer(2));
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.cellType.pop();
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 39: {
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.tableRowPending = true;
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.tableRowPending = false;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 40: {
                    String string = node.name();
                    int n = (Integer)H4PDF.this.cellType.car();
                    if (n == 0) {
                        string = "header-" + string;
                    } else if (n == 1) {
                        string = "body-" + string;
                    } else if (n == 2) {
                        string = "footer-" + string;
                    } else {
                        throw new PDFLibInternalError("table cell has unknown parent element");
                    }
                    if (s == 1 && !H4PDF.this.tableRowPending && !H4PDF.this.noTRParentWarned) {
                        this.session.warning("Some table cells do not have table row parent; PDF may not be fully accessible.");
                        H4PDF.this.noTRParentWarned = true;
                    }
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.addStructElemItem(new Node(string, new Integer(node.position()), node.last), this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 46: {
                    this.markContent = false;
                    if (s == 1) {
                        H4PDF.this.footnotePending = true;
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.footnotePending = false;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 47: {
                    H4PDF.this.footnotePending = false;
                    if (s == 1) {
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                case 27: {
                    if (s == 1) {
                        if (H4PDF.this.footnotePending) {
                            H4PDF.this.addStructElemItem(new Node("FootnoteLabel", new Integer(node.position()), node.last), this.name_id.toString());
                            break;
                        }
                        H4PDF.this.addStructElemItem(node, this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.closeStructElemItem();
                    break;
                }
                default: {
                    if (s == 1) {
                        H4PDF.this.addStructElemItem(new Node("Private", new Integer(node.position()), node.last), this.name_id.toString());
                        break;
                    }
                    if (s != 2) break;
                    H4PDF.this.closeStructElemItem();
                }
            }
        }

        private void closeAll() {
            H4PDF.this.gXPath = (XPathList)H4PDF.this.gXPath.reverse();
            while (!H4PDF.this.gXPath.isEmpty()) {
                Node node = (Node)H4PDF.this.gXPath.shift();
                this.closeElement(node);
            }
        }
    }

    private static class Permission {
        static final int canNothing = -64;
        static final int canPrint = 4;
        static final int canModify = 8;
        static final int canCopy = 16;
        static final int canAnnotate = 32;

        private Permission() {
        }
    }
}

