/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import com.renderx.graphics.EPSImage;
import com.renderx.pslib.PSOutputStream;
import com.renderx.util.SeekableInput;
import java.io.IOException;

public class EPS {
    EPSImage eps = null;
    String shortname;
    double[] bbox;

    public EPS(EPSImage ePSImage) {
        this.eps = ePSImage;
        this.shortname = this.eps.toDisplayString();
        int n = this.shortname.lastIndexOf(47);
        if (n != -1) {
            this.shortname = this.shortname.substring(n + 1);
        }
        this.bbox = this.eps.hiResBoundingBox;
        if (this.bbox == null) {
            this.bbox = this.eps.boundingBox;
        }
    }

    public void writeEPS(PSOutputStream pSOutputStream) throws IOException {
        pSOutputStream.println("%%BeginDocument: " + this.shortname);
        SeekableInput seekableInput = this.eps.openSeekableImageStream();
        try {
            seekableInput.seek(this.eps.psOffset);
            byte[] byArray = new byte[8192];
            long l = this.eps.psLength;
            while (l > 0L) {
                int n = l < (long)byArray.length ? (int)l : byArray.length;
                int n2 = seekableInput.read(byArray, 0, n);
                pSOutputStream.write(byArray, 0, n2);
                if (n2 < n) break;
                l -= (long)n;
            }
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            seekableInput.close();
            throw throwable;
        }
        seekableInput.close();
        pSOutputStream.println("\n%%EndDocument");
    }
}

