/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib;

import com.renderx.pdflib.Annot;
import com.renderx.pdflib.IndirectObject;
import com.renderx.pdflib.MediaAppearance;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.RichMediaContent;
import com.renderx.pdflib.RichMediaSettings;
import com.renderx.util.URLUtil;

class RichMediaAnnot
extends Annot {
    IndirectObject parent_page_id;
    IndirectObject pid;
    RichMediaContent rmc;
    RichMediaSettings rms;
    final String fileName;
    String pname;
    String type;
    MediaAppearance ap;

    RichMediaAnnot(IndirectObject indirectObject, float[] fArray, String string) {
        super(indirectObject, fArray[0], fArray[1], fArray[2], fArray[3]);
        this.fileName = string;
    }

    String getSubType() {
        return "RichMedia";
    }

    void setParentPageID(IndirectObject indirectObject) {
        this.parent_page_id = indirectObject;
    }

    void setContent(RichMediaContent richMediaContent) {
        this.rmc = richMediaContent;
    }

    void setSettings(RichMediaSettings richMediaSettings) {
        this.rms = richMediaSettings;
    }

    void setPoster(IndirectObject indirectObject, String string, String string2) {
        this.pid = indirectObject;
        this.pname = string;
        this.type = string2;
    }

    void writeAnnotBody(PDFOutputStream pDFOutputStream) {
        pDFOutputStream.print("/Type /Annot ");
        pDFOutputStream.print("/NM (" + URLUtil.urlEncode(this.fileName) + ") ");
        pDFOutputStream.print("/BS<</S/S/W 0/Type/Border>>");
        pDFOutputStream.print("/AP<<");
        if (this.pid != null) {
            if (this.type.equals("image/svg+xml") || this.type.equals("image/svg") || this.type.equals("application/pdf")) {
                pDFOutputStream.print("/N " + this.pid.toStringR());
            } else {
                this.ap = new MediaAppearance(pDFOutputStream.getNextID());
                this.ap.setPoster(this.pid, this.pname, this.rect);
                pDFOutputStream.print("/N " + this.ap.getID().toStringR());
            }
        }
        pDFOutputStream.print(">>");
        if (this.rms != null) {
            pDFOutputStream.print("/RichMediaSettings " + this.rms.getID().toStringR());
        }
        pDFOutputStream.print("/RichMediaContent " + this.rmc.getID().toStringR());
        if (this.parent_page_id != null) {
            pDFOutputStream.print("/P " + this.parent_page_id.toStringR());
        }
    }

    void writeSubObjects(PDFOutputStream pDFOutputStream) {
        this.rmc.write(pDFOutputStream);
        if (this.rms != null) {
            this.rms.write(pDFOutputStream);
        }
        if (this.ap != null) {
            this.ap.write(pDFOutputStream);
        }
    }
}

