/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.fonts;

import com.renderx.fonts.UsedGlyphs;
import com.renderx.util.Hashtable;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.SeekableInput;
import com.renderx.util.User;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public final class TTFont {
    byte[] header = new byte[12];
    public Hashtable tableslist = null;
    public Hashtable tables = null;
    boolean isTTC = false;
    public UsedGlyphs used = new UsedGlyphs();
    public long[] glyphoffsets = null;
    public byte[] glyphdata = null;
    boolean longoffset = false;
    public int numGlyphs = -1;
    int numHMetrics = -1;
    int numVMetrics = -1;
    public byte[] hmtx;
    public byte[] vmtx;
    public byte[] glyf;
    public byte[] loca;

    public TTFont(SeekableInput seekableInput, int n) throws IOException {
        byte[] byArray;
        this.used.clearGlyphs();
        this.tableslist = new Hashtable();
        this.tables = new Hashtable();
        String string = User.getProperty("com.renderx.xep.TrueType.DropBitmaps");
        boolean bl = !"false".equals(string) && !"no".equals(string);
        int n2 = 0;
        seekableInput.readFully(this.header);
        if (this.header[0] == 116 && this.header[1] == 116 && this.header[2] == 99 && this.header[3] == 102) {
            this.isTTC = true;
            while (n-- > 0) {
                n2 = seekableInput.readInt();
            }
            seekableInput.seek(n2);
            seekableInput.readFully(this.header);
        }
        int n3 = this.ushort(this.header, 4);
        int n4 = 0;
        while (n4 < n3) {
            seekableInput.seek(n2 + 12 + 16 * n4);
            byArray = new byte[4];
            seekableInput.readFully(byArray);
            String string2 = new String(byArray);
            if (!(bl && (string2.equals("EBDT") || string2.equals("EBLC") || string2.equals("EBSC") || string2.equals("hdmx") || string2.equals("VDMX")))) {
                byte[] byArray2 = new byte[12];
                seekableInput.readFully(byArray2);
                this.tableslist.put(string2, byArray2);
                long l = this.ulong(byArray2, 4);
                int n5 = this.ulong(byArray2, 8);
                byte[] byArray3 = new byte[n5];
                seekableInput.seek(l);
                seekableInput.readFully(byArray3);
                this.tables.put(string2, byArray3);
            }
            ++n4;
        }
        byArray = null;
        byArray = (byte[])this.tables.get("maxp");
        this.numGlyphs = this.ushort(byArray, 4);
        byArray = (byte[])this.tables.get("head");
        this.longoffset = this.ushort(byArray, 50) != 0;
        byArray = (byte[])this.tables.get("hhea");
        this.numHMetrics = this.ushort(byArray, 34);
        byArray = (byte[])this.tables.get("vhea");
        if (byArray != null) {
            this.numVMetrics = this.ushort(byArray, 34);
        }
        if (this.tables.containsKey("CFF ")) {
            return;
        }
        byArray = (byte[])this.tables.get("loca");
        this.glyphoffsets = new long[this.numGlyphs + 1];
        int n6 = 0;
        while (n6 < this.numGlyphs + 1) {
            this.glyphoffsets[n6] = this.longoffset ? (long)this.ulong(byArray, n6 * 4) : (long)(this.ushort(byArray, n6 * 2) * 2);
            ++n6;
        }
        this.glyphdata = (byte[])this.tables.get("glyf");
        this.addGlyph(0);
    }

    public void addGlyph(int n) {
        if (this.used.checkGlyph((char)n)) {
            return;
        }
        this.used.markGlyph((char)n);
        if (this.glyphoffsets[n] == this.glyphoffsets[n + 1]) {
            return;
        }
        int n2 = (int)this.glyphoffsets[n];
        if ((this.ushort(this.glyphdata, n2) & 0x8000) == 0) {
            return;
        }
        n2 += 10;
        while (true) {
            this.addGlyph(this.ushort(this.glyphdata, n2 + 2));
            int n3 = this.ushort(this.glyphdata, n2);
            if ((n3 & 0x20) == 0) break;
            n2 += (n3 & 1) > 0 ? 8 : 6;
            if ((n3 & 8) > 0) {
                n2 += 2;
                continue;
            }
            if ((n3 & 0x40) > 0) {
                n2 += 4;
                continue;
            }
            if ((n3 & 0x80) <= 0) continue;
            n2 += 8;
        }
    }

    public void createSubsetTables() throws IOException {
        int n;
        int n2;
        boolean bl = false;
        int n3 = 0;
        while (n3 < this.numGlyphs && !bl) {
            bl = this.used.checkGlyph((char)n3) && this.glyphoffsets[n3 + 1] != this.glyphoffsets[n3];
            ++n3;
        }
        if (!bl) {
            int n4 = 0;
            while (this.glyphoffsets[n4 + 1] != this.glyphoffsets[n4] && n4 < this.numGlyphs) {
                ++n4;
            }
            if (n4 < this.numGlyphs) {
                this.addGlyph(n4);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byte[] byArray = (byte[])this.tables.get("hmtx");
        byte[] byArray2 = (byte[])this.tables.get("vmtx");
        this.hmtx = null;
        if (byArray != null) {
            this.hmtx = new byte[byArray.length];
            n2 = 0;
            while (n2 < this.hmtx.length) {
                this.hmtx[n2] = 0;
                ++n2;
            }
            n = 4 * (this.numHMetrics - 1);
            while (n >= 0 && n < 4 * this.numHMetrics) {
                this.hmtx[n] = byArray[n];
                ++n;
            }
        }
        this.vmtx = null;
        if (byArray2 != null) {
            this.vmtx = new byte[byArray2.length];
            n2 = 0;
            while (n2 < this.vmtx.length) {
                this.vmtx[n2] = 0;
                ++n2;
            }
            n = 4 * (this.numVMetrics - 1);
            while (n >= 0 && n < 4 * this.numVMetrics) {
                this.vmtx[n] = byArray2[n];
                ++n;
            }
        }
        n2 = 0;
        n = 0;
        while (n < this.numGlyphs) {
            byteArrayOutputStream2.write(this.longoffset ? this.int2long(n2) : this.int2short(n2 / 2));
            if (this.used.checkGlyph((char)n)) {
                int n5;
                int n6;
                int n7;
                int n8 = (int)(this.glyphoffsets[n + 1] - this.glyphoffsets[n]);
                byteArrayOutputStream.write(this.glyphdata, (int)this.glyphoffsets[n], n8);
                n2 += n8;
                if (this.hmtx != null) {
                    n7 = n < this.numHMetrics ? 4 : 2;
                    n5 = n6 = n < this.numHMetrics ? 4 * n : 2 * (n + this.numHMetrics);
                    while (n5 < n6 + n7) {
                        this.hmtx[n5] = byArray[n5];
                        ++n5;
                    }
                }
                if (this.vmtx != null) {
                    n7 = n < this.numVMetrics ? 4 : 2;
                    n5 = n6 = n < this.numVMetrics ? 4 * n : 2 * (n + this.numVMetrics);
                    while (n5 < n6 + n7) {
                        this.vmtx[n5] = byArray2[n5];
                        ++n5;
                    }
                }
            }
            ++n;
        }
        byteArrayOutputStream2.write(this.longoffset ? this.int2long(n2) : this.int2short(n2 / 2));
        this.glyf = byteArrayOutputStream.toByteArray();
        this.loca = byteArrayOutputStream2.toByteArray();
    }

    public byte[] createSubsetHeader() throws IOException {
        return this.createSubsetHeader(false);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] createSubsetHeader(boolean var1_1) throws IOException {
        var2_2 = new ByteArrayOutputStream();
        var2_2.write(this.header, 0, 4);
        var3_3 = this.tableslist.size();
        var4_4 = 0;
        var5_5 = 2;
        while (var5_5 <= var3_3) {
            var5_5 *= 2;
            ++var4_4;
        }
        var2_2.write(this.int2short(var3_3));
        var2_2.write(this.int2short(var4_4));
        var2_2.write(this.int2short(var5_5 *= 8));
        var2_2.write(this.int2short(var3_3 * 16 - var5_5));
        var6_6 = this.tableslist.keys();
        var7_7 = 12 + this.tableslist.size() * 16;
        ** GOTO lbl58
        {
            ++var7_7;
            do {
                if ((var7_7 & 3) > 0) continue block1;
                var8_8 = (String)var6_6.nextElement();
                var9_9 = var8_8.getBytes();
                var2_2.write(var9_9);
                var10_10 = (byte[])this.tableslist.get(var8_8);
                if (var1_1) {
                    var2_2.write(var10_10, 0, 4);
                    var2_2.write(this.int2long(var7_7));
                    var2_2.write(var10_10, 8, 4);
                    var7_7 += this.ulong(var10_10, 8);
                    continue;
                }
                if (var8_8.equals("loca")) {
                    var2_2.write(this.int2long(this.calcCheckSum(this.loca)));
                    var2_2.write(this.int2long(var7_7));
                    var2_2.write(this.int2long(this.loca.length));
                    var7_7 += this.loca.length;
                    continue;
                }
                if (var8_8.equals("glyf")) {
                    var2_2.write(this.int2long(this.calcCheckSum(this.glyf)));
                    var2_2.write(this.int2long(var7_7));
                    var2_2.write(this.int2long(this.glyf.length));
                    var7_7 += this.glyf.length;
                    continue;
                }
                if (var8_8.equals("hmtx")) {
                    var2_2.write(this.int2long(this.calcCheckSum(this.hmtx)));
                    var2_2.write(this.int2long(var7_7));
                    var2_2.write(this.int2long(this.hmtx.length));
                    var7_7 += this.hmtx.length;
                    continue;
                }
                if (var8_8.equals("vmtx")) {
                    var2_2.write(this.int2long(this.calcCheckSum(this.vmtx)));
                    var2_2.write(this.int2long(var7_7));
                    var2_2.write(this.int2long(this.vmtx.length));
                    var7_7 += this.vmtx.length;
                    continue;
                }
                var2_2.write(var10_10, 0, 4);
                var2_2.write(this.int2long(var7_7));
                var2_2.write(var10_10, 8, 4);
                var7_7 += this.ulong(var10_10, 8);
lbl58:
                // 7 sources

            } while (var6_6.hasMoreElements());
        }
        return var2_2.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    public byte[] createSubset() throws IOException {
        this.createSubsetTables();
        var1_1 = new ByteArrayOutputStream();
        var1_1.write(this.createSubsetHeader());
        var2_2 = this.tableslist.keys();
        ** GOTO lbl23
        {
            var1_1.write(0);
            do {
                if ((var1_1.size() & 3) > 0) continue block0;
                var3_3 = (String)var2_2.nextElement();
                if (var3_3.equals("loca")) {
                    var1_1.write(this.loca);
                    continue;
                }
                if (var3_3.equals("glyf")) {
                    var1_1.write(this.glyf);
                    continue;
                }
                if (var3_3.equals("hmtx")) {
                    var1_1.write(this.hmtx);
                    continue;
                }
                if (var3_3.equals("vmtx")) {
                    var1_1.write(this.vmtx);
                    continue;
                }
                var1_1.write((byte[])this.tables.get(var3_3));
lbl23:
                // 6 sources

            } while (var2_2.hasMoreElements());
        }
        return var1_1.toByteArray();
    }

    int calcCheckSum(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = n2;
            while (n3 < byArray.length) {
                n += byArray[n3];
                n3 += 4;
            }
            if (n2 < 3) {
                n *= 256;
            }
            ++n2;
        }
        return n;
    }

    int uoctet(byte n) {
        return n >= 0 ? n : 256 + n;
    }

    int ushort(byte[] byArray, int n) {
        return 256 * this.uoctet(byArray[n]) + this.uoctet(byArray[n + 1]);
    }

    int ulong(byte[] byArray, int n) {
        return 65536 * this.ushort(byArray, n) + this.ushort(byArray, n + 2);
    }

    byte[] int2long(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    byte[] int2short(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    private String toHexString(int n) {
        String string = Integer.toHexString(n);
        n = string.length();
        while (n < 4) {
            string = "0" + string;
            ++n;
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        TTFont tTFont = new TTFont(new SeekableFileInputStream(stringArray[0]), 1);
        tTFont.addGlyph(80);
        tTFont.addGlyph(90);
        tTFont.addGlyph(100);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        fileOutputStream.write(tTFont.createSubset());
        fileOutputStream.close();
    }
}

