/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.crypto;

import com.renderx.crypto.MD5;
import com.renderx.crypto.PGPCRC;
import com.renderx.crypto.PGPSignature;
import com.renderx.crypto.RSAPublicKey;
import com.renderx.sax.Canonicalizer;
import com.renderx.sax.XMLReaderFactory;
import com.renderx.util.Base64InputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class CheckSignedXML {
    private PGPSignature signature = null;
    private byte[] pgpHash = null;

    public void load(InputSource inputSource, XMLReader xMLReader) throws IOException, SAXException {
        byte[] byArray;
        this.signature = null;
        this.pgpHash = null;
        Canonicalizer canonicalizer = new Canonicalizer();
        xMLReader.setContentHandler(canonicalizer);
        xMLReader.parse(inputSource);
        MD5 mD5 = new MD5();
        mD5.update(canonicalizer.body);
        if (canonicalizer.signature == null) {
            return;
        }
        String string = canonicalizer.signature.trim();
        if (string.length() < 5) {
            throw new IOException("Invalid or corrupt signature");
        }
        if (string.charAt(string.length() - 5) != '=') {
            throw new IOException("Signature incorrectly structured - no checksum");
        }
        byte[] byArray2 = this.base64decode(string.substring(string.length() - 4));
        int n = (byArray2[0] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[2] & 0xFF;
        if (n != PGPCRC.checksum(byArray = this.base64decode(string.substring(0, string.length() - 5)))) {
            throw new IOException("Incorrect signature checksum");
        }
        this.signature = new PGPSignature(new DataInputStream(new ByteArrayInputStream(byArray)));
        this.signature.addExtasToHash(mD5);
        this.pgpHash = mD5.digest();
    }

    public byte[] base64decode(String string) throws IOException {
        byte[] byArray;
        Base64InputStream base64InputStream = new Base64InputStream(string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byte[] byArray2 = new byte[1024];
            int n = 0;
            while ((n = base64InputStream.read(byArray2)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            base64InputStream.close();
            byteArrayOutputStream.close();
            throw throwable;
        }
        base64InputStream.close();
        byteArrayOutputStream.close();
        return byArray;
    }

    public boolean checkSignature(RSAPublicKey rSAPublicKey) {
        if (this.signature == null) {
            return false;
        }
        return this.signature.check(rSAPublicKey, this.pgpHash);
    }

    public static boolean check(InputSource inputSource, XMLReader xMLReader, String string) throws IOException, SAXException {
        int n = string.indexOf(58);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(new BigInteger(string.substring(0, n), 16), new BigInteger(string.substring(n + 1), 16));
        CheckSignedXML checkSignedXML = new CheckSignedXML();
        checkSignedXML.load(inputSource, xMLReader);
        return checkSignedXML.checkSignature(rSAPublicKey);
    }

    public static void main(String[] stringArray) throws Exception {
        boolean bl;
        if (stringArray.length != 2) {
            System.err.println("Usage: java com.renderx.crypto.CheckSignedXML <XML file> <public key>\n");
            System.exit(1);
        }
        System.out.println((bl = CheckSignedXML.check(new InputSource(stringArray[0]), XMLReaderFactory.createXMLReader(), stringArray[1])) ? "PASSED" : "FAILED");
    }
}

