/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.afplib;

import com.renderx.afpcommon.CodePage;
import com.renderx.afplib.AFP;
import com.renderx.afplib.ConfigManager;
import com.renderx.afplib.Point2D;
import com.renderx.afplib.XFont;
import com.renderx.afplib.XPage;
import com.renderx.afplib.XTextDecoderSingleton;
import com.renderx.afplib.XYObject;
import com.renderx.util.ErrorHandler;
import com.renderx.xep.pre.Attr;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;

public class XTextPiece
extends XYObject {
    public String value;
    public int width;
    protected XFont style;
    public int letterSpacingDelta;
    public int wordSpacing;
    private ErrorHandler logger;
    private ConfigManager configManager;

    public XTextPiece(Point2D point2D, String string, int n, XFont xFont, Attr.Color color, int n2, int n3, int n4, ErrorHandler errorHandler, ConfigManager configManager) {
        super(point2D, color, n4);
        this.value = string;
        this.width = n;
        this.style = xFont;
        this.letterSpacingDelta = n2;
        this.wordSpacing = n3;
        this.logger = errorHandler;
        this.configManager = configManager;
    }

    public static void generate(Point2D point2D, String string, int n, XFont xFont, Attr.Color color, int n2, int n3, int n4, ErrorHandler errorHandler, ArrayList arrayList, XPage xPage, ConfigManager configManager) {
        XTextDecoderSingleton xTextDecoderSingleton = xPage.getAFP().utf8TextDecoder;
        ArrayList arrayList2 = XTextPiece.separateTextToSubstrings(xPage, xTextDecoderSingleton, string);
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            TextPiece textPiece = (TextPiece)iterator.next();
            XTextPiece xTextPiece = new XTextPiece(textPiece.isOriginNull ? null : point2D, textPiece.getTextPiece(), n, textPiece.getTextFont(), color, n2, n3, n4, errorHandler, configManager);
            arrayList.add(xTextPiece);
        }
    }

    public static ArrayList separateTextToSubstrings(XPage xPage, XTextDecoderSingleton xTextDecoderSingleton, String string) {
        XFont xFont;
        Object object;
        int n;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CodePage codePage = xTextDecoderSingleton.getCharsetByChar(string.charAt(0));
        String string2 = null;
        CodePage codePage2 = new CodePage("T1V10500", "Cp500", 0, 127, true);
        String string3 = string;
        for (n = 1; n < string.length(); ++n) {
            if (codePage.equals(xTextDecoderSingleton.getCharsetByChar(string.charAt(n)))) continue;
            if (codePage.equals(codePage2) && xTextDecoderSingleton.getCharsetByChar((char)string.charAt((int)n)).forceLatin) {
                codePage = xTextDecoderSingleton.getCharsetByChar(string.charAt(n));
                continue;
            }
            object = string.substring(0, n);
            string = string.substring(n);
            xFont = xPage.getCurrentStyleWithCharset(codePage);
            TextPiece textPiece = new TextPiece((String)object, xFont, false);
            arrayList.add(textPiece);
            string2 = XTextPiece.nextCodeSubString(xPage, string, arrayList, xTextDecoderSingleton);
            break;
        }
        n = 1;
        if (string2 == null) {
            string2 = string;
        }
        if (string3.equals(string2)) {
            n = 0;
        } else {
            codePage = xTextDecoderSingleton.getCharsetByChar(string2.charAt(0));
        }
        xFont = xPage.getCurrentStyleWithCharset(codePage);
        object = new TextPiece(string2, xFont, n != 0);
        arrayList.add(object);
        return arrayList;
    }

    private static String nextCodeSubString(XPage xPage, String string, ArrayList arrayList, XTextDecoderSingleton xTextDecoderSingleton) {
        CodePage codePage = xTextDecoderSingleton.getCharsetByChar(string.charAt(0));
        String string2 = null;
        for (int i = 1; i < string.length(); ++i) {
            if (codePage.equals(xTextDecoderSingleton.getCharsetByChar(string.charAt(i)))) continue;
            string2 = string.substring(0, i);
            string = string.substring(i);
            XFont xFont = xPage.getCurrentStyleWithCharset(codePage);
            TextPiece textPiece = new TextPiece(string2, xFont, true);
            arrayList.add(textPiece);
            return XTextPiece.nextCodeSubString(xPage, string, arrayList, xTextDecoderSingleton);
        }
        return string;
    }

    public String toString() {
        return "  at=(" + this.origin.toString() + ") \"" + this.value + "\"" + " style = " + this.style.toString() + " color = " + this.color.toString();
    }

    public void writeToAFP(AFP aFP) throws IOException {
        byte[] byArray = null;
        try {
            byArray = this.getByteArrayFromStr(this.value);
            if (byArray.length != 0) {
                aFP.setTextStyle(this.style);
                aFP.setColor(this.color);
                aFP.setOrientation(this);
                if (this.origin != null) {
                    aFP.gotoXY(this.origin);
                }
                aFP.setLetterSpacingDelta(this.letterSpacingDelta);
                aFP.setWordSpacing(this.wordSpacing);
                aFP.writePTOCACS("TRN", byArray.length + 2);
                aFP.writeConvertedText(byArray);
            }
        }
        catch (Exception exception) {
            if (byArray == null) {
                byte[] byArray2 = this.value.getBytes("UTF-8");
                this.logger.error("XTextPiece: it is impossible convert to bytes " + this.value + "(" + this.fromByteArrayToHexString(byArray2) + ")" + ", codepage " + this.style.codePage.codepage + ", IBM codepage " + this.style.codePage.afpCodepage);
            } else {
                this.logger.warning("XTextPiece: could not render (bad co-ordinates?)");
            }
            aFP.rollback();
        }
    }

    private String fromByteArrayToHexString(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            string = string + "0x" + Integer.toHexString(byArray[i]).substring(6, 8) + ";";
        }
        return string;
    }

    protected byte[] getByteArrayFromStr(String string) throws UnsupportedEncodingException {
        String string2 = this.configManager.getActionUnrecognizedChar();
        byte[] byArray = null;
        if (!this.style.codePage.isRecognize()) {
            byArray = this.replaceString(string, string2);
        } else {
            byArray = new byte[string.length()];
            if (this.style.codePage.unicodeToAFP != null) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    Integer n = (Integer)this.style.codePage.unicodeToAFP.get(new Integer(c));
                    if (n == null) {
                        this.logger.error(string.charAt(i) + " (0x" + Integer.toHexString(string.charAt(i)) + ") is not defined for " + this.style.codePage.name + " codepage");
                        String string3 = new String(new char[]{string.charAt(i)});
                        byArray[i] = this.replaceString(string3, string2)[0];
                        continue;
                    }
                    byArray[i] = (byte)n.intValue();
                }
            } else {
                byArray = this.getByteArrayFromStrDefault(this.style.codePage, string);
            }
        }
        return byArray;
    }

    private byte[] replaceString(String string, String string2) {
        byte[] byArray = new byte[string.length()];
        if (string2.equals("Ignore")) {
            byArray = new byte[]{};
        } else {
            int n = 111;
            if (string2.equals("Blank")) {
                n = 64;
            }
            for (int i = 0; i < string.length(); ++i) {
                byArray[i] = n;
            }
        }
        return byArray;
    }

    private byte[] getByteArrayFromStrDefault(CodePage codePage, String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes(codePage.codepage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = null;
        }
        return byArray;
    }

    public static class TextPiece {
        private String textPiece;
        private XFont textFont;
        private boolean isOriginNull;

        public TextPiece(String string, XFont xFont, boolean bl) {
            this.textPiece = string;
            this.textFont = xFont;
            this.isOriginNull = bl;
        }

        public String getTextPiece() {
            return this.textPiece;
        }

        public XFont getTextFont() {
            return this.textFont;
        }

        public boolean isOriginNull() {
            return this.isOriginNull;
        }
    }
}

