/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import org.freehep.swing.graphics.AbstractRegionSelectionPanel;
import org.freehep.swing.images.FreeHepImage;

public class RectangularSelectionPanel
extends AbstractRegionSelectionPanel {
    public int getNumberOfControlPoints() {
        return 4;
    }

    public Cursor getControlPointCursor(int index) {
        if (index >= 0) {
            int k = (index + 2) % 4;
            return RectangularSelectionPanel.compassCursor("Resize", this.xCtrlPts[index] - this.xCtrlPts[k], this.yCtrlPts[index] - this.yCtrlPts[k], 4, true);
        }
        return FreeHepImage.getCursor("RectangularCursor");
    }

    public void initializeControlPoints(int x, int y) {
        this.activeCtrlPt = 2;
        Arrays.fill(this.xCtrlPts, x);
        Arrays.fill(this.yCtrlPts, y);
    }

    public void updateActiveControlPoint(int x, int y) {
        x = this.forceXCoordinateWithinBounds(x);
        y = this.forceYCoordinateWithinBounds(y);
        this.xCtrlPts[this.activeCtrlPt] = x;
        this.yCtrlPts[this.activeCtrlPt] = y;
        int oppCtrlPt = (this.activeCtrlPt + 2) % this.nCtrlPts;
        int xOpp = this.xCtrlPts[oppCtrlPt];
        int yOpp = this.yCtrlPts[oppCtrlPt];
        int otherCtrlPt = x < xOpp && y > yOpp || x > xOpp && y < yOpp ? 1 : 3;
        otherCtrlPt = (this.activeCtrlPt + otherCtrlPt) % 4;
        this.xCtrlPts[otherCtrlPt] = x;
        this.yCtrlPts[otherCtrlPt] = yOpp;
        otherCtrlPt = (otherCtrlPt + 2) % this.nCtrlPts;
        this.xCtrlPts[otherCtrlPt] = xOpp;
        this.yCtrlPts[otherCtrlPt] = y;
        this.repaintPanel();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setStroke(thickStroke);
            g.setColor(Color.black);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, this.nCtrlPts);
            g2d.setStroke(thinStroke);
            g.setColor(Color.white);
            g.drawPolygon(this.xCtrlPts, this.yCtrlPts, this.nCtrlPts);
            if (this.activeCtrlPt >= 0) {
                g.setColor(Color.black);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize - 1, 2 * ctrlPtSize + 3, 2 * ctrlPtSize + 3);
                g.setColor(Color.white);
                g.fillRect(this.xCtrlPts[this.activeCtrlPt] - ctrlPtSize, this.yCtrlPts[this.activeCtrlPt] - ctrlPtSize, 2 * ctrlPtSize + 1, 2 * ctrlPtSize + 1);
            }
        }
    }

    public AffineTransform makeAffineTransform() {
        int second = 0;
        int third = 0;
        int first = 0;
        int savedValue = this.xCtrlPts[0] * this.xCtrlPts[0] + this.yCtrlPts[0] * this.yCtrlPts[0];
        for (int i = 1; i < 4; ++i) {
            int value = this.xCtrlPts[i] * this.xCtrlPts[i] + this.yCtrlPts[i] * this.yCtrlPts[i];
            if (value >= savedValue) continue;
            savedValue = value;
            first = i;
        }
        second = (first + 1) % 4;
        third = (first + 2) % 4;
        return this.makeTransform(this.xCtrlPts[first], this.yCtrlPts[first], this.xCtrlPts[second], this.yCtrlPts[second], this.xCtrlPts[third], this.yCtrlPts[third]);
    }

    public boolean isValidSelection() {
        return this.visible && (this.xCtrlPts[0] != this.xCtrlPts[2] || this.yCtrlPts[0] != this.yCtrlPts[2]);
    }
}

