/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.pre.att;

import com.renderx.xep.pre.Attn;
import com.renderx.xep.pre.Attr;
import com.renderx.xep.pre.AttributeParser;
import com.renderx.xep.pre.ParserContext;
import com.renderx.xep.pre.ParserException;
import com.renderx.xep.pre.Token;
import com.renderx.xep.pre.att.ColorSpec;
import java.util.Enumeration;
import java.util.Stack;

public class Background
extends Attn {
    private Attn bgcolor = Attn.$background_color;
    private Attn bgimage = Attn.$background_image;
    private Attn bgrepeat = Attn.$background_repeat;
    private Attn bgattach = Attn.$background_attachment;
    private Attn bgpos = Attn.$background_position;

    public Background(String string) throws ParserException {
        super(string);
    }

    public void process(String string, ParserContext parserContext) throws ParserException {
        if (string.trim().equals("inherit")) {
            this.bgcolor.process("inherit", parserContext);
            this.bgimage.process("inherit", parserContext);
            this.bgrepeat.process("inherit", parserContext);
            this.bgattach.process("inherit", parserContext);
            this.bgpos.process("inherit", parserContext);
            return;
        }
        Stack stack = AttributeParser.parseShorthand(string);
        Enumeration enumeration = stack.elements();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            if (token.type == 8192) {
                if (token.value instanceof Attr.Word) {
                    String string7 = token.value.word();
                    if (string7.equals("transparent") || ColorSpec.predefinedColors.get(string7) != null) {
                        bl = false;
                        if (string2 != null) {
                            parserContext.session.warning("Color defined twice in '" + this.name + "' shorthand: second definition ignored");
                            continue;
                        }
                        string2 = string7;
                        continue;
                    }
                    if (string7.equals("repeat") || string7.equals("no-repeat") || string7.equals("repeat-x") || string7.equals("repeat-y")) {
                        bl = false;
                        if (string4 != null) {
                            parserContext.session.warning("Tiling defined twice in '" + this.name + "' shorthand: second definition ignored");
                            continue;
                        }
                        string4 = string7;
                        continue;
                    }
                    if (string7.equals("scroll") || string7.equals("fixed")) {
                        bl = false;
                        if (string5 != null) {
                            parserContext.session.warning("Attachment defined twice in '" + this.name + "' shorthand: second definition ignored");
                            continue;
                        }
                        string5 = string7;
                        continue;
                    }
                    if (string7.equals("none") || string7.startsWith("url(")) {
                        bl = false;
                        if (string3 != null) {
                            parserContext.session.warning("Image URL defined twice in '" + this.name + "' shorthand: second definition ignored");
                            continue;
                        }
                        string3 = string7;
                        continue;
                    }
                    if (string7.equals("top") || string7.equals("bottom") || string7.equals("right") || string7.equals("left") || string7.equals("center")) {
                        if (string6 == null) {
                            bl = true;
                            string6 = string7;
                            continue;
                        }
                        if (bl) {
                            bl = false;
                            string6 = string6 + " " + string7;
                            continue;
                        }
                        parserContext.session.warning("Misplaced token in '" + this.name + "' shorthand: " + string7);
                        continue;
                    }
                    parserContext.session.warning("Ignored unexpected token in '" + this.name + "' shorthand: " + string7);
                    continue;
                }
                if (token.value instanceof Attr.Length || token.value instanceof Attr.Percentage) {
                    if (string6 == null) {
                        bl = true;
                        string6 = token.value.toString();
                        continue;
                    }
                    if (bl) {
                        bl = false;
                        string6 = string6 + " " + token.value.toString();
                        continue;
                    }
                    parserContext.session.warning("Ignored unexpected token in '" + this.name + "' shorthand: " + token.value.toString());
                    continue;
                }
                if (!(token.value instanceof Attr.Color)) continue;
                bl = false;
                if (string2 != null) {
                    parserContext.session.warning("Color defined twice in '" + this.name + "' shorthand: second definition ignored");
                    continue;
                }
                string2 = token.value.toString();
                continue;
            }
            bl = false;
            parserContext.session.warning("Unexpected token type in '" + this.name + "' shorthand: " + token.getTypeName() + ", token ignored");
        }
        this.bgcolor.process(string2 == null ? "transparent" : string2, parserContext);
        this.bgimage.process(string3 == null ? "none" : string3, parserContext);
        this.bgrepeat.process(string4 == null ? "repeat" : string4, parserContext);
        this.bgattach.process(string5 == null ? "scroll" : string5, parserContext);
        this.bgpos.process(string6 == null ? "0% 0%" : string6, parserContext);
    }
}

