/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.xep.lib;

import com.renderx.util.Stack;
import com.renderx.util.TLS;
import com.renderx.util.TLSInstance;
import com.renderx.xep.lib.InternalException;
import com.renderx.xep.lib.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class EventLogger
extends TLSInstance
implements Logger {
    private static final TLS tls = new TLS(class$com$renderx$xep$lib$EventLogger == null ? (class$com$renderx$xep$lib$EventLogger = EventLogger.class$("com.renderx.xep.lib.EventLogger")) : class$com$renderx$xep$lib$EventLogger);
    public static final String uri = "http://www.renderx.com/XEP/log";
    private static final String pfx = "log";
    private Stack sst = new Stack();
    private static ContentHandler fallbackHandler = new FallbackHandler();
    private ContentHandler handler = fallbackHandler;
    private AttributesImpl attrs = new AttributesImpl();
    private String[] prevmsg = new String[8];
    static /* synthetic */ Class class$com$renderx$xep$lib$EventLogger;

    private void addAttribute(String string, String string2, String string3) {
        this.attrs.addAttribute("", string, string, string2, string3);
    }

    private void startElement(String string, Attributes attributes) throws SAXException {
        this.handler.startElement(uri, string, "log:" + string, attributes);
    }

    private void endElement(String string) throws SAXException {
        this.handler.endElement(uri, string, "log:" + string);
    }

    public static synchronized EventLogger logger() {
        try {
            return (EventLogger)tls.instance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("should not happen: " + instantiationException.toString());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("should not happen: " + illegalAccessException.toString());
        }
    }

    public static synchronized void release() {
        tls.release();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler != null ? contentHandler : fallbackHandler;
    }

    public synchronized void openDocument() {
        try {
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            throw new InternalException("problem in the logger");
        }
    }

    public synchronized void closeDocument() {
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            throw new InternalException("problem in the logger");
        }
    }

    public synchronized void event(String string, String string2) {
        try {
            this.attrs.clear();
            this.addAttribute("class", "CDATA", string);
            this.startElement("event", this.attrs);
            this.info(string2);
            this.endElement("event");
        }
        catch (SAXException sAXException) {
            throw new InternalException("problem in the logger");
        }
    }

    public synchronized void openState(String string) {
        try {
            this.attrs.clear();
            this.addAttribute("class", "CDATA", string);
            this.startElement("state", this.attrs);
            this.sst.push(string);
        }
        catch (SAXException sAXException) {
            throw new InternalException("problem in the logger");
        }
    }

    public synchronized void closeState(String string) {
        try {
            String string2 = (String)this.sst.pop();
            if (!string.equals(string2)) {
                throw new InternalException("openState(\"" + string2 + "\")/closeState(\"" + string + "\") do not match");
            }
            this.endElement("state");
        }
        catch (SAXException sAXException) {
            throw new InternalException("problem in the logger");
        }
    }

    public synchronized void info(String string) {
        try {
            char[] cArray = new char[string.length()];
            string.getChars(0, cArray.length, cArray, 0);
            this.handler.characters(cArray, 0, cArray.length);
        }
        catch (SAXException sAXException) {
            throw new InternalException("problem in the logger");
        }
    }

    private boolean dejavu(String string) {
        int n = 0;
        while (n != this.prevmsg.length) {
            if (string.equals(this.prevmsg[n])) {
                return true;
            }
            ++n;
        }
        System.arraycopy(this.prevmsg, 0, this.prevmsg, 1, this.prevmsg.length - 1);
        this.prevmsg[0] = string;
        return false;
    }

    public synchronized void warning(String string) {
        if (!this.dejavu(string)) {
            try {
                this.attrs.clear();
                this.startElement("warning", this.attrs);
                this.info(string);
                this.endElement("warning");
            }
            catch (SAXException sAXException) {
                throw new InternalException("problem in the logger");
            }
        }
    }

    public synchronized void error(String string) {
        if (!this.dejavu(string)) {
            try {
                this.attrs.clear();
                this.startElement("error", this.attrs);
                this.info(string);
                this.endElement("error");
            }
            catch (SAXException sAXException) {
                throw new InternalException("problem in the logger");
            }
        }
    }

    public synchronized void exception(String string, Exception exception) {
        this.error(string + ": " + exception.getMessage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class FallbackHandler
    extends DefaultHandler {
        private FallbackHandler() {
        }

        public synchronized void startDocument() throws SAXException {
            System.err.println("(document");
        }

        public synchronized void endDocument() throws SAXException {
            System.err.println(")");
        }

        public synchronized void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (EventLogger.uri.equals(string)) {
                if (string2.equals("state")) {
                    System.err.print("(" + attributes.getValue("class") + " ");
                } else if (string2.equals("event")) {
                    System.err.print("[" + attributes.getValue("class") + " ");
                } else if (string2.equals("error") || string2.equals("warning")) {
                    System.err.print("\n{" + (string2.equals("error") ? "!" : "?"));
                } else {
                    throw new SAXException("invalid element " + string2 + " passed to log handler");
                }
            }
        }

        public synchronized void endElement(String string, String string2, String string3) throws SAXException {
            if (EventLogger.uri.equals(string)) {
                if (string2.equals("state")) {
                    System.err.print(")");
                } else if (string2.equals("event")) {
                    System.err.print("]");
                } else if (string2.equals("error") || string2.equals("warning")) {
                    System.err.print("}\n");
                } else {
                    throw new SAXException("invalid element " + string2 + " passed to log handler");
                }
            }
        }

        public synchronized void characters(char[] cArray, int n, int n2) throws SAXException {
            System.err.print(new String(cArray, n, n2));
        }

        public synchronized void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public synchronized void processingInstruction(String string, String string2) throws SAXException {
        }
    }
}

