/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.XMLReaderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JAXPTransformerAdapter
implements XMLReader {
    protected Transformer transformer = null;
    protected ContentHandler handler = null;
    protected ErrorHandler errhandler = null;
    protected DTDHandler dtdhandler = null;
    protected EntityResolver resolver = null;

    public JAXPTransformerAdapter(Transformer transformer) {
        this.transformer = transformer;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.handler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.handler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errhandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errhandler;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdhandler = dTDHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdhandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.resolver = entityResolver;
    }

    public EntityResolver getEntityResolver() {
        return this.resolver;
    }

    public void setProperty(String string, Object object) throws SAXNotSupportedException, SAXNotRecognizedException {
        throw new SAXNotRecognizedException(this.getClass().getName() + " does not recognize property " + string);
    }

    public Object getProperty(String string) throws SAXNotSupportedException, SAXNotRecognizedException {
        throw new SAXNotRecognizedException(this.getClass().getName() + " does not recognize property " + string);
    }

    public void setFeature(String string, boolean bl) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            if (bl) {
                return;
            }
            throw new SAXNotSupportedException(this.getClass().getName() + " does not support setting feature " + string + " to " + bl);
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            if (!bl) {
                return;
            }
            throw new SAXNotSupportedException(this.getClass().getName() + " does not support setting feature " + string + " to " + bl);
        }
        throw new SAXNotRecognizedException(this.getClass().getName() + " does not recognize feature " + string);
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException {
        if (string.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (string.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException(this.getClass().getName() + " does not recognize feature " + string);
    }

    public void parse(String string) throws SAXException {
        this.parse(new InputSource(string));
    }

    public void parse(InputSource inputSource) throws SAXException {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            this.transformer.transform(new SAXSource(xMLReader, inputSource), new SAXResult(this.handler));
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

