/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.sax;

import com.renderx.sax.XMLReaderFactory;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Canonicalizer
extends DefaultHandler {
    private int level = 0;
    private int sigLevel = 0;
    private StringBuffer sigBuffer = null;
    private StringBuffer bodyBuffer = null;
    public String signature = null;
    public byte[] body = null;

    public void startDocument() {
        this.sigBuffer = new StringBuffer();
        this.bodyBuffer = new StringBuffer();
        this.signature = null;
        this.level = 0;
        this.sigLevel = 0;
    }

    public void endDocument() {
        this.body = new byte[this.bodyBuffer.length()];
        int n = 0;
        while (n < this.body.length) {
            this.body[n] = (byte)this.bodyBuffer.charAt(n);
            ++n;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        ++this.level;
        if (this.sigLevel > 0) {
            ++this.sigLevel;
            return;
        }
        if ("signature".equals(string2)) {
            this.sigLevel = 1;
            return;
        }
        this.write("<");
        if (string != null && string.length() != 0) {
            this.writeEscaped(string + ":");
        }
        this.writeEscaped(string2);
        int n2 = attributes.getLength();
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            String string4 = attributes.getLocalName(n3);
            n = 0;
            while (n < n3 && attributes.getLocalName(nArray[n]).compareTo(string4) < 0) {
                ++n;
            }
            int n4 = n3;
            while (n4 > n) {
                nArray[n4] = nArray[n4 - 1];
                --n4;
            }
            nArray[n] = n3++;
        }
        int n5 = 0;
        while (n5 < n2) {
            n = nArray[n5];
            String string5 = attributes.getURI(n);
            this.write(" ");
            if (string5 != null && string5.length() > 0 && !string5.equals(string)) {
                this.writeEscaped(string5 + ":");
            }
            this.writeEscaped(attributes.getLocalName(n));
            this.write("=\"");
            this.writeEscaped(attributes.getValue(n));
            this.write("\"");
            ++n5;
        }
        this.write(">");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.level;
        if (this.sigLevel > 0) {
            --this.sigLevel;
            if (this.sigLevel == 0) {
                this.signature = this.sigBuffer.toString();
            }
            return;
        }
        this.write("</>");
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.write("<?");
        this.writeEscaped(string);
        this.write(" ");
        this.writeEscaped(string2);
        this.write("?>");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.level == 0) {
            return;
        }
        if (this.sigLevel > 0) {
            this.sigBuffer.append(cArray, n, n2);
            return;
        }
        this.writeEscaped(cArray, n, n2);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private void writeEscaped(String string) {
        this.writeEscaped(string.toCharArray(), 0, string.length());
    }

    private void writeEscaped(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            char c = cArray[n + n3];
            switch (c) {
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '\"': {
                    this.write("&quot;");
                    break;
                }
                case '\'': {
                    this.write("&apos;");
                    break;
                }
                default: {
                    if (c > '\u007f' || c < ' ') {
                        this.write("&#" + c + ";");
                        break;
                    }
                    this.write(c);
                }
            }
            ++n3;
        }
    }

    private void write(String string) {
        this.bodyBuffer.append(string);
    }

    private void write(char c) {
        this.bodyBuffer.append(c);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("Usage: java com.renderx.crypto.SignedXMLBuffer <XML file> <output file>");
            System.exit(1);
        }
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        Canonicalizer canonicalizer = new Canonicalizer();
        xMLReader.setContentHandler(canonicalizer);
        xMLReader.parse(new InputSource(stringArray[0]));
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        ((OutputStream)fileOutputStream).write(canonicalizer.body);
        ((OutputStream)fileOutputStream).close();
        System.out.println("Signature: " + canonicalizer.signature);
    }
}

