/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pslib;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RunLength_Encode
extends FilterOutputStream {
    byte[] buffer = new byte[128];
    boolean sameSequence = false;
    int length = 0;
    byte lastByte = 0;

    public RunLength_Encode(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        if (this.length == 0) {
            this.buffer[0] = (byte)n;
        } else if (this.sameSequence) {
            if (this.lastByte != (byte)n) {
                this.flushBuffer(this.length);
                this.buffer[0] = (byte)n;
                this.sameSequence = false;
            }
        } else if (this.lastByte == (byte)n) {
            this.flushBuffer(this.length - 1);
            this.sameSequence = true;
        } else {
            this.buffer[this.length] = (byte)n;
        }
        this.lastByte = (byte)n;
        if (++this.length >= 128) {
            this.flushBuffer(this.length);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        while (n3 < n + n2) {
            this.write(byArray[n3]);
            ++n3;
        }
    }

    public void EOD() throws IOException {
        this.flushBuffer(this.length);
        super.write(128);
    }

    private void flushBuffer(int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.sameSequence) {
            super.write(257 - n);
            super.write(this.lastByte);
        } else {
            super.write(n - 1);
            int n2 = 0;
            while (n2 < n) {
                super.write(this.buffer[n2]);
                ++n2;
            }
        }
        this.length -= n;
    }
}

