/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.pdflib.parser;

import com.renderx.graphics.ImageFormatException;
import com.renderx.pdflib.PDFOutputStream;
import com.renderx.pdflib.parser.Lexer;
import com.renderx.pdflib.parser.PDFArray;
import com.renderx.pdflib.parser.PDFDictionary;
import com.renderx.pdflib.parser.PDFElement;
import com.renderx.pdflib.parser.PDFHexString;
import com.renderx.pdflib.parser.PDFIndirectObject;
import com.renderx.pdflib.parser.PDFName;
import com.renderx.pdflib.parser.PDFNumeric;
import com.renderx.pdflib.parser.PDFSimple;
import com.renderx.pdflib.parser.PDFStream;
import com.renderx.pdflib.parser.PDFString;
import com.renderx.pdflib.parser.Rectangle;
import com.renderx.pdflib.parser.Token;
import com.renderx.util.Array;
import com.renderx.util.SeekableFileInputStream;
import com.renderx.util.Stack;
import java.io.IOException;

class ElementParser {
    ElementParser() {
    }

    public static PDFElement parse(Lexer lexer) throws IOException, ImageFormatException {
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("<parse>");
        }
        Token token = lexer.nextToken();
        if (token.type == 9 || token.type == 7 || token.type == 5 || token.type == 13 || token.type == 12 || token.type == 11) {
            throw new IOException("Wrong PDF file.");
        }
        Stack stack = new Stack();
        PDFElement pDFElement = null;
        try {
            while (token.type != 13 && token.type != 12 && token.type != 11) {
                Object object;
                Object object2;
                if (token.type == 10) {
                    if (stack.length() != 2) {
                        stack.pop();
                        throw new ImageFormatException("Wrong PDF file: too many tokens before object " + stack.pop() + ".");
                    }
                } else if (token.type == 2) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFString/>");
                    }
                    stack.push(new PDFString(token.value));
                } else if (token.type == 3) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFHexadecimalString/>");
                    }
                    stack.push(new PDFHexString(token.value));
                } else if (token.type == 1) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFName/>");
                    }
                    stack.push(new PDFName(token.value));
                } else if (token.type == 14) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFSimple/>");
                    }
                    stack.push(new PDFSimple(token.value));
                } else if (token.type == 4) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFNumeric/>");
                    }
                    stack.push(new PDFNumeric(token.value, true));
                } else if (token.type == 5) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFIndirectObject/>");
                    }
                    object2 = (PDFNumeric)stack.pop();
                    object = (PDFNumeric)stack.pop();
                    if (((PDFNumeric)object2).isUnsignedInteger || ((PDFNumeric)object).isUnsignedInteger) {
                        stack.push(new PDFIndirectObject(((PDFNumeric)object).value));
                    }
                } else if (token.type == 7) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFArray/>");
                    }
                    object2 = stack.pop();
                    object = new Array();
                    int n = 0;
                    while (!(object2 instanceof Token)) {
                        ((Array)object).put(n, (PDFElement)object2);
                        object2 = stack.pop();
                        ++n;
                    }
                    int n2 = ((Array)object).length();
                    int n3 = 0;
                    while (n3 < n2) {
                        ++n3;
                    }
                    PDFArray pDFArray = new PDFArray();
                    pDFArray.array = new Array(((Array)object).length());
                    int n4 = 0;
                    while (n4 < n2) {
                        pDFArray.array.put(n4, ((Array)object).get(n - n4 - 1));
                        ++n4;
                    }
                    stack.push(pDFArray);
                } else if (token.type == 9) {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<pushPDFDictionary/>");
                    }
                    object2 = stack.pop();
                    object = new PDFDictionary();
                    while (!(object2 instanceof Token)) {
                        PDFName pDFName = (PDFName)stack.pop();
                        if ("/Rect".equals(pDFName.value) && object2 instanceof PDFArray) {
                            object2 = new Rectangle((PDFArray)object2);
                        }
                        ((PDFDictionary)object).dict.put(pDFName.value, (PDFElement)object2);
                        object2 = stack.pop();
                    }
                    stack.push(object);
                } else {
                    if (PDFOutputStream.dump != null) {
                        PDFOutputStream.dumpprintln("<push" + token + "/>");
                    }
                    stack.push(token);
                }
                token = lexer.nextToken();
            }
            if (token.type == 12) {
                pDFElement = (PDFElement)stack.pop();
                pDFElement = new PDFStream((PDFDictionary)pDFElement);
                ((PDFStream)pDFElement).streamOffset = lexer.raf.getFilePointer();
                stack.push(pDFElement);
            }
            pDFElement = (PDFElement)stack.pop();
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new IOException("Broken PDF file!");
        }
        if (PDFOutputStream.dump != null) {
            PDFOutputStream.dumpprintln("</parse>");
        }
        return pDFElement;
    }

    public static void main(String[] stringArray) throws Exception {
        PDFElement pDFElement = ElementParser.parse(new Lexer(new SeekableFileInputStream(stringArray[0])));
        System.out.println(pDFElement.toString());
    }
}

