/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.graphics.vector;

import com.renderx.graphics.vector.Contour;
import com.renderx.graphics.vector.PaintSpec;
import com.renderx.graphics.vector.StrokeSpec;
import com.renderx.graphics.vector.Subpath;
import com.renderx.util.List;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;

public class Path
extends Contour {
    public List subs = new List();
    protected Subpath currentSubpath = null;
    public double curX = 0.0;
    public double curY = 0.0;

    public Path() {
    }

    public Path(PaintSpec paintSpec, StrokeSpec strokeSpec, int n, int n2, double d, double d2) {
        super(paintSpec, strokeSpec, n, n2, d, d2);
    }

    public void moveto(double d, double d2) {
        this.currentSubpath = null;
        this.curX = d;
        this.curY = d2;
    }

    public void lineto(double d, double d2) {
        if (this.currentSubpath == null) {
            this.currentSubpath = new Subpath(this.curX, this.curY);
            this.subs.append(this.currentSubpath);
        }
        this.currentSubpath.append(new Subpath.Line(this.curX, this.curY, d, d2));
        this.curX = d;
        this.curY = d2;
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        if (this.currentSubpath == null) {
            this.currentSubpath = new Subpath(this.curX, this.curY);
            this.subs.append(this.currentSubpath);
        }
        this.currentSubpath.append(new Subpath.Curve(this.curX, this.curY, d, d2, d3, d4, d5, d6));
        this.curX = d5;
        this.curY = d6;
    }

    public void closepath() {
        if (this.currentSubpath == null) {
            return;
        }
        this.currentSubpath.closed = true;
        this.curX = this.currentSubpath.startX;
        this.curY = this.currentSubpath.startY;
        this.currentSubpath = null;
    }

    public void quadcurveto(double d, double d2, double d3, double d4) {
        this.curveto((2.0 * d + this.curX) / 3.0, (2.0 * d2 + this.curY) / 3.0, (2.0 * d + d3) / 3.0, (2.0 * d2 + d4) / 3.0, d3, d4);
    }

    /*
     * Unable to fully structure code
     */
    public void arcto(double var1_1, double var3_2, double var5_3, boolean var7_4, boolean var8_5, double var9_6, double var11_7) {
        block21: {
            if (this.curX == var9_6 && this.curY == var11_7) {
                return;
            }
            if (var1_1 == 0.0 || var3_2 == 0.0) {
                this.lineto(var9_6, var11_7);
                return;
            }
            if (var1_1 < 0.0) {
                var1_1 = -var1_1;
            }
            if (var3_2 < 0.0) {
                var3_2 = -var3_2;
            }
            var13_8 = Math.sin(var5_3);
            var15_9 = Math.cos(var5_3);
            if (var13_8 == 1.0 || var13_8 == -1.0) {
                var15_9 = 0.0;
            }
            if (var15_9 == 1.0 || var15_9 == -1.0) {
                var13_8 = 0.0;
            }
            var17_10 = (this.curX - var9_6) / 2.0;
            var19_11 = (this.curY - var11_7) / 2.0;
            var21_12 = var15_9 * var17_10 + var13_8 * var19_11;
            var23_13 = -var13_8 * var17_10 + var15_9 * var19_11;
            var25_14 = var1_1 * var1_1;
            var27_15 = var3_2 * var3_2;
            var29_16 = var21_12 * var21_12;
            var31_17 = var23_13 * var23_13;
            var33_18 = 0.0;
            var35_19 = 0.0;
            var37_20 = var29_16 / var25_14 + var31_17 / var27_15;
            if (var37_20 >= 1.0) {
                var1_1 *= Math.sqrt(var37_20);
                var3_2 *= Math.sqrt(var37_20);
            } else {
                var39_21 = var7_4 == var8_5 ? -1.0 : 1.0;
                var41_22 = var39_21 * Math.sqrt((var25_14 * var27_15 - var25_14 * var31_17 - var27_15 * var29_16) / (var25_14 * var31_17 + var27_15 * var29_16));
                var33_18 = var41_22 * (var1_1 * var23_13 / var3_2);
                var35_19 = -var41_22 * (var3_2 * var21_12 / var1_1);
            }
            var39_21 = (this.curX + var9_6) / 2.0;
            var41_22 = (this.curY + var11_7) / 2.0;
            var43_23 = var15_9 * var33_18 - var13_8 * var35_19 + var39_21;
            var45_24 = var13_8 * var33_18 + var15_9 * var35_19 + var41_22;
            var47_25 = this.curX - var43_23;
            var49_26 = this.curY - var45_24;
            var51_27 = var9_6 - var43_23;
            var53_28 = var11_7 - var45_24;
            var55_29 = (var15_9 * var47_25 + var13_8 * var49_26) / var1_1;
            var57_30 = (-var13_8 * var47_25 + var15_9 * var49_26) / var3_2;
            var59_31 = (var15_9 * var51_27 + var13_8 * var53_28) / var1_1;
            var61_32 = (-var13_8 * var51_27 + var15_9 * var53_28) / var3_2;
            if (var55_29 >= 1.0) {
                var55_29 = 1.0;
                var57_30 = 0.0;
            }
            if (var55_29 <= -1.0) {
                var55_29 = -1.0;
                var57_30 = 0.0;
            }
            if (var59_31 >= 1.0) {
                var59_31 = 1.0;
                var61_32 = 0.0;
            }
            if (var59_31 <= -1.0) {
                var59_31 = -1.0;
                var61_32 = 0.0;
            }
            if (var57_30 >= 1.0) {
                var55_29 = 0.0;
                var57_30 = 1.0;
            }
            if (var57_30 <= -1.0) {
                var55_29 = 0.0;
                var57_30 = -1.0;
            }
            if (var61_32 >= 1.0) {
                var59_31 = 0.0;
                var61_32 = 1.0;
            }
            if (var61_32 <= -1.0) {
                var59_31 = 0.0;
                var61_32 = -1.0;
            }
            var63_33 = var57_30 >= 0.0 ? Math.acos(var55_29) : -Math.acos(var55_29);
            var65_34 = var61_32 >= 0.0 ? Math.acos(var59_31) : -Math.acos(var59_31);
            var67_35 = var65_34 - var63_33;
            if (!var8_5) ** GOTO lbl80
            while (var67_35 < 0.0) {
                var67_35 += 6.283185307179586;
            }
            break block21;
lbl-1000:
            // 1 sources

            {
                var67_35 -= 6.283185307179586;
lbl80:
                // 2 sources

                ** while (var67_35 > 0.0)
            }
        }
        var69_36 = (int)Math.ceil(Math.abs(2.0 * var67_35) / 3.141592653589793);
        var70_37 = var67_35 / (double)var69_36;
        var72_38 = 1.3333333333333333 * Math.tan(var70_37 / 4.0);
        var74_39 = var63_33;
        var76_40 = var57_30;
        var78_41 = var55_29;
        var80_42 = 0;
        while (var80_42 < var69_36) {
            var81_43 = var80_42 == 0;
            var82_44 = var80_42 == var69_36 - 1;
            var83_45 = var65_34;
            var85_46 = var61_32;
            var87_47 = var59_31;
            if (!var82_44) {
                var83_45 = var74_39 + var70_37;
                var85_46 = Math.sin(var83_45);
                var87_47 = Math.cos(var83_45);
            }
            var89_48 = var78_41 - var72_38 * var76_40;
            var91_49 = var76_40 + var72_38 * var78_41;
            var93_50 = var87_47 + var72_38 * var85_46;
            var95_51 = var85_46 - var72_38 * var87_47;
            var97_52 = var89_48 * var1_1 * var15_9 - var91_49 * var3_2 * var13_8 + var43_23;
            var99_53 = var89_48 * var1_1 * var13_8 + var91_49 * var3_2 * var15_9 + var45_24;
            var101_54 = var93_50 * var1_1 * var15_9 - var95_51 * var3_2 * var13_8 + var43_23;
            var103_55 = var93_50 * var1_1 * var13_8 + var95_51 * var3_2 * var15_9 + var45_24;
            var105_56 = var9_6;
            var107_57 = var11_7;
            if (!var82_44) {
                var105_56 = var87_47 * var1_1 * var15_9 - var85_46 * var3_2 * var13_8 + var43_23;
                var107_57 = var87_47 * var1_1 * var13_8 + var85_46 * var3_2 * var15_9 + var45_24;
            }
            this.curveto(var97_52, var99_53, var101_54, var103_55, var105_56, var107_57);
            ((Subpath.Segment)this.currentSubpath.segs.last()).beginsArc = var81_43;
            ((Subpath.Segment)this.currentSubpath.segs.last()).endsArc = var82_44;
            var74_39 = var83_45;
            var76_40 = var85_46;
            var78_41 = var87_47;
            ++var80_42;
        }
    }

    public void circle(double d, double d2, double d3) {
        this.ellipse(d, d2, d3, d3);
    }

    public void ellipse(double d, double d2, double d3, double d4) {
        this.moveto(d + d3, d2);
        this.quarterarcto(d, d2 + d4, false);
        this.quarterarcto(d - d3, d2, true);
        this.quarterarcto(d, d2 - d4, false);
        this.quarterarcto(d + d3, d2, true);
        this.closepath();
    }

    public void quarterarcto(double d, double d2, boolean bl) {
        double d3 = (d - this.curX) * 0.55228475;
        double d4 = (d2 - this.curY) * 0.55228475;
        if (bl) {
            this.curveto(this.curX + d3, this.curY, d, d2 - d4, d, d2);
        } else {
            this.curveto(this.curX, this.curY + d4, d - d3, d2, d, d2);
        }
    }

    public void square(double d, double d2, double d3) {
        this.rectangle(d, d2, d3, d3);
    }

    public void rectangle(double d, double d2, double d3, double d4) {
        this.moveto(d, d2);
        this.lineto(d, d2 + d4);
        this.lineto(d + d3, d2 + d4);
        this.lineto(d + d3, d2);
        this.lineto(d, d2);
        this.closepath();
    }

    public void dump(PrintStream printStream, String string) throws IOException {
        printStream.println(string + "%<path fill-rule=\"" + (this.fillRule == 0 ? "nonzero" : "evenodd") + "\" clip-rule=\"" + (this.clipRule == 0 ? "nonzero" : "evenodd") + "\" fill-opacity=\"" + this.fillOpacity + "\" stroke-opacity=\"" + this.strokeOpacity + "\">");
        printStream.println(string + "  newpath");
        Enumeration enumeration = this.subs.elements();
        while (enumeration.hasMoreElements()) {
            ((Subpath)enumeration.nextElement()).dump(printStream, string + "  ");
        }
        if (this.fill != null) {
            printStream.println(string + "  gsave");
            printStream.println(string + "  %<fill>");
            this.fill.dump(printStream, string + "    ");
            printStream.println(string + "    " + (this.fillRule == 0 ? "fill" : "eofill"));
            printStream.println(string + "  %</fill>");
            printStream.println(string + "  grestore");
        }
        if (this.stroke != null && this.stroke.paint != null) {
            printStream.println(string + "  gsave");
            this.stroke.dump(printStream, string + "  ");
            printStream.println(string + "  stroke");
            printStream.println(string + "  grestore");
        }
        printStream.println(string + "%</path>");
    }
}

