/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.crypto;

import java.math.BigInteger;

public class RSAPublicKey {
    protected BigInteger n_;
    protected BigInteger e_;

    private static final BigInteger newBigInteger(BigInteger bigInteger) {
        return bigInteger.pow(1);
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.n_ = RSAPublicKey.newBigInteger(bigInteger);
        this.e_ = RSAPublicKey.newBigInteger(bigInteger2);
    }

    public RSAPublicKey(RSAPublicKey rSAPublicKey) {
        this.copy(rSAPublicKey);
    }

    public void copy(Object object) {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
        this.n_ = RSAPublicKey.newBigInteger(rSAPublicKey.n_);
        this.e_ = RSAPublicKey.newBigInteger(rSAPublicKey.e_);
    }

    public boolean equals(Object object) {
        if (object instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
            if (this.n_.equals(rSAPublicKey.n_) && this.e_.equals(rSAPublicKey.e_)) {
                return true;
            }
        }
        return false;
    }

    public final byte[] id() {
        byte[] byArray = this.n_.toByteArray();
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, byArray.length - 8, byArray2, 0, 8);
        return byArray2;
    }

    public final int bitLength() {
        return this.n_.bitLength();
    }

    public BigInteger encrypt(BigInteger bigInteger) {
        return RSAPublicKey.newBigInteger(bigInteger).modPow(this.e_, this.n_);
    }

    public String toString() {
        return "n:" + this.n_ + "\ne:" + this.e_;
    }
}

