/*
 * Decompiled with CFR 0.152.
 */
package com.renderx.crypto;

import com.renderx.crypto.CryptoException;
import java.io.DataInput;
import java.io.IOException;

public final class PGPHeader {
    private static final int CTB_TYPE_MASK = 124;
    private static final int CTB_TYPE_SHIFT = 2;
    private static final int CTB_LLEN_MASK = 3;
    public int type;
    public int len;
    public int lensize;

    public PGPHeader(DataInput dataInput) throws IOException {
        this.read(dataInput);
    }

    public void read(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        this.type = (byte)PGPHeader.ctbToType(by);
        byte by2 = (byte)PGPHeader.ctbToLengthSpecifier(by);
        switch (by2) {
            case 0: {
                this.len = dataInput.readByte() & 0xFF;
                break;
            }
            case 1: {
                this.len = dataInput.readShort() & 0xFFFF;
                break;
            }
            case 2: {
                this.len = dataInput.readInt();
                break;
            }
            case 3: {
                this.len = -1;
                break;
            }
            default: {
                throw new CryptoException("Bad value for CTB (" + by2 + ")");
            }
        }
        this.lensize = 0;
    }

    public static final int ctbToType(int n) {
        return (n & 0x7C) >> 2;
    }

    public static final int ctbToLengthSpecifier(int n) {
        return n & 3;
    }
}

